/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.tile;

import CoroUtil.packet.WatchableObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.DataWatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ReportedException;

public class TileDataWatcher {
    private boolean isBlank = true;
    public static final HashMap dataTypes = new HashMap();
    private final Map watchedObjects = new HashMap();
    private boolean objectChanged;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public void addObject(int par1, Object par2Obj) {
        Integer integer = (Integer)dataTypes.get(par2Obj.getClass());
        if (integer == null) {
            throw new IllegalArgumentException("Unknown data type: " + par2Obj.getClass());
        }
        if (par1 > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + par1 + "! (Max is " + 31 + ")");
        }
        if (this.watchedObjects.containsKey(par1)) {
            throw new IllegalArgumentException("Duplicate id value for " + par1 + "!");
        }
        WatchableObject watchableobject = new WatchableObject(integer, par1, par2Obj);
        this.lock.writeLock().lock();
        this.watchedObjects.put(par1, watchableobject);
        this.lock.writeLock().unlock();
        this.isBlank = false;
    }

    public void addObjectByDataType(int par1, int par2) {
        WatchableObject watchableobject = new WatchableObject(par2, par1, null);
        this.lock.writeLock().lock();
        this.watchedObjects.put(par1, watchableobject);
        this.lock.writeLock().unlock();
        this.isBlank = false;
    }

    public byte getWatchableObjectByte(int par1) {
        return (Byte)this.getWatchedObject(par1).getObject();
    }

    public short getWatchableObjectShort(int par1) {
        return (Short)this.getWatchedObject(par1).getObject();
    }

    public int getWatchableObjectInt(int par1) {
        return (Integer)this.getWatchedObject(par1).getObject();
    }

    public String getWatchableObjectString(int par1) {
        return (String)this.getWatchedObject(par1).getObject();
    }

    public ItemStack getWatchableObjectItemStack(int par1) {
        return (ItemStack)this.getWatchedObject(par1).getObject();
    }

    public WatchableObject getWatchedObject(int par1) {
        WatchableObject watchableobject;
        this.lock.readLock().lock();
        try {
            watchableobject = (WatchableObject)this.watchedObjects.get(par1);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting synched entity data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Synched entity data");
            crashreportcategory.func_71507_a("Data ID", (Object)par1);
            throw new ReportedException(crashreport);
        }
        this.lock.readLock().unlock();
        return watchableobject;
    }

    public void updateObject(int par1, Object par2Obj) {
        WatchableObject watchableobject = this.getWatchedObject(par1);
        if (!par2Obj.equals(watchableobject.getObject())) {
            watchableobject.setObject(par2Obj);
            watchableobject.setWatched(true);
            this.objectChanged = true;
        }
    }

    public void setObjectWatched(int par1) {
        this.getWatchedObject(par1).setWatched(true);
        this.objectChanged = true;
    }

    public boolean hasChanges() {
        return this.objectChanged;
    }

    public void func_151509_a(PacketBuffer p_151509_1_) throws IOException {
        this.lock.readLock().lock();
        for (DataWatcher.WatchableObject watchableobject : this.watchedObjects.values()) {
            TileDataWatcher.writeWatchableObjectToPacketBuffer(p_151509_1_, watchableobject);
        }
        this.lock.readLock().unlock();
        p_151509_1_.writeByte(127);
    }

    public List unwatchAndReturnAllWatched() {
        ArrayList<WatchableObject> arraylist = null;
        if (this.objectChanged) {
            this.lock.readLock().lock();
            for (WatchableObject watchableobject : this.watchedObjects.values()) {
                if (!watchableobject.isWatched()) continue;
                watchableobject.setWatched(false);
                if (arraylist == null) {
                    arraylist = new ArrayList<WatchableObject>();
                }
                arraylist.add(watchableobject);
            }
            this.lock.readLock().unlock();
        }
        this.objectChanged = false;
        return arraylist;
    }

    public List getAllWatched() {
        ArrayList<WatchableObject> arraylist = null;
        this.lock.readLock().lock();
        for (WatchableObject watchableobject : this.watchedObjects.values()) {
            if (arraylist == null) {
                arraylist = new ArrayList<WatchableObject>();
            }
            arraylist.add(watchableobject);
        }
        this.lock.readLock().unlock();
        return arraylist;
    }

    private static void writeWatchableObjectToPacketBuffer(PacketBuffer p_151510_0_, DataWatcher.WatchableObject p_151510_1_) throws IOException {
        int i = (p_151510_1_.func_75674_c() << 5 | p_151510_1_.func_75672_a() & 0x1F) & 0xFF;
        p_151510_0_.writeByte(i);
        switch (p_151510_1_.func_75674_c()) {
            case 0: {
                p_151510_0_.writeByte((int)((Byte)p_151510_1_.func_75669_b()).byteValue());
                break;
            }
            case 1: {
                p_151510_0_.writeShort((int)((Short)p_151510_1_.func_75669_b()).shortValue());
                break;
            }
            case 2: {
                p_151510_0_.writeInt(((Integer)p_151510_1_.func_75669_b()).intValue());
                break;
            }
            case 3: {
                p_151510_0_.writeFloat(((Float)p_151510_1_.func_75669_b()).floatValue());
                break;
            }
            case 4: {
                p_151510_0_.func_150785_a((String)p_151510_1_.func_75669_b());
                break;
            }
            case 5: {
                ItemStack itemstack = (ItemStack)p_151510_1_.func_75669_b();
                p_151510_0_.func_150788_a(itemstack);
                break;
            }
            case 6: {
                ChunkCoordinates chunkcoordinates = (ChunkCoordinates)p_151510_1_.func_75669_b();
                p_151510_0_.writeInt(chunkcoordinates.field_71574_a);
                p_151510_0_.writeInt(chunkcoordinates.field_71572_b);
                p_151510_0_.writeInt(chunkcoordinates.field_71573_c);
            }
        }
    }

    public static List readWatchedListFromPacketBuffer(PacketBuffer p_151508_0_) throws IOException {
        ArrayList<DataWatcher.WatchableObject> arraylist = null;
        byte b0 = p_151508_0_.readByte();
        while (b0 != 127) {
            if (arraylist == null) {
                arraylist = new ArrayList<DataWatcher.WatchableObject>();
            }
            int i = (b0 & 0xE0) >> 5;
            int j = b0 & 0x1F;
            DataWatcher.WatchableObject watchableobject = null;
            switch (i) {
                case 0: {
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)p_151508_0_.readByte());
                    break;
                }
                case 1: {
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)p_151508_0_.readShort());
                    break;
                }
                case 2: {
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)p_151508_0_.readInt());
                    break;
                }
                case 3: {
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)Float.valueOf(p_151508_0_.readFloat()));
                    break;
                }
                case 4: {
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)p_151508_0_.func_150789_c(Short.MAX_VALUE));
                    break;
                }
                case 5: {
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)p_151508_0_.func_150791_c());
                    break;
                }
                case 6: {
                    int k = p_151508_0_.readInt();
                    int l = p_151508_0_.readInt();
                    int i1 = p_151508_0_.readInt();
                    watchableobject = new DataWatcher.WatchableObject(i, j, (Object)new ChunkCoordinates(k, l, i1));
                }
            }
            arraylist.add(watchableobject);
            b0 = p_151508_0_.readByte();
        }
        return arraylist;
    }

    public void updateWatchedObjectsFromList(List par1List) {
        this.updateWatchedObjectsFromList(par1List, false);
    }

    public void updateWatchedObjectsFromList(List par1List, boolean forceMarkWatched) {
        this.lock.writeLock().lock();
        for (WatchableObject watchableobject : par1List) {
            WatchableObject watchableobject1 = (WatchableObject)this.watchedObjects.get(watchableobject.getDataValueId());
            if (watchableobject1 == null) continue;
            watchableobject1.setObject(watchableobject.getObject());
            if (!forceMarkWatched) continue;
            watchableobject1.setWatched(true);
        }
        if (forceMarkWatched) {
            this.objectChanged = true;
        }
        this.lock.writeLock().unlock();
    }

    public boolean getIsBlank() {
        return this.isBlank;
    }

    static {
        dataTypes.put(Byte.class, 0);
        dataTypes.put(Short.class, 1);
        dataTypes.put(Integer.class, 2);
        dataTypes.put(Float.class, 3);
        dataTypes.put(String.class, 4);
        dataTypes.put(ItemStack.class, 5);
        dataTypes.put(ChunkCoordinates.class, 6);
    }
}

