/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block;

import com.jaquadro.minecraft.modularpots.ModularPots;
import com.jaquadro.minecraft.modularpots.client.ClientProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockThinLogFence
extends Block {
    public static final String[] subNames = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};
    @SideOnly(value=Side.CLIENT)
    IIcon sideIcon;

    public BlockThinLogFence(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModularPots.tabModularPots);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.func_149683_g();
    }

    public float getMargin() {
        return 0.25f;
    }

    public void func_149683_g() {
        float margin = this.getMargin();
        this.func_149676_a(margin, 0.0f, margin, 1.0f - margin, 1.0f, 1.0f - margin);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        float margin;
        boolean connectedZNeg = this.canConnectFenceTo((IBlockAccess)world, x, y, z - 1);
        boolean connectedZPos = this.canConnectFenceTo((IBlockAccess)world, x, y, z + 1);
        boolean connectedXNeg = this.canConnectFenceTo((IBlockAccess)world, x - 1, y, z);
        boolean connectedXPos = this.canConnectFenceTo((IBlockAccess)world, x + 1, y, z);
        float xs = margin = this.getMargin();
        float xe = 1.0f - margin;
        float zs = margin;
        float ze = 1.0f - margin;
        if (connectedZNeg) {
            zs = 0.0f;
        }
        if (connectedZPos) {
            ze = 1.0f;
        }
        if (connectedZNeg || connectedZPos) {
            this.func_149676_a(xs, 0.0f, zs, xe, 1.5f, ze);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        zs = margin;
        ze = 1.0f - margin;
        if (connectedXNeg) {
            xs = 0.0f;
        }
        if (connectedXPos) {
            xe = 1.0f;
        }
        if (connectedXNeg || connectedXPos || !connectedZNeg && !connectedZPos) {
            this.func_149676_a(xs, 0.0f, zs, xe, 1.5f, ze);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (connectedZNeg) {
            zs = 0.0f;
        }
        if (connectedZPos) {
            ze = 1.0f;
        }
        this.func_149676_a(xs, 0.0f, zs, xe, 1.0f, ze);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float margin;
        boolean connectedZNeg = this.canConnectFenceTo(world, x, y, z - 1);
        boolean connectedZPos = this.canConnectFenceTo(world, x, y, z + 1);
        boolean connectedXNeg = this.canConnectFenceTo(world, x - 1, y, z);
        boolean connectedXPos = this.canConnectFenceTo(world, x + 1, y, z);
        float xs = margin = this.getMargin();
        float xe = 1.0f - margin;
        float zs = margin;
        float ze = 1.0f - margin;
        if (connectedZNeg) {
            zs = 0.0f;
        }
        if (connectedZPos) {
            ze = 1.0f;
        }
        if (connectedXNeg) {
            xs = 0.0f;
        }
        if (connectedXPos) {
            xe = 1.0f;
        }
        this.func_149676_a(xs, 0.0f, zs, xe, 1.0f, ze);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.thinLogFenceRenderID;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean canConnectFenceTo(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return block.func_149688_o().func_76218_k() && block.func_149686_d() ? block.func_149688_o() != Material.field_151572_C : false;
        }
        return true;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getIconSource(meta).func_149691_a(side, meta % 4);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getSideIcon() {
        return this.sideIcon;
    }

    private Block getIconSource(int meta) {
        switch (meta / 4) {
            case 0: {
                return Blocks.field_150364_r;
            }
            case 1: {
                return Blocks.field_150363_s;
            }
        }
        return Blocks.field_150364_r;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 6; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.sideIcon = iconRegister.func_94245_a("modularpots:thinlog_fence_side");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        return world.field_72995_K ? true : ItemLead.func_150909_a((EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
    }
}

