/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block;

import com.jaquadro.minecraft.modularpots.ModBlocks;
import com.jaquadro.minecraft.modularpots.ModItems;
import com.jaquadro.minecraft.modularpots.ModularPots;
import com.jaquadro.minecraft.modularpots.client.ClientProxy;
import com.jaquadro.minecraft.modularpots.config.PatternConfig;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityLargePot;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLargePot
extends BlockContainer {
    public static final String[] subTypes = new String[]{"default", "raw"};
    private boolean colored;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayArray;
    private int scratchDropMetadata;

    public BlockLargePot(String blockName, boolean colored) {
        super(Material.field_151571_B);
        this.colored = colored;
        this.func_149647_a(ModularPots.tabModularPots);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c(blockName);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        float dim = 0.0625f;
        TileEntityLargePot te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null || te.getSubstrate() == null || !this.isSubstrateSolid(te.getSubstrate())) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, dim, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f - dim, 1.0f);
        }
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        if (!this.isCompatibleNeighbor((IBlockAccess)world, x, y, z, -1, 0)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, dim, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (!this.isCompatibleNeighbor((IBlockAccess)world, x, y, z, 0, -1)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, dim);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (!this.isCompatibleNeighbor((IBlockAccess)world, x, y, z, 1, 0)) {
            this.func_149676_a(1.0f - dim, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (!this.isCompatibleNeighbor((IBlockAccess)world, x, y, z, 0, 1)) {
            this.func_149676_a(0.0f, 0.0f, 1.0f - dim, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.largePotRenderID;
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int nx = x++;
        int nz = z++;
        switch (side) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                --x;
            }
        }
        if (side >= 2 && side < 6) {
            return !this.isCompatibleNeighbor(blockAccess, x, y, z, nx - x, nz - z);
        }
        return side != 1;
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        TileEntityLargePot te = this.getTileEntity(world, x, y, z);
        if (te == null || te.getSubstrate() == null) {
            return false;
        }
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        Block plant = plantable.getPlant(world, x, y + 1, z);
        Block substrate = Block.func_149634_a((Item)te.getSubstrate());
        if (plant == Blocks.field_150434_aF) {
            return substrate == Blocks.field_150354_m;
        }
        return plantType == EnumPlantType.Crop && substrate == Blocks.field_150458_ak;
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityLargePot tileEntity;
        if (world.field_72995_K) {
            return;
        }
        if (y >= world.func_72800_K() - 1) {
            return;
        }
        Block overBlock = world.func_147439_a(x, y + 1, z);
        if (overBlock.isAir((IBlockAccess)world, x, y, z) && (tileEntity = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            tileEntity.setItem(null, 0);
            tileEntity.func_70296_d();
        }
    }

    public boolean isCompatibleNeighbor(IBlockAccess world, int x, int y, int z, int dx, int dz) {
        int metaComp;
        Block block = world.func_147439_a(x + dx, y, z + dz);
        if (block != this) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta != (metaComp = world.func_72805_g(x + dx, y, z + dz))) {
            return false;
        }
        if (!this.colored && meta == 1) {
            return false;
        }
        BlockLargePot pot = (BlockLargePot)block;
        TileEntityLargePot teThis = this.getTileEntity(world, x, y, z);
        TileEntityLargePot teThat = this.getTileEntity(world, x + dx, y, z + dz);
        if (teThis == null || teThat == null) {
            return false;
        }
        return teThis.getSubstrate() == teThat.getSubstrate() && teThis.getSubstrateData() == teThat.getSubstrateData();
    }

    public void func_149681_a(World world, int x, int y, int z, int p_149681_5_, EntityPlayer player) {
        TileEntityLargePot te;
        super.func_149681_a(world, x, y, z, p_149681_5_, player);
        if (player.field_71075_bZ.field_75098_d && (te = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            te.setSubstrate(null, 0);
            te.setItem(null, 0);
            te.func_70296_d();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        Block substrate;
        TileEntityLargePot te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te.getSubstrate() != null && (substrate = Block.func_149634_a((Item)te.getSubstrate())) != Blocks.field_150355_j) {
            if (substrate == Blocks.field_150458_ak) {
                substrate = Blocks.field_150346_d;
            }
            ItemStack item = new ItemStack(substrate, 1, te.getSubstrateOriginalData());
            this.func_149642_a(world, x, y, z, item);
        }
        if (te != null && te.getFlowerPotItem() != null) {
            ItemStack item = new ItemStack(te.getFlowerPotItem(), 1, te.getFlowerPotData());
            this.func_149642_a(world, x, y, z, item);
        }
        if (te != null) {
            this.scratchDropMetadata = te.getCarving() << 8;
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            items.add(new ItemStack(item, 1, metadata | this.scratchDropMetadata));
        }
        return items;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        Block itemBlock;
        if (side != 1) {
            return false;
        }
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack == null) {
            return false;
        }
        TileEntityLargePot tileEntity = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tileEntity == null) {
            tileEntity = new TileEntityLargePot();
            world.func_147455_a(x, y, z, (TileEntity)tileEntity);
        }
        IPlantable plantable = null;
        Item item = itemStack.func_77973_b();
        if (item instanceof IPlantable) {
            plantable = (IPlantable)item;
        } else if (item instanceof ItemBlock && (itemBlock = Block.func_149634_a((Item)item)) instanceof IPlantable) {
            plantable = (IPlantable)itemBlock;
        }
        if (tileEntity.getSubstrate() == null && this.isValidSubstrate(item)) {
            this.applySubstrate(world, x, y, z, tileEntity, player);
        } else if (tileEntity.getSubstrate() != null && this.canApplyItemToSubstrate(tileEntity, itemStack)) {
            this.applyItemToSubstrate(world, x, y, z, tileEntity, player);
        } else if (plantable != null && this.canSustainPlantActivated((IBlockAccess)world, x, y, z, plantable)) {
            if (!this.enoughAirAbove((IBlockAccess)world, x, y, z, plantable)) {
                return false;
            }
            this.applyPlantable(world, x, y, z, tileEntity, player, plantable);
        } else {
            return false;
        }
        return true;
    }

    protected void applySubstrate(World world, int x, int y, int z, TileEntityLargePot tile, EntityPlayer player) {
        ItemStack substrate = player.field_71071_by.func_70448_g();
        if (!this.colored && world.func_72805_g(x, y, z) == 1) {
            world.func_147468_f(x, y, z);
            world.func_72956_a((Entity)player, "dig.sand", 1.0f, 1.0f);
            for (int i = 0; i < 4; ++i) {
                this.func_149642_a(world, x, y, z, new ItemStack(Items.field_151119_aD));
            }
            return;
        }
        if (substrate.func_77973_b() == Items.field_151131_as) {
            tile.setSubstrate(Item.func_150898_a((Block)Blocks.field_150355_j), 0);
            tile.func_70296_d();
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
            }
        } else {
            tile.setSubstrate(substrate.func_77973_b(), substrate.func_77960_j());
            if (Block.func_149634_a((Item)substrate.func_77973_b()) == Blocks.field_150458_ak) {
                tile.setSubstrate(substrate.func_77973_b(), 1, substrate.func_77960_j());
            }
            tile.func_70296_d();
            if (!player.field_71075_bZ.field_75098_d && --substrate.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        world.func_147471_g(x, y, z);
    }

    protected boolean canApplyItemToSubstrate(TileEntityLargePot tile, ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_151131_as || itemStack.func_77973_b() == ModItems.usedSoilTestKit || itemStack.func_77973_b() == Items.field_151133_ar || itemStack.func_77973_b() instanceof ItemHoe || itemStack.func_77973_b() instanceof ItemTool;
    }

    protected void applyItemToSubstrate(World world, int x, int y, int z, TileEntityLargePot tile, EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item.func_77973_b() == Items.field_151133_ar) {
            if (Block.func_149634_a((Item)tile.getSubstrate()) == Blocks.field_150355_j) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151131_as));
                tile.setSubstrate(null, 0);
                tile.func_70296_d();
                world.func_147471_g(x, y, z);
            }
            return;
        }
        if (item.func_77973_b() instanceof ItemTool && item.func_77973_b().getToolClasses(item).contains("shovel")) {
            if (Block.func_149634_a((Item)tile.getSubstrate()) != Blocks.field_150355_j) {
                ItemStack drop = new ItemStack(tile.getSubstrate(), 1, tile.getSubstrateOriginalData());
                this.func_149642_a(world, x, y, z, drop);
                if (tile.getFlowerPotItem() != null) {
                    drop = new ItemStack(tile.getFlowerPotItem(), 1, tile.getFlowerPotData());
                    this.func_149642_a(world, x, y, z, drop);
                }
                tile.setSubstrate(null, 0);
                tile.setItem(null, 0);
                tile.func_70296_d();
                world.func_147471_g(x, y, z);
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150346_d.field_149762_H.func_150498_e(), (Blocks.field_150346_d.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150346_d.field_149762_H.func_150494_d() * 0.8f);
                if (world.func_147439_a(x, y + 1, z) == ModBlocks.largePotPlantProxy) {
                    world.func_147468_f(x, y + 1, z);
                }
            }
            return;
        }
        if (item.func_77973_b() == Items.field_151131_as) {
            this.applyWaterToSubstrate(world, x, y, z, tile, player);
        } else if (item.func_77973_b() instanceof ItemHoe) {
            this.applyHoeToSubstrate(world, x, y, z, tile, player);
        } else if (item.func_77973_b() == ModItems.usedSoilTestKit) {
            this.applyTestKit(world, x, y, z, item);
        }
    }

    protected void applyWaterToSubstrate(World world, int x, int y, int z, TileEntityLargePot tile, EntityPlayer player) {
        if (Block.func_149634_a((Item)tile.getSubstrate()) == Blocks.field_150346_d) {
            tile.setSubstrate(Item.func_150898_a((Block)Blocks.field_150458_ak), 1, tile.getSubstrateData());
            tile.func_70296_d();
            world.func_147471_g(x, y, z);
        }
    }

    protected void applyHoeToSubstrate(World world, int x, int y, int z, TileEntityLargePot tile, EntityPlayer player) {
        Block substrate = Block.func_149634_a((Item)tile.getSubstrate());
        if (substrate == Blocks.field_150346_d || substrate == Blocks.field_150349_c) {
            tile.setSubstrate(Item.func_150898_a((Block)Blocks.field_150458_ak), 1, tile.getSubstrateData());
            tile.func_70296_d();
            world.func_147471_g(x, y, z);
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
        }
    }

    public boolean applyTestKit(World world, int x, int y, int z, ItemStack testKit) {
        if (testKit.func_77973_b() != ModItems.usedSoilTestKit) {
            return false;
        }
        TileEntityLargePot tileEntity = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tileEntity == null) {
            return false;
        }
        Block substrate = Block.func_149634_a((Item)tileEntity.getSubstrate());
        if (substrate != Blocks.field_150346_d && substrate != Blocks.field_150349_c && substrate != Blocks.field_150458_ak) {
            return false;
        }
        tileEntity.setBiomeData(testKit.func_77960_j());
        world.func_147471_g(x, y, z);
        for (int i = 0; i < 5; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            world.func_72869_a("happyVillager", (double)((float)x + world.field_73012_v.nextFloat()), (double)((float)y + 0.5f + world.field_73012_v.nextFloat()), (double)((float)z + world.field_73012_v.nextFloat()), d0, d1, d2);
        }
        return true;
    }

    protected void applyPlantable(World world, int x, int y, int z, TileEntityLargePot tile, EntityPlayer player, IPlantable plantable) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        Block itemBlock = plantable.getPlant((IBlockAccess)world, x, y, z);
        if (itemBlock == null && plantable instanceof Block) {
            itemBlock = (Block)plantable;
        }
        world.func_147465_d(x, y + 1, z, (Block)ModBlocks.largePotPlantProxy, itemStack.func_77960_j(), 3);
        if (itemBlock instanceof BlockDoublePlant || itemBlock.func_149645_b() == 40) {
            world.func_147465_d(x, y + 2, z, (Block)ModBlocks.largePotPlantProxy, itemStack.func_77960_j() | 8, 3);
        }
        tile.setItem(itemStack.func_77973_b(), itemStack.func_77960_j());
        tile.func_70296_d();
        if (!player.field_71075_bZ.field_75098_d && --itemStack.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
    }

    private boolean enoughAirAbove(IBlockAccess world, int x, int y, int z, IPlantable plant) {
        Block plantBlock = plant.getPlant(world, x, y + 1, z);
        int height = plantBlock instanceof BlockDoublePlant ? 2 : 1;
        boolean enough = true;
        for (int i = 0; i < height; ++i) {
            enough &= world.func_147437_c(x, y + 1 + i, z);
        }
        return enough;
    }

    protected boolean isValidSubstrate(Item item) {
        if (item == Items.field_151131_as) {
            return true;
        }
        Block block = Block.func_149634_a((Item)item);
        if (block == null) {
            return false;
        }
        return block == Blocks.field_150346_d || block == Blocks.field_150354_m || block == Blocks.field_150351_n || block == Blocks.field_150425_aM || block == Blocks.field_150349_c || block == Blocks.field_150355_j || block == Blocks.field_150458_ak;
    }

    private boolean isSubstrateSolid(Item item) {
        Block block = Block.func_149634_a((Item)item);
        return block != Blocks.field_150355_j;
    }

    protected boolean canSustainPlantActivated(IBlockAccess world, int x, int y, int z, IPlantable plantable) {
        TileEntityLargePot te = this.getTileEntity(world, x, y, z);
        if (te == null || te.getSubstrate() == null) {
            return false;
        }
        Block substrate = Block.func_149634_a((Item)te.getSubstrate());
        if (substrate == null) {
            return false;
        }
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        Block plant = plantable.getPlant(world, x, y + 1, z);
        if (plantType == null) {
            plantType = EnumPlantType.Plains;
        }
        if (plant == Blocks.field_150434_aF) {
            return false;
        }
        switch (plantType) {
            case Desert: {
                return substrate == Blocks.field_150354_m;
            }
            case Nether: {
                return substrate == Blocks.field_150425_aM;
            }
            case Cave: {
                return true;
            }
            case Plains: {
                return substrate == Blocks.field_150349_c || substrate == Blocks.field_150346_d;
            }
            case Beach: {
                return substrate == Blocks.field_150349_c || substrate == Blocks.field_150346_d || substrate == Blocks.field_150354_m;
            }
            case Water: {
                return substrate == Blocks.field_150355_j;
            }
        }
        return false;
    }

    public TileEntityLargePot getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity != null && tileEntity instanceof TileEntityLargePot ? (TileEntityLargePot)tileEntity : null;
    }

    public TileEntity func_149915_a(World world, int data) {
        return new TileEntityLargePot();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int data) {
        if (this.colored) {
            return this.iconArray[data & 0xF];
        }
        switch (data) {
            case 1: {
                return Blocks.field_150435_aG.func_149691_a(side, 0);
            }
        }
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBottomIcon(int data) {
        if (!this.colored && data == 1) {
            return Blocks.field_150435_aG.func_149691_a(0, 0);
        }
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(int data) {
        if (this.iconOverlayArray[data] != null) {
            return this.iconOverlayArray[data];
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        if (this.colored) {
            for (int i = 0; i < 16; ++i) {
                blockList.add(new ItemStack(item, 1, i));
            }
        } else {
            blockList.add(new ItemStack(item, 1, 0));
            blockList.add(new ItemStack(item, 1, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int i;
        this.iconSide = iconRegister.func_94245_a("modularpots:large_pot");
        if (this.colored) {
            this.iconArray = new IIcon[16];
            for (i = 0; i < 16; ++i) {
                String colorName = ItemDye.field_150921_b[BlockLargePot.getBlockFromDye(i)];
                this.iconArray[i] = iconRegister.func_94245_a("modularpots:large_pot_" + colorName);
            }
        }
        this.iconOverlayArray = new IIcon[256];
        for (i = 1; i < this.iconOverlayArray.length; ++i) {
            PatternConfig pattern = ModularPots.config.getPattern(i);
            if (pattern == null || pattern.getOverlay() == null) continue;
            this.iconOverlayArray[i] = iconRegister.func_94245_a("modularpots:" + pattern.getOverlay());
        }
    }

    public static int getBlockFromDye(int index) {
        return index & 0xF;
    }

    public static enum Direction {
        North(1),
        East(2),
        South(4),
        West(8),
        NorthWest(16),
        NorthEast(32),
        SouthEast(64),
        SouthWest(128);

        private final int flag;

        private Direction(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public static boolean isSet(int bitflags, Direction direction) {
            return (bitflags & direction.flag) != 0;
        }

        public static int set(int bitflags, Direction direction) {
            return bitflags | direction.flag;
        }

        public static int clear(int bitflags, Direction direction) {
            return bitflags & ~direction.flag;
        }

        public static int setOrClear(int bitflags, Direction direction, boolean set) {
            return set ? Direction.set(bitflags, direction) : Direction.clear(bitflags, direction);
        }
    }
}

