/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.client.renderer;

import com.jaquadro.minecraft.modularpots.block.BlockLargePotPlantProxy;
import com.jaquadro.minecraft.modularpots.client.ClientProxy;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityLargePot;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;

public class TransformPlantRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLargePotPlantProxy)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockLargePotPlantProxy)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockLargePotPlantProxy block, int modelId, RenderBlocks renderer) {
        TileEntityLargePot potData;
        Block itemBlock = block.getItemBlock(world, x, y, z);
        if (itemBlock == null || itemBlock.isAir(world, x, y, z)) {
            return true;
        }
        int itemRenderType = itemBlock.func_149645_b();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78372_c(0.0f, -0.0625f, 0.0f);
        int color = block.func_149720_d(world, x, y, z);
        if (color != 0xFFFFFF) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            tessellator.func_78386_a(r, g, b);
        }
        if ((potData = block.getAttachedPotEntity(world, x, y, z)) == null) {
            potData = new TileEntityLargePot();
        }
        if (itemRenderType == 1) {
            this.renderCrossedSquares(world, renderer, itemBlock, x, y, z, potData, 0.0f, 0.0f);
        } else if (itemRenderType == 40 && itemBlock instanceof BlockDoublePlant) {
            this.renderBlockDoublePlant(world, renderer, (BlockDoublePlant)itemBlock, x, y, z, potData);
        } else {
            renderer.func_147805_b(itemBlock, x, y, z);
        }
        tessellator.func_78372_c(0.0f, 0.0625f, 0.0f);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.transformPlantRenderID;
    }

    private boolean renderCrossedSquares(IBlockAccess world, RenderBlocks renderer, Block block, int x, int y, int z, TileEntityLargePot potData, float offX, float offZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        int l = block.func_149720_d(renderer.field_147845_a, x, y, z);
        if (l == world.func_72807_a(x, z).func_150558_b(x, y, z)) {
            l = ColorizerGrass.func_77480_a((double)potData.getBiomeTemperature(), (double)potData.getBiomeHumidity());
        }
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        tessellator.func_78386_a(f, f1, f2);
        double d1 = x;
        double d2 = y;
        double d0 = z;
        IIcon iicon = renderer.func_147787_a(block, 0, renderer.field_147845_a.func_72805_g(x, y, z));
        renderer.func_147765_a(iicon, d1 + (double)offX, d2, d0 + (double)offZ, 1.0f);
        return true;
    }

    private boolean renderBlockDoublePlant(IBlockAccess world, RenderBlocks renderer, BlockDoublePlant block, int x, int y, int z, TileEntityLargePot potData) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        int l = block.func_149720_d(renderer.field_147845_a, x, y, z);
        if (l == world.func_72807_a(x, z).func_150558_b(x, y, z)) {
            l = ColorizerGrass.func_77480_a((double)potData.getBiomeTemperature(), (double)potData.getBiomeHumidity());
        }
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        tessellator.func_78386_a(f, f1, f2);
        long j1 = (long)(x * 3129871) ^ (long)z * 116129781L;
        j1 = j1 * j1 * 42317861L + j1 * 11L;
        double d19 = x;
        double d0 = y;
        double d1 = z;
        int i1 = renderer.field_147845_a.func_72805_g(x, y, z);
        boolean flag = false;
        boolean flag1 = BlockDoublePlant.func_149887_c((int)i1);
        int k1 = flag1 ? BlockDoublePlant.func_149890_d((int)renderer.field_147845_a.func_72805_g(x, y - 1, z)) : BlockDoublePlant.func_149890_d((int)i1);
        IIcon iicon = block.func_149888_a(flag1, k1);
        renderer.func_147765_a(iicon, d19, d0, d1, 1.0f);
        if (flag1 && k1 == 0) {
            IIcon iicon1 = block.field_149891_b[0];
            double d2 = Math.cos((double)j1 * 0.8) * Math.PI * 0.1;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            double d5 = iicon1.func_94209_e();
            double d6 = iicon1.func_94206_g();
            double d7 = iicon1.func_94212_f();
            double d8 = iicon1.func_94210_h();
            double d9 = 0.3;
            double d10 = -0.05;
            double d11 = 0.5 + 0.3 * d3 - 0.5 * d4;
            double d12 = 0.5 + 0.5 * d3 + 0.3 * d4;
            double d13 = 0.5 + 0.3 * d3 + 0.5 * d4;
            double d14 = 0.5 + -0.5 * d3 + 0.3 * d4;
            double d15 = 0.5 + -0.05 * d3 + 0.5 * d4;
            double d16 = 0.5 + -0.5 * d3 + -0.05 * d4;
            double d17 = 0.5 + -0.05 * d3 - 0.5 * d4;
            double d18 = 0.5 + 0.5 * d3 + -0.05 * d4;
            tessellator.func_78374_a(d19 + d15, d0 + 1.0, d1 + d16, d5, d8);
            tessellator.func_78374_a(d19 + d17, d0 + 1.0, d1 + d18, d7, d8);
            tessellator.func_78374_a(d19 + d11, d0 + 0.0, d1 + d12, d7, d6);
            tessellator.func_78374_a(d19 + d13, d0 + 0.0, d1 + d14, d5, d6);
            IIcon iicon2 = block.field_149891_b[1];
            d5 = iicon2.func_94209_e();
            d6 = iicon2.func_94206_g();
            d7 = iicon2.func_94212_f();
            d8 = iicon2.func_94210_h();
            tessellator.func_78374_a(d19 + d17, d0 + 1.0, d1 + d18, d5, d8);
            tessellator.func_78374_a(d19 + d15, d0 + 1.0, d1 + d16, d7, d8);
            tessellator.func_78374_a(d19 + d13, d0 + 0.0, d1 + d14, d7, d6);
            tessellator.func_78374_a(d19 + d11, d0 + 0.0, d1 + d12, d5, d6);
        }
        return true;
    }
}

