/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.world.gen.feature;

import com.jaquadro.minecraft.modularpots.block.BlockLargePot;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public abstract class WorldGenOrnamentalTree
extends WorldGenAbstractTree {
    private final Block wood;
    private final Block leaves;
    private final int metaWood;
    private final int metaLeaves;
    protected static final String PATTERN_1X1 = "X";
    protected static final String PATTERN_3X3PLUS = " X XXX X ";
    protected static final String PATTERN_3X3 = "XXXXXXXXX";
    protected static final String PATTERN_5X5PLUS = "  X   XXX XXXXX XXX   X  ";
    protected static final String PATTERN_5X5PLUSW = " XXX XXXXXXXXXXXXXXX XXX ";
    protected static final String PATTERN_5X5 = "XXXXXXXXXXXXXXXXXXXXXXXXX";
    protected static final String PATTERN_5X5UNBAL1 = " XX  XXXX XXXX  XXX      ";
    protected static final String PATTERN_5X5UNBAL2 = "  XX  XXXX XXXX XXX      ";
    protected static final String PATTERN_5X5UNBAL3 = "      XXX  XXXX XXXX  XX ";
    protected static final String PATTERN_5X5UNBAL4 = "      XXX XXXX XXXX  XX  ";

    public WorldGenOrnamentalTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
        super(blockNotify);
        this.wood = wood;
        this.leaves = leaves;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        boolean potted = world.func_147439_a(x, y - 1, z) instanceof BlockLargePot;
        int height = potted ? 5 : 6;
        int trunkHeight = height - 4;
        this.prepare(world, rand, x, y, z, trunkHeight);
        if (!this.canGenerate(world, x, y, z, height)) {
            return false;
        }
        this.generateCanopy(world, x, y, z, trunkHeight);
        this.generateTrunk(world, x, y, z, trunkHeight);
        return true;
    }

    private boolean canGenerate(World world, int x, int y, int z, int height) {
        int trunkHeight = height - 4;
        if (y + height > 256) {
            return false;
        }
        return this.canGenerateTrunk(world, x, y, z, trunkHeight) && this.canGenerateCanopy(world, x, y, z, trunkHeight);
    }

    protected void prepare(World world, Random rand, int x, int y, int z, int trunkHeight) {
    }

    protected boolean canGenerateTrunk(World world, int x, int y, int z, int trunkHeight) {
        for (int iy = y; iy < y + trunkHeight; ++iy) {
            if (this.isReplaceable(world, x, iy, z)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean canGenerateCanopy(World var1, int var2, int var3, int var4, int var5);

    protected void generateTrunk(World world, int x, int y, int z, int trunkHeight) {
        for (int iy = y; iy < y + trunkHeight + 1; ++iy) {
            this.generateBlock(world, x, iy, z, this.wood, this.metaWood);
        }
    }

    protected abstract void generateCanopy(World var1, int var2, int var3, int var4, int var5);

    private int getPatternDim(String pattern) {
        return (int)Math.floor(Math.sqrt(pattern.length()));
    }

    protected boolean canGeneratePattern(World world, int x, int y, int z, String pattern) {
        int dim = this.getPatternDim(pattern) / 2;
        for (int ix = x - dim; ix <= x + dim; ++ix) {
            for (int iz = z - dim; iz <= z + dim; ++iz) {
                int index = (iz - z + dim) * (dim * 2 + 1) + (ix - x + dim);
                if (pattern.charAt(index) != 'X' || this.isReplaceable(world, ix, y, iz)) continue;
                return false;
            }
        }
        return true;
    }

    protected void generatePattern(World world, int x, int y, int z, String pattern) {
        int dim = this.getPatternDim(pattern) / 2;
        for (int ix = x - dim; ix <= x + dim; ++ix) {
            for (int iz = z - dim; iz <= z + dim; ++iz) {
                int index = (iz - z + dim) * (dim * 2 + 1) + (ix - x + dim);
                if (pattern.charAt(index) != 'X') continue;
                this.generateBlock(world, ix, y, iz);
            }
        }
    }

    private void generateBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z)) {
            this.func_150516_a(world, x, y, z, this.leaves, this.metaLeaves);
        }
    }

    private void generateBlock(World world, int x, int y, int z, Block block, int meta) {
        Block existingBlock = world.func_147439_a(x, y, z);
        if (existingBlock.isAir((IBlockAccess)world, x, y, z) || existingBlock.isLeaves((IBlockAccess)world, x, y, z)) {
            this.func_150516_a(world, x, y, z, block, meta);
        }
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return super.isReplaceable(world, x, y, z);
    }
}

