/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block;

import com.jaquadro.minecraft.modularpots.ModBlocks;
import com.jaquadro.minecraft.modularpots.ModItems;
import com.jaquadro.minecraft.modularpots.addon.PlantHandlerRegistry;
import com.jaquadro.minecraft.modularpots.block.BlockLargePot;
import com.jaquadro.minecraft.modularpots.client.ClientProxy;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityLargePot;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenAcaciaOrnTree;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenJungleOrnTree;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenOakOrnTree;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenOrnamentalTree;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenPineOrnTree;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockLargePotPlantProxy
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon transpIcon;
    private int scratchX;
    private int scratchY;
    private int scratchZ;
    private boolean applyingBonemeal;
    private int reeLightValue;

    public BlockLargePotPlantProxy(String blockName) {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149713_g(0);
        this.func_149663_c(blockName);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.transformPlantRenderID;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        Block block = this.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            return null;
        }
        return block.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        Block block = this.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            return super.func_149633_g(world, x, y, z);
        }
        return block.func_149633_g(world, x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        Block block = this.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        } else {
            block.func_149743_a(world, x, y, z, mask, list, colliding);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        Block block = this.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            return super.func_149731_a(world, x, y, z, startVec, endVec);
        }
        return block.func_149731_a(world, x, y, z, startVec, endVec);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.hasValidUnderBlock((IBlockAccess)world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77973_b() == ModItems.usedSoilTestKit) {
            return this.applyTestKit(world, x, y, z, itemStack);
        }
        return false;
    }

    public boolean applyTestKit(World world, int x, int y, int z, ItemStack testKit) {
        BlockLargePot block = this.getAttachedPot((IBlockAccess)world, x, y, z);
        if (block == null) {
            return false;
        }
        y = this.getAttachedPotYIndex((IBlockAccess)world, x, y, z);
        return block.applyTestKit(world, x, y, z, testKit);
    }

    public boolean applyBonemeal(World world, int x, int y, int z) {
        this.applyingBonemeal = true;
        if (PlantHandlerRegistry.applyBonemeal(world, x, y, z)) {
            this.applyingBonemeal = false;
            return true;
        }
        Block block = this.getItemBlock((IBlockAccess)world, x, y, z);
        if (block != Blocks.field_150345_g) {
            this.applyingBonemeal = false;
            return false;
        }
        TileEntityLargePot te = this.getAttachedPotEntity((IBlockAccess)world, x, y, z);
        int blockMeta = te.getFlowerPotData();
        this.scratchX = x;
        this.scratchY = y;
        this.scratchZ = z;
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        WorldGenOrnamentalTree generator = null;
        switch (blockMeta) {
            case 0: 
            case 2: {
                generator = new WorldGenOakOrnTree(false, ModBlocks.thinLog, blockMeta, (Block)Blocks.field_150362_t, blockMeta);
                break;
            }
            case 1: {
                generator = new WorldGenPineOrnTree(false, ModBlocks.thinLog, blockMeta, (Block)Blocks.field_150362_t, blockMeta);
                break;
            }
            case 3: {
                generator = new WorldGenJungleOrnTree(false, ModBlocks.thinLog, blockMeta, (Block)Blocks.field_150362_t, blockMeta);
                break;
            }
            case 4: {
                generator = new WorldGenAcaciaOrnTree(false, ModBlocks.thinLog, blockMeta, (Block)Blocks.field_150361_u, blockMeta & 3);
                break;
            }
            case 5: {
                generator = new WorldGenOakOrnTree(false, ModBlocks.thinLog, blockMeta, (Block)Blocks.field_150361_u, blockMeta & 3);
            }
        }
        if (generator == null || !generator.func_76484_a(world, world.field_73012_v, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, blockMeta, 4);
        }
        this.applyingBonemeal = false;
        return true;
    }

    public void func_149681_a(World world, int x, int y, int z, int p_149681_5_, EntityPlayer player) {
        TileEntityLargePot tileEntity;
        super.func_149681_a(world, x, y, z, p_149681_5_, player);
        if (player.field_71075_bZ.field_75098_d && this.isUnderBlockPot((IBlockAccess)world, x, y, z) && (tileEntity = this.getAttachedPotEntity((IBlockAccess)world, x, y, z)) != null) {
            tileEntity.setItem(null, 0);
            tileEntity.func_70296_d();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileEntityLargePot tileEntity;
        if (this.isUnderBlockPot((IBlockAccess)world, x, y, z) && !this.isApplyingBonemealTo(x, y, z) && (tileEntity = this.getAttachedPotEntity((IBlockAccess)world, x, y, z)) != null && tileEntity.getFlowerPotItem() != null) {
            ItemStack item = new ItemStack(tileEntity.getFlowerPotItem(), 1, tileEntity.getFlowerPotData());
            this.func_149642_a(world, x, y, z, item);
        }
        world.func_147460_e(x, y + 1, z, block);
        world.func_147460_e(x, y - 1, z, block);
        super.func_149749_a(world, x, y, z, block, data);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    private boolean isApplyingBonemealTo(int x, int y, int z) {
        return this.applyingBonemeal;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.reeLightValue > 0) {
            return this.func_149750_m();
        }
        ++this.reeLightValue;
        Block block = this.getItemBlock(world, x, y, z);
        int value = block == null ? super.getLightValue(world, x, y, z) : block.getLightValue(world, x, y, z);
        --this.reeLightValue;
        return value;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        Block block = this.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            super.func_149670_a(world, x, y, z, entity);
        } else {
            block.func_149670_a(world, x, y, z, entity);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        Block block = this.getItemBlock(world, x, y, z);
        if (block == null) {
            return super.func_149673_e(world, x, y, z, side);
        }
        return block.func_149673_e(world, x, y, z, side);
    }

    public IIcon func_149691_a(int side, int data) {
        return this.transpIcon;
    }

    private boolean hasValidUnderBlock(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return false;
        }
        Block underBlock = world.func_147439_a(x, y - 1, z);
        return underBlock instanceof BlockLargePotPlantProxy || underBlock instanceof BlockLargePot;
    }

    private boolean isUnderBlockPot(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return false;
        }
        Block underBlock = world.func_147439_a(x, y - 1, z);
        return underBlock instanceof BlockLargePot;
    }

    private int getAttachedPotYIndex(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return 0;
        }
        Block underBlock = world.func_147439_a(x, --y, z);
        while (y > 0 && underBlock instanceof BlockLargePotPlantProxy) {
            underBlock = world.func_147439_a(x, --y, z);
        }
        return y;
    }

    private BlockLargePot getAttachedPot(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return null;
        }
        Block underBlock = world.func_147439_a(x, --y, z);
        while (y > 0 && underBlock instanceof BlockLargePotPlantProxy) {
            underBlock = world.func_147439_a(x, --y, z);
        }
        if (!(underBlock instanceof BlockLargePot)) {
            return null;
        }
        return (BlockLargePot)underBlock;
    }

    public TileEntityLargePot getAttachedPotEntity(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return null;
        }
        Block underBlock = world.func_147439_a(x, --y, z);
        while (y > 0 && underBlock instanceof BlockLargePotPlantProxy) {
            underBlock = world.func_147439_a(x, --y, z);
        }
        if (!(underBlock instanceof BlockLargePot)) {
            return null;
        }
        BlockLargePot largePot = (BlockLargePot)underBlock;
        return largePot.getTileEntity(world, x, y, z);
    }

    public Block getItemBlock(IBlockAccess world, int x, int y, int z) {
        TileEntityLargePot tile = this.getAttachedPotEntity(world, x, y, z);
        if (tile == null) {
            return null;
        }
        Item item = tile.getFlowerPotItem();
        if (item == null) {
            return null;
        }
        if (item instanceof IPlantable) {
            return ((IPlantable)item).getPlant(world, x, y, z);
        }
        if (item instanceof ItemBlock) {
            return Block.func_149634_a((Item)item);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.transpIcon = iconRegister.func_94245_a("modularpots:proxy_transp");
    }
}

