/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.IPacketReceiver;
import net.smart.moving.IPacketSender;
import net.smart.moving.SmartMovingInfo;

public class SmartMovingPacketStream {
    public static final String Id;
    public static final Set<StackTraceElement> errors;

    public static void receivePacket(FMLProxyPacket packet, IPacketReceiver comm, IEntityPlayerMP player) {
        try {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(packet.payload().array());
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            byte packetId = objectInput.readByte();
            switch (packetId) {
                case 0: {
                    int entityId = objectInput.readInt();
                    long state = objectInput.readLong();
                    comm.processStatePacket(packet, player, entityId, state);
                    break;
                }
                case 1: {
                    String info = (String)objectInput.readObject();
                    comm.processConfigInfoPacket(packet, player, info);
                    break;
                }
                case 2: {
                    String[] content = (String[])objectInput.readObject();
                    String username = (String)objectInput.readObject();
                    comm.processConfigContentPacket(packet, player, content, username);
                    break;
                }
                case 3: {
                    comm.processConfigChangePacket(packet, player);
                    break;
                }
                case 4: {
                    int difference = objectInput.readInt();
                    String username = (String)objectInput.readObject();
                    comm.processSpeedChangePacket(packet, player, difference, username);
                    break;
                }
                case 5: {
                    float hunger = objectInput.readFloat();
                    comm.processHungerChangePacket(packet, player, hunger);
                    break;
                }
                case 6: {
                    String soundId = (String)objectInput.readObject();
                    float volume = objectInput.readFloat();
                    float pitch = objectInput.readFloat();
                    comm.processSoundPacket(packet, player, soundId, volume, pitch);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown packet id '" + packetId + "' found");
                }
            }
        }
        catch (Throwable t) {
            if (errors.add(t.getStackTrace()[0])) {
                t.printStackTrace();
            }
            System.err.println(t.getClass().getName() + ": " + t.getMessage());
        }
    }

    public static void sendState(IPacketSender comm, int entityId, long state) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(0);
            objectOutput.writeInt(entityId);
            objectOutput.writeLong(state);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendConfigInfo(IPacketSender comm, String info) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(1);
            objectOutput.writeObject(info);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendConfigContent(IPacketSender comm, String[] content, String username) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(2);
            objectOutput.writeObject(content);
            objectOutput.writeObject(username);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendConfigChange(IPacketSender comm) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(3);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendSpeedChange(IPacketSender comm, int difference, String username) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(4);
            objectOutput.writeInt(difference);
            objectOutput.writeObject(username);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendHungerChange(IPacketSender comm, float hunger) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(5);
            objectOutput.writeFloat(hunger);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    public static void sendSound(IPacketSender comm, String soundId, float volume, float pitch) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
            objectOutput.writeByte(6);
            objectOutput.writeObject(soundId);
            objectOutput.writeFloat(volume);
            objectOutput.writeFloat(pitch);
            objectOutput.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        comm.sendPacket(byteOutput.toByteArray());
    }

    static {
        String id = SmartMovingInfo.ModComId;
        if (id.length() > 15) {
            id = id.substring(0, 15);
        }
        Id = id;
        errors = new HashSet<StackTraceElement>();
    }
}

