/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C13PacketPlayerAbilities;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.smart.moving.Button;
import net.smart.moving.ClimbGap;
import net.smart.moving.FeetClimbing;
import net.smart.moving.HandsClimbing;
import net.smart.moving.IEntityPlayerSP;
import net.smart.moving.ISmartMovingSelf;
import net.smart.moving.Orientation;
import net.smart.moving.SmartMoving;
import net.smart.moving.SmartMovingComm;
import net.smart.moving.SmartMovingInstall;
import net.smart.moving.SmartMovingPacketStream;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.moving.render.SmartMovingRender;
import net.smart.render.statistics.SmartStatisticsFactory;
import net.smart.utilities.Reflect;

public class SmartMovingSelf
extends SmartMoving
implements ISmartMovingSelf {
    private boolean initialized = false;
    private int multiPlayerInitialized;
    private int updateCounter;
    private float distanceSwom;
    private static ClimbGap out_handsClimbGap = new ClimbGap();
    private static ClimbGap out_feetClimbGap = new ClimbGap();
    private static HandsClimbing[] inout_handsClimbing = new HandsClimbing[1];
    private static FeetClimbing[] inout_feetClimbing = new FeetClimbing[1];
    public boolean wantClimbUp;
    public boolean wantClimbDown;
    public boolean wantSprint;
    public boolean wantCrawlNotClimb;
    public boolean wantClimbCeiling;
    public boolean isStanding;
    public boolean wouldIsSneaking;
    public boolean isVineOnlyClimbing;
    public boolean isVineAnyClimbing;
    public boolean isClimbingStill;
    public boolean isClimbHolding;
    public boolean isNeighborClimbing;
    public boolean hasClimbGap;
    public boolean hasClimbCrawlGap;
    public boolean hasNeighborClimbGap;
    public boolean hasNeighborClimbCrawlGap;
    public float dippingDepth;
    public boolean isJumping;
    public boolean isJumpingOutOfWater;
    public boolean isShallowDiveOrSwim;
    public boolean isFakeShallowWaterSneaking;
    public boolean isStillSwimmingJump;
    public boolean isGroundSprinting;
    public boolean isSprintJump;
    public boolean isAerodynamic;
    public Block handsEdgeBlock;
    public int handsEdgeMeta;
    public Block feetEdgeBlock;
    public int feetEdgeMeta;
    public int waterMovementTicks;
    public float exhaustion = 0.0f;
    public float jumpCharge;
    public float headJumpCharge;
    public boolean blockJumpTillButtonRelease;
    public float maxExhaustionForAction;
    public float maxExhaustionToStartAction;
    public float prevMaxExhaustionForAction = Float.NaN;
    public float prevMaxExhaustionToStartAction = Float.NaN;
    public float foreignExhaustionFactor;
    public float foreignMaxExhaustionForAction = Float.MAX_VALUE;
    public float foreignMaxExhaustionToStartAction = Float.MAX_VALUE;
    public double lastHorizontalCollisionX = 0.0;
    public double lastHorizontalCollisionZ = 0.0;
    public float lastHungerIncrease = -2.0f;
    private double beforeMoveEntityPosX;
    private double beforeMoveEntityPosY;
    private double beforeMoveEntityPosZ;
    private float beforeDistanceWalkedModified;
    private float horizontalCollisionAngle;
    boolean wasOnGround;
    boolean wasCapabilitiesIsFlying;
    private float fadingPerspectiveFactor = -1.0f;
    private boolean wasInventory;
    private double jumpMotionX;
    private double jumpMotionZ;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public final Button forwardButton = new Button();
    public final Button leftButton = new Button();
    public final Button rightButton = new Button();
    public final Button backButton = new Button();
    public final Button jumpButton = new Button();
    public final Button sneakButton = new Button();
    public final Button grabButton = new Button();
    public final Button sprintButton = new Button();
    public final Button toggleButton = new Button();
    public final Button speedIncreaseButton = new Button();
    public final Button speedDecreaseButton = new Button();
    public boolean wasRunning;
    public boolean wasLevitating;
    public boolean wasCrawling;
    public boolean wasHeadJumping;
    private boolean contextContinueCrawl;
    private boolean ignoreNextStopSneakButtonPressed;
    private int collidedHorizontallyTickCount;
    private boolean wantWallJumping;
    private boolean continueWallJumping;
    private boolean wasCollidedHorizontally;
    private boolean wasRunningWhenSprintStarted;
    private boolean jumpAvoided;
    private int climbIntoCount;
    private int leftJumpCount;
    private int rightJumpCount;
    private int backJumpCount;
    private int wallJumpCount;
    private int nextClimbDistance = 0;
    public float distanceClimbedModified = 0.0f;
    private boolean sneakToggled = false;
    private boolean crawlToggled = false;
    private int lastWorldPlayerEntitiesSize = -1;
    private int lastWorldPlayerLastEnttyId = -1;
    private long prevPacketState = -1L;
    private static Class<?> ropesPlusClient = Reflect.LoadClass(SmartMovingInstall.class, SmartMovingInstall.RopesPlusClient, false);
    private static Field onZipLine = ropesPlusClient != null ? Reflect.GetField(ropesPlusClient, SmartMovingInstall.RopesPlusClient_onZipLine, false) : null;

    public SmartMovingSelf(EntityPlayer sp, IEntityPlayerSP isp) {
        super(sp, isp);
    }

    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        if (this.sp.motionX == 0.0 && this.prevMotionX < 0.005) {
            this.sp.motionX = this.prevMotionX;
        }
        if (this.sp.motionZ == 0.0 && this.prevMotionZ < 0.005) {
            this.sp.motionZ = this.prevMotionZ;
        }
        if (this.sp.capabilities.isFlying && !Config.isFlyingEnabled()) {
            double d3 = this.sp.motionY;
            float f2 = this.sp.jumpMovementFactor;
            this.sp.jumpMovementFactor = 0.05f;
            this.superMoveEntityWithHeading(moveStrafing, moveForward);
            this.sp.motionY = d3 * 0.6;
            this.sp.jumpMovementFactor = f2;
        } else {
            this.superMoveEntityWithHeading(moveStrafing, moveForward);
        }
    }

    private void superMoveEntityWithHeading(float moveStrafing, float moveForward) {
        if (this.isRunning() && !Config.isRunningEnabled()) {
            this.sp.setSprinting(false);
        }
        boolean wasShortInWater = this.isSwimming || this.isDiving;
        boolean wasSwimming = this.isSwimming;
        boolean wasClimbing = this.isClimbing;
        boolean wasDiving = this.isDiving;
        boolean wasCeilingClimbing = this.isCeilingClimbing;
        boolean wasJumpingOutOfWater = this.isJumpingOutOfWater;
        this.handleJumping();
        double d_S = this.sp.posX;
        double d1_S = this.sp.posY;
        double d2_S = this.sp.posZ;
        if (this.sp.isCollidedHorizontally) {
            this.lastHorizontalCollisionX = this.sp.posX;
            this.lastHorizontalCollisionZ = this.sp.posZ;
        }
        float speedFactor = this.getSpeedFactor(moveForward, moveStrafing);
        boolean isLiquidClimbing = Config.isFreeClimbingEnabled() && (double)this.sp.fallDistance <= 3.0 && this.wantClimbUp && this.sp.isCollidedHorizontally && !this.isDiving;
        boolean handledSwimming = this.handleSwimming(moveForward, moveStrafing, speedFactor, wasSwimming, wasDiving, isLiquidClimbing, wasJumpingOutOfWater);
        boolean handledLava = this.handleLava(moveForward, moveStrafing, handledSwimming, isLiquidClimbing);
        boolean handledAlternativeFlying = this.handleAlternativeFlying(moveForward, moveStrafing, speedFactor, handledSwimming, handledLava);
        this.handleLand(moveForward, moveStrafing, speedFactor, handledSwimming, handledLava, handledAlternativeFlying, wasShortInWater, wasClimbing, wasCeilingClimbing);
        this.handleWallJumping();
        double diffX = this.sp.posX - d_S;
        double diffY = this.sp.posY - d1_S;
        double diffZ = this.sp.posZ - d2_S;
        this.sp.addMovementStat(diffX, diffY, diffZ);
        this.handleExhaustion(diffX, diffY, diffZ);
    }

    private float getSpeedFactor() {
        return SmartMovingSelf.Config.enabled ? ((Float)SmartMovingSelf.Config._speedFactor.value).floatValue() * Config.getUserSpeedFactor() * this.getLandMovementFactor() * 10.0f / (this.sp.isSprinting() ? 1.3f : 1.0f) : 1.0f;
    }

    private float getSpeedFactor(float moveForward, float moveStrafing) {
        float speedFactor = this.getSpeedFactor();
        if (this.sp.isUsingItem()) {
            float itemFactor = 0.2f;
            if (SmartMovingSelf.Config.enabled) {
                Item item = this.sp.getItemInUse().getItem();
                itemFactor = item instanceof ItemSword ? ((Float)SmartMovingSelf.Config._usageSwordSpeedFactor.value).floatValue() : (item instanceof ItemBow ? ((Float)SmartMovingSelf.Config._usageBowSpeedFactor.value).floatValue() : (item instanceof ItemFood ? ((Float)SmartMovingSelf.Config._usageFoodSpeedFactor.value).floatValue() : ((Float)SmartMovingSelf.Config._usageSpeedFactor.value).floatValue()));
            }
            speedFactor *= itemFactor;
        }
        if (this.isCrawling || this.isCrawlClimbing && !this.isClimbCrawling) {
            speedFactor *= ((Float)SmartMovingSelf.Config._crawlFactor.value).floatValue();
        } else if (this.isSlow) {
            speedFactor *= ((Float)SmartMovingSelf.Config._sneakFactor.value).floatValue();
        }
        if (this.isFast) {
            speedFactor *= ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue();
        }
        if (this.isClimbing) {
            if (moveStrafing != 0.0f || moveForward != 0.0f) {
                speedFactor *= ((Float)SmartMovingSelf.Config._freeClimbingHorizontalSpeedFactor.value).floatValue();
            } else if (this.wantClimbDown && this.isNeighborClimbing && (!(Math.abs(this.sp.posX - this.lastHorizontalCollisionX) < 0.05) || !(Math.abs(this.sp.posZ - this.lastHorizontalCollisionZ) < 0.05))) {
                moveForward = 0.3f;
                if (this.isVineOnlyClimbing) {
                    if (this.handsEdgeMeta != 0 && this.feetEdgeMeta != 0) {
                        moveForward = 0.0f;
                    } else {
                        Orientation orientation = Orientation.getOrientation(this.sp, 45.0f, true, false);
                        if (orientation != null) {
                            float gap = (float)orientation.getHorizontalBorderGap((Entity)this.sp);
                            float minGap = this.sp.width / 2.0f;
                            float factor = Math.max(0.0f, gap * (1.0f + minGap) - minGap);
                            moveForward = factor * factor * 0.3f;
                        }
                    }
                }
            }
        }
        if (this.isCeilingClimbing) {
            speedFactor *= ((Float)SmartMovingSelf.Config._ceilingClimbingSpeedFactor.value).floatValue();
        }
        return speedFactor;
    }

    private boolean handleSwimming(float moveForward, float moveStrafing, float speedFactor, boolean wasSwimming, boolean wasDiving, boolean isLiquidClimbing, boolean wasJumpingOutOfWater) {
        boolean handleSwimming;
        boolean handleSwimmingRejected = false;
        boolean bl = handleSwimming = !this.isFlying && !isLiquidClimbing && (this.sp.isInWater() || wasSwimming && this.isInLiquid() || Config.isLavaLikeWaterEnabled() && this.sp.handleLavaMovement());
        if (handleSwimming) {
            boolean useStandard;
            this.resetClimbing();
            float wasHeightOffset = this.heightOffset;
            boolean bl2 = useStandard = !Config.isSwimmingEnabled() && !Config.isDivingEnabled();
            if (this.sp.ridingEntity != null) {
                this.resetSwimming();
                useStandard = true;
            }
            if (useStandard && this.isCrawling) {
                this.standupIfPossible();
            } else {
                this.resetHeightOffset();
            }
            if (!useStandard) {
                boolean wantShallowSwim;
                this.resetSwimming();
                int i = MathHelper.floor_double((double)this.sp.posX);
                int j = MathHelper.floor_double((double)this.sp.boundingBox.minY);
                int k = MathHelper.floor_double((double)this.sp.posZ);
                boolean swimming = false;
                boolean diving = false;
                boolean dipping = false;
                double j_offset = this.sp.boundingBox.minY - (double)j;
                double totalSwimWaterBorder = this.getMaxPlayerLiquidBetween(this.sp.boundingBox.maxY - 1.8, this.sp.boundingBox.maxY + 1.2);
                double minPlayerSwimWaterCeiling = this.getMinPlayerSolidBetween(this.sp.boundingBox.maxY - 1.8, this.sp.boundingBox.maxY + 1.2, 0.0);
                double realTotalSwimWaterBorder = Math.min(totalSwimWaterBorder, minPlayerSwimWaterCeiling);
                double minPlayerSwimWaterDepth = totalSwimWaterBorder - this.getMaxPlayerSolidBetween(totalSwimWaterBorder - 2.0, totalSwimWaterBorder, 0.0);
                double realMinPlayerSwimWaterDepth = totalSwimWaterBorder - this.getMaxPlayerSolidBetween(realTotalSwimWaterBorder - 2.0, realTotalSwimWaterBorder, 0.0);
                double playerSwimWaterBorder = totalSwimWaterBorder - (double)j - j_offset;
                if (this.isCrawling && playerSwimWaterBorder > (double)0.65f) {
                    this.standupIfPossible();
                }
                double motionYDiff = 0.0;
                boolean couldStandUp = playerSwimWaterBorder >= 0.0 && minPlayerSwimWaterDepth <= 1.5;
                boolean diveUp = this.isp.getIsJumpingField();
                boolean diveDown = this.esp.movementInput.sneak && (Boolean)SmartMovingSelf.Config._diveDownOnSneak.value != false;
                boolean swimDown = this.esp.movementInput.sneak && (Boolean)SmartMovingSelf.Config._swimDownOnSneak.value != false;
                boolean bl3 = wantShallowSwim = couldStandUp && (wasSwimming || wasDiving);
                if (wantShallowSwim) {
                    HashSet<Orientation> orientations = Orientation.getClimbingOrientations(this.sp, true, true);
                    Iterator<Orientation> iterator = orientations.iterator();
                    while (iterator.hasNext() && (wantShallowSwim &= !iterator.next().isTunnelAhead(this.sp.worldObj, i, j, k))) {
                    }
                }
                if (wasSwimming && wantShallowSwim && swimDown) {
                    swimDown = false;
                    this.isFakeShallowWaterSneaking = true;
                }
                if (this.isDiving && diveUp && diveDown) {
                    diveDown = false;
                    diveUp = false;
                }
                if (this.isCrawling || this.isClimbCrawling || this.isCrawlClimbing) {
                    this.isDipping = true;
                } else if (playerSwimWaterBorder >= 0.0 && playerSwimWaterBorder <= 2.0) {
                    boolean moveSwim;
                    double offset = playerSwimWaterBorder + 0.1625;
                    boolean bl4 = moveSwim = this.sp.rotationPitch < 0.0f && this.esp.movementInput.moveForward > 0.0f || this.sp.rotationPitch > 0.0f && this.esp.movementInput.moveForward < 0.0f;
                    if (diveUp || moveSwim || wantShallowSwim) {
                        if (offset < 1.4) {
                            dipping = true;
                            motionYDiff = offset < 1.0 ? -0.02 : -0.01;
                        } else if (offset < 1.9) {
                            swimming = true;
                            if (swimDown) {
                                motionYDiff = -0.05 * (double)(this.isFast ? ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue() : 1.0f);
                            } else if (offset < 1.5) {
                                motionYDiff = -0.02;
                            }
                            motionYDiff = offset < 1.6 ? -0.01 : (offset < 1.62 ? -0.005 : (offset < 1.64 ? -0.0025 : (offset < 1.66 ? -0.00125 : (offset < 1.664 ? -6.25E-4 : (offset < 1.668 ? 0.0 : (offset < 1.672 ? 6.25E-4 : (offset < 1.676 ? 0.00125 : (offset < 1.68 ? 0.0025 : (offset < 1.7 ? 0.005 : (offset < 1.8 ? 0.01 : 0.02))))))))));
                        } else {
                            diving = true;
                            motionYDiff = diveUp ? 0.05 * (double)(this.isFast ? ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue() : 1.0f) : (diveDown ? 0.01 - 0.1 * (double)speedFactor : (moveSwim ? 0.04 : 0.02));
                        }
                    } else if (offset < 1.5) {
                        dipping = true;
                        motionYDiff = offset < 1.0 ? -0.02 : -0.02;
                    } else {
                        diving = true;
                        motionYDiff = diveDown ? 0.01 - 0.1 * (double)speedFactor : (offset < 1.8 ? -0.02 : (offset < 1.82 ? -0.01 : (offset < 1.84 ? -0.005 : (offset < 1.86 ? -0.0025 : (offset < 1.864 ? -0.00125 : (offset < 1.868 ? 0.0 : (offset < 1.872 ? 0.00125 : (offset < 1.876 ? 0.0025 : (offset < 1.88 ? 0.005 : (offset < 1.9 ? 0.01 : 0.01))))))))));
                    }
                } else if (playerSwimWaterBorder > 2.0) {
                    diving = true;
                    motionYDiff = diveUp ? (this.isFast && playerSwimWaterBorder < 2.5 && this.sp.worldObj.isAirBlock(i, j + 3, k) ? 0.11 / (double)((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue() : 0.01 + 0.1 * (double)speedFactor) : (diveDown ? 0.01 - 0.1 * (double)speedFactor : 0.01);
                } else {
                    handleSwimmingRejected = true;
                }
                this.dippingDepth = (float)playerSwimWaterBorder;
                float playerCrawlWaterBorder = this.dippingDepth + wasHeightOffset;
                if ((this.isCrawling || this.isSliding) && playerCrawlWaterBorder < 1.0f) {
                    if (playerCrawlWaterBorder < 0.65f) {
                        this.setHeightOffset(wasHeightOffset);
                        handleSwimmingRejected = true;
                    } else {
                        if (wantShallowSwim) {
                            this.move(0.0, 0.1, 0.0, true);
                        }
                        this.isCrawling = false;
                        this.isDiving = false;
                        this.isSwimming = true;
                        this.isDipping = false;
                    }
                }
                if (!handleSwimmingRejected) {
                    swimming = !useStandard && swimming && Config.isSwimmingEnabled();
                    diving = !useStandard && diving && Config.isDivingEnabled();
                    dipping = !useStandard && dipping && Config.isSwimmingEnabled();
                    boolean bl5 = useStandard = !swimming && !diving && !dipping;
                    if (!useStandard) {
                        boolean levitating;
                        if (diveUp) {
                            this.sp.motionY -= (double)0.04f;
                        }
                        if (swimming) {
                            this.sp.motionX *= 0.85;
                            this.sp.motionY *= 0.85;
                            this.sp.motionZ *= 0.85;
                        } else if (diving) {
                            this.sp.motionX *= 0.83;
                            this.sp.motionY *= 0.83;
                            this.sp.motionZ *= 0.83;
                        } else if (dipping) {
                            this.sp.motionX *= 0.8;
                            this.sp.motionY *= 0.83;
                            this.sp.motionZ *= 0.8;
                        } else {
                            this.sp.motionX *= 0.9;
                            this.sp.motionY *= 0.85;
                            this.sp.motionZ *= 0.9;
                        }
                        boolean moveFlying = true;
                        boolean bl6 = levitating = diving && !diveUp && !diveDown && moveStrafing == 0.0f && moveForward == 0.0f;
                        if (diving) {
                            speedFactor *= ((Float)SmartMovingSelf.Config._diveSpeedFactor.value).floatValue();
                        }
                        if (swimming) {
                            speedFactor *= ((Float)SmartMovingSelf.Config._swimSpeedFactor.value).floatValue();
                        }
                        this.waterMovementTicks = swimming || diving ? ++this.waterMovementTicks : 0;
                        boolean wantJumpOutOfWater = (moveForward != 0.0f || moveStrafing != 0.0f) && this.sp.isCollidedHorizontally && diveUp && !this.isSlow;
                        boolean bl7 = this.isJumpingOutOfWater = wantJumpOutOfWater && (this.waterMovementTicks > 10 || this.sp.onGround || wasJumpingOutOfWater);
                        if (diving) {
                            if (diveUp || diveDown || levitating) {
                                this.sp.motionY = (this.sp.motionY + motionYDiff) * 0.6;
                            } else {
                                this.moveFlying((float)motionYDiff, moveStrafing, moveForward, 0.02f * speedFactor, (Boolean)SmartMovingSelf.Options._diveControlVertical.value);
                            }
                            moveFlying = false;
                        } else {
                            this.sp.motionY = swimming && swimDown ? (this.sp.motionY + motionYDiff) * 0.6 : (this.isJumpingOutOfWater ? (double)0.3f : (this.sp.motionY += motionYDiff));
                        }
                        this.isDiving = diving;
                        this.isLevitating = levitating;
                        this.isSwimming = swimming;
                        this.isShallowDiveOrSwim = couldStandUp && (this.isDiving || this.isSwimming);
                        this.isDipping = dipping;
                        if (this.isDiving || this.isSwimming) {
                            this.setHeightOffset(-1.0f);
                        }
                        if (this.isShallowDiveOrSwim && realMinPlayerSwimWaterDepth < (double)0.55f) {
                            if (this.isSlow) {
                                this.setHeightOffset(-1.0f);
                                this.isCrawling = true;
                                this.isDiving = false;
                                this.isSwimming = false;
                                this.isShallowDiveOrSwim = false;
                                this.isDipping = true;
                            } else {
                                this.resetHeightOffset();
                                this.sp.moveEntity(0.0, this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY, this.sp.boundingBox.maxY, 0.0) - this.sp.boundingBox.minY, 0.0);
                                this.isCrawling = false;
                                this.isDiving = false;
                                this.isSwimming = false;
                                this.isShallowDiveOrSwim = false;
                                this.isDipping = true;
                            }
                        }
                        if (moveFlying) {
                            this.sp.moveFlying(moveStrafing, moveForward, 0.02f * speedFactor);
                        }
                        this.sp.moveEntity(this.sp.motionX, this.sp.motionY, this.sp.motionZ);
                    }
                }
            } else {
                this.isDiving = false;
                this.isSwimming = false;
                this.isShallowDiveOrSwim = false;
                this.isDipping = false;
                this.isStillSwimmingJump = false;
            }
            if (useStandard) {
                this.resetSwimming();
                if (this.isCrawling) {
                    this.setHeightOffset(wasHeightOffset);
                }
                double dY = this.sp.posY;
                this.sp.moveFlying(moveStrafing, moveForward, 0.02f * speedFactor);
                this.sp.moveEntity(this.sp.motionX, this.sp.motionY, this.sp.motionZ);
                this.sp.motionX *= (double)0.8f;
                this.sp.motionY *= (double)0.8f;
                this.sp.motionZ *= (double)0.8f;
                this.sp.motionY -= 0.02;
                if (this.sp.isCollidedHorizontally && this.sp.isOffsetPositionInLiquid(this.sp.motionX, this.sp.motionY + (double)0.6f - this.sp.posY + dY, this.sp.motionZ)) {
                    this.sp.motionY = 0.3f;
                }
            }
        }
        return handleSwimming && !handleSwimmingRejected;
    }

    private boolean handleLava(float moveForward, float moveStrafing, boolean handledSwimming, boolean isLiquidClimbing) {
        boolean handleLava;
        boolean bl = handleLava = !this.isFlying && !handledSwimming && !isLiquidClimbing && this.sp.handleLavaMovement();
        if (handleLava) {
            this.standupIfPossible();
            this.resetClimbing();
            this.resetSwimming();
            double d1 = this.sp.posY;
            this.sp.moveFlying(moveStrafing, moveForward, 0.02f);
            this.sp.moveEntity(this.sp.motionX, this.sp.motionY, this.sp.motionZ);
            this.sp.motionX *= 0.5;
            this.sp.motionY *= 0.5;
            this.sp.motionZ *= 0.5;
            this.sp.motionY -= 0.02;
            if (this.sp.isCollidedHorizontally && this.sp.isOffsetPositionInLiquid(this.sp.motionX, this.sp.motionY + (double)0.6f - this.sp.posY + d1, this.sp.motionZ)) {
                this.sp.motionY = 0.3f;
            }
        }
        return handleLava;
    }

    private boolean handleAlternativeFlying(float moveForward, float moveStrafing, float speedFactor, boolean handledSwimming, boolean handledLava) {
        boolean handleAlternativeFlying;
        boolean bl = handleAlternativeFlying = !handledSwimming && !handledLava && this.sp.capabilities.isFlying && Config.isFlyingEnabled();
        if (handleAlternativeFlying) {
            this.resetSwimming();
            this.resetClimbing();
            float moveUpward = 0.0f;
            if (this.esp.movementInput.sneak) {
                this.sp.motionY += 0.15;
                moveUpward -= 0.98f;
            }
            if (this.esp.movementInput.jump) {
                this.sp.motionY -= 0.15;
                moveUpward += 0.98f;
            }
            this.moveFlying(moveUpward, moveStrafing, moveForward, speedFactor * 0.05f * ((Float)SmartMovingSelf.Config._flyingSpeedFactor.value).floatValue(), (Boolean)SmartMovingSelf.Options._flyControlVertical.value);
            this.sp.moveEntity(this.sp.motionX, this.sp.motionY, this.sp.motionZ);
            this.sp.motionX *= (double)0.91f;
            this.sp.motionY *= (double)0.91f;
            this.sp.motionZ *= (double)0.91f;
        }
        return handleAlternativeFlying;
    }

    private void handleLand(float moveForward, float moveStrafing, float speedFactor, boolean handledSwimming, boolean handledLava, boolean handledAlternativeFlying, boolean wasShortInWater, boolean wasClimbing, boolean wasCeilingClimbing) {
        if (!(handledSwimming || handledLava || handledAlternativeFlying)) {
            this.resetSwimming();
            if (!this.grabButton.Pressed) {
                this.fromSwimmingOrDiving(wasShortInWater);
            }
            boolean isOnLadder = this.isOnLadder(this.isClimbCrawling);
            boolean isOnVine = this.isOnVine(this.isClimbCrawling);
            float horizontalDamping = this.landMotion(moveForward, moveStrafing, speedFactor, isOnLadder, isOnVine);
            boolean crawlingThroughWeb = (this.isCrawling || this.isCrawlClimbing) && this.isp.getIsInWebField();
            this.move(this.sp.motionX, this.sp.motionY, this.sp.motionZ, crawlingThroughWeb);
            this.handleClimbing(isOnLadder, isOnVine, wasClimbing);
            this.handleCeilingClimbing(wasCeilingClimbing);
            this.setLandMotions(horizontalDamping);
        }
        this.landMotionPost(wasShortInWater);
    }

    private void move(double motionX, double motionY, double motionZ, boolean relocate) {
        boolean isInWeb = this.isp.getIsInWebField();
        if (relocate) {
            this.isp.setIsInWebField(false);
        }
        this.sp.moveEntity(motionX, motionY, motionZ);
        if (relocate) {
            this.isp.setIsInWebField(isInWeb);
        }
    }

    private float landMotion(float moveForward, float moveStrafing, float speedFactor, boolean isOnLadder, boolean isOnVine) {
        int k;
        int i;
        int j;
        double jGap;
        float horizontalDamping;
        Block block;
        if (this.sp.onGround && !this.isJumping) {
            block = this.sp.worldObj.getBlock(MathHelper.floor_double((double)this.sp.posX), MathHelper.floor_double((double)this.sp.boundingBox.minY) - 1, MathHelper.floor_double((double)this.sp.posZ));
            horizontalDamping = block != null ? block.slipperiness * 0.91f : 0.546f;
            if (this.esp.movementInput.jump && this.isFast) {
                if (Config.isJumpingEnabled(0, 0)) {
                    speedFactor *= ((Float)SmartMovingSelf.Config._sprintJumpVerticalFactor.value).floatValue();
                }
            }
        } else {
            horizontalDamping = 0.91f;
        }
        if (this.isClimbing && this.climbingUpIsBlockedByLadder()) {
            this.sp.moveFlying(0.0f, -1.0f, 0.07f);
        } else if (this.isClimbing && this.climbingUpIsBlockedByTrapDoor()) {
            if (this.sp.isOnLadder()) {
                this.sp.moveFlying(0.0f, -1.0f, 0.09f);
            } else {
                this.sp.moveFlying(0.0f, -1.0f, 0.09f);
            }
        } else if (this.isClimbing && this.climbingUpIsBlockedByCobbleStoneWall()) {
            this.sp.moveFlying(0.0f, -1.0f, 0.07f);
        } else if (!this.isSliding) {
            float rawSpeed;
            if (this.isHeadJumping) {
                speedFactor *= ((Float)SmartMovingSelf.Config._headJumpControlFactor.value).floatValue();
            } else if (SmartMovingSelf.Config.enabled && !this.sp.onGround && !this.sp.capabilities.isFlying && !this.isFlying) {
                speedFactor *= ((Float)SmartMovingSelf.Config._jumpControlFactor.value).floatValue();
            }
            float f3 = 0.1627714f / (horizontalDamping * horizontalDamping * horizontalDamping);
            float f4 = this.sp.onGround ? this.getLandMovementFactor() * f3 : this.sp.jumpMovementFactor;
            float f = rawSpeed = this.sp.isSprinting() ? f4 / 1.3f : f4;
            if (Config.isRunningEnabled() && this.isRunning() && !this.isFast) {
                speedFactor *= ((Float)SmartMovingSelf.Config._runFactor.value).floatValue();
            }
            this.sp.moveFlying(moveStrafing, moveForward, rawSpeed * speedFactor);
        }
        if (this.sp.onGround && !this.isJumping) {
            block = this.sp.worldObj.getBlock(MathHelper.floor_double((double)this.sp.posX), MathHelper.floor_double((double)this.sp.boundingBox.minY) - 1, MathHelper.floor_double((double)this.sp.posZ));
            if (block != null) {
                float slipperiness = block.slipperiness;
                if (this.isSliding) {
                    double angle;
                    horizontalDamping = 1.0f / ((1.0f / slipperiness - 1.0f) / 25.0f * ((Float)SmartMovingSelf.Config._slideSlipperinessFactor.value).floatValue() + 1.0f) * 0.98f;
                    if (moveStrafing != 0.0f && ((Float)SmartMovingSelf.Config._slideControlDegrees.value).floatValue() > 0.0f && !Double.isNaN(angle = -Math.atan(this.sp.motionX / this.sp.motionZ))) {
                        if (this.sp.motionZ < 0.0) {
                            angle += Math.PI;
                        }
                        double hMotion = Math.sqrt(this.sp.motionX * this.sp.motionX + this.sp.motionZ * this.sp.motionZ);
                        this.sp.motionX = hMotion * -Math.sin(angle -= (double)(((Float)SmartMovingSelf.Config._slideControlDegrees.value).floatValue() / 57.295776f * Math.signum(moveStrafing)));
                        this.sp.motionZ = hMotion * Math.cos(angle);
                    }
                } else {
                    horizontalDamping = slipperiness * 0.91f;
                }
            } else {
                horizontalDamping = 0.546f;
            }
        } else {
            horizontalDamping = this.isAerodynamic ? 0.999f : 0.91f;
        }
        if (isOnLadder || isOnVine) {
            boolean notTotalFreeClimbing;
            float f4 = 0.15f;
            if (this.sp.motionX < (double)(-f4)) {
                this.sp.motionX = -f4;
            }
            if (this.sp.motionX > (double)f4) {
                this.sp.motionX = f4;
            }
            if (this.sp.motionZ < (double)(-f4)) {
                this.sp.motionZ = -f4;
            }
            if (this.sp.motionZ > (double)f4) {
                this.sp.motionZ = f4;
            }
            boolean bl = notTotalFreeClimbing = !this.isClimbing && isOnLadder && !Config.isTotalFreeLadderClimb() || isOnVine && !Config.isTotalFreeVineClimb();
            if (notTotalFreeClimbing) {
                this.sp.fallDistance = 0.0f;
                this.sp.motionY = Math.max(this.sp.motionY, -0.15 * (double)this.getSpeedFactor());
            }
            if (Config.isFreeBaseClimb()) {
                if (this.esp.movementInput.sneak && this.sp.motionY < 0.0 && !this.sp.onGround && notTotalFreeClimbing) {
                    this.sp.motionY = 0.0;
                }
            } else if (this.isp.localIsSneaking() && this.sp.motionY < 0.0) {
                this.sp.motionY = 0.0;
            }
        } else if (Config.isFreeClimbAutoLaddderEnabled() && moveForward > 0.0f && (jGap = this.sp.boundingBox.minY - (double)(j = MathHelper.floor_double((double)this.sp.boundingBox.minY))) < 0.1 && Orientation.isLadder(this.sp.worldObj.getBlock(i = MathHelper.floor_double((double)this.sp.posX), j - 1, k = MathHelper.floor_double((double)this.sp.posZ)))) {
            this.sp.motionY = Math.max(this.sp.motionY, 0.0);
        }
        return horizontalDamping;
    }

    private void handleClimbing(boolean isOnLadder, boolean isOnVine, boolean wasClimbing) {
        block47: {
            block48: {
                FeetClimbing feetClimbing;
                HandsClimbing handsClimbing;
                block51: {
                    block49: {
                        block55: {
                            block56: {
                                block54: {
                                    block53: {
                                        block52: {
                                            block50: {
                                                float rotation;
                                                boolean isSmallClimbing;
                                                boolean isOnLadderOrVine;
                                                this.resetClimbing();
                                                boolean bl = isOnLadderOrVine = isOnLadder || isOnVine;
                                                if (Config.isStandardBaseClimb() && this.sp.isCollidedHorizontally && isOnLadderOrVine) {
                                                    this.sp.motionY = 0.2 * (double)this.getSpeedFactor();
                                                }
                                                if (Config.isSimpleBaseClimb() && this.sp.isCollidedHorizontally && isOnLadderOrVine) {
                                                    int i = MathHelper.floor_double((double)this.sp.posX);
                                                    int j = MathHelper.floor_double((double)this.sp.boundingBox.minY);
                                                    int k = MathHelper.floor_double((double)this.sp.posZ);
                                                    boolean feet = Orientation.isClimbable(this.sp.worldObj, i, j, k);
                                                    boolean hands = Orientation.isClimbable(this.sp.worldObj, i, j + 1, k);
                                                    this.sp.motionY = feet && hands ? 0.2 : (feet ? 0.2 : (hands ? 0.1 : 0.0));
                                                    this.sp.motionY *= (double)this.getSpeedFactor();
                                                }
                                                if (!Config.isSmartBaseClimb() && !Config.isFreeClimbingEnabled()) break block47;
                                                double id = this.sp.posX;
                                                double jd = this.sp.boundingBox.minY;
                                                double kd = this.sp.posZ;
                                                int i = MathHelper.floor_double((double)id);
                                                int j = MathHelper.floor_double((double)jd);
                                                int k = MathHelper.floor_double((double)kd);
                                                if (Config.isSmartBaseClimb() && isOnLadderOrVine && this.sp.isCollidedHorizontally) {
                                                    boolean feet = Orientation.isClimbable(this.sp.worldObj, i, j, k);
                                                    boolean hands = Orientation.isClimbable(this.sp.worldObj, i, j + 1, k);
                                                    if (feet && hands) {
                                                        this.sp.motionY = 0.2;
                                                    } else if (feet) {
                                                        boolean handsSubstitute;
                                                        boolean bl2 = handsSubstitute = Orientation.PZ.isHandsLadderSubstitute(this.sp.worldObj, i, j + 1, k) || Orientation.NZ.isHandsLadderSubstitute(this.sp.worldObj, i, j + 1, k) || Orientation.ZP.isHandsLadderSubstitute(this.sp.worldObj, i, j + 1, k) || Orientation.ZN.isHandsLadderSubstitute(this.sp.worldObj, i, j + 1, k);
                                                        this.sp.motionY = handsSubstitute ? 0.2 : 0.1;
                                                    } else if (hands) {
                                                        boolean feetSubstitute;
                                                        boolean bl3 = feetSubstitute = Orientation.ZZ.isFeetLadderSubstitute(this.sp.worldObj, i, j, k) || Orientation.PZ.isFeetLadderSubstitute(this.sp.worldObj, i, j, k) || Orientation.NZ.isFeetLadderSubstitute(this.sp.worldObj, i, j, k) || Orientation.ZP.isFeetLadderSubstitute(this.sp.worldObj, i, j, k) || Orientation.ZN.isFeetLadderSubstitute(this.sp.worldObj, i, j, k);
                                                        this.sp.motionY = feetSubstitute ? 0.2 : 0.1;
                                                    } else {
                                                        this.sp.motionY = 0.0;
                                                    }
                                                    this.sp.motionY *= (double)this.getSpeedFactor();
                                                }
                                                if (!Config.isFreeClimbingEnabled() || !(this.sp.fallDistance <= ((Float)SmartMovingSelf.Config._freeClimbFallMaximumDistance.value).floatValue()) || isOnLadderOrVine && !Config.isFreeBaseClimb()) break block47;
                                                boolean exhaustionAllowsClimbing = !Config.isClimbExhaustionEnabled() || this.exhaustion <= ((Float)SmartMovingSelf.Config._climbExhaustionStop.value).floatValue() && (wasClimbing || this.exhaustion <= ((Float)SmartMovingSelf.Config._climbExhaustionStart.value).floatValue());
                                                boolean preferClimb = false;
                                                if (this.wantClimbUp || this.wantClimbDown) {
                                                    if (Config.isClimbExhaustionEnabled()) {
                                                        this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._climbExhaustionStop.value).floatValue());
                                                        this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._climbExhaustionStart.value).floatValue());
                                                    }
                                                    if (exhaustionAllowsClimbing) {
                                                        preferClimb = true;
                                                    }
                                                }
                                                if (!preferClimb) break block48;
                                                boolean bl4 = isSmallClimbing = this.isCrawling || this.isSliding;
                                                if (this.isClimbCrawling || this.isCrawlClimbing || isSmallClimbing) {
                                                    jd += -1.0;
                                                }
                                                if ((rotation = this.sp.rotationYaw % 360.0f) < 0.0f) {
                                                    rotation += 360.0f;
                                                }
                                                double jh = jd * 2.0 + 1.0;
                                                handsClimbing = HandsClimbing.None;
                                                feetClimbing = FeetClimbing.None;
                                                SmartMovingSelf.inout_handsClimbing[0] = handsClimbing;
                                                SmartMovingSelf.inout_feetClimbing[0] = feetClimbing;
                                                out_handsClimbGap.reset();
                                                out_feetClimbGap.reset();
                                                Orientation.PZ.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                Orientation.NZ.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                Orientation.ZP.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                Orientation.ZN.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                handsClimbing = inout_handsClimbing[0];
                                                feetClimbing = inout_feetClimbing[0];
                                                this.isNeighborClimbing = handsClimbing != HandsClimbing.None || feetClimbing != FeetClimbing.None;
                                                this.hasNeighborClimbGap = SmartMovingSelf.out_handsClimbGap.CanStand || SmartMovingSelf.out_feetClimbGap.CanStand;
                                                boolean bl5 = this.hasNeighborClimbCrawlGap = SmartMovingSelf.out_handsClimbGap.MustCrawl || SmartMovingSelf.out_feetClimbGap.MustCrawl;
                                                if (!isSmallClimbing) {
                                                    Orientation.PP.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                    Orientation.NP.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                    Orientation.NN.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                    Orientation.PN.seekClimbGap(rotation, this.sp.worldObj, i, id, jh, k, kd, this.isClimbCrawling, this.isCrawlClimbing, isSmallClimbing, inout_handsClimbing, inout_feetClimbing, out_handsClimbGap, out_feetClimbGap);
                                                }
                                                handsClimbing = inout_handsClimbing[0];
                                                feetClimbing = inout_feetClimbing[0];
                                                this.hasClimbGap = SmartMovingSelf.out_handsClimbGap.CanStand || SmartMovingSelf.out_feetClimbGap.CanStand;
                                                boolean bl6 = this.hasClimbCrawlGap = SmartMovingSelf.out_handsClimbGap.MustCrawl || SmartMovingSelf.out_feetClimbGap.MustCrawl;
                                                if (handsClimbing == HandsClimbing.BottomHold && Orientation.isLadder(this.sp.worldObj.getBlock(i, j + 2, k))) {
                                                    Orientation ladderOrientation = Orientation.getKnownLadderOrientation(this.sp.worldObj, i, j + 2, k);
                                                    int remote_i = i + ladderOrientation._i;
                                                    int remote_k = k + ladderOrientation._k;
                                                    if (!this.sp.worldObj.getBlock(remote_i, j, remote_k).getMaterial().isSolid() && !this.sp.worldObj.getBlock(remote_i, j + 1, remote_k).getMaterial().isSolid()) {
                                                        handsClimbing = HandsClimbing.None;
                                                    }
                                                }
                                                if (!this.grabButton.Pressed && handsClimbing == HandsClimbing.Up && feetClimbing == FeetClimbing.None && !this.sp.isCollidedHorizontally && this.sp.worldObj.isAirBlock(i, j, k) && this.sp.worldObj.isAirBlock(i, j + 1, k)) {
                                                    handsClimbing = HandsClimbing.None;
                                                }
                                                if (!feetClimbing.IsRelevant() && !handsClimbing.IsRelevant()) break block48;
                                                if (!this.wantClimbUp) break block49;
                                                if (this.isSliding && handsClimbing.IsRelevant()) {
                                                    this.isSliding = false;
                                                    this.isCrawling = true;
                                                }
                                                handsClimbing = handsClimbing.ToUp();
                                                if (feetClimbing != FeetClimbing.FastUp || handsClimbing == HandsClimbing.None && this.sp.onGround && SmartMovingSelf.out_feetClimbGap.Block != Block.getBlockFromName((String)"bed")) break block50;
                                                this.setShouldClimbSpeed(0.2, 0, 1);
                                                break block51;
                                            }
                                            if (!this.hasClimbGap && !this.hasClimbCrawlGap || handsClimbing != HandsClimbing.FastUp || feetClimbing != FeetClimbing.None && feetClimbing != FeetClimbing.BaseWithHands) break block52;
                                            this.setShouldClimbSpeed(feetClimbing == FeetClimbing.None ? 0.1 : 0.2, 2, 1);
                                            break block51;
                                        }
                                        if (!feetClimbing.IsRelevant() || !handsClimbing.IsRelevant() || feetClimbing == FeetClimbing.BaseHold && handsClimbing == HandsClimbing.Sink || handsClimbing == HandsClimbing.Sink && feetClimbing == FeetClimbing.TopWithHands || handsClimbing == HandsClimbing.TopHold && feetClimbing == FeetClimbing.TopWithHands) break block53;
                                        this.setShouldClimbSpeed(0.14, !(!this.hasClimbGap && !this.hasClimbCrawlGap || handsClimbing == HandsClimbing.Sink && feetClimbing == FeetClimbing.BaseWithHands) ? 2 : 1, 1);
                                        break block51;
                                    }
                                    if (!handsClimbing.IsUp()) break block54;
                                    this.setShouldClimbSpeed(0.1);
                                    break block51;
                                }
                                if (handsClimbing != HandsClimbing.TopHold && feetClimbing != FeetClimbing.BaseHold && (feetClimbing != FeetClimbing.SlowUpWithHoldWithoutHands || handsClimbing != HandsClimbing.None)) break block55;
                                if (!this.jumpButton.StartPressed) break block56;
                                this.isClimbJumping = this.tryJump(feetClimbing != FeetClimbing.None ? 5 : 6, null, null, null);
                                if (this.isClimbJumping) break block51;
                            }
                            if (handsClimbing == HandsClimbing.Sink && feetClimbing == FeetClimbing.BaseHold || handsClimbing == HandsClimbing.TopHold && feetClimbing == FeetClimbing.TopWithHands) {
                                this.setShouldClimbSpeed(0.08, 2, 1);
                            } else {
                                this.setShouldClimbSpeed(0.08);
                            }
                            break block51;
                        }
                        if (handsClimbing == HandsClimbing.Sink || feetClimbing == FeetClimbing.SlowUpWithSinkWithoutHands && handsClimbing == HandsClimbing.None) {
                            this.setShouldClimbSpeed(0.05);
                        }
                        break block51;
                    }
                    if (this.wantClimbDown) {
                        if ((handsClimbing = handsClimbing.ToDown()) == HandsClimbing.BottomHold && !feetClimbing.IsIndependentlyRelevant()) {
                            this.setShouldClimbSpeed(0.08);
                        } else if (handsClimbing.IsRelevant()) {
                            if (feetClimbing == FeetClimbing.FastUp) {
                                this.setShouldClimbSpeed(0.01, 0, 1);
                            } else if (feetClimbing == FeetClimbing.SlowUpWithHoldWithoutHands) {
                                this.setShouldClimbSpeed(0.01);
                            } else if (feetClimbing == FeetClimbing.TopWithHands) {
                                this.setShouldClimbSpeed(0.01);
                            } else if (feetClimbing == FeetClimbing.BaseWithHands || feetClimbing == FeetClimbing.BaseHold) {
                                if (handsClimbing != HandsClimbing.None && handsClimbing != HandsClimbing.Up || handsClimbing == HandsClimbing.Up && feetClimbing == FeetClimbing.BaseHold) {
                                    this.setShouldClimbSpeed(0.01);
                                } else {
                                    this.setShouldClimbSpeed(0.05);
                                }
                            } else {
                                this.setShouldClimbSpeed(0.05, handsClimbing == HandsClimbing.FastUp ? 2 : 1, 0);
                            }
                        }
                        if (this.isClimbHolding) {
                            this.setOnlyShouldClimbSpeed(0.08);
                            if (this.jumpButton.StartPressed) {
                                boolean handsOnly;
                                boolean bl = handsOnly = feetClimbing != FeetClimbing.None;
                                int type = ((Boolean)SmartMovingSelf.Options._climbJumpBackHeadOnGrab.value != false ? this.grabButton.Pressed : !this.grabButton.Pressed) ? (handsOnly ? 9 : 10) : (handsOnly ? 7 : 8);
                                float jumpAngle = this.sp.rotationYaw + 180.0f;
                                if (this.tryJump(type, null, null, Float.valueOf(jumpAngle))) {
                                    this.continueWallJumping = !this.isHeadJumping;
                                    this.isClimbing = false;
                                    this.sp.rotationYaw = jumpAngle;
                                    this.onStartClimbBackJump();
                                }
                            }
                        }
                    }
                }
                if (this.isClimbing) {
                    this.handleCrash(((Float)SmartMovingSelf.Config._freeClimbFallDamageStartDistance.value).floatValue(), ((Float)SmartMovingSelf.Config._freeClimbFallDamageFactor.value).floatValue());
                }
                if (this.wantClimbUp || this.wantClimbDown) {
                    if (handsClimbing == HandsClimbing.None) {
                        this.actualHandsClimbType = 0;
                    } else if (feetClimbing == FeetClimbing.None) {
                        this.actualFeetClimbType = 0;
                    }
                    this.handsEdgeBlock = SmartMovingSelf.out_handsClimbGap.Block;
                    this.handsEdgeMeta = SmartMovingSelf.out_handsClimbGap.Meta;
                    this.feetEdgeBlock = SmartMovingSelf.out_feetClimbGap.Block;
                    this.feetEdgeMeta = SmartMovingSelf.out_feetClimbGap.Meta;
                }
            }
            if (SmartMovingOptions.hasRedPowerWire && !this.isClimbing && this.wantClimbUp && wasClimbing) {
                this.sp.motionY = 0.15;
            }
            this.isHandsVineClimbing = this.isClimbing && this.handsEdgeBlock == Block.getBlockFromName((String)"vine");
            this.isFeetVineClimbing = this.isClimbing && this.feetEdgeBlock == Block.getBlockFromName((String)"vine");
            this.isVineAnyClimbing = this.isHandsVineClimbing || this.isFeetVineClimbing;
            this.isVineOnlyClimbing = !(!this.isVineAnyClimbing || this.handsEdgeBlock != null && this.handsEdgeBlock != Block.getBlockFromName((String)"vine") || this.feetEdgeBlock != null && this.feetEdgeBlock != Block.getBlockFromName((String)"vine"));
        }
    }

    private void handleCeilingClimbing(boolean wasCeilingClimbing) {
        boolean couldClimbCeiling;
        boolean exhaustionAllowsClimbCeiling = !Config.isCeilingClimbExhaustionEnabled() || this.exhaustion <= ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStop.value).floatValue() && (wasCeilingClimbing || this.exhaustion <= ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStart.value).floatValue());
        boolean climbCeilingCrawlingStartConflict = !Config.isFreeClimbingEnabled() && this.isCrawling && !this.wasCrawling;
        boolean bl = couldClimbCeiling = this.wantClimbCeiling && !this.isClimbing && (!this.isCrawling || climbCeilingCrawlingStartConflict) && !this.isCrawlClimbing;
        if (couldClimbCeiling && Config.isCeilingClimbExhaustionEnabled()) {
            this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStop.value).floatValue());
            this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionStart.value).floatValue());
        }
        if (couldClimbCeiling && exhaustionAllowsClimbCeiling) {
            boolean bottomCeilingClimbing;
            double id = this.sp.posX;
            double jd = this.sp.boundingBox.maxY + (double)(climbCeilingCrawlingStartConflict ? 1.0f : 0.0f);
            double kd = this.sp.posZ;
            int i = MathHelper.floor_double((double)id);
            int j = MathHelper.floor_double((double)jd);
            int k = MathHelper.floor_double((double)kd);
            Block topBlock = this.supportsCeilingClimbing(i, j, k);
            Block bottomBlock = this.supportsCeilingClimbing(i, j + 1, k);
            boolean topCeilingClimbing = topBlock != null;
            boolean bl2 = bottomCeilingClimbing = bottomBlock != null;
            if (topCeilingClimbing || bottomCeilingClimbing) {
                double jgap = 1.0 - jd + (double)j;
                if (bottomCeilingClimbing) {
                    jgap += 1.0;
                }
                double actuallySolidHeight = this.getMinPlayerSolidBetween(jd, jd + 0.6, 0.2);
                if (jgap < 1.9 && actuallySolidHeight < jd + 0.5) {
                    this.sp.motionY = jgap > 1.2 ? 0.12 : (jgap > 1.115 ? 0.08 : 0.04);
                    this.sp.fallDistance = 0.0f;
                    this.isCeilingClimbing = true;
                    Block block = this.handsEdgeBlock = topCeilingClimbing ? topBlock : bottomBlock;
                }
            }
        }
        if (this.isCeilingClimbing && climbCeilingCrawlingStartConflict) {
            this.isCrawling = false;
            this.resetHeightOffset();
            this.move(0.0, 1.0, 0.0, true);
        }
    }

    private void setLandMotions(float horizontalDamping) {
        this.sp.motionY -= 0.08;
        this.sp.motionY *= (double)0.98f;
        this.sp.motionX *= (double)horizontalDamping;
        this.sp.motionZ *= (double)horizontalDamping;
    }

    private void handleExhaustion(double diffX, double diffY, double diffZ) {
        float hungerIncrease = 0.0f;
        if (SmartMovingSelf.Config.enabled) {
            boolean isStill;
            boolean isRunning = this.isRunning();
            boolean isVerticalStill = Math.abs(diffY) < 0.007;
            boolean bl = isStill = this.isStanding && isVerticalStill;
            if (this.sp.ridingEntity == null) {
                float horizontalMovement = MathHelper.sqrt_double((double)(diffX * diffX + diffZ * diffZ));
                float movement = MathHelper.sqrt_double((double)((double)(horizontalMovement * horizontalMovement) + diffY * diffY));
                int relevantMovementFactor = Math.round(movement * 100.0f);
                if (Config.isHungerGainEnabled()) {
                    float hungerGainFactor = Config.getFactor(true, this.sp.onGround, this.isStanding, isStill, this.isSlow, isRunning, this.isFast, this.isClimbing, this.isClimbCrawling, this.isCeilingClimbing, this.isDipping, this.isSwimming, this.isDiving, this.isCrawling, this.isCrawlClimbing);
                    hungerIncrease += ((Float)SmartMovingSelf.Config._alwaysHungerGain.value).floatValue() + (float)relevantMovementFactor * 1.0E-4f * hungerGainFactor;
                }
                float additionalExhaustion = 0.0f;
                if (this.isClimbing && !isStill && Config.isClimbExhaustionEnabled()) {
                    float climbingExhaustion = ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                    climbingExhaustion = isVerticalStill ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbStrafeExhaustionGain.value).floatValue()) : (!this.isStanding ? (this.wantClimbUp ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbStrafeUpExhaustionGain.value).floatValue()) : (this.wantClimbDown ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbStrafeDownExhaustionGain.value).floatValue()) : (climbingExhaustion *= 0.0f))) : (this.wantClimbUp ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbUpExhaustionGain.value).floatValue()) : (this.wantClimbDown ? (climbingExhaustion *= ((Float)SmartMovingSelf.Config._climbDownExhaustionGain.value).floatValue()) : (climbingExhaustion *= 0.0f))));
                    additionalExhaustion += climbingExhaustion;
                }
                if (this.isCeilingClimbing && !this.isStanding && Config.isCeilingClimbExhaustionEnabled()) {
                    additionalExhaustion += ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue() * ((Float)SmartMovingSelf.Config._ceilingClimbExhaustionGain.value).floatValue();
                }
                if (this.isFast && Config.isSprintExhaustionEnabled()) {
                    if (additionalExhaustion == 0.0f) {
                        additionalExhaustion = ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                    }
                    additionalExhaustion *= ((Float)SmartMovingSelf.Config._sprintExhaustionGainFactor.value).floatValue();
                }
                if (this.isRunning() && Config.isRunExhaustionEnabled()) {
                    if (additionalExhaustion == 0.0f) {
                        additionalExhaustion = ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                    }
                    additionalExhaustion *= ((Float)SmartMovingSelf.Config._runExhaustionGainFactor.value).floatValue();
                }
                if (this.foreignExhaustionFactor > 0.0f) {
                    additionalExhaustion += this.foreignExhaustionFactor * ((Float)SmartMovingSelf.Config._baseExhautionGainFactor.value).floatValue();
                    if (this.foreignMaxExhaustionForAction == Float.MAX_VALUE) {
                        this.foreignMaxExhaustionForAction = Client.getMaximumExhaustion();
                    }
                    this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, this.foreignMaxExhaustionForAction);
                    if (this.foreignMaxExhaustionToStartAction == Float.MAX_VALUE) {
                        this.foreignMaxExhaustionToStartAction = Client.getMaximumExhaustion();
                    }
                    this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, this.foreignMaxExhaustionToStartAction);
                }
                this.exhaustion += additionalExhaustion;
            } else {
                hungerIncrease = -1.0f;
            }
            if (this.exhaustion > 0.0f) {
                boolean exhaustionLossPossible;
                boolean bl2 = exhaustionLossPossible = !Config.isExhaustionLossHungerEnabled() || (float)this.sp.getFoodStats().getFoodLevel() > ((Float)SmartMovingSelf.Config._exhaustionLossFoodLevelMinimum.value).floatValue();
                if (exhaustionLossPossible) {
                    float exhaustionLossFactor = Config.getFactor(false, this.sp.onGround, this.isStanding, isStill, this.isSlow, isRunning, this.isFast, this.isClimbing, this.isClimbCrawling, this.isCeilingClimbing, this.isDipping, this.isSwimming, this.isDiving, this.isCrawling, this.isCrawlClimbing);
                    float exhaustionLoss = 1.0f * exhaustionLossFactor;
                    this.exhaustion -= exhaustionLoss;
                    if (Config.isExhaustionLossHungerEnabled()) {
                        hungerIncrease += ((Float)SmartMovingSelf.Config._exhaustionLossHungerFactor.value).floatValue() * exhaustionLoss;
                    }
                }
            }
            if (this.exhaustion < 0.0f) {
                this.exhaustion = 0.0f;
            }
            if (this.exhaustion == 0.0f) {
                this.maxExhaustionToStartAction = Float.NaN;
                this.maxExhaustionForAction = Float.NaN;
            }
            if (this.maxExhaustionForAction == Float.MAX_VALUE) {
                this.maxExhaustionForAction = this.prevMaxExhaustionForAction;
            }
            if (this.maxExhaustionToStartAction == Float.MAX_VALUE) {
                this.maxExhaustionToStartAction = this.prevMaxExhaustionToStartAction;
            }
            this.foreignExhaustionFactor = 0.0f;
            this.foreignMaxExhaustionForAction = Float.MAX_VALUE;
            this.foreignMaxExhaustionToStartAction = Float.MAX_VALUE;
        } else {
            hungerIncrease = -1.0f;
        }
        if (hungerIncrease != this.lastHungerIncrease) {
            SmartMovingPacketStream.sendHungerChange(SmartMovingComm.instance, hungerIncrease);
            this.lastHungerIncrease = hungerIncrease;
        }
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public float getUpJumpCharge() {
        return this.jumpCharge;
    }

    @Override
    public float getHeadJumpCharge() {
        return this.headJumpCharge;
    }

    @Override
    public void addExhaustion(float factor) {
        if (!Float.isNaN(factor) && factor > 0.0f) {
            this.foreignExhaustionFactor += factor;
        }
    }

    @Override
    public void setMaxExhaustionForAction(float maxExhaustionForAction) {
        if (!Float.isNaN(maxExhaustionForAction) && maxExhaustionForAction >= 0.0f) {
            this.foreignMaxExhaustionForAction = Math.min(this.foreignMaxExhaustionForAction, maxExhaustionForAction);
        }
    }

    @Override
    public void setMaxExhaustionToStartAction(float maxExhaustionToStartAction) {
        if (!Float.isNaN(maxExhaustionToStartAction) && maxExhaustionToStartAction >= 0.0f) {
            this.foreignMaxExhaustionToStartAction = Math.min(this.foreignMaxExhaustionToStartAction, maxExhaustionToStartAction);
        }
    }

    private void landMotionPost(boolean wasShortInWater) {
        if (this.grabButton.Pressed) {
            this.fromSwimmingOrDiving(wasShortInWater);
        }
        if (this.heightOffset != 0.0f && this.isp.getSleepingField()) {
            this.resetInternalHeightOffset();
        }
    }

    private void fromSwimmingOrDiving(boolean wasShortInWater) {
        boolean isShortInWater;
        boolean bl = isShortInWater = this.isSwimming || this.isDiving;
        if (wasShortInWater && !isShortInWater && !this.isp.getSleepingField()) {
            this.setHeightOffset(-1.0f);
            double crawlStandUpBottom = this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY - 1.0, this.sp.boundingBox.minY, 0.0);
            double crawlStandUpLiquidCeiling = this.getMinPlayerLiquidBetween(this.sp.boundingBox.maxY, this.sp.boundingBox.maxY + 1.1);
            double crawlStandUpCeiling = this.getMinPlayerSolidBetween(this.sp.boundingBox.maxY, this.sp.boundingBox.maxY + 1.1, 0.0);
            this.resetHeightOffset();
            if (crawlStandUpCeiling - crawlStandUpBottom < (double)this.sp.height) {
                this.isCrawling = true;
                this.isDipping = false;
                this.setHeightOffset(-1.0f);
            } else if (crawlStandUpLiquidCeiling - crawlStandUpBottom < (double)this.sp.height) {
                this.isCrawling = true;
                this.contextContinueCrawl = true;
                this.isDipping = false;
                this.setHeightOffset(-1.0f);
            } else if (crawlStandUpBottom > this.sp.boundingBox.minY) {
                if (this.isSlow && crawlStandUpBottom > this.sp.boundingBox.minY + 0.5) {
                    this.isCrawling = true;
                    this.isDipping = false;
                    this.setHeightOffset(-1.0f);
                }
                this.move(0.0, crawlStandUpBottom - this.sp.boundingBox.minY, 0.0, true);
            }
        }
    }

    public boolean canTriggerWalking() {
        return !this.isClimbing && !this.isDiving;
    }

    private void resetClimbing() {
        this.isClimbing = false;
        this.isHandsVineClimbing = false;
        this.isFeetVineClimbing = false;
        this.isVineOnlyClimbing = false;
        this.isVineAnyClimbing = false;
        this.isClimbingStill = false;
        this.isNeighborClimbing = false;
        this.actualHandsClimbType = 0;
        this.actualFeetClimbType = 0;
        this.isCeilingClimbing = false;
    }

    private void resetSwimming() {
        this.dippingDepth = -1.0f;
        this.isDipping = false;
        this.isSwimming = false;
        this.isDiving = false;
        this.isLevitating = false;
        this.isShallowDiveOrSwim = false;
        this.isFakeShallowWaterSneaking = false;
        this.isJumpingOutOfWater = false;
    }

    private void setShouldClimbSpeed(double value) {
        this.setShouldClimbSpeed(value, 1, 1);
    }

    private void setShouldClimbSpeed(double value, int handsClimbType, int feetClimbType) {
        this.setOnlyShouldClimbSpeed(value);
        this.actualHandsClimbType = handsClimbType;
        this.actualFeetClimbType = feetClimbType;
    }

    private void setOnlyShouldClimbSpeed(double value) {
        boolean relevant;
        this.isClimbing = true;
        if (this.climbIntoCount > 0) {
            value = 0.08;
        }
        if (value != 0.08) {
            float factor = this.getSpeedFactor();
            if (this.isFast) {
                factor *= ((Float)SmartMovingSelf.Config._sprintFactor.value).floatValue();
            }
            if (Config.isFreeBaseClimb() && value == 0.14) {
                switch (this.getOnLadder(Integer.MAX_VALUE, false, this.isClimbCrawling)) {
                    case 1: {
                        factor *= ((Float)SmartMovingSelf.Config._freeOneLadderClimbUpSpeedFactor.value).floatValue();
                        break;
                    }
                    case 2: {
                        factor *= ((Float)SmartMovingSelf.Config._freeBothLadderClimbUpSpeedFactor.value).floatValue();
                    }
                }
            }
            value = value > 0.08 ? (value - 0.08) * (double)((Float)SmartMovingSelf.Config._freeClimbingUpSpeedFactor.value).floatValue() * (double)factor + 0.08 : 0.08 - (0.08 - value) * (double)((Float)SmartMovingSelf.Config._freeClimbingDownSpeedFactor.value).floatValue() * (double)factor;
            if (this.hasClimbCrawlGap && this.isClimbCrawling && value > 0.08) {
                value = Math.min(0.17, value);
            }
        } else {
            this.isClimbingStill = true;
        }
        boolean bl = relevant = value < 0.0 || value > this.sp.motionY;
        if (relevant) {
            this.sp.motionY = value;
        }
        this.isClimbJumping = !relevant && !this.isClimbHolding;
    }

    public boolean isOnLadderOrVine() {
        return this.isOnLadderOrVine(this.isClimbCrawling);
    }

    public void beforeMoveEntity(double d, double d1, double d2) {
        this.beforeMoveEntityPosX = this.sp.posX;
        this.beforeMoveEntityPosY = this.sp.posZ;
        this.beforeMoveEntityPosZ = this.sp.posY;
        if (this.esp.movementInput.sneak || this.sneakToggled) {
            this.sp.ySize = this.isSwimming || this.isDiving || this.isCrawling || this.isClimbing || !Config.isSneakingEnabled() && !this.isSneaking() ? 0.0f : (this.isSlow ? 0.6f : 0.0f);
        }
        if (this.isSliding || this.isCrawling) {
            this.beforeDistanceWalkedModified = this.sp.distanceWalkedModified;
            this.sp.distanceWalkedModified = Float.MIN_VALUE;
        }
        if (this.wantWallJumping) {
            int collisions = this.calculateSeparateCollisions(d, d1, d2);
            this.horizontalCollisionAngle = SmartMovingSelf.getHorizontalCollisionangle(((collisions & 0x10) != 0 ? 1 : 0) != 0, ((collisions & 0x20) != 0 ? 1 : 0) != 0, ((collisions & 1) != 0 ? 1 : 0) != 0, ((collisions & 2) != 0 ? 1 : 0) != 0);
        }
    }

    public void moveEntity(double d, double d1, double d2) {
        this.beforeMoveEntity(d, d1, d2);
        this.isp.localMoveEntity(d, d1, d2);
        this.afterMoveEntity(d, d1, d2);
    }

    public void afterMoveEntity(double d, double d1, double d2) {
        if (this.isSliding || this.isCrawling) {
            this.sp.distanceWalkedModified = this.beforeDistanceWalkedModified;
        }
        if (this.heightOffset != 0.0f) {
            this.sp.posY += (double)this.heightOffset;
        }
        this.wasOnGround = this.sp.onGround;
        double d10 = this.sp.posX - this.beforeMoveEntityPosX;
        double d12 = this.sp.posZ - this.beforeMoveEntityPosY;
        double d13 = this.sp.posY - this.beforeMoveEntityPosZ;
        double distance = MathHelper.sqrt_double((double)(d10 * d10 + d12 * d12 + d13 * d13));
        if (this.isClimbing || this.isCeilingClimbing) {
            this.distanceClimbedModified = (float)((double)this.distanceClimbedModified + distance * (this.isClimbing ? 1.2 : 0.9));
            if (this.distanceClimbedModified > (float)this.nextClimbDistance) {
                Block.SoundType stepsound;
                Block stepBlock = this.isClimbing ? (this.handsEdgeBlock == null ? (this.feetEdgeBlock == null ? Block.getBlockFromName((String)"cobblestone") : this.feetEdgeBlock) : (this.feetEdgeBlock == null ? this.handsEdgeBlock : (this.nextClimbDistance % 2 != 0 ? this.feetEdgeBlock : this.handsEdgeBlock))) : this.handsEdgeBlock;
                ++this.nextClimbDistance;
                if (stepBlock != null && (stepsound = stepBlock.stepSound) != null) {
                    this.playSound(stepsound.getStepResourcePath(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
                }
            }
        }
        if (this.isSwimming) {
            this.distanceSwom = (float)((double)this.distanceSwom + distance);
            if (this.distanceSwom > 1.4285715f) {
                Random rand = this.sp.getRNG();
                this.playSound("random.splash", 0.05f, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
                this.distanceSwom -= 1.4285715f;
            }
        }
    }

    private void playSound(String id, float volume, float pitch) {
        Minecraft.getMinecraft().theWorld.playSound(this.sp.posX, this.sp.posY - (double)this.sp.yOffset, this.sp.posZ, id, volume, pitch, false);
        SmartMovingPacketStream.sendSound(SmartMovingComm.instance, id, volume, pitch);
    }

    public void beforeSleepInBedAt(int i, int j, int k) {
        if (!this.isp.getSleepingField()) {
            this.updateEntityActionState(true);
        }
    }

    public EntityPlayer.EnumStatus sleepInBedAt(int i, int j, int k) {
        this.beforeSleepInBedAt(i, j, k);
        return this.isp.localSleepInBedAt(i, j, k);
    }

    private void resetHeightOffset() {
        this.sp.boundingBox.minY += (double)this.heightOffset;
        this.sp.height -= this.heightOffset;
        this.heightOffset = 0.0f;
    }

    private void resetInternalHeightOffset() {
        this.sp.height -= this.heightOffset;
        this.heightOffset = 0.0f;
    }

    private void setHeightOffset(float offset) {
        this.resetHeightOffset();
        if (offset == 0.0f) {
            return;
        }
        this.heightOffset = offset;
        this.sp.boundingBox.minY -= (double)this.heightOffset;
        this.sp.height += this.heightOffset;
    }

    public float getBrightness(float f) {
        this.sp.posY -= (double)this.heightOffset;
        float result = this.isp.localGetBrightness(f);
        this.sp.posY += (double)this.heightOffset;
        return result;
    }

    public int getBrightnessForRender(float f) {
        this.sp.posY -= (double)this.heightOffset;
        int result = this.isp.localGetBrightnessForRender(f);
        this.sp.posY += (double)this.heightOffset;
        return result;
    }

    public boolean pushOutOfBlocks(double d, double d1, double d2) {
        if (this.multiPlayerInitialized > 0) {
            return false;
        }
        boolean top = false;
        if (this.heightOffset != 0.0f) {
            top = this.sp.height > 1.0f;
        }
        return this.pushOutOfBlocks(d, d1, d2, top);
    }

    public void beforeOnUpdate() {
        this.prevMotionX = this.sp.motionX;
        this.prevMotionY = this.sp.motionY;
        this.prevMotionZ = this.sp.motionZ;
        this.wasCollidedHorizontally = this.sp.isCollidedHorizontally;
        this.isJumping = false;
        if (this.sp.worldObj.isRemote && this.updateCounter < 10) {
            List chatMessageList = (List)Reflect.GetField(GuiNewChat.class, this.isp.getMcField().ingameGUI.getChatGUI(), SmartMovingInstall.GuiNewChat_chatMessageList);
            for (int i = 0; i < chatMessageList.size(); ++i) {
                if (!SmartMovingComm.processBlockCode(((ChatLine)chatMessageList.get(i)).func_151461_a().getUnformattedText())) continue;
                chatMessageList.remove(i--);
            }
            ++this.updateCounter;
        }
    }

    public void afterOnUpdate() {
        this.correctOnUpdate(this.isSwimming || this.isDiving || this.isDipping || this.isCrawling, this.isSwimming);
        this.spawnParticles(this.isp.getMcField(), this.sp.motionX, this.sp.motionZ);
        float landMovementFactor = this.getLandMovementFactor();
        if (SmartMovingSelf.Config.enabled) {
            float perspectiveFactor = landMovementFactor;
            if (this.isFast || this.isSprintJump || this.isRunning()) {
                if (this.sp.isSprinting()) {
                    perspectiveFactor /= 1.3f;
                }
                if (this.isFast || this.isSprintJump) {
                    perspectiveFactor *= ((Float)SmartMovingSelf.Options._perspectiveSprintFactor.value).floatValue();
                } else if (this.isRunning()) {
                    perspectiveFactor *= 1.3f * ((Float)SmartMovingSelf.Options._perspectiveRunFactor.value).floatValue();
                }
            }
            this.fadingPerspectiveFactor = this.fadingPerspectiveFactor != -1.0f ? (this.fadingPerspectiveFactor += (perspectiveFactor - this.fadingPerspectiveFactor) * ((Float)SmartMovingSelf.Options._perspectiveFadeFactor.value).floatValue()) : landMovementFactor;
        }
        if (this.sp.capabilities.disableDamage) {
            this.exhaustion = 0.0f;
        }
        if (this.sp.capabilities.isFlying) {
            this.sp.fallDistance = 0.0f;
        }
        this.collidedHorizontallyTickCount = this.sp.isCollidedHorizontally ? ++this.collidedHorizontallyTickCount : 0;
        this.addToSendQueue();
        if (this.wasInventory) {
            this.sp.prevRotationYawHead = this.sp.rotationYawHead;
        }
        this.wasInventory = this.isp.getMcField().currentScreen instanceof GuiInventory;
    }

    public void beforeOnLivingUpdate() {
        this.wasCapabilitiesIsFlying = this.sp.capabilities.isFlying;
    }

    public void afterOnLivingUpdate() {
        if (((Boolean)SmartMovingSelf.Options._flyWhileOnGround.value).booleanValue() && (!this.sneakButton.Pressed || !this.grabButton.Pressed) && this.wasCapabilitiesIsFlying && !this.sp.capabilities.isFlying && this.sp.onGround) {
            this.sp.cameraYaw = 0.0f;
            this.sp.prevCameraYaw = 0.0f;
            this.sp.capabilities.isFlying = true;
            ((EntityClientPlayerMP)this.sp).sendQueue.addToSendQueue((Packet)new C13PacketPlayerAbilities(this.sp.capabilities));
        }
    }

    public void handleJumping() {
        boolean jump;
        if (this.blockJumpTillButtonRelease && !this.esp.movementInput.jump) {
            this.blockJumpTillButtonRelease = false;
        }
        if (this.isSwimming || this.isDiving) {
            return;
        }
        boolean bl = jump = this.jumpAvoided && this.sp.onGround && this.isp.getIsJumpingField() && !this.sp.isInWater() && !this.sp.handleLavaMovement();
        if (jump && this.sp.boundingBox.minY - this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY - 0.2, this.sp.boundingBox.minY, 0.0) >= 0.01) {
            return;
        }
        this.jumpMotionX = this.sp.motionX;
        this.jumpMotionZ = this.sp.motionZ;
        boolean isJumpCharging = false;
        if (Config.isJumpChargingEnabled()) {
            boolean actualJumpCharging;
            boolean isJumpChargingPossible = this.sp.onGround && this.isStanding;
            isJumpCharging = isJumpChargingPossible && this.wouldIsSneaking;
            boolean bl2 = actualJumpCharging = isJumpChargingPossible && ((Boolean)SmartMovingSelf.Config._jumpChargeCancelOnSneakRelease.value == false || this.wouldIsSneaking);
            if (actualJumpCharging) {
                if (this.esp.movementInput.jump && (((Boolean)SmartMovingSelf.Config._jumpChargeCancelOnSneakRelease.value).booleanValue() || this.wouldIsSneaking)) {
                    this.jumpCharge += 1.0f;
                } else {
                    if (this.jumpCharge > 0.0f) {
                        this.tryJump(1, null, null, null);
                    }
                    this.jumpCharge = 0.0f;
                }
            } else {
                if (this.jumpCharge > 0.0f) {
                    this.blockJumpTillButtonRelease = true;
                }
                this.jumpCharge = 0.0f;
            }
        }
        boolean isHeadJumpCharging = false;
        if (Config.isHeadJumpingEnabled()) {
            boolean bl3 = isHeadJumpCharging = this.grabButton.Pressed && (this.isGroundSprinting || this.isSprintJump || this.isRunning() && this.sp.onGround) && !this.isCrawling;
            if (isHeadJumpCharging) {
                if (this.esp.movementInput.jump) {
                    this.headJumpCharge += 1.0f;
                } else {
                    if (this.headJumpCharge > 0.0f && this.sp.onGround) {
                        this.tryJump(3, null, null, null);
                    }
                    this.headJumpCharge = 0.0f;
                }
            } else {
                if (this.headJumpCharge > 0.0f) {
                    this.blockJumpTillButtonRelease = true;
                }
                this.headJumpCharge = 0.0f;
            }
        }
        if (this.esp.movementInput.jump && this.sp.isInWater() && this.isDipping) {
            double d = this.sp.posY - (double)MathHelper.floor_double((double)this.sp.posY);
            double d2 = this.isSlow ? 0.37 : 0.6;
            if (d > d2) {
                this.sp.motionY -= (double)0.04f;
                if (!this.isStillSwimmingJump && this.sp.onGround && this.jumpCharge == 0.0f) {
                    if (this.tryJump(0, true, null, null)) {
                        Random rand = this.sp.getRNG();
                        this.playSound("random.splash", 0.05f, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
                    }
                }
            }
        }
        if (!(!jump || this.blockJumpTillButtonRelease || isJumpCharging || isHeadJumpCharging || this.isVineAnyClimbing)) {
            this.tryJump(0, false, null, null);
        }
        int left = 0;
        int back = 0;
        if (this.leftJumpCount == -1) {
            ++left;
        }
        if (this.rightJumpCount == -1) {
            --left;
        }
        if (this.backJumpCount == -1) {
            ++back;
        }
        if (left != 0 || back != 0) {
            int angle = left > 0 ? (back == 0 ? 270 : 225) : (left < 0 ? (back == 0 ? 90 : 135) : 180);
            if (this.tryJump(2, null, null, Float.valueOf(this.sp.rotationYaw + (float)angle))) {
                this.angleJumpType = (360 - angle) / 45 % 8;
            }
            this.leftJumpCount = 0;
            this.rightJumpCount = 0;
            this.backJumpCount = 0;
        }
    }

    public void handleWallJumping() {
        float jumpAngle;
        int jumpType;
        if (!this.wantWallJumping || Double.isNaN(this.horizontalCollisionAngle)) {
            return;
        }
        if (this.grabButton.Pressed) {
            if (this.sp.fallDistance > ((Float)SmartMovingSelf.Config._wallHeadJumpFallMaximumDistance.value).floatValue()) {
                return;
            }
            jumpType = this.wasCollidedHorizontally ? 14 : 12;
        } else {
            if (this.sp.fallDistance > ((Float)SmartMovingSelf.Config._wallUpJumpFallMaximumDistance.value).floatValue()) {
                return;
            }
            int n = this.wasCollidedHorizontally ? 13 : (jumpType = 11);
        }
        if (!this.wasCollidedHorizontally) {
            float movementAngle = SmartMovingSelf.getAngle((double)this.jumpMotionZ, (double)(-this.jumpMotionX));
            if (Double.isNaN(movementAngle)) {
                return;
            }
            jumpAngle = this.horizontalCollisionAngle * 2.0f - movementAngle + 180.0f;
        } else {
            jumpAngle = this.horizontalCollisionAngle;
        }
        while (jumpAngle > 360.0f) {
            jumpAngle -= 360.0f;
        }
        if (((Float)SmartMovingSelf.Config._wallUpJumpOrthogonalTolerance.value).floatValue() != 0.0f) {
            float aligned;
            for (aligned = jumpAngle; aligned > 45.0f; aligned -= 90.0f) {
            }
            if (Math.abs(aligned) < ((Float)SmartMovingSelf.Config._wallUpJumpOrthogonalTolerance.value).floatValue()) {
                jumpAngle = (float)Math.round(jumpAngle / 90.0f) * 90.0f;
            }
        }
        if (this.tryJump(jumpType, null, null, Float.valueOf(jumpAngle))) {
            this.continueWallJumping = !this.isHeadJumping;
            this.sp.isCollidedHorizontally = false;
            this.sp.rotationYaw = jumpAngle;
            this.onStartWallJump(Float.valueOf(jumpAngle));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean tryJump(int type, Boolean inWaterOrNull, Boolean isRunningOrNull, Float angle) {
        block20: {
            block21: {
                noVertical = false;
                if (type != 13) {
                    if (type == 14) {
                    }
                } else {
                    type = type == 13 ? 11 : 12;
                    noVertical = true;
                }
                inWater = inWaterOrNull != null ? inWaterOrNull : this.isDipping;
                isRunning = isRunningOrNull != null ? isRunningOrNull.booleanValue() : this.isRunning();
                charged = type == 1;
                if (type == 0) ** GOTO lbl-1000
                if (type == 1) ** GOTO lbl-1000
                if (type == 3) ** GOTO lbl-1000
                if (type == 5) ** GOTO lbl-1000
                if (type == 6) ** GOTO lbl-1000
                if (type == 7) ** GOTO lbl-1000
                if (type == 8) ** GOTO lbl-1000
                if (type == 9) ** GOTO lbl-1000
                if (type == 10) ** GOTO lbl-1000
                if (type == 2) ** GOTO lbl-1000
                if (type == 11) ** GOTO lbl-1000
                if (type == 12) lbl-1000:
                // 12 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                up = v0;
                if (type == 3) ** GOTO lbl-1000
                if (type == 9) ** GOTO lbl-1000
                if (type == 10) ** GOTO lbl-1000
                if (type == 12) lbl-1000:
                // 4 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                head = v1;
                speed = SmartMovingSelf.getJumpSpeed(this.isStanding, this.isSlow, isRunning, this.isFast, angle);
                enabled = SmartMovingSelf.Config.isJumpingEnabled(speed, type);
                if (!enabled) break block20;
                exhausionEnabled = SmartMovingSelf.Config.isJumpExhaustionEnabled(speed, type);
                if (exhausionEnabled) {
                    maxExhausionForJump = SmartMovingSelf.Config.getJumpExhaustionStop(speed, type, this.jumpCharge);
                    if (this.exhaustion > maxExhausionForJump) {
                        return false;
                    }
                    this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, maxExhausionForJump);
                    this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, maxExhausionForJump + SmartMovingSelf.Config.getJumpExhaustionGain(speed, type, this.jumpCharge));
                }
                jumpFactor = this.sp.isPotionActive(Potion.jump) != false ? 1.0f + (float)(this.sp.getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.2f : 1.0f;
                horizontalJumpFactor = SmartMovingSelf.Config.getJumpHorizontalFactor(speed, type) * jumpFactor;
                verticalJumpFactor = SmartMovingSelf.Config.getJumpVerticalFactor(speed, type) * jumpFactor;
                v2 = jumpChargeFactor = charged != false ? SmartMovingSelf.Config.getJumpChargeFactor(this.jumpCharge) : 1.0f;
                if (!up) {
                    horizontalJumpFactor = MathHelper.sqrt_float((float)(horizontalJumpFactor * horizontalJumpFactor + verticalJumpFactor * verticalJumpFactor));
                    verticalJumpFactor = 0.0f;
                }
                maxHorizontalMotion = null;
                horizontalMotion = MathHelper.sqrt_double((double)(this.jumpMotionX * this.jumpMotionX + this.jumpMotionZ * this.jumpMotionZ));
                verticalMotion = -0.078 + 0.498 * (double)verticalJumpFactor * (double)jumpChargeFactor;
                if (horizontalJumpFactor > 1.0f && !this.sp.isCollidedHorizontally) {
                    maxHorizontalMotion = (double)SmartMovingSelf.Config.getMaxHorizontalMotion(speed, type, inWater) * (double)this.getSpeedFactor();
                }
                if (head) {
                    normalAngle = Math.atan(verticalMotion / horizontalMotion);
                    totalMotion = Math.sqrt(verticalMotion * verticalMotion + horizontalMotion * horizontalMotion);
                    newAngle = (double)SmartMovingSelf.Config.getHeadJumpFactor(this.headJumpCharge) * normalAngle;
                    newVerticalMotion = totalMotion * Math.sin(newAngle);
                    newHorizontalMotion = totalMotion * Math.cos(newAngle);
                    if (maxHorizontalMotion != null) {
                        maxHorizontalMotion = maxHorizontalMotion * (newHorizontalMotion / horizontalMotion);
                    }
                    verticalMotion = newVerticalMotion;
                    horizontalMotion = newHorizontalMotion;
                }
                if (angle == null) break block21;
                jumpAngle = angle.floatValue() / 57.295776f;
                if (type == 11) ** GOTO lbl-1000
                if (type == 12) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                reset = v3;
                horizontal = Math.max(horizontalMotion, (double)horizontalJumpFactor);
                moveX = -Math.sin(jumpAngle);
                moveZ = Math.cos(jumpAngle);
                this.sp.motionX = SmartMovingSelf.getJumpMoving(this.jumpMotionX, moveX, reset, horizontal, horizontalJumpFactor);
                this.sp.motionZ = SmartMovingSelf.getJumpMoving(this.jumpMotionZ, moveZ, reset, horizontal, horizontalJumpFactor);
                horizontalMotion = 0.0;
                verticalMotion = verticalJumpFactor;
            }
            if (horizontalMotion > 0.0) {
                absoluteMotionX = Math.abs(this.sp.motionX) * (double)horizontalJumpFactor;
                absoluteMotionZ = Math.abs(this.sp.motionZ) * (double)horizontalJumpFactor;
                if (maxHorizontalMotion != null) {
                    absoluteMotionX = Math.min(absoluteMotionX, maxHorizontalMotion * ((double)horizontalJumpFactor * (Math.abs(this.sp.motionX) / horizontalMotion)));
                    absoluteMotionZ = Math.min(absoluteMotionZ, maxHorizontalMotion * ((double)horizontalJumpFactor * (Math.abs(this.sp.motionZ) / horizontalMotion)));
                }
                this.sp.motionX = Math.signum(this.sp.motionX) * absoluteMotionX;
                this.sp.motionZ = Math.signum(this.sp.motionZ) * absoluteMotionZ;
            }
            if (up && !noVertical) {
                this.sp.motionY = verticalMotion;
                this.sp.addStat(StatList.jumpStat, 1);
                this.isSprintJump = this.isFast;
            }
            if (exhausionEnabled) {
                exhaustionFromJump = SmartMovingSelf.Config.getJumpExhaustionGain(speed, type, this.jumpCharge);
                this.exhaustion += exhaustionFromJump;
            }
            if (head) {
                this.isHeadJumping = true;
                this.setHeightOffset(-1.0f);
            }
            this.sp.isAirBorne = true;
            this.isJumping = true;
            this.onLivingJump();
        }
        return enabled;
    }

    private static double getJumpMoving(double actual, double move, boolean reset, double horizontal, float horizontalJumpFactor) {
        if (!reset) {
            return actual + move * horizontal;
        }
        if (Math.signum(actual) != Math.signum(move)) {
            return move * (double)horizontalJumpFactor;
        }
        return Math.max(Math.abs(actual), Math.abs(move) * horizontal) * Math.signum(move);
    }

    private static int getJumpSpeed(boolean isStanding, boolean isSneaking, boolean isRunning, boolean isSprinting, Float angle) {
        isRunning &= angle == null;
        if (isSprinting &= angle == null) {
            return 0;
        }
        if (isRunning) {
            return 1;
        }
        if (isSneaking) {
            return 3;
        }
        if (isStanding) {
            return 4;
        }
        return 2;
    }

    private void standupIfPossible() {
        boolean groundClose;
        if (this.heightOffset >= 0.0f) {
            return;
        }
        double gapUnderneight = this.getGapUnderneight();
        boolean bl = groundClose = gapUnderneight < 1.0;
        if (!groundClose) {
            this.resetHeightOffset();
        } else {
            boolean standUpPossible;
            double gapOverneight = groundClose ? this.getGapOverneight() : -1.0;
            boolean bl2 = standUpPossible = gapUnderneight + gapOverneight >= 1.0;
            if (standUpPossible) {
                this.standUp(gapUnderneight);
            } else {
                this.toSlidingOrCrawling(gapUnderneight);
            }
        }
    }

    private void standupIfPossible(boolean tryLanding, boolean restoreFromFlying) {
        boolean standUpPossible;
        if (this.heightOffset >= 0.0f) {
            return;
        }
        double gapUnderneight = this.getGapUnderneight();
        boolean groundClose = gapUnderneight < 1.0;
        double gapOverneight = groundClose ? this.getGapOverneight() : -1.0;
        boolean bl = standUpPossible = gapUnderneight + gapOverneight >= 1.0;
        if (tryLanding && groundClose && standUpPossible) {
            this.isFlying = false;
            this.sp.capabilities.isFlying = false;
            restoreFromFlying = true;
        }
        if (!restoreFromFlying) {
            return;
        }
        if (!groundClose && !this.sneakButton.Pressed) {
            this.resetHeightOffset();
        } else if (!(!standUpPossible || this.sneakButton.Pressed && this.grabButton.Pressed)) {
            this.standUp(gapUnderneight);
        } else {
            this.toSlidingOrCrawling(gapUnderneight);
        }
    }

    private void standUp(double gapUnderneight) {
        this.move(0.0, 1.0 - gapUnderneight, 0.0, true);
        this.isCrawling = false;
        this.isHeadJumping = false;
        this.resetHeightOffset();
    }

    private void toSlidingOrCrawling(double gapUnderneight) {
        this.move(0.0, -gapUnderneight, 0.0, true);
        if (Config.isSlidingEnabled() && (this.grabButton.Pressed || this.wasHeadJumping)) {
            this.isSliding = true;
        } else {
            this.wasCrawling = this.toCrawling();
        }
    }

    private void handleCrash(float fallDamageStartDistance, float fallDamageFactor) {
        if (this.sp.fallDistance >= 2.0f) {
            this.sp.addStat(StatList.distanceFallenStat, (int)Math.round((double)this.sp.fallDistance * 100.0));
        }
        if (this.sp.fallDistance >= fallDamageStartDistance) {
            this.sp.attackEntityFrom(DamageSource.fall, (float)((int)Math.ceil((this.sp.fallDistance - fallDamageStartDistance) * fallDamageFactor)));
            this.distanceClimbedModified = this.nextClimbDistance;
        }
        this.sp.fallDistance = 0.0f;
    }

    public void beforeSetPositionAndRotation() {
        if (this.sp.worldObj.isRemote) {
            this.initialized = false;
            this.multiPlayerInitialized = 5;
        }
    }

    public void updateEntityActionState(boolean startSleeping) {
        boolean canBackJump;
        boolean canClimbCrawling;
        boolean exhaustionAllowsSprinting;
        boolean exhaustionAllowsRunning;
        boolean tryLanding;
        boolean wantClimb;
        boolean inputContinueCrawl;
        this.jumpAvoided = false;
        this.prevMaxExhaustionForAction = this.maxExhaustionForAction;
        this.prevMaxExhaustionToStartAction = this.maxExhaustionToStartAction;
        this.maxExhaustionForAction = Float.MAX_VALUE;
        this.maxExhaustionToStartAction = Float.MAX_VALUE;
        boolean isLevitating = this.sp.capabilities.isFlying && !this.isFlying;
        boolean isRunning = this.isRunning();
        this.toggleButton.update(SmartMovingSelf.Options.keyBindConfigToggle);
        this.speedIncreaseButton.update(SmartMovingSelf.Options.keyBindSpeedIncrease);
        this.speedDecreaseButton.update(SmartMovingSelf.Options.keyBindSpeedDecrease);
        if (this.toggleButton.StartPressed) {
            if (Config == Options) {
                Config.toggle();
            } else {
                SmartMovingPacketStream.sendConfigChange(SmartMovingComm.instance);
            }
        }
        if (Config.isUserSpeedEnabled() && !Config.isUserSpeedAlwaysDefault() && (this.speedIncreaseButton.StartPressed || this.speedDecreaseButton.StartPressed)) {
            int difference = 0;
            if (this.speedIncreaseButton.StartPressed) {
                ++difference;
            }
            if (this.speedDecreaseButton.StartPressed) {
                --difference;
            }
            if (difference != 0) {
                if (Config == Options) {
                    Config.changeSpeed(difference);
                } else {
                    SmartMovingPacketStream.sendSpeedChange(SmartMovingComm.instance, difference, null);
                }
            }
        }
        boolean initializeCrawling = false;
        if (!(this.initialized || this.sp.worldObj.isRemote && this.multiPlayerInitialized != 0 || this.sp.isRiding())) {
            if (this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY, this.sp.boundingBox.maxY, 0.0) > this.sp.boundingBox.minY) {
                initializeCrawling = true;
                this.toCrawling();
            }
            this.initialized = true;
        }
        if (this.multiPlayerInitialized > 0) {
            --this.multiPlayerInitialized;
        }
        if (!this.esp.movementInput.jump) {
            this.isStillSwimmingJump = false;
        }
        if (!startSleeping) {
            this.isp.localUpdateEntityActionState();
            this.isp.setMoveStrafingField(Math.signum(this.esp.movementInput.moveStrafe));
            this.isp.setMoveForwardField(Math.signum(this.esp.movementInput.moveForward));
            this.isp.setIsJumpingField(!(!this.esp.movementInput.jump || this.isCrawling || this.isSliding || Config.isHeadJumpingEnabled() && this.grabButton.Pressed && this.sp.isSprinting() || Config.isJumpChargingEnabled() && this.wouldIsSneaking && this.sp.onGround && this.isStanding || this.blockJumpTillButtonRelease));
        }
        boolean isRiding = this.sp.ridingEntity != null;
        boolean isSleeping = this.isp.getSleepingField();
        boolean disabled = !SmartMovingSelf.Config.enabled || isRiding || isSleeping || startSleeping;
        Minecraft minecraft = this.isp.getMcField();
        GameSettings gameSettings = minecraft.gameSettings;
        this.forwardButton.update(gameSettings.keyBindForward);
        this.leftButton.update(gameSettings.keyBindLeft);
        this.rightButton.update(gameSettings.keyBindRight);
        this.backButton.update(gameSettings.keyBindBack);
        this.jumpButton.update(this.esp.movementInput.jump);
        this.sprintButton.update(gameSettings.keyBindSprint);
        this.sneakButton.update(this.esp.movementInput.sneak);
        this.grabButton.update(SmartMovingSelf.Options.keyBindGrab);
        double horizontalSpeedSquare = this.sp.motionX * this.sp.motionX + this.sp.motionZ * this.sp.motionZ;
        boolean blocked = minecraft.currentScreen != null && !minecraft.currentScreen.allowUserInput;
        boolean mustCrawl = false;
        double crawlStandUpBottom = -1.0;
        if (this.isCrawling || this.isClimbCrawling) {
            crawlStandUpBottom = this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY - (initializeCrawling ? 0.0 : 1.0), this.sp.boundingBox.minY, (Boolean)SmartMovingSelf.Config._crawlOverEdge.value != false ? 0.0 : -0.05);
            double crawlStandUpCeiling = this.getMinPlayerSolidBetween(this.sp.boundingBox.maxY, this.sp.boundingBox.maxY + 1.1, 0.0);
            boolean bl = mustCrawl = crawlStandUpCeiling - crawlStandUpBottom < (double)(this.sp.height - this.heightOffset);
        }
        if (this.esp.capabilities.isFlying && (Config.isFlyingEnabled() || Config.isLevitateSmallEnabled())) {
            mustCrawl = false;
        }
        boolean bl = Options.isCrawlToggleEnabled() ? this.crawlToggled : (inputContinueCrawl = this.sneakButton.Pressed || !Config.isFreeClimbingEnabled() && this.grabButton.Pressed);
        if (this.contextContinueCrawl) {
            double crawlStandUpLiquidCeiling;
            if (inputContinueCrawl || this.sp.isInWater() || mustCrawl) {
                this.contextContinueCrawl = false;
            } else if (this.isCrawling && (crawlStandUpLiquidCeiling = this.getMinPlayerLiquidBetween(this.sp.boundingBox.maxY, this.sp.boundingBox.maxY + 1.1)) - crawlStandUpBottom >= (double)(this.sp.height + 1.0f)) {
                this.contextContinueCrawl = false;
            }
        }
        boolean wouldWantCrawl = !this.esp.capabilities.isFlying && (this.isCrawling && (inputContinueCrawl || this.contextContinueCrawl) || this.grabButton.StartPressed && (this.sneakToggled || this.sneakButton.Pressed) && this.sp.onGround);
        boolean wantCrawl = Config.isCrawlingEnabled() && wouldWantCrawl;
        boolean canCrawl = !this.isSwimming && !this.isDiving && (!this.isDipping || this.dippingDepth + this.heightOffset < 0.65f) && !this.isClimbing && this.sp.fallDistance < ((Float)SmartMovingSelf.Config._fallingDistanceMinimum.value).floatValue();
        this.wasCrawling = this.isCrawling;
        boolean bl2 = this.isCrawling = canCrawl && (wantCrawl || mustCrawl);
        if (!this.isCrawling) {
            this.contextContinueCrawl = false;
        }
        if (this.wasCrawling && !this.isCrawling && this.esp.capabilities.isFlying) {
            this.tryJump(0, null, null, null);
        }
        this.wantCrawlNotClimb = (this.wantCrawlNotClimb || this.grabButton.StartPressed && !this.wasCrawling) && this.grabButton.Pressed && this.esp.movementInput.moveForward > 0.0f && this.isCrawling && this.sp.isCollidedHorizontally;
        boolean isFacedToSolidVine = this.isFacedToSolidVine(this.isClimbCrawling);
        boolean wouldWantClimb = (this.grabButton.Pressed || this.isClimbHolding && this.sneakButton.Pressed || Config.isFreeClimbAutoLaddderEnabled() && this.isFacedToLadder(this.isClimbCrawling) || Config.isFreeClimbAutoVineEnabled() && isFacedToSolidVine) && (!this.isSliding || this.grabButton.Pressed && this.esp.movementInput.moveForward > 0.0f) && !this.isHeadJumping && !this.wantCrawlNotClimb && !disabled;
        boolean bl3 = wantClimb = Config.isFreeClimbingEnabled() && wouldWantClimb;
        if (!wantClimb || this.sp.isCollidedVertically) {
            this.isClimbJumping = false;
        }
        if (this.sp.isCollided) {
            this.isClimbBackJumping = false;
        }
        this.wantClimbUp = wantClimb && this.esp.movementInput.moveForward > 0.0f || this.isVineAnyClimbing && this.jumpButton.Pressed && (!this.sneakButton.Pressed || !isFacedToSolidVine) && (!this.isCrawling || this.sp.isCollidedHorizontally) && (!this.isSliding || this.sp.isCollidedHorizontally);
        this.wantClimbDown = wantClimb && this.esp.movementInput.moveForward <= 0.0f && !wantCrawl;
        this.wantClimbCeiling = Config.isCeilingClimbingEnabled() && this.grabButton.Pressed && !this.wantCrawlNotClimb && !this.isSneaking() && !disabled;
        boolean restoreFromFlying = false;
        boolean wasFlying = this.isFlying;
        boolean bl4 = this.isFlying = Config.isFlyingEnabled() && this.sp.capabilities.isFlying && !this.isSwimming && !this.isDiving;
        if (this.isFlying && !wasFlying) {
            this.setHeightOffset(-1.0f);
        } else if (!this.isFlying && wasFlying) {
            restoreFromFlying = true;
        }
        if (!Config.isFlyingEnabled() && Config.isLevitateSmallEnabled()) {
            if (isLevitating && !this.wasLevitating) {
                this.setHeightOffset(-1.0f);
            } else if (!isLevitating && this.wasLevitating) {
                restoreFromFlying = true;
            }
        }
        this.wasHeadJumping = this.isHeadJumping;
        boolean bl5 = this.isHeadJumping = !(!this.isHeadJumping || this.sp.onGround || this.isSwimming || this.isDiving || this.isFlying || this.sp.capabilities.isFlying || this.sp.handleWaterMovement() && this.sp.motionY < 0.0 || this.sp.handleLavaMovement());
        if (!this.isHeadJumping) {
            this.isAerodynamic = false;
        }
        if (this.wasHeadJumping && !this.isHeadJumping && this.sp.onGround) {
            this.handleCrash(((Float)SmartMovingSelf.Config._headFallDamageStartDistance.value).floatValue(), ((Float)SmartMovingSelf.Config._headFallDamageFactor.value).floatValue());
            restoreFromFlying = true;
        }
        boolean bl6 = tryLanding = this.isFlying && (Boolean)SmartMovingSelf.Options._flyCloseToGround.value == false && horizontalSpeedSquare < 0.003 && this.sp.motionY > -0.03;
        if (restoreFromFlying || tryLanding) {
            this.standupIfPossible(tryLanding, restoreFromFlying);
        }
        if (this.isSliding && this.sp.fallDistance > 0.05f) {
            this.isSliding = false;
            this.isHeadJumping = true;
            this.isAerodynamic = true;
        }
        if (Config.isSlidingEnabled() && this.grabButton.Pressed && (this.isGroundSprinting || this.wasRunning && !isRunning && this.sp.onGround) && !this.isCrawling && this.sneakButton.StartPressed && !this.isDipping) {
            this.setHeightOffset(-1.0f);
            this.move(0.0, -1.0, 0.0, true);
            this.tryJump(4, false, this.wasRunning, null);
            this.isSliding = true;
            this.isHeadJumping = false;
            this.isAerodynamic = false;
        }
        if (this.isSliding && (!this.sneakButton.Pressed || horizontalSpeedSquare < (double)((Float)SmartMovingSelf.Config._slidingSpeedStopFactor.value).floatValue() * 0.01)) {
            this.isSliding = false;
            this.wasCrawling = this.toCrawling();
        }
        if (this.isSliding && this.sp.fallDistance > ((Float)SmartMovingSelf.Config._fallingDistanceMinimum.value).floatValue()) {
            this.isSliding = false;
            this.wasCrawling = true;
            this.isCrawling = false;
        }
        boolean sneakContinueInput = Options.isSneakToggleEnabled() ? this.sneakToggled || this.sneakButton.StartPressed : this.sneakButton.Pressed;
        boolean wouldWantSneak = !(this.isFlying || this.isSliding || this.isHeadJumping || this.isDiving && (Boolean)SmartMovingSelf.Config._diveDownOnSneak.value != false || this.isSwimming && (Boolean)SmartMovingSelf.Config._swimDownOnSneak.value != false && !this.isFakeShallowWaterSneaking || !sneakContinueInput || wantCrawl || mustCrawl || Config.isCrawlingEnabled() && this.grabButton.Pressed);
        boolean wantSneak = Config.isSneakingEnabled() && wouldWantSneak;
        boolean moveButtonPressed = this.esp.movementInput.moveForward != 0.0f || this.esp.movementInput.moveStrafe != 0.0f;
        boolean moveForwardButtonPressed = this.esp.movementInput.moveForward > 0.0f;
        this.wantSprint = Config.isSprintingEnabled() && !this.isSliding && this.sprintButton.Pressed && (moveForwardButtonPressed || this.isClimbing || this.isSwimming && (moveButtonPressed || this.sneakButton.Pressed && (Boolean)SmartMovingSelf.Config._swimDownOnSneak.value != false) || this.isDiving && (moveButtonPressed || this.jumpButton.Pressed || this.sneakButton.Pressed && (Boolean)SmartMovingSelf.Config._diveDownOnSneak.value != false) || this.isFlying && (moveButtonPressed || this.jumpButton.Pressed || this.sneakButton.Pressed)) && !disabled;
        boolean bl7 = exhaustionAllowsRunning = !Config.isRunExhaustionEnabled() || this.exhaustion < ((Float)SmartMovingSelf.Config._runExhaustionStop.value).floatValue() && (this.wasRunning || this.exhaustion < ((Float)SmartMovingSelf.Config._runExhaustionStart.value).floatValue());
        if (isRunning && this.sp.onGround && Config.isRunExhaustionEnabled()) {
            this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._runExhaustionStop.value).floatValue());
            this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._runExhaustionStart.value).floatValue());
        }
        if (!exhaustionAllowsRunning && isRunning) {
            isRunning = false;
            this.sp.setSprinting(false);
        }
        if (!(this.sp.onGround || !this.isFast || this.isClimbing || this.isCeilingClimbing || this.isDiving || this.isSwimming)) {
            this.isSprintJump = true;
        }
        boolean bl8 = exhaustionAllowsSprinting = !Config.isSprintExhaustionEnabled() || this.exhaustion <= ((Float)SmartMovingSelf.Config._sprintExhaustionStop.value).floatValue() && (this.isFast || this.isSprintJump || this.exhaustion <= ((Float)SmartMovingSelf.Config._sprintExhaustionStart.value).floatValue());
        if (this.sp.onGround || this.isFlying || this.isSwimming || this.isDiving || this.sp.handleLavaMovement()) {
            this.isSprintJump = false;
        }
        boolean preferSprint = false;
        if (this.wantSprint && !wantSneak) {
            if (!this.isSprintJump && Config.isSprintExhaustionEnabled()) {
                this.maxExhaustionForAction = Math.min(this.maxExhaustionForAction, ((Float)SmartMovingSelf.Config._sprintExhaustionStop.value).floatValue());
                this.maxExhaustionToStartAction = Math.min(this.maxExhaustionToStartAction, ((Float)SmartMovingSelf.Config._sprintExhaustionStart.value).floatValue());
            }
            if (exhaustionAllowsSprinting) {
                preferSprint = true;
            }
        }
        boolean isClimbSprintSpeed = true;
        if (this.isClimbing && preferSprint) {
            double minTickDistance = this.wantClimbUp ? 0.07 * (double)((Float)SmartMovingSelf.Config._freeClimbingUpSpeedFactor.value).floatValue() : (this.wantClimbDown ? 0.11 * (double)((Float)SmartMovingSelf.Config._freeClimbingDownSpeedFactor.value).floatValue() : 0.07);
            isClimbSprintSpeed = (double)SmartStatisticsFactory.getInstance((EntityPlayer)this.sp).getTickDistance() >= minTickDistance;
        }
        boolean canAnySprint = preferSprint && !this.sp.isBurning() && ((Boolean)SmartMovingSelf.Config._sprintDuringItemUsage.value != false || !this.sp.isUsingItem());
        boolean canVerticallySprint = canAnySprint && !this.sp.isCollidedVertically;
        boolean canHorizontallySprint = canAnySprint && this.collidedHorizontallyTickCount < 3;
        boolean canAllSprint = canHorizontallySprint && canVerticallySprint;
        boolean wasGroundSprinting = this.isGroundSprinting;
        this.isGroundSprinting = canHorizontallySprint && this.sp.onGround && !this.isSwimming && !this.isDiving && !this.isClimbing;
        boolean isSwimSprinting = canHorizontallySprint && this.isSwimming;
        boolean isDiveSprinting = canAllSprint && this.isDiving;
        boolean isCeilingSprinting = canHorizontallySprint && this.isCeilingClimbing;
        boolean isFlyingSprinting = canAllSprint && this.isFlying;
        boolean isClimbSprinting = canAnySprint && this.isClimbing && isClimbSprintSpeed;
        boolean bl9 = this.isFast = this.isGroundSprinting || isClimbSprinting || isSwimSprinting || isDiveSprinting || isCeilingSprinting || isFlyingSprinting || isClimbSprinting;
        if (this.isGroundSprinting && !wasGroundSprinting) {
            this.wasRunningWhenSprintStarted = this.sp.isSprinting();
            this.sp.setSprinting(this.isStandupSprintingOrRunning());
        } else if (wasGroundSprinting && !this.isGroundSprinting) {
            this.sp.setSprinting(this.wasRunningWhenSprintStarted);
        }
        this.wouldIsSneaking = wouldWantSneak && !this.wantSprint && !this.isClimbing;
        boolean wasSneaking = this.isSlow;
        this.isSlow = wantSneak && this.wouldIsSneaking;
        boolean wantClimbHolding = this.isClimbHolding && this.sneakButton.Pressed || this.isClimbing && blocked || wantClimb && !this.isSwimming && !this.isDiving && !this.isCrawling && (this.sneakButton.Pressed || this.crawlToggled);
        this.isClimbHolding = wantClimbHolding && this.isClimbing;
        this.isStanding = horizontalSpeedSquare < 5.0E-4;
        boolean wasCrawlClimbing = this.isCrawlClimbing;
        boolean bl10 = this.isCrawlClimbing = !(!this.wasCrawling && !this.isCrawlClimbing || !this.isClimbing || !this.isNeighborClimbing || !this.sneakButton.Pressed && !this.crawlToggled || !(this.esp.movementInput.moveForward > 0.0f));
        if (this.isCrawlClimbing) {
            boolean canStandUp;
            boolean bl11 = canStandUp = !this.isPlayerInSolidBetween(this.sp.boundingBox.minY - (this.isClimbCrawling ? 0.95 : 1.0), this.sp.boundingBox.minY);
            if (canStandUp) {
                wasCrawlClimbing = false;
                this.isCrawlClimbing = false;
                if (!this.isClimbCrawling) {
                    this.resetHeightOffset();
                }
            }
            if (!wasCrawlClimbing) {
                this.wasCrawling = false;
                this.isCrawling = false;
            }
        } else if (wasCrawlClimbing) {
            double minY;
            boolean toCrawling;
            boolean bl12 = toCrawling = this.sneakButton.Pressed || this.crawlToggled;
            if (!this.isClimbing) {
                this.wasCrawling = this.toCrawling();
                minY = this.sp.boundingBox.minY;
                this.move(0.0, -minY + Math.floor(minY), 0.0, true);
            } else if (this.esp.movementInput.moveForward <= 0.0f) {
                this.wasCrawling = toCrawling;
                this.isCrawling = toCrawling;
                this.wantClimbUp = false;
                this.wantClimbDown = false;
                if (!toCrawling) {
                    this.resetHeightOffset();
                }
                minY = this.sp.boundingBox.minY;
                this.move(0.0, -minY + Math.floor(minY) + (double)(toCrawling ? 0.0f : 1.0f), 0.0, true);
            } else if (!toCrawling) {
                this.resetHeightOffset();
                minY = this.sp.boundingBox.minY;
                this.move(0.0, Math.ceil(minY) - minY, 0.0, true);
            }
        }
        boolean wasClimbCrawling = this.isClimbCrawling;
        boolean needClimbCrawling = this.hasClimbCrawlGap || this.hasClimbGap && this.isClimbHolding;
        boolean bl13 = canClimbCrawling = wantClimbHolding && this.wantClimbUp;
        if (this.climbIntoCount > 1) {
            --this.climbIntoCount;
        } else if (this.isClimbCrawling && !needClimbCrawling && this.climbIntoCount == 0) {
            this.climbIntoCount = 6;
        }
        boolean bl14 = this.isClimbCrawling = canClimbCrawling && (needClimbCrawling && this.climbIntoCount == 0 || this.climbIntoCount > 1);
        if (this.isClimbCrawling && !wasClimbCrawling) {
            this.setHeightOffset(-1.0f);
            boolean wasCollidedHorizontally = this.sp.isCollidedHorizontally;
            this.move(0.0, 0.05, 0.0, true);
            this.sp.isCollidedHorizontally = wasCollidedHorizontally;
        } else if (!this.isClimbCrawling && wasClimbCrawling) {
            this.climbIntoCount = 0;
            if (mustCrawl || this.sneakButton.Pressed || this.crawlToggled) {
                double gapUnderneight = this.sp.boundingBox.minY - this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY - 1.0, this.sp.boundingBox.minY, 0.0);
                if (gapUnderneight >= 0.0 && gapUnderneight < 1.0) {
                    this.wasCrawling = this.toCrawling();
                    this.move(0.0, -gapUnderneight, 0.0, true);
                } else {
                    this.resetHeightOffset();
                }
            } else {
                this.resetHeightOffset();
            }
        }
        if (this.wasCrawling && !this.isCrawling && !initializeCrawling && !this.esp.capabilities.isFlying) {
            this.resetHeightOffset();
            this.move(0.0, crawlStandUpBottom - this.sp.boundingBox.minY, 0.0, true);
        } else if (this.isCrawling && !this.wasCrawling || initializeCrawling) {
            this.setHeightOffset(-1.0f);
            if (!initializeCrawling || this.sp.worldObj.isRemote) {
                this.move(0.0, -1.0, 0.0, true);
            }
            if (initializeCrawling) {
                this.wasCrawling = this.toCrawling();
            }
        }
        if (this.grabButton.StartPressed) {
            if (this.isShallowDiveOrSwim && wouldWantClimb) {
                this.resetHeightOffset();
                this.move(0.0, this.getMaxPlayerSolidBetween(this.sp.boundingBox.minY, this.sp.boundingBox.maxY, 0.0) - this.sp.boundingBox.minY, 0.0, true);
                if (this.jumpButton.Pressed) {
                    this.isStillSwimmingJump = true;
                }
            } else if (this.isDipping && wouldWantCrawl && this.dippingDepth >= 0.55f) {
                if (this.dippingDepth >= 0.6f) {
                    this.setHeightOffset(-1.0f);
                    this.move(0.0, -1.6f + this.dippingDepth, 0.0, true);
                    this.isCrawling = false;
                } else {
                    this.setHeightOffset(-1.0f);
                    this.move(0.0, -1.0, 0.0, true);
                    this.wasCrawling = this.toCrawling();
                }
            }
        }
        this.isWallJumping = false;
        if (this.continueWallJumping && (this.sp.onGround || this.isClimbing || !this.jumpButton.Pressed)) {
            this.continueWallJumping = false;
        }
        boolean canWallJumping = Config.isWallJumpEnabled() && !this.isHeadJumping && !this.sp.onGround && !this.isClimbing && !this.isSwimming && !this.isDiving && !isLevitating && !this.isFlying;
        boolean triggerWallJumping = false;
        if (((Boolean)SmartMovingSelf.Options._wallJumpDoubleClick.value).booleanValue()) {
            if (canWallJumping) {
                if (this.jumpButton.StartPressed) {
                    if (this.wallJumpCount == 0) {
                        this.wallJumpCount = Options.wallJumpDoubleClickTicks();
                    } else {
                        triggerWallJumping = true;
                        this.wallJumpCount = 0;
                    }
                } else if (this.wallJumpCount > 0) {
                    --this.wallJumpCount;
                }
            } else {
                this.wallJumpCount = 0;
            }
        } else {
            triggerWallJumping = this.jumpButton.StartPressed;
        }
        this.wantWallJumping = canWallJumping && (triggerWallJumping || this.continueWallJumping || this.wantWallJumping && this.jumpButton.Pressed && !this.sp.isCollidedHorizontally);
        boolean canAngleJump = !isSleeping && this.sp.onGround && !this.isCrawling && !this.isClimbing && !this.isClimbCrawling && !this.isSwimming && !this.isDiving;
        boolean canSideJump = Config.isSideJumpEnabled() && canAngleJump;
        boolean canLeftJump = canSideJump && !this.rightButton.Pressed;
        boolean canRightJump = canSideJump && !this.leftButton.Pressed;
        boolean bl15 = canBackJump = Config.isBackJumpEnabled() && canAngleJump && !this.forwardButton.Pressed && !this.isStandupSprintingOrRunning();
        if (canLeftJump) {
            if (this.leftButton.StartPressed) {
                this.leftJumpCount = this.leftJumpCount == 0 ? Options.angleJumpDoubleClickTicks() : -1;
            } else if (this.leftJumpCount > 0) {
                --this.leftJumpCount;
            }
        } else {
            this.leftJumpCount = 0;
        }
        if (canRightJump) {
            if (this.rightButton.StartPressed) {
                this.rightJumpCount = this.rightJumpCount == 0 ? Options.angleJumpDoubleClickTicks() : -1;
            } else if (this.rightJumpCount > 0) {
                --this.rightJumpCount;
            }
        } else {
            this.rightJumpCount = 0;
        }
        if (canBackJump) {
            if (this.backButton.StartPressed) {
                this.backJumpCount = this.backJumpCount == 0 ? Options.angleJumpDoubleClickTicks() : -1;
            } else if (this.backJumpCount > 0) {
                --this.backJumpCount;
            }
        } else {
            this.backJumpCount = 0;
        }
        if (this.rightJumpCount == -2 && this.backJumpCount <= 0) {
            this.rightJumpCount = -1;
        }
        if (this.leftJumpCount == -2 && this.backJumpCount <= 0) {
            this.leftJumpCount = -1;
        }
        if (this.backJumpCount == -2 && (this.leftJumpCount <= 0 || this.rightJumpCount <= 0)) {
            this.backJumpCount = -1;
        }
        if (this.rightJumpCount == -1 && this.backJumpCount > 0) {
            this.rightJumpCount = -2;
        }
        if (this.leftJumpCount == -1 && this.backJumpCount > 0) {
            this.leftJumpCount = -2;
        }
        if (this.backJumpCount == -1 && (this.leftJumpCount > 0 || this.rightJumpCount > 0)) {
            this.backJumpCount = -2;
        }
        if (this.sp.onGround || this.sp.isCollidedVertically) {
            this.angleJumpType = 0;
        }
        this.isRopeSliding = SmartMovingSelf.isRopeSliding();
        boolean isSneakToggleEnabled = Options.isSneakToggleEnabled();
        boolean isCrawlToggleEnabled = Options.isCrawlToggleEnabled();
        boolean willStopCrawl = false;
        boolean willStopCrawlStartSneak = false;
        if (isSneakToggleEnabled || isCrawlToggleEnabled) {
            if (this.isCrawling && this.jumpButton.StopPressed) {
                willStopCrawlStartSneak = true;
            }
            if (this.isCrawling && this.sneakButton.StopPressed && !this.ignoreNextStopSneakButtonPressed) {
                willStopCrawlStartSneak = true;
            }
            if (!(this.isCrawling || this.isCrawlClimbing || this.isClimbCrawling)) {
                willStopCrawl = true;
            }
            willStopCrawl |= willStopCrawlStartSneak;
        }
        boolean willStopSneak = false;
        if (isSneakToggleEnabled) {
            if (this.isCrawling && !willStopCrawlStartSneak) {
                willStopSneak = true;
            }
            if (wantSneak && this.wantSprint && this.sneakButton.StartPressed && this.sneakToggled) {
                willStopSneak = true;
                this.ignoreNextStopSneakButtonPressed = true;
            }
            if (wasSneaking && this.sneakButton.StartPressed) {
                willStopSneak = true;
            }
            if (!this.isSwimming && !this.isDiving && this.jumpButton.StopPressed) {
                willStopSneak = true;
            }
        }
        boolean willStartSneak = false;
        if (isSneakToggleEnabled) {
            if (willStopCrawlStartSneak && this.sneakButton.StopPressed) {
                willStartSneak = true;
            }
            if (this.isFast && this.sneakButton.StopPressed && !this.ignoreNextStopSneakButtonPressed) {
                willStartSneak = true;
            }
            if (this.isSlow && !wasSneaking) {
                willStartSneak = true;
            }
        }
        boolean willStartCrawl = false;
        if (isCrawlToggleEnabled) {
            if (this.isCrawling && !this.wasCrawling) {
                willStartCrawl = true;
            }
            if (this.isClimbCrawling && !wasClimbCrawling) {
                willStartCrawl = true;
            }
        }
        if (isSneakToggleEnabled) {
            if (willStartSneak) {
                this.sneakToggled = true;
            }
            if (willStopSneak) {
                this.sneakToggled = false;
            }
        }
        if (isCrawlToggleEnabled) {
            if (willStartCrawl) {
                this.crawlToggled = true;
                this.ignoreNextStopSneakButtonPressed = this.sneakButton.Pressed;
            }
            if (willStopCrawl) {
                this.crawlToggled = false;
            }
        }
        if (this.sneakButton.StopPressed) {
            this.ignoreNextStopSneakButtonPressed = false;
        }
        this.wasRunning = isRunning;
        this.wasLevitating = isLevitating;
    }

    private boolean toCrawling() {
        this.isCrawling = true;
        if (Options.isCrawlToggleEnabled()) {
            this.crawlToggled = true;
        }
        this.ignoreNextStopSneakButtonPressed = true;
        return true;
    }

    public void addToSendQueue() {
        if (!this.sp.worldObj.isRemote) {
            return;
        }
        boolean isSmall = this.sp.height < 1.0f;
        long state = 0L;
        state |= this.isRopeSliding ? 1L : 0L;
        state <<= 1;
        state |= this.isWallJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isFast ? 1L : 0L;
        state <<= 1;
        state |= this.isSlow ? 1L : 0L;
        state <<= 1;
        state |= this.isClimbBackJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isClimbJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isHandsVineClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.isFeetVineClimbing ? 1L : 0L;
        state <<= 3;
        state |= (long)this.angleJumpType;
        state <<= 1;
        state |= this.isSliding ? 1L : 0L;
        state <<= 1;
        state |= this.isHeadJumping ? 1L : 0L;
        state <<= 1;
        state |= this.isLevitating ? 1L : 0L;
        state <<= 1;
        state |= this.isCeilingClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.doFlyingAnimation() ? 1L : 0L;
        state <<= 1;
        state |= this.doFallingAnimation() ? 1L : 0L;
        state <<= 1;
        state |= isSmall ? 1L : 0L;
        state <<= 1;
        state |= this.isClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.isCrawling ? 1L : 0L;
        state <<= 1;
        state |= this.isCrawlClimbing ? 1L : 0L;
        state <<= 1;
        state |= this.isSwimming ? 1L : 0L;
        state <<= 1;
        state |= this.isDipping ? 1L : 0L;
        state <<= 1;
        state |= this.isDiving ? 1L : 0L;
        state <<= 1;
        state |= this.isp.getIsJumpingField() ? 1L : 0L;
        state <<= 4;
        state |= (long)this.actualHandsClimbType;
        state <<= 4;
        boolean sendStatePacket = (state |= (long)this.actualFeetClimbType) != this.prevPacketState;
        int currentWorldPlayerEntitiesSize = this.sp.worldObj.playerEntities.size();
        if (currentWorldPlayerEntitiesSize == 0) {
            sendStatePacket = false;
            this.lastWorldPlayerEntitiesSize = currentWorldPlayerEntitiesSize;
            this.lastWorldPlayerLastEnttyId = -1;
        } else {
            int currentWorldPlayerLastEnttyId = ((Entity)this.sp.worldObj.playerEntities.get(currentWorldPlayerEntitiesSize - 1)).getEntityId();
            if (currentWorldPlayerEntitiesSize != this.lastWorldPlayerEntitiesSize) {
                if (currentWorldPlayerEntitiesSize > this.lastWorldPlayerEntitiesSize) {
                    sendStatePacket = true;
                }
                this.lastWorldPlayerEntitiesSize = currentWorldPlayerEntitiesSize;
                this.lastWorldPlayerLastEnttyId = currentWorldPlayerLastEnttyId;
            } else if (currentWorldPlayerLastEnttyId != this.lastWorldPlayerLastEnttyId) {
                sendStatePacket = true;
                this.lastWorldPlayerLastEnttyId = currentWorldPlayerLastEnttyId;
            }
        }
        if (sendStatePacket) {
            SmartMovingPacketStream.sendState(SmartMovingComm.instance, this.sp.getEntityId(), state);
            this.prevPacketState = state;
        }
    }

    @Override
    public boolean isSneaking() {
        return this.isSlow && (this.sp.onGround || this.isp.getIsInWebField()) || (Boolean)SmartMovingSelf.Config._sneak.value == false && this.wouldIsSneaking && this.jumpCharge > 0.0f || (this.sp.ridingEntity != null || !SmartMovingSelf.Config.enabled) && this.isp.localIsSneaking() || (Boolean)SmartMovingSelf.Config._crawlOverEdge.value == false && this.isCrawling && !this.isClimbing;
    }

    public boolean isStandupSprintingOrRunning() {
        return (this.isFast || this.sp.isSprinting()) && this.sp.onGround && !this.isSliding && !this.isCrawling;
    }

    public boolean isRunning() {
        return this.sp.isSprinting() && !this.isFast && this.sp.onGround;
    }

    public void beforeGetSleepTimer() {
        SmartMovingRender.renderGuiIngame(this.isp.getMcField());
    }

    public void jump() {
        this.jumpAvoided = true;
    }

    public void writeEntityToNBT(NBTTagCompound nBTTagCompound) {
        this.isp.localWriteEntityToNBT(nBTTagCompound);
        NBTTagCompound abilities = nBTTagCompound.getCompoundTag("abilities");
        if (abilities != null && abilities.hasKey("flying")) {
            abilities.setBoolean("flying", this.sp.capabilities.isFlying);
        }
    }

    @Override
    public boolean isJumping() {
        return this.isp.getIsJumpingField();
    }

    @Override
    public boolean doFlyingAnimation() {
        if (Config.isFlyingEnabled() || Config.isLevitationAnimationEnabled()) {
            return this.sp.capabilities.isFlying;
        }
        return false;
    }

    @Override
    public boolean doFallingAnimation() {
        if (Config.isFallAnimationEnabled()) {
            return !this.sp.onGround && this.sp.fallDistance > ((Float)SmartMovingSelf.Config._fallAnimationDistanceMinimum.value).floatValue();
        }
        return false;
    }

    public void onLivingJump() {
        ForgeHooks.onLivingJump((EntityLivingBase)this.sp);
    }

    public float getFOVMultiplier() {
        if (!SmartMovingSelf.Config.enabled) {
            return this.isp.localGetFOVMultiplier();
        }
        float landMovmentFactor = this.getLandMovementFactor();
        this.setLandMovementFactor(this.fadingPerspectiveFactor);
        float result = this.isp.localGetFOVMultiplier();
        this.setLandMovementFactor(landMovmentFactor);
        return result;
    }

    public float getLandMovementFactor() {
        return this.sp.getAIMoveSpeed();
    }

    public void setLandMovementFactor(float landMovementFactor) {
        Reflect.SetField(ModifiableAttributeInstance.class, this.sp.getEntityAttribute(SharedMonsterAttributes.movementSpeed), SmartMovingInstall.ModifiableAttributeInstance_attributeValue, Float.valueOf(landMovementFactor));
    }

    public static boolean isRopeSliding() {
        return onZipLine != null && Reflect.GetField(onZipLine, null) != null;
    }
}

