/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import net.smart.properties.Properties;
import net.smart.properties.Property;

public abstract class SmartMovingProperties
extends Properties {
    public static final String Enabled = "enabled";
    public static final String Disabled = "disabled";
    private static final String[] _defaultKeys = new String[1];
    private int toggler = -2;
    private String[] keys = _defaultKeys;
    public boolean enabled;

    protected void load(Properties ... propertiesList) throws Exception {
        Iterator<Property> iterator;
        List<Property> propertiesToLoad = this.getProperties();
        if (this.toggler != -2) {
            iterator = propertiesToLoad.iterator();
            while (iterator.hasNext()) {
                iterator.next().reset();
            }
        }
        while (propertiesToLoad.size() > 0) {
            iterator = propertiesToLoad.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().load(propertiesList)) continue;
                iterator.remove();
            }
        }
        this.toggler = 0;
        this.update();
    }

    protected void save(File file, String version, boolean header, boolean comments) throws Exception {
        List<Property> propertiesToSave = this.getProperties();
        FileOutputStream stream = new FileOutputStream(file);
        PrintWriter printer = new PrintWriter(stream);
        if (header) {
            this.printHeader(printer);
        }
        if (version != null) {
            this.printVersion(printer, version, comments);
        }
        for (int i = 0; i < propertiesToSave.size(); ++i) {
            if (!propertiesToSave.get(i).print(printer, this.keys, version, comments) || i >= propertiesToSave.size() - 1) continue;
            printer.println();
        }
        printer.close();
    }

    protected abstract void printVersion(PrintWriter var1, String var2, boolean var3);

    protected abstract void printHeader(PrintWriter var1);

    public void toggle() {
        int length = this.keys == null ? 0 : this.keys.length;
        ++this.toggler;
        if (this.toggler == length) {
            this.toggler = -1;
        }
        this.update();
    }

    public void setKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            keys = _defaultKeys;
        }
        this.keys = keys;
        this.toggler = 0;
        this.update();
    }

    public String getKey(int index) {
        if (this.keys[index] == null) {
            return Enabled;
        }
        return this.keys[index];
    }

    public String getNextKey(String key) {
        int index;
        if (key == null || key.equals(Disabled)) {
            return this.getKey(0);
        }
        for (index = 0; !(index >= this.keys.length || key == null && this.keys[index] == null || key != null && key.equals(this.keys[index])); ++index) {
        }
        if (++index < this.keys.length) {
            return this.keys[index];
        }
        return Disabled;
    }

    public void setCurrentKey(String key) {
        if (key == null || key.equals(Disabled)) {
            this.toggler = -1;
        } else if (this.keys.length == 1 && this.keys[0] == null && key.equals(Enabled)) {
            this.toggler = 0;
        } else {
            this.toggler = 0;
            while (!(this.toggler >= this.keys.length || key == null && this.keys[this.toggler] == null || key != null && key.equals(this.keys[this.toggler]))) {
                ++this.toggler;
            }
            if (this.toggler == this.keys.length) {
                this.toggler = -1;
            }
        }
        this.update();
    }

    public String getCurrentKey() {
        if (this.toggler == -1) {
            return Disabled;
        }
        return this.keys[this.toggler];
    }

    public boolean hasKey(String key) {
        if (Enabled.equals(key)) {
            return this.keys[0] == null;
        }
        if (Disabled.equals(key)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if ((key != null || this.keys[i] != null) && (key == null || !key.equals(this.keys[i]))) continue;
            return true;
        }
        return false;
    }

    public int getKeyCount() {
        return this.keys.length;
    }

    protected void update() {
        List<Property> properties = this.getProperties();
        Iterator<Property> iterator = properties.iterator();
        String currentKey = this.getCurrentKey();
        while (iterator.hasNext()) {
            iterator.next().update(currentKey);
        }
        this.enabled = this.toggler != -1;
    }
}

