/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.render;

import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.util.MathHelper;
import net.smart.moving.render.IModelPlayer;
import net.smart.moving.render.SmartRenderContext;
import net.smart.render.ModelRotationRenderer;
import net.smart.render.SmartRenderModel;

public class SmartMovingModel
extends SmartRenderContext {
    public IModelPlayer imp;
    public ModelBiped mp;
    public SmartRenderModel md;
    public boolean isStandard;
    public boolean isClimb;
    public boolean isClimbJump;
    public int feetClimbType;
    public int handsClimbType;
    public boolean isHandsVineClimbing;
    public boolean isFeetVineClimbing;
    public boolean isCeilingClimb;
    public boolean isSwim;
    public boolean isDive;
    public boolean isCrawl;
    public boolean isCrawlClimb;
    public boolean isJump;
    public boolean isHeadJump;
    public boolean isFlying;
    public boolean isSlide;
    public boolean isLevitate;
    public boolean isFalling;
    public boolean isGenericSneaking;
    public boolean isAngleJumping;
    public int angleJumpType;
    public boolean isRopeSliding;
    public float currentHorizontalSpeedFlattened;
    public float smallOverGroundHeight;
    public Block overGroundBlock;
    public int scaleArmType;
    public int scaleLegType;

    public SmartMovingModel(float f, net.smart.render.IModelPlayer md, IModelPlayer imp) {
        this.imp = imp;
        this.md = md.getRenderModel();
        this.mp = this.md.mp;
    }

    private void setRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        float FrequenceFactor = 0.6662f;
        this.isStandard = false;
        float currentCameraAngle = this.md.currentCameraAngle;
        float currentHorizontalAngle = this.md.currentHorizontalAngle;
        float currentVerticalAngle = this.md.currentVerticalAngle;
        float forwardRotation = this.md.forwardRotation;
        float currentVerticalSpeed = this.md.currentVerticalSpeed;
        float totalVerticalDistance = this.md.totalVerticalDistance;
        float totalDistance = this.md.totalDistance;
        double horizontalDistance = this.md.horizontalDistance;
        float currentSpeed = this.md.currentSpeed;
        if (!Float.isNaN(this.currentHorizontalSpeedFlattened)) {
            currentHorizontalSpeed = this.currentHorizontalSpeedFlattened;
        }
        ModelRotationRenderer bipedOuter = this.md.bipedOuter;
        ModelRotationRenderer bipedTorso = this.md.bipedTorso;
        ModelRotationRenderer bipedBody = this.md.bipedBody;
        ModelRotationRenderer bipedBreast = this.md.bipedBreast;
        ModelRotationRenderer bipedHead = this.md.bipedHead;
        ModelRotationRenderer bipedRightShoulder = this.md.bipedRightShoulder;
        ModelRotationRenderer bipedRightArm = this.md.bipedRightArm;
        ModelRotationRenderer bipedLeftShoulder = this.md.bipedLeftShoulder;
        ModelRotationRenderer bipedLeftArm = this.md.bipedLeftArm;
        ModelRotationRenderer bipedPelvic = this.md.bipedPelvic;
        ModelRotationRenderer bipedRightLeg = this.md.bipedRightLeg;
        ModelRotationRenderer bipedLeftLeg = this.md.bipedLeftLeg;
        if (this.isRopeSliding) {
            float time = totalTime * 0.15f;
            bipedHead.rotateAngleZ = SmartMovingModel.Between(-0.3926991f, 0.3926991f, SmartMovingModel.Normalize(currentCameraAngle - currentHorizontalAngle));
            bipedHead.rotateAngleX = 0.7853982f;
            bipedHead.rotationPointY = 2.0f;
            bipedOuter.fadeRotateAngleY = false;
            bipedOuter.rotateAngleY = currentHorizontalAngle;
            bipedTorso.rotateAngleX = 0.3926991f + 0.09817477f * MathHelper.cos((float)time);
            bipedLeftArm.rotateAngleX = bipedRightArm.rotateAngleX = (float)Math.PI - bipedTorso.rotateAngleX;
            bipedRightArm.rotateAngleZ = 0.5890486f;
            bipedLeftArm.rotateAngleZ = -0.5890486f;
            bipedLeftArm.rotationPointY = -2.0f;
            bipedRightArm.rotationPointY = -2.0f;
            bipedPelvic.rotateAngleX = bipedTorso.rotateAngleX;
            bipedLeftLeg.rotateAngleZ = -0.19634955f;
            bipedRightLeg.rotateAngleZ = 0.19634955f;
            bipedLeftLeg.rotateAngleX = 0.09817477f * MathHelper.cos((float)(time + 1.5707964f));
            bipedRightLeg.rotateAngleX = 0.09817477f * MathHelper.cos((float)(time - 1.5707964f));
        } else if (this.isClimb || this.isCrawlClimb) {
            float feetDistanceSideOffset;
            float feetDistanceSideFactor;
            float feetFrequenceSideFactor;
            float feetDistanceUpOffset;
            float feetDistanceUpFactor;
            float feetFrequenceUpFactor;
            float handsDistanceUpOffset;
            float handsDistanceUpFactor;
            float handsFrequenceUpFactor;
            float handsDistanceSideOffset;
            float handsDistanceSideFactor;
            float handsFrequenceSideFactor;
            bipedOuter.rotateAngleY = forwardRotation / 57.295776f;
            bipedHead.rotateAngleY = 0.0f;
            bipedHead.rotateAngleX = viewVerticalAngelOffset / 57.295776f;
            bipedLeftLeg.rotationOrder = ModelRotationRenderer.YZX;
            bipedRightLeg.rotationOrder = ModelRotationRenderer.YZX;
            int handsClimbType = this.handsClimbType;
            if (this.isHandsVineClimbing && handsClimbType == 2) {
                handsClimbType = 1;
            }
            float verticalSpeed = Math.min(0.5f, currentVerticalSpeed);
            float horizontalSpeed = Math.min(0.5f, currentHorizontalSpeed);
            switch (handsClimbType) {
                case 2: {
                    handsFrequenceSideFactor = 0.6662f;
                    handsDistanceSideFactor = 1.0f;
                    handsDistanceSideOffset = 0.0f;
                    handsFrequenceUpFactor = 0.6662f;
                    handsDistanceUpFactor = 2.0f;
                    handsDistanceUpOffset = -1.5707964f;
                    break;
                }
                case 1: {
                    handsFrequenceSideFactor = 0.6662f;
                    handsDistanceSideFactor = 1.0f;
                    handsDistanceSideOffset = 0.0f;
                    handsFrequenceUpFactor = 0.6662f;
                    handsDistanceUpFactor = 2.0f;
                    handsDistanceUpOffset = -2.5f;
                    break;
                }
                default: {
                    handsFrequenceSideFactor = 0.6662f;
                    handsDistanceSideFactor = 1.0f;
                    handsDistanceSideOffset = 0.0f;
                    handsFrequenceUpFactor = 0.6662f;
                    handsDistanceUpFactor = 0.0f;
                    handsDistanceUpOffset = -0.5f;
                }
            }
            switch (this.feetClimbType) {
                case 1: {
                    feetFrequenceUpFactor = 0.6662f;
                    feetDistanceUpFactor = 0.3f / verticalSpeed;
                    feetDistanceUpOffset = -0.3f;
                    feetFrequenceSideFactor = 0.6662f;
                    feetDistanceSideFactor = 0.5f;
                    feetDistanceSideOffset = 0.0f;
                    break;
                }
                default: {
                    feetFrequenceUpFactor = 0.6662f;
                    feetDistanceUpFactor = 0.0f;
                    feetDistanceUpOffset = 0.0f;
                    feetFrequenceSideFactor = 0.6662f;
                    feetDistanceSideFactor = 0.0f;
                    feetDistanceSideOffset = 0.0f;
                }
            }
            bipedRightArm.rotateAngleX = MathHelper.cos((float)(totalVerticalDistance * handsFrequenceUpFactor + (float)Math.PI)) * verticalSpeed * handsDistanceUpFactor + handsDistanceUpOffset;
            bipedLeftArm.rotateAngleX = MathHelper.cos((float)(totalVerticalDistance * handsFrequenceUpFactor)) * verticalSpeed * handsDistanceUpFactor + handsDistanceUpOffset;
            bipedRightArm.rotateAngleY = MathHelper.cos((float)(totalHorizontalDistance * handsFrequenceSideFactor + 1.5707964f)) * horizontalSpeed * handsDistanceSideFactor + handsDistanceSideOffset;
            bipedLeftArm.rotateAngleY = MathHelper.cos((float)(totalHorizontalDistance * handsFrequenceSideFactor)) * horizontalSpeed * handsDistanceSideFactor + handsDistanceSideOffset;
            if (this.isHandsVineClimbing) {
                bipedLeftArm.rotateAngleY *= 1.0f + handsFrequenceSideFactor;
                bipedRightArm.rotateAngleY *= 1.0f + handsFrequenceSideFactor;
                bipedLeftArm.rotateAngleY += 0.7853982f;
                bipedRightArm.rotateAngleY -= 0.7853982f;
                this.setArmScales(Math.abs(MathHelper.cos((float)bipedRightArm.rotateAngleX)), Math.abs(MathHelper.cos((float)bipedLeftArm.rotateAngleX)));
            }
            if (!this.isFeetVineClimbing) {
                bipedRightLeg.rotateAngleX = MathHelper.cos((float)(totalVerticalDistance * feetFrequenceUpFactor)) * feetDistanceUpFactor * verticalSpeed + feetDistanceUpOffset;
                bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(totalVerticalDistance * feetFrequenceUpFactor + (float)Math.PI)) * feetDistanceUpFactor * verticalSpeed + feetDistanceUpOffset;
            }
            bipedRightLeg.rotateAngleZ = -(MathHelper.cos((float)(totalHorizontalDistance * feetFrequenceSideFactor)) - 1.0f) * horizontalSpeed * feetDistanceSideFactor + feetDistanceSideOffset;
            bipedLeftLeg.rotateAngleZ = -(MathHelper.cos((float)(totalHorizontalDistance * feetFrequenceSideFactor + 1.5707964f)) + 1.0f) * horizontalSpeed * feetDistanceSideFactor + feetDistanceSideOffset;
            if (this.isFeetVineClimbing) {
                float total = (MathHelper.cos((float)(totalDistance + (float)Math.PI)) + 1.0f) * 0.19634955f + 0.3926991f;
                bipedRightLeg.rotateAngleX = -total;
                bipedLeftLeg.rotateAngleX = -total;
                float difference = Math.max(0.0f, MathHelper.cos((float)(totalDistance - 1.5707964f))) * 0.09817477f;
                bipedLeftLeg.rotateAngleZ += -difference;
                bipedRightLeg.rotateAngleZ += difference;
                this.setLegScales(Math.abs(MathHelper.cos((float)bipedRightLeg.rotateAngleX)), Math.abs(MathHelper.cos((float)bipedLeftLeg.rotateAngleX)));
            }
            if (this.isCrawlClimb) {
                float legAngleZ;
                float legAngleX;
                float bodyAngleX;
                float height = this.smallOverGroundHeight + 0.25f;
                float bodyLength = 0.7f;
                float legLength = 0.55f;
                if (height < bodyLength) {
                    bodyAngleX = Math.max(0.0f, (float)Math.acos(height / bodyLength));
                    legAngleX = 1.5707964f - bodyAngleX;
                    legAngleZ = 0.19634955f;
                } else if (height < bodyLength + legLength) {
                    bodyAngleX = 0.0f;
                    legAngleX = Math.max(0.0f, (float)Math.acos((height - bodyLength) / legLength));
                    legAngleZ = 0.19634955f * (legAngleX / 1.537f);
                } else {
                    bodyAngleX = 0.0f;
                    legAngleX = 0.0f;
                    legAngleZ = 0.0f;
                }
                bipedTorso.rotateAngleX = bodyAngleX;
                bipedRightShoulder.rotateAngleX = -bodyAngleX;
                bipedLeftShoulder.rotateAngleX = -bodyAngleX;
                bipedHead.rotateAngleX = -bodyAngleX;
                bipedRightLeg.rotateAngleX = legAngleX;
                bipedLeftLeg.rotateAngleX = legAngleX;
                bipedRightLeg.rotateAngleZ = legAngleZ;
                bipedLeftLeg.rotateAngleZ = -legAngleZ;
            }
            if (handsClimbType == 0 && this.feetClimbType != 0) {
                bipedTorso.rotateAngleX = 0.5f;
                bipedHead.rotateAngleX -= 0.5f;
                bipedPelvic.rotateAngleX -= 0.5f;
                bipedTorso.rotationPointZ = -6.0f;
            }
        } else if (this.isClimbJump) {
            bipedRightArm.rotateAngleX = 3.5342917f;
            bipedLeftArm.rotateAngleX = 3.5342917f;
            bipedRightArm.rotateAngleZ = -0.19634955f;
            bipedLeftArm.rotateAngleZ = 0.19634955f;
        } else if (this.isCeilingClimb) {
            float distance = totalHorizontalDistance * 0.7f;
            float walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 0.12951545f);
            float standFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.12951545f, 0.0f);
            float horizontalAngle = horizontalDistance < (double)0.015f ? currentCameraAngle : currentHorizontalAngle;
            bipedLeftArm.rotateAngleX = (MathHelper.cos((float)distance) * 0.52f + (float)Math.PI) * walkFactor + (float)Math.PI * standFactor;
            bipedRightArm.rotateAngleX = (MathHelper.cos((float)(distance + (float)Math.PI)) * 0.52f - (float)Math.PI) * walkFactor - (float)Math.PI * standFactor;
            bipedLeftLeg.rotateAngleX = -MathHelper.cos((float)distance) * 0.12f * walkFactor;
            bipedRightLeg.rotateAngleX = -MathHelper.cos((float)(distance + (float)Math.PI)) * 0.32f * walkFactor;
            float rotateY = MathHelper.cos((float)distance) * 0.44f * walkFactor;
            bipedOuter.rotateAngleY = rotateY + horizontalAngle;
            bipedRightArm.rotateAngleY = bipedLeftArm.rotateAngleY = -rotateY;
            bipedRightLeg.rotateAngleY = bipedLeftLeg.rotateAngleY = -rotateY;
            bipedHead.rotateAngleY = -rotateY;
        } else if (this.isSwim) {
            float rotateFeetAngleZ;
            float distance = totalHorizontalDistance;
            float walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.15679921f, 0.52264464f);
            float sneakFactor = Math.min(SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 0.15679921f), SmartMovingModel.Factor(currentHorizontalSpeed, 0.52264464f, 0.15679921f));
            float standFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.15679921f, 0.0f);
            float standSneakFactor = standFactor + sneakFactor;
            float horizontalAngle = horizontalDistance < (this.isGenericSneaking ? 0.005 : (double)0.015f) ? currentCameraAngle : currentHorizontalAngle;
            bipedHead.rotationOrder = ModelRotationRenderer.YXZ;
            bipedHead.rotateAngleY = MathHelper.cos((float)(distance / 2.0f - 1.5707964f)) * walkFactor;
            bipedHead.rotateAngleX = -0.7853982f * standSneakFactor;
            bipedHead.rotationPointZ = -2.0f;
            bipedOuter.fadeRotateAngleX = true;
            bipedOuter.rotateAngleX = 1.5707964f - 0.3926991f * standSneakFactor;
            bipedOuter.rotateAngleY = horizontalAngle;
            bipedBreast.rotateAngleY = bipedBody.rotateAngleY = MathHelper.cos((float)(distance / 2.0f - 1.5707964f)) * walkFactor;
            bipedRightArm.rotationOrder = ModelRotationRenderer.YZX;
            bipedLeftArm.rotationOrder = ModelRotationRenderer.YZX;
            bipedRightArm.rotateAngleZ = 2.3561945f + MathHelper.cos((float)(totalTime * 0.1f)) * standSneakFactor * 0.8f;
            bipedLeftArm.rotateAngleZ = -2.3561945f - MathHelper.cos((float)(totalTime * 0.1f)) * standSneakFactor * 0.8f;
            bipedRightArm.rotateAngleX = (distance * 0.5f % ((float)Math.PI * 2) - (float)Math.PI) * walkFactor + 0.3926991f * standSneakFactor;
            bipedLeftArm.rotateAngleX = ((distance * 0.5f + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI) * walkFactor + 0.3926991f * standSneakFactor;
            bipedRightLeg.rotateAngleX = MathHelper.cos((float)distance) * 0.52264464f * walkFactor;
            bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(distance + (float)Math.PI)) * 0.52264464f * walkFactor;
            bipedRightLeg.rotateAngleZ = rotateFeetAngleZ = 0.3926991f * standSneakFactor + MathHelper.cos((float)(totalTime * 0.1f)) * 0.4f * (standFactor - sneakFactor);
            bipedLeftLeg.rotateAngleZ = -rotateFeetAngleZ;
            if (this.scaleLegType != 1) {
                this.setLegScales(1.0f + (MathHelper.cos((float)(totalTime * 0.1f + 1.5707964f)) - 1.0f) * 0.15f * sneakFactor, 1.0f + (MathHelper.cos((float)(totalTime * 0.1f + 1.5707964f)) - 1.0f) * 0.15f * sneakFactor);
            }
            if (this.scaleArmType != 1) {
                this.setArmScales(1.0f + (MathHelper.cos((float)(totalTime * 0.1f - 1.5707964f)) - 1.0f) * 0.15f * sneakFactor, 1.0f + (MathHelper.cos((float)(totalTime * 0.1f - 1.5707964f)) - 1.0f) * 0.15f * sneakFactor);
            }
        } else if (this.isDive) {
            float distance = totalDistance * 0.7f;
            float walkFactor = SmartMovingModel.Factor(currentSpeed, 0.0f, 0.15679921f);
            float standFactor = SmartMovingModel.Factor(currentSpeed, 0.15679921f, 0.0f);
            float horizontalAngle = (double)totalDistance < (this.isGenericSneaking ? 0.005 : (double)0.015f) ? currentCameraAngle : currentHorizontalAngle;
            bipedHead.rotateAngleX = -0.7853982f;
            bipedHead.rotationPointZ = -2.0f;
            bipedOuter.fadeRotateAngleX = true;
            bipedOuter.rotateAngleX = this.isLevitate ? 1.1780972f : (this.isJump ? 0.0f : 1.5707964f - currentVerticalAngle);
            bipedOuter.rotateAngleY = horizontalAngle;
            bipedRightLeg.rotateAngleZ = (MathHelper.cos((float)distance) + 1.0f) * 0.52264464f * walkFactor + 0.3926991f * standFactor;
            bipedLeftLeg.rotateAngleZ = (MathHelper.cos((float)(distance + (float)Math.PI)) - 1.0f) * 0.52264464f * walkFactor - 0.3926991f * standFactor;
            if (this.scaleLegType != 1) {
                this.setLegScales(1.0f + (MathHelper.cos((float)(distance - 1.5707964f)) - 1.0f) * 0.25f * walkFactor, 1.0f + (MathHelper.cos((float)(distance - 1.5707964f)) - 1.0f) * 0.25f * walkFactor);
            }
            bipedRightArm.rotateAngleZ = (MathHelper.cos((float)(distance + (float)Math.PI)) * 0.52264464f * 2.5f + 1.5707964f) * walkFactor + 2.3561945f * standFactor;
            bipedLeftArm.rotateAngleZ = (MathHelper.cos((float)distance) * 0.52264464f * 2.5f - 1.5707964f) * walkFactor - 2.3561945f * standFactor;
            if (this.scaleArmType != 1) {
                this.setArmScales(1.0f + (MathHelper.cos((float)(distance + 1.5707964f)) - 1.0f) * 0.15f * walkFactor, 1.0f + (MathHelper.cos((float)(distance + 1.5707964f)) - 1.0f) * 0.15f * walkFactor);
            }
        } else if (this.isCrawl) {
            float distance = totalHorizontalDistance * 1.3f;
            float walkFactor = SmartMovingModel.Factor(this.currentHorizontalSpeedFlattened, 0.0f, 0.12951545f);
            float standFactor = SmartMovingModel.Factor(this.currentHorizontalSpeedFlattened, 0.12951545f, 0.0f);
            bipedHead.rotateAngleZ = -viewHorizontalAngelOffset / 57.295776f;
            bipedHead.rotateAngleX = -0.7853982f;
            bipedHead.rotationPointZ = -2.0f;
            bipedTorso.rotationOrder = ModelRotationRenderer.YZX;
            bipedTorso.rotateAngleX = 1.3744469f;
            bipedTorso.rotationPointY = 3.0f;
            bipedTorso.rotateAngleZ = MathHelper.cos((float)(distance + 1.5707964f)) * 0.09817477f * walkFactor;
            bipedBody.rotateAngleY = MathHelper.cos((float)(distance + (float)Math.PI)) * 0.09817477f * walkFactor;
            bipedRightLeg.rotateAngleX = (MathHelper.cos((float)(distance - 1.5707964f)) * 0.09817477f + 0.19634955f) * walkFactor + 0.19634955f * standFactor;
            bipedLeftLeg.rotateAngleX = (MathHelper.cos((float)(distance - (float)Math.PI - 1.5707964f)) * 0.09817477f + 0.19634955f) * walkFactor + 0.19634955f * standFactor;
            bipedRightLeg.rotateAngleZ = (MathHelper.cos((float)(distance - 1.5707964f)) + 1.0f) * 0.25f * walkFactor + 0.19634955f * standFactor;
            bipedLeftLeg.rotateAngleZ = (MathHelper.cos((float)(distance - 1.5707964f)) - 1.0f) * 0.25f * walkFactor - 0.19634955f * standFactor;
            if (this.scaleLegType != 1) {
                this.setLegScales(1.0f + (MathHelper.cos((float)(distance + 1.5707964f - 1.5707964f)) - 1.0f) * 0.25f * walkFactor, 1.0f + (MathHelper.cos((float)(distance - 1.5707964f - 1.5707964f)) - 1.0f) * 0.25f * walkFactor);
            }
            bipedRightArm.rotationOrder = ModelRotationRenderer.YZX;
            bipedLeftArm.rotationOrder = ModelRotationRenderer.YZX;
            bipedRightArm.rotateAngleX = 3.926991f;
            bipedLeftArm.rotateAngleX = 3.926991f;
            bipedRightArm.rotateAngleZ = (MathHelper.cos((float)(distance + (float)Math.PI)) * 0.09817477f + 0.19634955f) * walkFactor + 0.3926991f * standFactor;
            bipedLeftArm.rotateAngleZ = (MathHelper.cos((float)(distance + (float)Math.PI)) * 0.09817477f - 0.19634955f) * walkFactor - 0.3926991f * standFactor;
            bipedRightArm.rotateAngleY = -1.5707964f;
            bipedLeftArm.rotateAngleY = 1.5707964f;
            if (this.scaleArmType != 1) {
                this.setArmScales(1.0f + (MathHelper.cos((float)(distance + 1.5707964f)) - 1.0f) * 0.15f * walkFactor, 1.0f + (MathHelper.cos((float)(distance - 1.5707964f)) - 1.0f) * 0.15f * walkFactor);
            }
        } else if (this.isSlide) {
            float distance = totalHorizontalDistance * 0.7f;
            float walkFactor = SmartMovingModel.Factor(currentHorizontalSpeed, 0.0f, 1.0f) * 0.8f;
            bipedHead.rotateAngleZ = -viewHorizontalAngelOffset / 57.295776f;
            bipedHead.rotateAngleX = -1.1780972f;
            bipedHead.rotationPointZ = -2.0f;
            bipedOuter.fadeRotateAngleY = false;
            bipedOuter.rotateAngleY = currentHorizontalAngle;
            bipedOuter.rotationPointY = 5.0f;
            bipedOuter.rotateAngleX = 1.5707964f;
            bipedBody.rotationOrder = ModelRotationRenderer.YXZ;
            bipedBody.offsetY = -0.4f;
            bipedBody.rotationPointY = 6.5f;
            bipedBody.rotateAngleX = MathHelper.cos((float)(distance - 0.7853982f)) * 0.09817477f * walkFactor;
            bipedBody.rotateAngleY = MathHelper.cos((float)(distance + 0.7853982f)) * 0.09817477f * walkFactor;
            bipedRightLeg.rotateAngleX = MathHelper.cos((float)(distance + (float)Math.PI)) * 0.09817477f * walkFactor + 0.09817477f;
            bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(distance + 1.5707964f)) * 0.09817477f * walkFactor + 0.09817477f;
            bipedRightLeg.rotateAngleZ = 0.19634955f;
            bipedLeftLeg.rotateAngleZ = -0.19634955f;
            bipedRightArm.rotationOrder = ModelRotationRenderer.YZX;
            bipedLeftArm.rotationOrder = ModelRotationRenderer.YZX;
            bipedRightArm.rotateAngleX = MathHelper.cos((float)(distance + 1.5707964f)) * 0.09817477f * walkFactor + (float)Math.PI - 0.09817477f;
            bipedLeftArm.rotateAngleX = MathHelper.cos((float)(distance - (float)Math.PI)) * 0.09817477f * walkFactor + (float)Math.PI - 0.09817477f;
            bipedRightArm.rotateAngleZ = 0.3926991f;
            bipedLeftArm.rotateAngleZ = -0.3926991f;
            bipedRightArm.rotateAngleY = -1.5707964f;
            bipedLeftArm.rotateAngleY = 1.5707964f;
        } else if (this.isFlying) {
            float distance = totalDistance * 0.08f;
            float walkFactor = SmartMovingModel.Factor(currentSpeed, 0.0f, 1.0f);
            float standFactor = SmartMovingModel.Factor(currentSpeed, 1.0f, 0.0f);
            float time = totalTime * 0.15f;
            float verticalAngle = this.isJump ? Math.abs(currentVerticalAngle) : currentVerticalAngle;
            float horizontalAngle = horizontalDistance < (double)0.05f ? currentCameraAngle : currentHorizontalAngle;
            bipedOuter.fadeRotateAngleX = true;
            bipedOuter.rotateAngleX = (1.5707964f - verticalAngle) * walkFactor;
            bipedOuter.rotateAngleY = horizontalAngle;
            bipedHead.rotateAngleX = -bipedOuter.rotateAngleX / 2.0f;
            bipedRightArm.rotationOrder = ModelRotationRenderer.XZY;
            bipedLeftArm.rotationOrder = ModelRotationRenderer.XZY;
            bipedRightArm.rotateAngleY = MathHelper.cos((float)time) * 0.3926991f * standFactor;
            bipedLeftArm.rotateAngleY = MathHelper.cos((float)time) * 0.3926991f * standFactor;
            bipedRightArm.rotateAngleZ = (MathHelper.cos((float)(distance + (float)Math.PI)) * 0.09817477f + 2.7488937f) * walkFactor + 1.5707964f * standFactor;
            bipedLeftArm.rotateAngleZ = (MathHelper.cos((float)distance) * 0.09817477f - 2.7488937f) * walkFactor - 1.5707964f * standFactor;
            bipedRightLeg.rotateAngleX = MathHelper.cos((float)distance) * 0.09817477f * walkFactor + MathHelper.cos((float)(time + (float)Math.PI)) * 0.09817477f * standFactor;
            bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(distance + (float)Math.PI)) * 0.09817477f * walkFactor + MathHelper.cos((float)time) * 0.09817477f * standFactor;
            bipedRightLeg.rotateAngleZ = 0.09817477f;
            bipedLeftLeg.rotateAngleZ = -0.09817477f;
        } else if (this.isHeadJump) {
            bipedOuter.fadeRotateAngleX = true;
            bipedOuter.rotateAngleX = 1.5707964f - currentVerticalAngle;
            bipedOuter.rotateAngleY = currentHorizontalAngle;
            bipedHead.rotateAngleX = -bipedOuter.rotateAngleX / 2.0f;
            float bendFactor = Math.min(SmartMovingModel.Factor(currentVerticalAngle, 1.5707964f, 0.0f), SmartMovingModel.Factor(currentVerticalAngle, -1.5707964f, 0.0f));
            bipedRightArm.rotateAngleX = bendFactor * -0.7853982f;
            bipedLeftArm.rotateAngleX = bendFactor * -0.7853982f;
            bipedRightLeg.rotateAngleX = bendFactor * -0.7853982f;
            bipedLeftLeg.rotateAngleX = bendFactor * -0.7853982f;
            float armFactorZ = SmartMovingModel.Factor(currentVerticalAngle, 1.5707964f, -1.5707964f);
            if (this.overGroundBlock != null && this.overGroundBlock.getMaterial().isSolid()) {
                armFactorZ = Math.min(armFactorZ, this.smallOverGroundHeight / 5.0f);
            }
            bipedRightArm.rotateAngleZ = 2.7488937f + armFactorZ * 0.7853982f;
            bipedLeftArm.rotateAngleZ = -2.7488937f - armFactorZ * 0.7853982f;
            float legFactorZ = SmartMovingModel.Factor(currentVerticalAngle, -1.5707964f, 1.5707964f);
            bipedRightLeg.rotateAngleZ = 0.09817477f * legFactorZ;
            bipedLeftLeg.rotateAngleZ = -0.09817477f * legFactorZ;
        } else if (this.isFalling) {
            float distance = totalDistance * 0.1f;
            bipedRightArm.rotationOrder = ModelRotationRenderer.XZY;
            bipedLeftArm.rotationOrder = ModelRotationRenderer.XZY;
            bipedRightArm.rotateAngleY = MathHelper.cos((float)(distance + 1.5707964f)) * 0.7853982f;
            bipedLeftArm.rotateAngleY = MathHelper.cos((float)(distance + 1.5707964f)) * 0.7853982f;
            bipedRightArm.rotateAngleZ = MathHelper.cos((float)distance) * 0.7853982f + 1.5707964f;
            bipedLeftArm.rotateAngleZ = MathHelper.cos((float)distance) * 0.7853982f - 1.5707964f;
            bipedRightLeg.rotateAngleX = MathHelper.cos((float)(distance + (float)Math.PI + 1.5707964f)) * 0.3926991f + 0.19634955f;
            bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(distance + 1.5707964f)) * 0.3926991f + 0.19634955f;
            bipedRightLeg.rotateAngleZ = MathHelper.cos((float)distance) * 0.3926991f + 0.19634955f;
            bipedLeftLeg.rotateAngleZ = MathHelper.cos((float)distance) * 0.3926991f - 0.19634955f;
        } else {
            this.isStandard = true;
        }
    }

    private boolean isWorking() {
        return this.mp.onGround > 0.0f;
    }

    private void animateAngleJumping() {
        float angle = (float)this.angleJumpType * 0.7853982f;
        this.md.bipedPelvic.rotateAngleY -= this.md.bipedOuter.rotateAngleY;
        this.md.bipedPelvic.rotateAngleY += this.md.currentCameraAngle;
        float backness = 1.0f - Math.abs(angle - (float)Math.PI) / 1.5707964f;
        float leftness = -Math.min(angle - (float)Math.PI, 0.0f) / 1.5707964f;
        float rightness = Math.max(angle - (float)Math.PI, 0.0f) / 1.5707964f;
        this.md.bipedLeftLeg.rotateAngleX = 0.19634955f * (1.0f + rightness);
        this.md.bipedRightLeg.rotateAngleX = 0.19634955f * (1.0f + leftness);
        this.md.bipedLeftLeg.rotateAngleY = -angle;
        this.md.bipedRightLeg.rotateAngleY = -angle;
        this.md.bipedLeftLeg.rotateAngleZ = 0.19634955f * backness;
        this.md.bipedRightLeg.rotateAngleZ = -0.19634955f * backness;
        this.md.bipedLeftLeg.rotationOrder = ModelRotationRenderer.ZXY;
        this.md.bipedRightLeg.rotationOrder = ModelRotationRenderer.ZXY;
        this.md.bipedLeftArm.rotateAngleZ = -0.3926991f * rightness;
        this.md.bipedRightArm.rotateAngleZ = 0.3926991f * leftness;
        this.md.bipedLeftArm.rotateAngleX = -0.7853982f * backness;
        this.md.bipedRightArm.rotateAngleX = -0.7853982f * backness;
    }

    private void animateNonStandardWorking(float viewVerticalAngelOffset) {
        this.md.bipedRightShoulder.ignoreSuperRotation = true;
        this.md.bipedRightShoulder.rotateAngleX = viewVerticalAngelOffset / 57.295776f;
        this.md.bipedRightShoulder.rotateAngleY = this.md.workingAngle / 57.295776f;
        this.md.bipedRightShoulder.rotateAngleZ = (float)Math.PI;
        this.md.bipedRightShoulder.rotationOrder = ModelRotationRenderer.ZYX;
        this.md.bipedRightArm.reset();
    }

    private void animateNonStandardBowAiming(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        this.md.bipedRightShoulder.ignoreSuperRotation = true;
        this.md.bipedRightShoulder.rotateAngleY = this.md.workingAngle / 57.295776f;
        this.md.bipedRightShoulder.rotateAngleZ = (float)Math.PI;
        this.md.bipedRightShoulder.rotationOrder = ModelRotationRenderer.ZYX;
        this.md.bipedLeftShoulder.ignoreSuperRotation = true;
        this.md.bipedLeftShoulder.rotateAngleY = this.md.workingAngle / 57.295776f;
        this.md.bipedLeftShoulder.rotateAngleZ = (float)Math.PI;
        this.md.bipedLeftShoulder.rotationOrder = ModelRotationRenderer.ZYX;
        this.md.bipedRightArm.reset();
        this.md.bipedLeftArm.reset();
        float headRotateAngleY = this.md.bipedHead.rotateAngleY;
        float outerRotateAngleY = this.md.bipedOuter.rotateAngleY;
        float headRotateAngleX = this.md.bipedHead.rotateAngleX;
        this.md.bipedHead.rotateAngleY = 0.0f;
        this.md.bipedOuter.rotateAngleY = 0.0f;
        this.md.bipedHead.rotateAngleX = 0.0f;
        this.imp.superAnimateBowAiming(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        this.md.bipedHead.rotateAngleY = headRotateAngleY;
        this.md.bipedOuter.rotateAngleY = outerRotateAngleY;
        this.md.bipedHead.rotateAngleX = headRotateAngleX;
    }

    public void animateHeadRotation(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        this.setRotationAngles(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.isStandard) {
            this.imp.superAnimateHeadRotation(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateSleeping(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superAnimateSleeping(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateArmSwinging(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            if (this.isAngleJumping) {
                this.animateAngleJumping();
            } else {
                this.imp.superAnimateArmSwinging(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
            }
        }
    }

    public void animateRiding(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superAnimateRiding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateLeftArmItemHolding(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superAnimateLeftArmItemHolding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateRightArmItemHolding(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superAnimateRightArmItemHolding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateWorkingBody(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superAnimateWorkingBody(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        } else if (this.isWorking()) {
            this.animateNonStandardWorking(viewVerticalAngelOffset);
        }
    }

    public void animateWorkingArms(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard || this.isWorking()) {
            this.imp.superAnimateWorkingArms(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateSneaking(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard && !this.isAngleJumping) {
            this.imp.superAnimateSneaking(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateArms(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superApplyAnimationOffsets(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    public void animateBowAiming(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        if (this.isStandard) {
            this.imp.superAnimateBowAiming(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        } else {
            this.animateNonStandardBowAiming(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
    }

    private void setArmScales(float rightScale, float leftScale) {
        if (this.scaleArmType == 0) {
            this.md.bipedRightArm.scaleY = rightScale;
            this.md.bipedLeftArm.scaleY = leftScale;
        } else if (this.scaleArmType == 2) {
            this.md.bipedRightArm.offsetY -= (1.0f - rightScale) * 0.5f;
            this.md.bipedLeftArm.offsetY -= (1.0f - leftScale) * 0.5f;
        }
    }

    private void setLegScales(float rightScale, float leftScale) {
        if (this.scaleLegType == 0) {
            this.md.bipedRightLeg.scaleY = rightScale;
            this.md.bipedLeftLeg.scaleY = leftScale;
        } else if (this.scaleLegType == 2) {
            this.md.bipedRightLeg.offsetY -= (1.0f - rightScale) * 0.5f;
            this.md.bipedLeftLeg.offsetY -= (1.0f - leftScale) * 0.5f;
        }
    }

    private static float Factor(float x, float x0, float x1) {
        if (x0 > x1) {
            if (x <= x1) {
                return 1.0f;
            }
            if (x >= x0) {
                return 0.0f;
            }
            return (x0 - x) / (x0 - x1);
        }
        if (x >= x1) {
            return 1.0f;
        }
        if (x <= x0) {
            return 0.0f;
        }
        return (x - x0) / (x1 - x0);
    }

    private static float Between(float min, float max, float value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static float Normalize(float radiant) {
        while (radiant > (float)Math.PI) {
            radiant -= (float)Math.PI * 2;
        }
        while (radiant < (float)(-Math.PI)) {
            radiant += (float)Math.PI * 2;
        }
        return radiant;
    }
}

