/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.render;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.smart.moving.SmartMoving;
import net.smart.moving.SmartMovingFactory;
import net.smart.moving.SmartMovingSelf;
import net.smart.moving.render.IModelPlayer;
import net.smart.moving.render.IRenderPlayer;
import net.smart.moving.render.SmartMovingModel;
import net.smart.moving.render.SmartRenderContext;
import net.smart.render.statistics.SmartStatistics;
import net.smart.render.statistics.SmartStatisticsFactory;
import org.lwjgl.opengl.GL11;

public class SmartMovingRender
extends SmartRenderContext {
    public IRenderPlayer irp;
    public final SmartMovingModel modelBipedMain;
    private static int _iOffset;
    private static int _jOffset;
    private static Minecraft _minecraft;

    public SmartMovingRender(IRenderPlayer irp) {
        this.irp = irp;
        this.modelBipedMain = irp.getPlayerModelBipedMain().getMovingModel();
        SmartMovingModel modelArmorChestplate = irp.getPlayerModelArmorChestplate().getMovingModel();
        SmartMovingModel modelArmor = irp.getPlayerModelArmor().getMovingModel();
        this.modelBipedMain.scaleArmType = 0;
        this.modelBipedMain.scaleLegType = 0;
        modelArmorChestplate.scaleArmType = 1;
        modelArmorChestplate.scaleLegType = 2;
        modelArmor.scaleArmType = 1;
        modelArmor.scaleLegType = 0;
    }

    public void renderPlayer(AbstractClientPlayer entityplayer, double d, double d1, double d2, float f, float renderPartialTicks) {
        IModelPlayer[] modelPlayers = null;
        SmartMoving moving = SmartMovingFactory.getInstance((EntityPlayer)entityplayer);
        if (moving != null) {
            boolean isInventory = d == 0.0 && d1 == 0.0 && d2 == 0.0 && f == 0.0f && renderPartialTicks == 1.0f;
            boolean isClimb = moving.isClimbing && !moving.isCrawling && !moving.isCrawlClimbing && !moving.isClimbJumping;
            boolean isClimbJump = moving.isClimbJumping;
            int handsClimbType = moving.actualHandsClimbType;
            int feetClimbType = moving.actualFeetClimbType;
            boolean isHandsVineClimbing = moving.isHandsVineClimbing;
            boolean isFeetVineClimbing = moving.isFeetVineClimbing;
            boolean isCeilingClimb = moving.isCeilingClimbing;
            boolean isSwim = moving.isSwimming && !moving.isDipping;
            boolean isDive = moving.isDiving;
            boolean isLevitate = moving.isLevitating;
            boolean isCrawl = moving.isCrawling && !moving.isClimbing;
            boolean isCrawlClimb = moving.isCrawlClimbing || moving.isClimbing && moving.isCrawling;
            boolean isJump = moving.isJumping();
            boolean isHeadJump = moving.isHeadJumping;
            boolean isFlying = moving.doFlyingAnimation();
            boolean isSlide = moving.isSliding;
            boolean isFalling = moving.doFallingAnimation();
            boolean isGenericSneaking = moving.isSlow;
            boolean isAngleJumping = moving.isAngleJumping();
            int angleJumpType = moving.angleJumpType;
            boolean isRopeSliding = moving.isRopeSliding;
            SmartStatistics statistics = SmartStatisticsFactory.getInstance((EntityPlayer)entityplayer);
            float currentHorizontalSpeedFlattened = statistics != null ? statistics.getCurrentHorizontalSpeedFlattened(renderPartialTicks, -1) : Float.NaN;
            float smallOverGroundHeight = isCrawlClimb || isHeadJump ? (float)moving.getOverGroundHeight(5.0) : 0.0f;
            Block overGroundBlock = isHeadJump && smallOverGroundHeight < 5.0f ? moving.getOverGroundBlockId(smallOverGroundHeight) : null;
            modelPlayers = this.irp.getPlayerModels();
            for (int i = 0; i < modelPlayers.length; ++i) {
                SmartMovingModel modelPlayer = modelPlayers[i].getMovingModel();
                modelPlayer.isClimb = isClimb;
                modelPlayer.isClimbJump = isClimbJump;
                modelPlayer.handsClimbType = handsClimbType;
                modelPlayer.feetClimbType = feetClimbType;
                modelPlayer.isHandsVineClimbing = isHandsVineClimbing;
                modelPlayer.isFeetVineClimbing = isFeetVineClimbing;
                modelPlayer.isCeilingClimb = isCeilingClimb;
                modelPlayer.isSwim = isSwim;
                modelPlayer.isDive = isDive;
                modelPlayer.isCrawl = isCrawl;
                modelPlayer.isCrawlClimb = isCrawlClimb;
                modelPlayer.isJump = isJump;
                modelPlayer.isHeadJump = isHeadJump;
                modelPlayer.isSlide = isSlide;
                modelPlayer.isFlying = isFlying;
                modelPlayer.isLevitate = isLevitate;
                modelPlayer.isFalling = isFalling;
                modelPlayer.isGenericSneaking = isGenericSneaking;
                modelPlayer.isAngleJumping = isAngleJumping;
                modelPlayer.angleJumpType = angleJumpType;
                modelPlayer.isRopeSliding = isRopeSliding;
                modelPlayer.currentHorizontalSpeedFlattened = currentHorizontalSpeedFlattened;
                modelPlayer.smallOverGroundHeight = smallOverGroundHeight;
                modelPlayer.overGroundBlock = overGroundBlock;
            }
            if (!isInventory && entityplayer.isSneaking() && !(entityplayer instanceof EntityPlayerSP) && isCrawl) {
                d1 += 0.125;
            }
        }
        this.irp.superRenderRenderPlayer(entityplayer, d, d1, d2, f, renderPartialTicks);
        if (moving != null && moving.isLevitating) {
            for (int i = 0; i < modelPlayers.length; ++i) {
                modelPlayers[i].getMovingModel().md.currentHorizontalAngle = modelPlayers[i].getMovingModel().md.currentCameraAngle;
            }
        }
    }

    public void rotatePlayer(AbstractClientPlayer entityplayer, float totalTime, float actualRotation, float f2) {
        SmartMoving moving = SmartMovingFactory.getInstance((EntityPlayer)entityplayer);
        if (moving != null) {
            boolean isInventory;
            boolean bl = isInventory = f2 == 1.0f && moving.isp != null && moving.isp.getMcField().currentScreen instanceof GuiInventory;
            if (!isInventory) {
                float forwardRotation = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f2;
                if (moving.isClimbing || moving.isClimbCrawling || moving.isCrawlClimbing || moving.isFlying || moving.isSwimming || moving.isDiving || moving.isCeilingClimbing || moving.isHeadJumping || moving.isSliding || moving.isAngleJumping()) {
                    entityplayer.renderYawOffset = forwardRotation;
                }
            }
        }
        this.irp.superRenderRotatePlayer(entityplayer, totalTime, actualRotation, f2);
    }

    public void renderPlayerAt(AbstractClientPlayer entityplayer, double d, double d1, double d2) {
        SmartMoving moving;
        if (entityplayer instanceof EntityOtherPlayerMP && (moving = SmartMovingFactory.getOtherSmartMoving(entityplayer.getEntityId())) != null && moving.heightOffset != 0.0f) {
            d1 += (double)moving.heightOffset;
        }
        this.irp.superRenderRenderPlayerAt(entityplayer, d, d1, d2);
    }

    public void renderName(EntityLivingBase entityPlayer, double d, double d1, double d2) {
        boolean changedIsSneaking = false;
        boolean originalIsSneaking = false;
        if (Minecraft.isGuiEnabled() && entityPlayer != this.irp.getRenderManager().livingPlayer) {
            SmartMoving moving;
            SmartMoving smartMoving = moving = entityPlayer instanceof EntityPlayer ? SmartMovingFactory.getInstance((EntityPlayer)entityPlayer) : null;
            if (moving != null) {
                boolean temporaryIsSneaking = originalIsSneaking = entityPlayer.isSneaking();
                if (moving.isCrawling && !moving.isClimbing) {
                    temporaryIsSneaking = (Boolean)SmartMovingRender.Config._crawlNameTag.value == false;
                } else if (originalIsSneaking) {
                    temporaryIsSneaking = (Boolean)SmartMovingRender.Config._sneakNameTag.value == false;
                }
                boolean bl = changedIsSneaking = temporaryIsSneaking != originalIsSneaking;
                if (changedIsSneaking) {
                    entityPlayer.setSneaking(temporaryIsSneaking);
                }
                if (moving.heightOffset == -1.0f) {
                    d1 -= (double)0.2f;
                } else if (originalIsSneaking && !temporaryIsSneaking) {
                    d1 -= (double)0.05f;
                }
            }
        }
        this.irp.superRenderRenderName(entityPlayer, d, d1, d2);
        if (changedIsSneaking) {
            entityPlayer.setSneaking(originalIsSneaking);
        }
    }

    public static void renderGuiIngame(Minecraft minecraft) {
        if (!Client.getNativeUserInterfaceDrawing()) {
            return;
        }
        if (!GL11.glGetBoolean((int)3008)) {
            return;
        }
        SmartMovingSelf moving = (SmartMovingSelf)SmartMovingFactory.getInstance((EntityPlayer)minecraft.thePlayer);
        if (moving != null && SmartMovingRender.Config.enabled && (((Boolean)SmartMovingRender.Options._displayExhaustionBar.value).booleanValue() || ((Boolean)SmartMovingRender.Options._displayJumpChargeBar.value).booleanValue())) {
            ScaledResolution scaledresolution = new ScaledResolution(minecraft, minecraft.displayWidth, minecraft.displayHeight);
            int width = scaledresolution.getScaledWidth();
            int height = scaledresolution.getScaledHeight();
            if (minecraft.playerController.shouldDrawHUD()) {
                float maxExhaustion = Client.getMaximumExhaustion();
                float exhaustion = Math.min(moving.exhaustion, maxExhaustion);
                boolean drawExhaustion = exhaustion > 0.0f && exhaustion <= maxExhaustion;
                float maxStillJumpCharge = ((Float)SmartMovingRender.Config._jumpChargeMaximum.value).floatValue();
                float stillJumpCharge = Math.min(moving.jumpCharge, maxStillJumpCharge);
                float maxRunJumpCharge = ((Float)SmartMovingRender.Config._headJumpChargeMaximum.value).floatValue();
                float runJumpCharge = Math.min(moving.headJumpCharge, maxRunJumpCharge);
                boolean drawJumpCharge = stillJumpCharge > 0.0f || runJumpCharge > 0.0f;
                float maxJumpCharge = stillJumpCharge > runJumpCharge ? maxStillJumpCharge : maxRunJumpCharge;
                float jumpCharge = Math.max(stillJumpCharge, runJumpCharge);
                if (drawExhaustion || drawJumpCharge) {
                    GL11.glPushAttrib((int)262144);
                    minecraft.getTextureManager().bindTexture(new ResourceLocation("smartmoving", "gui/icons.png"));
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    _minecraft = minecraft;
                }
                if (drawExhaustion) {
                    float maxExhaustionForAction = Math.min(moving.maxExhaustionForAction, maxExhaustion);
                    float maxExhaustionToStartAction = Math.min(moving.maxExhaustionToStartAction, maxExhaustion);
                    float fitness = maxExhaustion - exhaustion;
                    float minFitnessForAction = Float.isNaN(maxExhaustionForAction) ? 0.0f : maxExhaustion - maxExhaustionForAction;
                    float minFitnessToStartAction = Float.isNaN(maxExhaustionToStartAction) ? 0.0f : maxExhaustion - maxExhaustionToStartAction;
                    float maxFitnessDrawn = Math.max(Math.max(minFitnessToStartAction, fitness), minFitnessForAction);
                    int halfs = (int)Math.floor(maxFitnessDrawn / maxExhaustion * 21.0f);
                    int fulls = halfs / 2;
                    int half = halfs % 2;
                    int fitnessHalfs = (int)Math.floor(fitness / maxExhaustion * 21.0f);
                    int fitnessFulls = fitnessHalfs / 2;
                    int fitnessHalf = fitnessHalfs % 2;
                    int minFitnessForActionHalfs = (int)Math.floor(minFitnessForAction / maxExhaustion * 21.0f);
                    int minFitnessForActionFulls = minFitnessForActionHalfs / 2;
                    int minFitnessForActionHalf = minFitnessForActionHalfs % 2;
                    int minFitnessToStartActionHalfs = (int)Math.floor(minFitnessToStartAction / maxExhaustion * 21.0f);
                    int minFitnessToStartActionFulls = minFitnessToStartActionHalfs / 2;
                    _jOffset = height - 39 - 10 - (minecraft.thePlayer.isInsideOfMaterial(Material.water) ? 10 : 0);
                    for (int i = 0; i < Math.min(fulls + half, 10); ++i) {
                        _iOffset = width / 2 + 90 - (i + 1) * 8;
                        if (i < fitnessFulls) {
                            if (i < minFitnessForActionFulls) {
                                SmartMovingRender.drawIcon(2, 2);
                                continue;
                            }
                            if (i == minFitnessForActionFulls && minFitnessForActionHalf > 0) {
                                SmartMovingRender.drawIcon(3, 2);
                                continue;
                            }
                            SmartMovingRender.drawIcon(0, 0);
                            continue;
                        }
                        if (i == fitnessFulls && fitnessHalf > 0) {
                            if (i < minFitnessForActionFulls) {
                                SmartMovingRender.drawIcon(1, 2);
                                continue;
                            }
                            if (i == minFitnessForActionFulls && minFitnessForActionHalf > 0) {
                                if (i < minFitnessToStartActionFulls) {
                                    SmartMovingRender.drawIcon(3, 1);
                                    continue;
                                }
                                SmartMovingRender.drawIcon(4, 2);
                                continue;
                            }
                            if (i < minFitnessToStartActionFulls) {
                                SmartMovingRender.drawIcon(1, 1);
                                continue;
                            }
                            SmartMovingRender.drawIcon(1, 0);
                            continue;
                        }
                        if (i < minFitnessForActionFulls) {
                            SmartMovingRender.drawIcon(0, 2);
                            continue;
                        }
                        if (i == minFitnessForActionFulls && minFitnessForActionHalf > 0) {
                            if (i < minFitnessToStartActionFulls) {
                                SmartMovingRender.drawIcon(2, 1);
                                continue;
                            }
                            SmartMovingRender.drawIcon(5, 2);
                            continue;
                        }
                        if (i < minFitnessToStartActionFulls) {
                            SmartMovingRender.drawIcon(0, 1);
                            continue;
                        }
                        SmartMovingRender.drawIcon(4, 1);
                    }
                }
                if (drawJumpCharge) {
                    boolean max = jumpCharge == maxJumpCharge;
                    int fulls = max ? 10 : (int)Math.ceil((double)(jumpCharge - 2.0f) * 10.0 / (double)maxJumpCharge);
                    int half = max ? 0 : (int)Math.ceil((double)jumpCharge * 10.0 / (double)maxJumpCharge) - fulls;
                    _jOffset = height - 39 - 10 - (minecraft.thePlayer.getTotalArmorValue() > 0 ? 10 : 0);
                    for (int i = 0; i < fulls + half; ++i) {
                        _iOffset = width / 2 - 91 + i * 8;
                        SmartMovingRender.drawIcon(i < fulls ? 2 : 3, 0);
                    }
                }
                if (drawExhaustion || drawJumpCharge) {
                    GL11.glPopAttrib();
                }
            }
        }
    }

    private static void drawIcon(int x, int y) {
        SmartMovingRender._minecraft.ingameGUI.drawTexturedModalRect(_iOffset, _jOffset, x * 9, y * 9, 9, 9);
    }
}

