/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.smart.render.RendererData;
import net.smart.render.SmartRenderInstall;
import net.smart.utilities.Reflect;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ModelRotationRenderer
extends ModelRenderer {
    protected static final float RadiantToAngle = 57.295776f;
    protected static final float Whole = (float)Math.PI * 2;
    protected static final float Half = (float)Math.PI;
    private static Field _compiled = Reflect.GetField(ModelRenderer.class, SmartRenderInstall.ModelRenderer_compiled);
    private static Method _compileDisplayList = Reflect.GetMethod(ModelRenderer.class, SmartRenderInstall.ModelRenderer_compileDisplayList, Float.TYPE);
    private static Field _displayList = Reflect.GetField(ModelRenderer.class, SmartRenderInstall.ModelRenderer_displayList);
    protected ModelRotationRenderer base;
    public boolean ignoreRender;
    public boolean forceRender;
    public boolean compiled = false;
    public int displayList;
    public int rotationOrder = XYZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public boolean ignoreBase;
    public boolean ignoreSuperRotation;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public static int XYZ = 0;
    public static int XZY = 1;
    public static int YXZ = 2;
    public static int YZX = 3;
    public static int ZXY = 4;
    public static int ZYX = 5;
    public boolean fadeEnabled;
    public boolean fadeOffsetX;
    public boolean fadeOffsetY;
    public boolean fadeOffsetZ;
    public boolean fadeRotateAngleX;
    public boolean fadeRotateAngleY;
    public boolean fadeRotateAngleZ;
    public boolean fadeRotationPointX;
    public boolean fadeRotationPointY;
    public boolean fadeRotationPointZ;
    public RendererData previous;
    private static FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private static float[] array = new float[16];

    public ModelRotationRenderer(ModelBase modelBase, int i, int j, ModelRotationRenderer baseRenderer) {
        super(modelBase, i, j);
        this.base = baseRenderer;
        if (this.base != null) {
            this.base.addChild(this);
        }
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.fadeEnabled = false;
    }

    public void render(float f) {
        if (!this.ignoreRender && !this.ignoreBase || this.forceRender) {
            this.doRender(f, this.ignoreBase);
        }
    }

    public void renderIgnoreBase(float f) {
        if (this.ignoreBase) {
            this.doRender(f, false);
        }
    }

    public void doRender(float f, boolean useParentTransformations) {
        if (!this.preRender(f)) {
            return;
        }
        this.preTransforms(f, true, useParentTransformations);
        GL11.glCallList((int)this.displayList);
        if (this.childModels != null) {
            for (int i = 0; i < this.childModels.size(); ++i) {
                ((ModelRenderer)this.childModels.get(i)).render(f);
            }
        }
        this.postTransforms(f, true, useParentTransformations);
    }

    public boolean preRender(float f) {
        if (this.isHidden) {
            return false;
        }
        if (!this.showModel) {
            return false;
        }
        if (!this.compiled) {
            this.UpdateCompiled();
        }
        if (!this.compiled) {
            Reflect.Invoke(_compileDisplayList, (Object)this, Float.valueOf(f));
            this.UpdateDisplayList();
            this.compiled = true;
        }
        return true;
    }

    public void preTransforms(float f, boolean push, boolean useParentTransformations) {
        if (this.base != null && !this.ignoreBase && useParentTransformations) {
            this.base.preTransforms(f, push, true);
        }
        this.preTransform(f, push);
    }

    public void preTransform(float f, boolean push) {
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f || this.ignoreSuperRotation) {
            if (push) {
                GL11.glPushMatrix();
            }
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.ignoreSuperRotation) {
                buffer.rewind();
                GL11.glGetFloat((int)2982, (FloatBuffer)buffer);
                buffer.get(array);
                GL11.glLoadIdentity();
                GL11.glTranslatef((float)(array[12] / array[15]), (float)(array[13] / array[15]), (float)(array[14] / array[15]));
            }
            ModelRotationRenderer.rotate(this.rotationOrder, this.rotateAngleX, this.rotateAngleY, this.rotateAngleZ);
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        }
    }

    private static void rotate(int rotationOrder, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        if (rotationOrder == ZXY && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotationOrder == YXZ && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == YZX || rotationOrder == YXZ || rotationOrder == ZXY || rotationOrder == ZYX) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if ((rotationOrder == XZY || rotationOrder == ZYX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == XZY || rotationOrder == YZX || rotationOrder == ZXY || rotationOrder == ZYX) && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == YXZ || rotationOrder == YZX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == XZY) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    public void postTransform(float f, boolean pop) {
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f || this.ignoreSuperRotation) {
            if (pop) {
                GL11.glPopMatrix();
            }
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(-this.offsetX), (float)(-this.offsetY), (float)(-this.offsetZ));
            GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
            GL11.glTranslatef((float)(-this.rotationPointX * f), (float)(-this.rotationPointY * f), (float)(-this.rotationPointZ * f));
        }
    }

    public void postTransforms(float f, boolean pop, boolean useParentTransformations) {
        this.postTransform(f, pop);
        if (this.base != null && !this.ignoreBase && useParentTransformations) {
            this.base.postTransforms(f, pop, true);
        }
    }

    public void reset() {
        this.rotationOrder = XYZ;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.rotationPointX = 0.0f;
        this.rotationPointY = 0.0f;
        this.rotationPointZ = 0.0f;
        this.rotateAngleX = 0.0f;
        this.rotateAngleY = 0.0f;
        this.rotateAngleZ = 0.0f;
        this.ignoreBase = false;
        this.ignoreSuperRotation = false;
        this.forceRender = false;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.offsetZ = 0.0f;
        this.fadeOffsetX = false;
        this.fadeOffsetY = false;
        this.fadeOffsetZ = false;
        this.fadeRotateAngleX = false;
        this.fadeRotateAngleY = false;
        this.fadeRotateAngleZ = false;
        this.fadeRotationPointX = false;
        this.fadeRotationPointY = false;
        this.fadeRotationPointZ = false;
        this.previous = null;
    }

    public void renderWithRotation(float f) {
        boolean update = !this.compiled;
        super.renderWithRotation(f);
        if (update) {
            this.UpdateLocals();
        }
    }

    public void postRender(float f) {
        boolean update;
        boolean bl = update = !this.compiled;
        if (!this.preRender(f)) {
            return;
        }
        if (update) {
            this.UpdateLocals();
        }
        this.preTransforms(f, false, true);
    }

    private void UpdateLocals() {
        this.UpdateCompiled();
        if (this.compiled) {
            this.UpdateDisplayList();
        }
    }

    private void UpdateCompiled() {
        this.compiled = (Boolean)Reflect.GetField(_compiled, (Object)this);
    }

    private void UpdateDisplayList() {
        this.displayList = (Integer)Reflect.GetField(_displayList, (Object)this);
    }

    public void fadeStore(float totalTime) {
        if (this.previous != null) {
            this.previous.offsetX = this.offsetX;
            this.previous.offsetY = this.offsetY;
            this.previous.offsetZ = this.offsetZ;
            this.previous.rotateAngleX = this.rotateAngleX;
            this.previous.rotateAngleY = this.rotateAngleY;
            this.previous.rotateAngleZ = this.rotateAngleZ;
            this.previous.rotationPointX = this.rotationPointX;
            this.previous.rotationPointY = this.rotationPointY;
            this.previous.rotationPointZ = this.rotationPointZ;
            this.previous.totalTime = totalTime;
        }
    }

    public void fadeIntermediate(float totalTime) {
        if (this.previous != null && totalTime - this.previous.totalTime <= 2.0f) {
            this.offsetX = this.GetIntermediatePosition(this.previous.offsetX, this.offsetX, this.fadeOffsetX, this.previous.totalTime, totalTime);
            this.offsetY = this.GetIntermediatePosition(this.previous.offsetY, this.offsetY, this.fadeOffsetY, this.previous.totalTime, totalTime);
            this.offsetZ = this.GetIntermediatePosition(this.previous.offsetZ, this.offsetZ, this.fadeOffsetZ, this.previous.totalTime, totalTime);
            this.rotateAngleX = this.GetIntermediateAngle(this.previous.rotateAngleX, this.rotateAngleX, this.fadeRotateAngleX, this.previous.totalTime, totalTime);
            this.rotateAngleY = this.GetIntermediateAngle(this.previous.rotateAngleY, this.rotateAngleY, this.fadeRotateAngleY, this.previous.totalTime, totalTime);
            this.rotateAngleZ = this.GetIntermediateAngle(this.previous.rotateAngleZ, this.rotateAngleZ, this.fadeRotateAngleZ, this.previous.totalTime, totalTime);
            this.rotationPointX = this.GetIntermediatePosition(this.previous.rotationPointX, this.rotationPointX, this.fadeRotationPointX, this.previous.totalTime, totalTime);
            this.rotationPointY = this.GetIntermediatePosition(this.previous.rotationPointY, this.rotationPointY, this.fadeRotationPointY, this.previous.totalTime, totalTime);
            this.rotationPointZ = this.GetIntermediatePosition(this.previous.rotationPointZ, this.rotationPointZ, this.fadeRotationPointZ, this.previous.totalTime, totalTime);
        }
    }

    public boolean canBeRandomBoxSource() {
        return true;
    }

    private float GetIntermediatePosition(float prevPosition, float shouldPosition, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldPosition == prevPosition) {
            return shouldPosition;
        }
        return prevPosition + (shouldPosition - prevPosition) * (totalTime - lastTotalTime) * 0.2f;
    }

    private float GetIntermediateAngle(float prevAngle, float shouldAngle, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldAngle == prevAngle) {
            return shouldAngle;
        }
        while (prevAngle >= (float)Math.PI * 2) {
            prevAngle -= (float)Math.PI * 2;
        }
        while (prevAngle < 0.0f) {
            prevAngle += (float)Math.PI * 2;
        }
        while (shouldAngle >= (float)Math.PI * 2) {
            shouldAngle -= (float)Math.PI * 2;
        }
        while (shouldAngle < 0.0f) {
            shouldAngle += (float)Math.PI * 2;
        }
        if (shouldAngle > prevAngle && shouldAngle - prevAngle > (float)Math.PI) {
            prevAngle += (float)Math.PI * 2;
        }
        if (shouldAngle < prevAngle && prevAngle - shouldAngle > (float)Math.PI) {
            shouldAngle += (float)Math.PI * 2;
        }
        return prevAngle + (shouldAngle - prevAngle) * (totalTime - lastTotalTime) * 0.2f;
    }
}

