/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render;

import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.util.MathHelper;
import net.smart.render.IModelPlayer;
import net.smart.render.ModelCapeRenderer;
import net.smart.render.ModelEarsRenderer;
import net.smart.render.ModelRotationRenderer;
import net.smart.render.RendererData;
import net.smart.render.SmartRenderContext;

public class SmartRenderModel
extends SmartRenderContext {
    public IModelPlayer imp;
    public ModelBiped mp;
    public boolean isInventory;
    public int scaleArmType;
    public int scaleLegType;
    public float totalVerticalDistance;
    public float currentVerticalSpeed;
    public float totalDistance;
    public float currentSpeed;
    public double distance;
    public double verticalDistance;
    public double horizontalDistance;
    public float currentCameraAngle;
    public float currentVerticalAngle;
    public float currentHorizontalAngle;
    public float actualRotation;
    public float forwardRotation;
    public float workingAngle;
    public ModelRotationRenderer bipedOuter;
    public ModelRotationRenderer bipedTorso;
    public ModelRotationRenderer bipedBody;
    public ModelRotationRenderer bipedBreast;
    public ModelRotationRenderer bipedNeck;
    public ModelRotationRenderer bipedHead;
    public ModelRotationRenderer bipedHeadwear;
    public ModelRotationRenderer bipedRightShoulder;
    public ModelRotationRenderer bipedRightArm;
    public ModelRotationRenderer bipedLeftShoulder;
    public ModelRotationRenderer bipedLeftArm;
    public ModelRotationRenderer bipedPelvic;
    public ModelRotationRenderer bipedRightLeg;
    public ModelRotationRenderer bipedLeftLeg;
    public ModelEarsRenderer bipedEars;
    public ModelCapeRenderer bipedCloak;
    public boolean disabled;
    public boolean attemptToCallRenderCape;
    public RendererData prevOuterRenderData;
    public boolean isSleeping;
    public boolean firstPerson;

    public SmartRenderModel(float f, ModelBiped mp, IModelPlayer imp, ModelRenderer originalBipedBody, ModelRenderer originalBipedCloak, ModelRenderer originalBipedHead, ModelRenderer originalBipedEars, ModelRenderer originalBipedHeadwear, ModelRenderer originalBipedRightArm, ModelRenderer originalBipedLeftArm, ModelRenderer originalBipedRightLeg, ModelRenderer originalBipedLeftLeg) {
        this.imp = imp;
        this.mp = mp;
        mp.boxList.clear();
        this.bipedOuter = this.create(-1, -1, null);
        this.bipedOuter.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedOuter.fadeEnabled = true;
        this.bipedTorso = this.create(16, 16, this.bipedOuter);
        this.bipedTorso.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedBody = this.create(16, 16, this.bipedTorso, originalBipedBody);
        this.bipedBody.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedBreast = this.create(-1, -1, this.bipedTorso);
        this.bipedBreast.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedNeck = this.create(-1, -1, this.bipedBreast);
        this.bipedNeck.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedCloak = new ModelCapeRenderer((ModelBase)mp, 0, 0, this.bipedBreast, this.bipedOuter);
        this.copy(this.bipedCloak, originalBipedCloak);
        this.bipedCloak.setRotationPoint(0.0f, 0.0f, 2.0f);
        this.bipedHead = this.create(0, 0, this.bipedNeck, originalBipedHead);
        this.bipedHead.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedEars = new ModelEarsRenderer((ModelBase)mp, 24, 0, this.bipedHead);
        this.copy(this.bipedCloak, originalBipedEars);
        this.bipedEars.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedHeadwear = this.create(32, 0, this.bipedHead, originalBipedHeadwear);
        this.bipedHeadwear.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedRightShoulder = this.create(40, 16, this.bipedBreast);
        this.bipedRightShoulder.setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.bipedRightArm = this.create(40, 16, this.bipedRightShoulder, originalBipedRightArm);
        this.bipedLeftShoulder = this.create(-1, -1, this.bipedBreast);
        this.bipedLeftShoulder.mirror = true;
        this.bipedLeftShoulder.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.bipedLeftArm = this.create(40, 16, this.bipedLeftShoulder, originalBipedLeftArm);
        this.bipedPelvic = this.create(-1, -1, this.bipedTorso);
        this.bipedPelvic.setRotationPoint(0.0f, 12.0f, 0.0f);
        this.bipedRightLeg = this.create(0, 16, this.bipedPelvic, originalBipedRightLeg);
        this.bipedRightLeg.setRotationPoint(-2.0f, 0.0f, 0.0f);
        this.bipedLeftLeg = this.create(0, 16, this.bipedPelvic, originalBipedLeftLeg);
        this.bipedLeftLeg.setRotationPoint(2.0f, 0.0f, 0.0f);
        imp.initialize(this.bipedBody, this.bipedCloak, this.bipedHead, this.bipedEars, this.bipedHeadwear, this.bipedRightArm, this.bipedLeftArm, this.bipedRightLeg, this.bipedLeftLeg);
    }

    private ModelRotationRenderer create(int i, int j, ModelRotationRenderer base) {
        return new ModelRotationRenderer((ModelBase)this.mp, i, j, base);
    }

    private ModelRotationRenderer create(int i, int j, ModelRotationRenderer base, ModelRenderer original) {
        ModelRotationRenderer local = this.create(i, j, base);
        this.copy(local, original);
        return local;
    }

    private void copy(ModelRotationRenderer local, ModelRenderer original) {
        if (original.childModels != null) {
            for (Object childModel : original.childModels) {
                local.addChild((ModelRenderer)childModel);
            }
        }
        if (original.cubeList != null) {
            for (Object cube : original.cubeList) {
                local.cubeList.add(cube);
            }
        }
        local.mirror = original.mirror;
    }

    public void render(Entity entity, float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        this.bipedLeftLeg.ignoreRender = true;
        this.bipedRightLeg.ignoreRender = true;
        this.bipedLeftArm.ignoreRender = true;
        this.bipedRightArm.ignoreRender = true;
        this.bipedHeadwear.ignoreRender = true;
        this.bipedHead.ignoreRender = true;
        this.bipedBody.ignoreRender = true;
        this.imp.superRender(entity, totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        this.bipedLeftLeg.ignoreRender = false;
        this.bipedRightLeg.ignoreRender = false;
        this.bipedLeftArm.ignoreRender = false;
        this.bipedRightArm.ignoreRender = false;
        this.bipedHeadwear.ignoreRender = false;
        this.bipedHead.ignoreRender = false;
        this.bipedBody.ignoreRender = false;
        this.bipedOuter.render(factor);
        this.bipedOuter.renderIgnoreBase(factor);
        this.bipedTorso.renderIgnoreBase(factor);
        this.bipedBody.renderIgnoreBase(factor);
        this.bipedBreast.renderIgnoreBase(factor);
        this.bipedNeck.renderIgnoreBase(factor);
        this.bipedHead.renderIgnoreBase(factor);
        this.bipedHeadwear.renderIgnoreBase(factor);
        this.bipedRightShoulder.renderIgnoreBase(factor);
        this.bipedRightArm.renderIgnoreBase(factor);
        this.bipedLeftShoulder.renderIgnoreBase(factor);
        this.bipedLeftArm.renderIgnoreBase(factor);
        this.bipedPelvic.renderIgnoreBase(factor);
        this.bipedRightLeg.renderIgnoreBase(factor);
        this.bipedLeftLeg.renderIgnoreBase(factor);
    }

    public void setRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor, Entity entity) {
        this.reset();
        if (this.firstPerson || this.isInventory) {
            this.bipedBody.ignoreBase = true;
            this.bipedHead.ignoreBase = true;
            this.bipedHeadwear.ignoreBase = true;
            this.bipedEars.ignoreBase = true;
            this.bipedCloak.ignoreBase = true;
            this.bipedRightArm.ignoreBase = true;
            this.bipedLeftArm.ignoreBase = true;
            this.bipedRightLeg.ignoreBase = true;
            this.bipedLeftLeg.ignoreBase = true;
            this.bipedBody.forceRender = this.firstPerson;
            this.bipedHead.forceRender = this.firstPerson;
            this.bipedHeadwear.forceRender = this.firstPerson;
            this.bipedEars.forceRender = this.firstPerson;
            this.bipedCloak.forceRender = this.firstPerson;
            this.bipedRightArm.forceRender = this.firstPerson;
            this.bipedLeftArm.forceRender = this.firstPerson;
            this.bipedRightLeg.forceRender = this.firstPerson;
            this.bipedLeftLeg.forceRender = this.firstPerson;
            this.bipedRightArm.setRotationPoint(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm.setRotationPoint(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg.setRotationPoint(-2.0f, 12.0f, 0.0f);
            this.bipedLeftLeg.setRotationPoint(2.0f, 12.0f, 0.0f);
            this.imp.superSetRotationAngles(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor, entity);
            return;
        }
        if (this.isSleeping) {
            this.prevOuterRenderData.rotateAngleX = 0.0f;
            this.prevOuterRenderData.rotateAngleY = 0.0f;
            this.prevOuterRenderData.rotateAngleZ = 0.0f;
        }
        this.bipedOuter.previous = this.prevOuterRenderData;
        this.bipedOuter.rotateAngleY = this.actualRotation / 57.295776f;
        this.bipedOuter.fadeRotateAngleY = !(entity.ridingEntity instanceof EntityPig);
        this.imp.animateHeadRotation(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.isSleeping) {
            this.imp.animateSleeping(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        this.imp.animateArmSwinging(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.mp.isRiding) {
            this.imp.animateRiding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.heldItemLeft != 0) {
            this.imp.animateLeftArmItemHolding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.heldItemRight != 0) {
            this.imp.animateRightArmItemHolding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.onGround > -9990.0f) {
            this.imp.animateWorkingBody(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
            this.imp.animateWorkingArms(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.isSneak) {
            this.imp.animateSneaking(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        this.imp.animateArms(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.mp.aimedBow) {
            this.imp.animateBowAiming(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.bipedOuter.previous != null && !this.bipedOuter.fadeRotateAngleX) {
            this.bipedOuter.previous.rotateAngleX = this.bipedOuter.rotateAngleX;
        }
        if (this.bipedOuter.previous != null && !this.bipedOuter.fadeRotateAngleY) {
            this.bipedOuter.previous.rotateAngleY = this.bipedOuter.rotateAngleY;
        }
        this.bipedOuter.fadeIntermediate(totalTime);
        this.bipedOuter.fadeStore(totalTime);
        this.bipedCloak.ignoreBase = false;
        this.bipedCloak.rotateAngleX = 0.09817477f;
    }

    public void animateHeadRotation(float viewHorizontalAngelOffset, float viewVerticalAngelOffset) {
        this.bipedNeck.ignoreBase = true;
        this.bipedHead.rotateAngleY = (this.actualRotation + viewHorizontalAngelOffset) / 57.295776f;
        this.bipedHead.rotateAngleX = viewVerticalAngelOffset / 57.295776f;
    }

    public void animateSleeping() {
        this.bipedNeck.ignoreBase = false;
        this.bipedHead.rotateAngleY = 0.0f;
        this.bipedHead.rotateAngleX = 0.7853982f;
        this.bipedTorso.rotationPointZ = -17.0f;
    }

    public void animateArmSwinging(float totalHorizontalDistance, float currentHorizontalSpeed) {
        this.bipedRightArm.rotateAngleX = MathHelper.cos((float)(totalHorizontalDistance * 0.6662f + (float)Math.PI)) * 2.0f * currentHorizontalSpeed * 0.5f;
        this.bipedLeftArm.rotateAngleX = MathHelper.cos((float)(totalHorizontalDistance * 0.6662f)) * 2.0f * currentHorizontalSpeed * 0.5f;
        this.bipedRightLeg.rotateAngleX = MathHelper.cos((float)(totalHorizontalDistance * 0.6662f)) * 1.4f * currentHorizontalSpeed;
        this.bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(totalHorizontalDistance * 0.6662f + (float)Math.PI)) * 1.4f * currentHorizontalSpeed;
    }

    public void animateRiding() {
        this.bipedRightArm.rotateAngleX += -0.6283185f;
        this.bipedLeftArm.rotateAngleX += -0.6283185f;
        this.bipedRightLeg.rotateAngleX = -1.256637f;
        this.bipedLeftLeg.rotateAngleX = -1.256637f;
        this.bipedRightLeg.rotateAngleY = 0.3141593f;
        this.bipedLeftLeg.rotateAngleY = -0.3141593f;
    }

    public void animateLeftArmItemHolding() {
        this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.3141593f * (float)this.mp.heldItemLeft;
    }

    public void animateRightArmItemHolding() {
        this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.3141593f * (float)this.mp.heldItemRight;
    }

    public void animateWorkingBody() {
        float angle = MathHelper.sin((float)(MathHelper.sqrt_float((float)this.mp.onGround) * ((float)Math.PI * 2))) * 0.2f;
        this.bipedBreast.rotateAngleY = this.bipedBody.rotateAngleY += angle;
        this.bipedBreast.rotationOrder = this.bipedBody.rotationOrder = ModelRotationRenderer.YXZ;
        this.bipedLeftArm.rotateAngleX += angle;
    }

    public void animateWorkingArms() {
        float f6 = 1.0f - this.mp.onGround;
        f6 = 1.0f - f6 * f6 * f6;
        float f7 = MathHelper.sin((float)(f6 * (float)Math.PI));
        float f8 = MathHelper.sin((float)(this.mp.onGround * (float)Math.PI)) * -(this.bipedHead.rotateAngleX - 0.7f) * 0.75f;
        this.bipedRightArm.rotateAngleX = (float)((double)this.bipedRightArm.rotateAngleX - ((double)f7 * 1.2 + (double)f8));
        this.bipedRightArm.rotateAngleY += MathHelper.sin((float)(MathHelper.sqrt_float((float)this.mp.onGround) * ((float)Math.PI * 2))) * 0.4f;
        this.bipedRightArm.rotateAngleZ -= MathHelper.sin((float)(this.mp.onGround * (float)Math.PI)) * 0.4f;
    }

    public void animateSneaking() {
        this.bipedTorso.rotateAngleX += 0.5f;
        this.bipedRightLeg.rotateAngleX += -0.5f;
        this.bipedLeftLeg.rotateAngleX += -0.5f;
        this.bipedRightArm.rotateAngleX += -0.1f;
        this.bipedLeftArm.rotateAngleX += -0.1f;
        this.bipedPelvic.offsetY = -0.137f;
        this.bipedPelvic.offsetZ = -0.051f;
        this.bipedBreast.offsetY = -0.014f;
        this.bipedBreast.offsetZ = -0.057f;
        this.bipedNeck.offsetY = 0.0621f;
    }

    public void animateArms(float totalTime) {
        this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(totalTime * 0.067f)) * 0.05f;
    }

    public void animateBowAiming(float totalTime) {
        this.bipedRightArm.rotateAngleZ = 0.0f;
        this.bipedLeftArm.rotateAngleZ = 0.0f;
        this.bipedRightArm.rotateAngleY = -0.1f + this.bipedHead.rotateAngleY - this.bipedOuter.rotateAngleY;
        this.bipedLeftArm.rotateAngleY = 0.1f + this.bipedHead.rotateAngleY + 0.4f - this.bipedOuter.rotateAngleY;
        this.bipedRightArm.rotateAngleX = -1.570796f + this.bipedHead.rotateAngleX;
        this.bipedLeftArm.rotateAngleX = -1.570796f + this.bipedHead.rotateAngleX;
        this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(totalTime * 0.067f)) * 0.05f;
    }

    public void reset() {
        this.bipedOuter.reset();
        this.bipedTorso.reset();
        this.bipedBody.reset();
        this.bipedBreast.reset();
        this.bipedNeck.reset();
        this.bipedHead.reset();
        this.bipedHeadwear.reset();
        this.bipedEars.reset();
        this.bipedCloak.reset();
        this.bipedRightShoulder.reset();
        this.bipedRightArm.reset();
        this.bipedLeftShoulder.reset();
        this.bipedLeftArm.reset();
        this.bipedPelvic.reset();
        this.bipedRightLeg.reset();
        this.bipedLeftLeg.reset();
        this.bipedRightShoulder.setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.bipedLeftShoulder.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.bipedPelvic.setRotationPoint(0.0f, 12.0f, 0.0f);
        this.bipedRightLeg.setRotationPoint(-2.0f, 0.0f, 0.0f);
        this.bipedLeftLeg.setRotationPoint(2.0f, 0.0f, 0.0f);
        this.bipedCloak.setRotationPoint(0.0f, 0.0f, 2.0f);
    }

    public void renderCloak(float f) {
        this.attemptToCallRenderCape = true;
        if (!this.disabled) {
            this.imp.superRenderCloak(f);
        }
    }

    public ModelRenderer getRandomBox(Random par1Random) {
        List boxList = this.mp.boxList;
        int size = boxList.size();
        int renderersWithBoxes = 0;
        for (int i = 0; i < size; ++i) {
            ModelRenderer renderer = (ModelRenderer)boxList.get(i);
            if (!SmartRenderModel.canBeRandomBoxSource(renderer)) continue;
            ++renderersWithBoxes;
        }
        if (renderersWithBoxes != 0) {
            int random = par1Random.nextInt(renderersWithBoxes);
            renderersWithBoxes = -1;
            for (int i = 0; i < size; ++i) {
                ModelRenderer renderer = (ModelRenderer)boxList.get(i);
                if (SmartRenderModel.canBeRandomBoxSource(renderer)) {
                    ++renderersWithBoxes;
                }
                if (renderersWithBoxes != random) continue;
                return renderer;
            }
        }
        return null;
    }

    private static boolean canBeRandomBoxSource(ModelRenderer renderer) {
        return renderer.cubeList != null && renderer.cubeList.size() > 0 && (!(renderer instanceof ModelRotationRenderer) || ((ModelRotationRenderer)renderer).canBeRandomBoxSource());
    }
}

