package net.smart.moving;

import java.util.*;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;

import net.minecraft.entity.*;
import net.minecraft.util.*;

public interface IEntityPlayerMP extends IPacketSender
{
	void sendPacketToTrackedPlayers(FMLProxyPacket packet);

	String getUsername();

	void resetFallDistance();

	void resetTicksForFloatKick();

	void setHeight(float height);

	double getMinY();

	float getHeight();

	void setMaxY(double maxY);

	boolean localIsEntityInsideOpaqueBlock();

	SmartMovingServer getMoving();

	IEntityPlayerMP[] getAllPlayers();

	float doGetHealth();

	AxisAlignedBB getBox();

	AxisAlignedBB expandBox(AxisAlignedBB box, double x, double y, double z);

	List getEntitiesExcludingPlayer(AxisAlignedBB box);

	boolean isDeadEntity(Entity entity);

	void onCollideWithPlayer(Entity entity);

	void localAddExhaustion(float exhaustion);

	void localAddMovementStat(double x, double y, double z);

	void localPlaySound(String soundId, float volume, float pitch);
}