package net.smart.moving;

import java.util.*;

public class SmartMovingClient extends SmartMovingContext implements ISmartMovingClient
{
	private final Map<String, Float> maximumExhaustionValues = new HashMap<String, Float>();
	private boolean nativeUserInterfaceDrawing = true;

	public float getMaximumExhaustion()
	{
		float maxExhaustion = Config.getMaxExhaustion();
		if(maximumExhaustionValues.size() > 0)
		{
			Iterator<Float> iterator = maximumExhaustionValues.values().iterator();
			while(iterator.hasNext())
				maxExhaustion = Math.max(iterator.next(), maxExhaustion);
		}
		return maxExhaustion;
	}

	public float getMaximumUpJumpCharge()
	{
		return Config._jumpChargeMaximum.value;
	}

	public float getMaximumHeadJumpCharge()
	{
		return Config._headJumpChargeMaximum.value;
	}

	public void setMaximumExhaustionValue(String key, float value)
	{
		maximumExhaustionValues.put(key, value);
	}

	public float getMaximumExhaustionValue(String key)
	{
		return maximumExhaustionValues.get(key);
	}

	public boolean removeMaximumExhaustionValue(String key)
	{
		return maximumExhaustionValues.remove(key) != null;
	}

	public void setNativeUserInterfaceDrawing(boolean value)
	{
		nativeUserInterfaceDrawing = value;
	}

	public boolean getNativeUserInterfaceDrawing()
	{
		return nativeUserInterfaceDrawing;
	}
}
