package net.smart.moving;

import net.minecraft.client.entity.*;

public class SmartMovingOther extends SmartMoving
{
	public boolean foundAlive;

	public SmartMovingOther(EntityOtherPlayerMP sp)
	{
		super(sp, null);
	}

	public void processStatePacket(long state)
	{
		actualFeetClimbType = (int)(state & 15);
		state >>>= 4;

		actualHandsClimbType = (int)(state & 15);
		state >>>= 4;

		_isJumping = (state & 1) != 0;
		state >>>= 1;

		isDiving = (state & 1) != 0;
		state >>>= 1;

		isDipping = (state & 1) != 0;
		state >>>= 1;

		isSwimming = (state & 1) != 0;
		state >>>= 1;

		isCrawlClimbing = (state & 1) != 0;
		state >>>= 1;

		isCrawling = (state & 1) != 0;
		state >>>= 1;

		isClimbing = (state & 1) != 0;
		state >>>= 1;

		boolean isSmall = (state & 1) != 0;
		heightOffset = isSmall ? -1 : 0;
		sp.height = 1.8F + heightOffset;
		state >>>= 1;

		_doFallingAnimation = (state & 1) != 0;
		state >>>= 1;

		_doFlyingAnimation = (state & 1) != 0;
		state >>>= 1;

		isCeilingClimbing = (state & 1) != 0;
		state >>>= 1;

		isLevitating = (state & 1) != 0;
		state >>>= 1;

		isHeadJumping = (state & 1) != 0;
		state >>>= 1;

		isSliding = (state & 1) != 0;
		state >>>= 1;

		angleJumpType = (int)(state & 7);
		state >>>= 3;

		isFeetVineClimbing = (state & 1) != 0;
		state >>>= 1;

		isHandsVineClimbing = (state & 1) != 0;
		state >>>= 1;

		isClimbJumping = (state & 1) != 0;
		state >>>= 1;

		boolean wasClimbBackJumping = isClimbBackJumping;
		isClimbBackJumping = (state & 1) != 0;
		if(!wasClimbBackJumping && isClimbBackJumping)
			onStartClimbBackJump();
		state >>>= 1;

		isSlow = (state & 1) != 0;
		state >>>= 1;

		isFast = (state & 1) != 0;
		state >>>= 1;

		boolean wasWallJumping = isWallJumping;
		isWallJumping = (state & 1) != 0;
		if(!wasWallJumping && isWallJumping)
			onStartWallJump(null);
		state >>>= 1;

		isRopeSliding = (state & 1) != 0;
	}

	public boolean isJumping()
	{
		return _isJumping;
	}

	public boolean doFlyingAnimation()
	{
		return _doFlyingAnimation;
	}

	public boolean doFallingAnimation()
	{
		return _doFallingAnimation;
	}

	private boolean _isJumping = false;
	private boolean _doFlyingAnimation = false;
	private boolean _doFallingAnimation = false;
}
