package net.smart.moving;

import cpw.mods.fml.common.network.internal.*;

public class SmartMovingServerComm implements IPacketReceiver
{
	public static ILocalUserNameProvider localUserNameProvider = null;

	public boolean processStatePacket(FMLProxyPacket packet, IEntityPlayerMP player, int entityId, long state)
	{
		player.getMoving().processStatePacket(packet, state);
		return true;
	}

	public boolean processConfigInfoPacket(FMLProxyPacket packet, IEntityPlayerMP player, String info)
	{
		player.getMoving().processConfigPacket(info);
		return true;
	}

	public boolean processConfigContentPacket(FMLProxyPacket packet, IEntityPlayerMP player, String[] content, String username)
	{
		return false;
	}

	public boolean processConfigChangePacket(FMLProxyPacket packet, IEntityPlayerMP player)
	{
		player.getMoving().processConfigChangePacket(localUserNameProvider != null ? localUserNameProvider.getLocalConfigUserName() : null);
		return true;
	}

	public boolean processSpeedChangePacket(FMLProxyPacket packet, IEntityPlayerMP player, int difference, String username)
	{
		player.getMoving().processSpeedChangePacket(difference, localUserNameProvider != null ? localUserNameProvider.getLocalSpeedUserName() : null);
		return true;
	}

	public boolean processHungerChangePacket(FMLProxyPacket packet, IEntityPlayerMP player, float hunger)
	{
		player.getMoving().processHungerChangePacket(hunger);
		return true;
	}

	public boolean processSoundPacket(FMLProxyPacket packet, IEntityPlayerMP player, String soundId, float volume, float pitch)
	{
		player.getMoving().processSoundPacket(soundId, volume, pitch);
		return true;
	}

	public static final SmartMovingServerComm instance = new SmartMovingServerComm();
}
