package net.smart.moving.playerapi;

import io.netty.buffer.*;

import java.util.*;

import cpw.mods.fml.common.network.internal.*;

import api.player.server.*;

import net.smart.moving.*;
import net.smart.utilities.*;
import net.minecraft.entity.*;
import net.minecraft.util.*;

public class SmartMovingServerPlayerBase extends ServerPlayerBase implements IEntityPlayerMP
{
	public static void registerPlayerBase()
	{
		ServerPlayerAPI.register(SmartMovingInfo.ModName, SmartMovingServerPlayerBase.class);
	}

	public static SmartMovingServerPlayerBase getPlayerBase(Object player)
	{
		return (SmartMovingServerPlayerBase)((IServerPlayerAPI)player).getServerPlayerBase(SmartMovingInfo.ModName);
	}

	public SmartMovingServerPlayerBase(ServerPlayerAPI playerApi)
	{
		super(playerApi);
		moving = new SmartMovingServer(this, false);
	}

	public float getHeight()
	{
		return player.height;
	}

	public double getMinY()
	{
		return player.boundingBox.minY;
	}

	public void setMaxY(double maxY)
	{
		player.boundingBox.maxY = maxY;
	}

	@Override
	public void afterSetPosition(double d, double d1, double d2)
	{
		moving.afterSetPosition(d, d1, d2);
	}

	@Override
	public void beforeIsPlayerSleeping()
	{
		moving.beforeIsPlayerSleeping();
	}

	@Override
	public void beforeOnUpdate()
	{
		moving.beforeOnUpdate();
	}

	@Override
	public void afterOnUpdate()
	{
		moving.afterOnUpdate();
	}

	@Override
	public void beforeOnLivingUpdate()
	{
		moving.beforeOnLivingUpdate();
	}

	@Override
	public void afterOnLivingUpdate()
	{
		moving.afterOnLivingUpdate();
	}

	public float doGetHealth()
	{
		return player.getHealth();
	}

	public AxisAlignedBB getBox()
	{
		return player.boundingBox;
	}

	public AxisAlignedBB expandBox(AxisAlignedBB box, double x, double y, double z)
	{
		return box.expand(x, y, z);
	}

	public List getEntitiesExcludingPlayer(AxisAlignedBB box)
	{
		return player.worldObj.getEntitiesWithinAABBExcludingEntity(player, box);
	}

	public boolean isDeadEntity(Entity entity)
	{
		return entity.isDead;
	}

	public void onCollideWithPlayer(Entity entity)
	{
		entity.onCollideWithPlayer(player);
	}

	public float getEyeHeight()
	{
		 return player.height - 0.18F;
	}

	@Override
	public boolean isEntityInsideOpaqueBlock()
	{
		return moving.isEntityInsideOpaqueBlock();
	}

	public boolean localIsEntityInsideOpaqueBlock()
	{
		return super.isEntityInsideOpaqueBlock();
	}

	@Override
	public void addExhaustion(float exhaustion)
	{
		moving.addExhaustion(exhaustion);
	}

	public void localAddExhaustion(float exhaustion)
	{
		super.addExhaustion(exhaustion);
	}

	@Override
	public void addMovementStat(double x, double y, double z)
	{
		moving.addMovementStat(x, y, z);
	}

	public void localAddMovementStat(double x, double y, double z)
	{
		super.addMovementStat(x, y, z);
	}

	public void localPlaySound(String soundId, float volume, float pitch)
	{
		player.playSound(soundId, volume, pitch);
	}

	@Override
	public void beforeUpdatePotionEffects()
	{
		moving.afterAddMovingHungerBatch();
	}

	@Override
	public void afterUpdatePotionEffects()
	{
		moving.beforeAddMovingHungerBatch();
	}

	public void setHeight(float height)
	{
		player.height = height;
	}

	public void sendPacket(byte[] data)
	{
		sendPacket(new FMLProxyPacket(Unpooled.wrappedBuffer(data), SmartMovingPacketStream.Id));
	}

	public void sendPacket(FMLProxyPacket packet)
	{
		player.playerNetServerHandler.sendPacket(packet);
	}

	public String getUsername()
	{
		return player.getGameProfile().getName();
	}

	public void resetFallDistance()
	{
		player.fallDistance = 0;
		player.motionY = 0.08;
	}

	public void resetTicksForFloatKick()
	{
		Reflect.SetField(net.minecraft.network.NetHandlerPlayServer.class, player.playerNetServerHandler, SmartMovingInstall.NetServerHandler_ticksForFloatKick, 0);
	}

	public void sendPacketToTrackedPlayers(FMLProxyPacket packet)
	{
		player.mcServer.worldServerForDimension(player.dimension).getEntityTracker().func_151247_a(player, packet);
	}

	public SmartMovingServer getMoving()
	{
		return moving;
	}

	public IEntityPlayerMP[] getAllPlayers()
	{
		List playerEntityList = player.mcServer.getConfigurationManager().playerEntityList;
		IEntityPlayerMP[] result = new IEntityPlayerMP[playerEntityList.size()];
		for(int i=0; i<playerEntityList.size(); i++)
			result[i] = (IEntityPlayerMP)((IServerPlayerAPI)playerEntityList.get(i)).getServerPlayerBase(SmartMovingInfo.ModName);
		return result;
	}

	public final SmartMovingServer moving;
}