/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

@SideOnly(value=Side.CLIENT)
public abstract class GuiElement
extends Gui {
    protected Minecraft mc;
    private boolean visible = true;
    private boolean enabled = true;
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected HashSet<GuiElement> elements = new HashSet();

    public int getXPos() {
        return this.guiLeft;
    }

    public int getYPos() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public GuiElement(int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = Minecraft.func_71410_x();
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEnabled() {
        return this.enabled && this.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void update() {
        for (GuiElement elem : this.elements) {
            elem.update();
        }
    }

    public void handleMouseInput() {
        for (GuiElement elem : this.elements) {
            elem.handleMouseInput();
        }
    }

    public boolean keyTyped(char c, int i) {
        for (GuiElement elem : this.elements) {
            if (!elem.keyTyped(c, i)) continue;
            return true;
        }
        return false;
    }

    public void mouseUp(int i, int j, int k) {
        for (GuiElement elem : this.elements) {
            elem.mouseUp(i, j, k);
        }
    }

    public boolean mouseClicked(int i, int j, int k) {
        for (GuiElement elem : this.elements) {
            if (!elem.mouseClicked(i, j, k)) continue;
            return true;
        }
        return false;
    }

    public void render(float f, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        for (GuiElement elem : this.elements) {
            elem.render(f, mouseX, mouseY);
        }
    }

    public void renderForeground(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        for (GuiElement elem : this.elements) {
            elem.renderForeground(mouseX, mouseY);
        }
    }

    public List<String> getTooltipInfo() {
        List<String> list = null;
        for (GuiElement elem : this.elements) {
            list = elem.getTooltipInfo();
            if (list == null) continue;
            return list;
        }
        return list;
    }
}

