/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import java.util.List;
import net.minecraft.util.IIcon;

public abstract class GuiElementButtonBase
extends GuiElement {
    private IIcon icon;
    private String text;
    private List<String> tooltip;
    private boolean clicked;
    private boolean hovered = false;

    public GuiElementButtonBase(int guiLeft, int guiTop, int width, int height) {
        super(guiLeft, guiTop, width, height);
    }

    public void setIcon(IIcon icon) {
        this.icon = icon;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTooltip(List<String> string) {
        this.tooltip = string;
    }

    @Override
    public void mouseUp(int i, int j, int k) {
        if (this.clicked && GuiUtils.contains(i, j, this.guiLeft, this.guiTop, this.xSize, this.ySize)) {
            this.onClick(i, j, k);
        }
        this.clicked = false;
    }

    protected abstract void onClick(int var1, int var2, int var3);

    protected boolean isDepressed() {
        return this.clicked;
    }

    @Override
    public boolean mouseClicked(int i, int j, int k) {
        if (GuiUtils.contains(i, j, this.guiLeft, this.guiTop, this.xSize, this.ySize)) {
            this.clicked = true;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTooltipInfo() {
        if (this.hovered) {
            return this.tooltip;
        }
        return super.getTooltipInfo();
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
    }

    @Override
    public void render(float f, int mouseX, int mouseY) {
        this.hovered = GuiUtils.contains(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize, this.ySize);
        if (this.isDepressed()) {
            GuiUtils.drawSprite(this.guiLeft, this.guiTop, this.xSize, this.ySize, 0, 0, this.field_73735_i);
        } else {
            GuiUtils.drawSprite(this.guiLeft, this.guiTop, this.xSize, this.ySize, 0, 18, this.field_73735_i);
        }
        if (this.hovered) {
            GuiUtils.drawGradientRect(this.guiLeft, this.guiTop, this.guiLeft + this.xSize, this.guiTop + this.ySize, -1862270977, -1862270977, this.field_73735_i);
        }
        if (this.icon != null) {
            GuiUtils.drawIcon(this.guiLeft, this.guiTop, this.icon, this.xSize, this.ySize, this.field_73735_i);
        }
        if (this.text != null) {
            GuiUtils.drawScaledText(this.text, this.guiLeft + 2, this.guiTop + 2, this.xSize - 4, this.ySize - 4, -16777216);
        }
    }
}

