/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementTextField;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.inventory.InventoryNotebook;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MPacketGuiMessage;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.oldapi.PositionableItem;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElementPageSurface
extends GuiElement
implements GuiElementTextField.IGuiOnTextChange {
    private IGuiMessageHandler handler;
    private IGuiPositionedPagesProvider pagesProvider;
    private float pageWidth;
    private float pageHeight;
    private PositionableItem hoverpage;
    private List<String> hovertext = new ArrayList<String>();
    private float currentScroll;
    private float maxScroll;
    private boolean wasClicking;
    private boolean isScrolling;
    private boolean mouseOver;
    private boolean mousedown;
    private String searchtext;

    public GuiElementPageSurface(IGuiPositionedPagesProvider pagesProvider, IGuiMessageHandler handler, Minecraft mc, int left, int top, int width, int height) {
        super(left, top, width, height);
        this.mc = mc;
        this.handler = handler;
        this.pagesProvider = pagesProvider;
        this.pageWidth = InventoryNotebook.pagewidth;
        this.pageHeight = InventoryNotebook.pageheight;
        this.mousedown = false;
    }

    @Override
    public void handleMouseInput() {
        if (!this.mouseOver) {
            return;
        }
        int input = Mouse.getEventDWheel();
        if (input != 0) {
            if (input > 0) {
                input = 1;
            }
            if (input < 0) {
                input = -1;
            }
            this.currentScroll -= (float)(input * 20);
            if (this.currentScroll > this.maxScroll) {
                this.currentScroll = this.maxScroll;
            }
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (GuiUtils.contains(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize, this.ySize)) {
            this.mousedown = true;
            if (this.mc.field_71439_g.field_71071_by.func_70445_o() != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                NBTTagCompound data = new NBTTagCompound();
                data.func_74776_a("X", (float)(mouseX - this.guiLeft) - this.pageWidth / 2.0f);
                data.func_74776_a("Y", (float)(mouseY - this.guiTop) - this.pageHeight / 2.0f + this.currentScroll);
                nbttagcompound.func_74782_a("PlaceHeldAt", (NBTBase)data);
                nbttagcompound.func_74757_a("Single", button == 1);
                MystcraftPacketHandler.bus.sendToServer(MPacketGuiMessage.createPacket(this.mc.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
                this.handler.processMessage((EntityPlayer)this.mc.field_71439_g, nbttagcompound);
                return true;
            }
            if (button == 2) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("SortNotebook", (byte)0);
                MystcraftPacketHandler.bus.sendToServer(MPacketGuiMessage.createPacket(this.mc.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
                this.handler.processMessage((EntityPlayer)this.mc.field_71439_g, nbttagcompound);
                return true;
            }
            if (this.hoverpage != null && button == 0) {
                int index = this.hoverpage.slotId;
                if (index == -1) {
                    return true;
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("TakeFromSurface", index);
                MystcraftPacketHandler.bus.sendToServer(MPacketGuiMessage.createPacket(this.mc.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
                this.handler.processMessage((EntityPlayer)this.mc.field_71439_g, nbttagcompound);
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseUp(int i, int j, int k) {
        String symbol2;
        if (GuiUtils.contains(i, j, this.guiLeft, this.guiTop, this.xSize - 20, this.ySize) && this.hoverpage != null && k == 1 && this.mousedown && (symbol2 = Page.getSymbol(this.hoverpage.itemstack)) != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("WriteSymbol", symbol2);
            MystcraftPacketHandler.bus.sendToServer(MPacketGuiMessage.createPacket(this.mc.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
            this.handler.processMessage((EntityPlayer)this.mc.field_71439_g, nbttagcompound);
        }
    }

    @Override
    public List<String> getTooltipInfo() {
        if (this.hovertext != null && this.hovertext.size() > 0) {
            return this.hovertext;
        }
        return super.getTooltipInfo();
    }

    @Override
    public void render(float f, int mouseX, int mouseY) {
        this.mouseOver = GuiUtils.contains(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize, this.ySize);
        boolean mouseOverPageArea = GuiUtils.contains(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize - 20, this.ySize);
        boolean isClicking = Mouse.isButtonDown((int)0);
        int sliderleft = this.guiLeft + this.xSize - 16;
        int slidertop = this.guiTop + 4;
        int sliderbottom = this.guiTop + this.ySize - 19;
        int sliderright = sliderleft + 14;
        float sliderpos = this.currentScroll / this.maxScroll;
        if (this.maxScroll == 0.0f) {
            this.currentScroll = 0.0f;
        }
        if (sliderpos > 1.0f) {
            sliderpos = 1.0f;
        }
        if (this.currentScroll == 0.0f) {
            sliderpos = 0.0f;
        }
        if (!this.wasClicking && isClicking && mouseX >= sliderleft && mouseY >= slidertop && mouseX < sliderright && mouseY < sliderbottom + 15) {
            this.isScrolling = true;
        }
        if (!isClicking) {
            this.isScrolling = false;
        }
        this.wasClicking = isClicking;
        if (this.isScrolling) {
            sliderpos = ((float)(mouseY - slidertop) - 7.5f) / (float)(sliderbottom - slidertop);
            if (sliderpos < 0.0f) {
                sliderpos = 0.0f;
            }
            if (sliderpos > 1.0f) {
                sliderpos = 1.0f;
            }
            this.currentScroll = (int)(sliderpos * this.maxScroll);
        }
        this.hovertext.clear();
        this.hoverpage = null;
        int color = -1442840576;
        GuiElementPageSurface.func_73734_a((int)this.guiLeft, (int)this.guiTop, (int)(this.guiLeft + this.xSize - 20), (int)(this.guiTop + this.ySize), (int)color);
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft + this.xSize - 21, this.guiTop, this.xSize, 0, 21, this.ySize);
        this.func_73729_b(sliderleft, slidertop + (int)((float)(sliderbottom - slidertop) * sliderpos), this.xSize + 21, 0, 12, 15);
        this.func_73733_a(this.guiLeft, this.guiTop, this.guiLeft + this.xSize - 20, this.guiTop + this.ySize, 0, 0);
        GL11.glDepthFunc((int)516);
        this.field_73735_i = 20.0f;
        GL11.glPushMatrix();
        this.maxScroll = 0.0f;
        List<PositionableItem> pages = this.getPages();
        if (pages != null) {
            float x = this.guiLeft;
            float y = (float)this.guiTop - this.currentScroll;
            float pagexSize = this.pageWidth;
            float pageySize = this.pageHeight;
            for (PositionableItem positionable : pages) {
                IAgeSymbol symbol2;
                ItemStack page = positionable.itemstack;
                float pageX = positionable.x;
                float pageY = positionable.y;
                if (pageY + this.pageHeight - (float)(this.ySize / 2) > this.maxScroll) {
                    this.maxScroll = pageY + this.pageHeight - (float)(this.ySize / 2);
                }
                if (y + pageY < (float)this.guiTop - this.pageHeight || y + pageY > (float)(this.guiTop + this.ySize)) continue;
                String displayname = null;
                if (Page.getSymbol(page) != null && (symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page))) != null) {
                    displayname = symbol2.displayName();
                }
                if (displayname != null && this.searchtext != null && this.searchtext.length() > 0 && !displayname.toLowerCase().contains(this.searchtext.toLowerCase())) {
                    page = null;
                }
                GuiUtils.drawPage(this.mc.field_71446_o, this.field_73735_i, page, pagexSize, pageySize, x + pageX, y + pageY, false);
                if (!mouseOverPageArea || !GuiUtils.contains(mouseX, mouseY, (int)(x + pageX), (int)(y + pageY), (int)pagexSize, (int)pageySize)) continue;
                this.hoverpage = positionable;
                Page.getTooltip(page, this.hovertext);
                if (displayname != null) {
                    this.hovertext.add(displayname);
                    continue;
                }
                if (Page.getSymbol(page) == null || (symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page))) == null) continue;
                this.hovertext.add(symbol2.displayName());
            }
        }
        GL11.glPopMatrix();
        GL11.glDepthFunc((int)515);
        this.field_73735_i = 30.0f;
    }

    private List<PositionableItem> getPages() {
        if (this.pagesProvider == null) {
            return null;
        }
        return this.pagesProvider.getPositionedPages();
    }

    @Override
    public void onTextChange(GuiElementTextField caller, String text) {
        this.searchtext = text;
    }

    public static interface IGuiPositionedPagesProvider {
        public List<PositionableItem> getPositionedPages();
    }
}

