/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButton;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementLabel;
import java.util.List;

public class GuiElementValueCounter
extends GuiElement
implements GuiElementButton.IGuiOnClickHandler,
GuiElementLabel.IGuiLabelDataProvider {
    private String key;
    private IGuiOnValueChangeHandler handler;
    private IGuiValueProvider valueprovider;
    private int buttonWidth;
    private int buttonYPadding;

    public GuiElementValueCounter(IGuiOnValueChangeHandler handler, IGuiValueProvider valueprovider, String key, int guiLeft, int guiTop, int xSize, int ySize) {
        super(guiLeft, guiTop, xSize, ySize);
        this.key = key;
        this.handler = handler;
        this.valueprovider = valueprovider;
        this.buttonWidth = this.xSize / 6;
        if (this.buttonWidth > this.ySize) {
            this.buttonWidth = this.ySize;
        }
        this.buttonYPadding = 0;
        if (this.buttonWidth < ySize) {
            this.buttonYPadding = (ySize - this.buttonWidth) / 2;
        }
        this.elements.add(this.createButton(this, "--", this.guiLeft, this.guiTop + this.buttonYPadding, this.buttonWidth));
        this.elements.add(this.createButton(this, "-", this.guiLeft + this.buttonWidth, this.guiTop + this.buttonYPadding, this.buttonWidth));
        this.elements.add(this.createButton(this, "+", this.guiLeft + this.xSize - this.buttonWidth - this.buttonWidth, this.guiTop + this.buttonYPadding, this.buttonWidth));
        this.elements.add(this.createButton(this, "++", this.guiLeft + this.xSize - this.buttonWidth, this.guiTop + this.buttonYPadding, this.buttonWidth));
        this.elements.add(new GuiElementLabel(this, this.guiLeft + this.buttonWidth * 2, this.guiTop + this.buttonYPadding, this.xSize - this.buttonWidth * 4, ySize - this.buttonYPadding * 2, 0x7F000000, -16777216));
    }

    private GuiElement createButton(GuiElementButton.IGuiOnClickHandler eventhandler, String id, int guiLeft, int guiTop, int width) {
        GuiElementButton button = new GuiElementButton(eventhandler, id, guiLeft, guiTop, width, width);
        button.setText(id);
        return button;
    }

    public void updateValue(int newvalue) {
        this.handler.setCounterValue(this.key, newvalue);
    }

    @Override
    public void onClick(GuiElementButton caller) {
        String id = caller.getId();
        if (id.equals("+")) {
            this.updateValue(this.getValue() + 1);
        }
        if (id.equals("++")) {
            this.updateValue(this.getValue() + 10);
        }
        if (id.equals("-")) {
            this.updateValue(this.getValue() - 1);
        }
        if (id.equals("--")) {
            this.updateValue(this.getValue() - 10);
        }
    }

    private int getValue() {
        return this.valueprovider.getCounterValue(this.key);
    }

    @Override
    public String getText() {
        return String.valueOf(this.getValue());
    }

    @Override
    public List<String> getTooltip() {
        return null;
    }

    public static interface IGuiValueProvider {
        public int getCounterValue(String var1);
    }

    public static interface IGuiOnValueChangeHandler {
        public void setCounterValue(String var1, int var2);
    }
}

