/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.linkeffects;

import com.xcompwiz.mystcraft.api.client.ILinkPanelEffect;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LinkRendererDisarm
implements ILinkPanelEffect {
    private Random rand = new Random();
    private long lasttime;
    private Point effect;

    @Override
    public void onOpen() {
        this.lasttime = System.currentTimeMillis();
    }

    @Override
    public void render(int i, int j, int k, int l, ILinkInfo linkInfo) {
        if (linkInfo.getFlag("Disarm")) {
            long now = System.currentTimeMillis();
            long delta = now - this.lasttime;
            if (delta > 3000L && this.rand.nextInt(3000) == 0 || delta > 8000L) {
                this.generateLightningEffect(i, j, k, l);
                this.lasttime = now;
                delta = 0L;
            }
            if (this.effect != null) {
                this.effect.drawLightning();
                if (delta > 300L) {
                    this.effect = null;
                }
            }
        }
    }

    private void generateLightningEffect(int left, int top, int sizex, int sizey) {
        this.effect = this.generateCenterPoint(left, top, sizex, sizey);
        int offset = this.rand.nextInt(4);
        for (int i = 0; i < this.rand.nextInt(6) + 3; ++i) {
            this.effect.addChild(this.generateEndPoint((i + offset) % 4, left, top, sizex, sizey));
        }
    }

    private Point generateCenterPoint(int left, int top, int sizex, int sizey) {
        return new Point(this.rand.nextInt(sizex / 2) + left + sizex / 4, this.rand.nextInt(sizey / 2) + top + sizey / 4);
    }

    private Point generateEndPoint(int side, int left, int top, int sizex, int sizey) {
        switch (side) {
            case 0: {
                return new Point(left, this.rand.nextInt(sizey) + top);
            }
            case 1: {
                return new Point(this.rand.nextInt(sizex) + left, top);
            }
            case 2: {
                return new Point(sizex + left, this.rand.nextInt(sizey) + top);
            }
            case 3: {
                return new Point(this.rand.nextInt(sizex) + left, sizey + top);
            }
        }
        return new Point(this.rand.nextInt(sizex) + left, this.rand.nextInt(sizey) + top);
    }

    public class Point {
        private int x;
        private int y;
        private ArrayList<Point> children;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void addChild(Point child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        public void drawLightning() {
            double x = (double)this.x + LinkRendererDisarm.this.rand.nextGaussian() * 2.0;
            double y = (double)this.y + LinkRendererDisarm.this.rand.nextGaussian() * 2.0;
            for (Point p : this.children) {
                this.drawLine(x, y, (double)p.x + LinkRendererDisarm.this.rand.nextGaussian() * 3.0, (double)p.y + LinkRendererDisarm.this.rand.nextGaussian() * 3.0);
            }
        }

        private double interpolate(double start, double end, float f) {
            return start + (end - start) * (double)f;
        }

        private void drawLine(double par1, double par2, double par3, double par4) {
            double factor;
            int i;
            int color = -52429;
            int points = LinkRendererDisarm.this.rand.nextInt(50);
            float var10 = (float)(color >> 24 & 0xFF) / 255.0f;
            float var6 = (float)(color >> 16 & 0xFF) / 255.0f;
            float var7 = (float)(color >> 8 & 0xFF) / 255.0f;
            float var8 = (float)(color & 0xFF) / 255.0f;
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            Tessellator var9 = Tessellator.field_78398_a;
            long seed = LinkRendererDisarm.this.rand.nextLong();
            Random lrand = new Random();
            lrand.setSeed(seed);
            GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var10);
            GL11.glLineWidth((float)8.0f);
            var9.func_78371_b(3);
            var9.func_78377_a(par1, par2, 0.0);
            for (i = 1; i < points; ++i) {
                factor = 2 * (1 - i / points);
                var9.func_78377_a(this.interpolate(par1, par3, (float)i / (float)points) + lrand.nextGaussian() * factor, this.interpolate(par2, par4, (float)i / (float)points) + lrand.nextGaussian() * factor, 0.0);
            }
            var9.func_78377_a(par3, par4, 0.0);
            var9.func_78381_a();
            lrand.setSeed(seed);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glLineWidth((float)2.0f);
            var9.func_78371_b(3);
            var9.func_78377_a(par1, par2, 0.0);
            for (i = 1; i < points; ++i) {
                factor = 2 * (1 - i / points);
                var9.func_78377_a(this.interpolate(par1, par3, (float)i / (float)points) + lrand.nextGaussian() * factor, this.interpolate(par2, par4, (float)i / (float)points) + lrand.nextGaussian() * factor, 0.0);
            }
            var9.func_78377_a(par3, par4, 0.0);
            var9.func_78381_a();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
    }
}

