/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.command;

import com.xcompwiz.mystcraft.command.CommandBaseAdv;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class CommandRegenerateChunk
extends CommandBaseAdv {
    public String func_71517_b() {
        return "myst-regenchunk";
    }

    public int func_82362_a() {
        return 4;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.myst.chunkregen.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int x;
        WorldServer worldObj;
        int range = 3;
        Integer dimension = null;
        Integer chunkX = null;
        Integer chunkZ = null;
        if (args.length > 0) {
            range = CommandRegenerateChunk.func_71526_a((ICommandSender)sender, (String)args[0]);
        }
        if (args.length > 1) {
            dimension = CommandRegenerateChunk.func_71526_a((ICommandSender)sender, (String)args[1]);
        }
        if (args.length > 2) {
            chunkX = CommandRegenerateChunk.func_71526_a((ICommandSender)sender, (String)args[2]);
        }
        if (args.length > 3) {
            chunkZ = CommandRegenerateChunk.func_71526_a((ICommandSender)sender, (String)args[3]);
        }
        EntityPlayerMP caller = null;
        try {
            caller = CommandRegenerateChunk.func_71521_c((ICommandSender)sender);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dimension == null) {
            if (caller == null) {
                throw new PlayerNotFoundException("To use this from the commandline you must provide a dimension!", new Object[0]);
            }
            dimension = caller.field_71093_bK;
        }
        if (chunkX == null || chunkZ == null) {
            if (caller == null) {
                throw new PlayerNotFoundException("To use this from the commandline you must provide x and z coordinates!", new Object[0]);
            }
            chunkX = (int)caller.field_70165_t >> 4;
            chunkZ = (int)caller.field_70161_v >> 4;
        }
        if ((worldObj = DimensionManager.getWorld((int)dimension)) == null) {
            throw new CommandException("The target world is not loaded", new Object[0]);
        }
        ChunkProviderServer chunkprovider = (ChunkProviderServer)worldObj.func_72863_F();
        ArrayList players = new ArrayList();
        players.addAll(worldObj.field_73010_i);
        for (int x2 = chunkX - range; x2 <= chunkX + range; ++x2) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                for (EntityPlayerMP player : players) {
                    if (!worldObj.func_73040_p().func_72694_a(player, x2, z)) continue;
                    player.func_70012_b((double)(chunkX - range - 2 << 4), player.field_70163_u, (double)(chunkZ - range - 2 << 4), 0.0f, 0.0f);
                    worldObj.func_72866_a((Entity)player, false);
                }
                chunkprovider.func_73241_b(x2, z);
            }
        }
        int lastloaded = 0;
        while (chunkprovider.func_73152_e() != lastloaded) {
            lastloaded = chunkprovider.func_73152_e();
            chunkprovider.func_73156_b();
        }
        System.out.println(chunkprovider.func_73148_d());
        IChunkLoader chunkloader = chunkprovider.field_73247_e;
        chunkprovider.field_73247_e = null;
        for (x = chunkX - range; x <= chunkX + range; ++x) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                chunkprovider.func_73158_c(x, z);
            }
        }
        chunkprovider.field_73247_e = chunkloader;
        this.sendToAdmins(sender, String.format("%s regenerated chunks (%d, %d)+-%d in Dimension %d", sender.func_70005_c_(), chunkX, chunkZ, range, caller.field_71093_bK), new Object[0]);
        for (x = chunkX - range; x <= chunkX + range; ++x) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                Chunk chunk = worldObj.func_72964_e(x, z);
                S21PacketChunkData pkt = new S21PacketChunkData(chunk, true, -1);
                this.sendToAllPlayersWatchingChunk(worldObj, chunk.func_76632_l(), (Packet)pkt);
            }
        }
    }

    public void sendToAllPlayersWatchingChunk(WorldServer worldObj, ChunkCoordIntPair chunkLocation, Packet pkt) {
        List players = worldObj.field_73010_i;
        for (EntityPlayer entityplayer : players) {
            if (!(entityplayer instanceof EntityPlayerMP)) continue;
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityplayer;
            if (entityplayermp.field_71129_f.contains(chunkLocation)) continue;
            entityplayermp.field_71135_a.func_147359_a(pkt);
        }
    }
}

