/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.word.WordData;
import com.xcompwiz.mystcraft.core.InternalAPI;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.SymbolManager;

public class SymbolPoemData {
    public static void initialize() {
        WordData.init(InternalAPI.getAPIInstance("Mystcraft"));
        for (int i = 0; i < 26; ++i) {
            InternalAPI.symbol.registerWord("" + i, SymbolPoemData.constructNumber(i));
        }
        SymbolPoemData.setSymbolWords("WeatherCloudy", new String[]{"Sustain", "Static", "Believe", "Motion"});
        SymbolPoemData.setSymbolWords("WeatherFast", new String[]{"Sustain", "Dynamic", "Tradition", "Spur"});
        SymbolPoemData.setSymbolWords("WeatherNorm", new String[]{"Sustain", "Dynamic", "Tradition", "Balance"});
        SymbolPoemData.setSymbolWords("WeatherOn", new String[]{"Sustain", "Static", "Tradition", "Stimulate"});
        SymbolPoemData.setSymbolWords("WeatherRain", new String[]{"Sustain", "Static", "Rebirth", "Growth"});
        SymbolPoemData.setSymbolWords("WeatherSlow", new String[]{"Sustain", "Dynamic", "Tradition", "Inhibit"});
        SymbolPoemData.setSymbolWords("WeatherSnow", new String[]{"Sustain", "Static", "Inhibit", "Energy"});
        SymbolPoemData.setSymbolWords("WeatherStorm", new String[]{"Sustain", "Static", "Nature", "Power"});
        SymbolPoemData.setSymbolWords("WeatherOff", new String[]{"Sustain", "Static", "Stimulate", "Energy"});
        SymbolPoemData.setSymbolWords("TerrainNormal", new String[]{"Terrain", "Form", "Tradition", "Flow"});
        SymbolPoemData.setSymbolWords("TerrainAmplified", new String[]{"Terrain", "Form", "Tradition", "Spur"});
        SymbolPoemData.setSymbolWords("TerrainEnd", new String[]{"Terrain", "Form", "Ethereal", "Flow"});
        SymbolPoemData.setSymbolWords("TerrainNether", new String[]{"Terrain", "Form", "Constraint", "Entropy"});
        SymbolPoemData.setSymbolWords("Flat", new String[]{"Terrain", "Form", "Inhibit", "Motion"});
        SymbolPoemData.setSymbolWords("Void", new String[]{"Terrain", "Form", "Infinite", "Void"});
        SymbolPoemData.setSymbolWords("BioConHuge", new String[]{"Constraint", "Nature", "Weave", "Huge"});
        SymbolPoemData.setSymbolWords("BioConLarge", new String[]{"Constraint", "Nature", "Weave", "Large"});
        SymbolPoemData.setSymbolWords("BioConMedium", new String[]{"Constraint", "Nature", "Weave", "Medium"});
        SymbolPoemData.setSymbolWords("BioConSmall", new String[]{"Constraint", "Nature", "Weave", "Small"});
        SymbolPoemData.setSymbolWords("BioConTiny", new String[]{"Constraint", "Nature", "Weave", "Tiny"});
        SymbolPoemData.setSymbolWords("BioConSingle", new String[]{"Constraint", "Nature", "Infinite", "Static"});
        SymbolPoemData.setSymbolWords("BioConNative", new String[]{"Constraint", "Nature", "Tradition", "Sustain"});
        SymbolPoemData.setSymbolWords("BioConTiled", new String[]{"Constraint", "Nature", "Chain", "Contradict"});
        SymbolPoemData.setSymbolWords("BioConGrid", new String[]{"Constraint", "Nature", "Chain", "Mutual"});
        SymbolPoemData.setSymbolWords("ColorCloud", new String[]{"Image", "Entropy", "Believe", "Weave"});
        SymbolPoemData.setSymbolWords("ColorFog", new String[]{"Image", "Entropy", "Explore", "Weave"});
        SymbolPoemData.setSymbolWords("ColorSky", new String[]{"Image", "Celestial", "Harmony", "Weave"});
        SymbolPoemData.setSymbolWords("ColorSkyNight", new String[]{"Image", "Celestial", "Contradict", "Weave"});
        SymbolPoemData.setSymbolWords("ColorFoliage", new String[]{"Image", "Growth", "Elevate", "Weave"});
        SymbolPoemData.setSymbolWords("ColorGrass", new String[]{"Image", "Growth", "Resilience", "Weave"});
        SymbolPoemData.setSymbolWords("ColorWater", new String[]{"Image", "Flow", "Constraint", "Weave"});
        SymbolPoemData.setSymbolWords("ColorCloudNat", new String[]{"Image", "Entropy", "Believe", "Nature"});
        SymbolPoemData.setSymbolWords("ColorFogNat", new String[]{"Image", "Entropy", "Explore", "Nature"});
        SymbolPoemData.setSymbolWords("ColorSkyNat", new String[]{"Image", "Celestial", "Harmony", "Nature"});
        SymbolPoemData.setSymbolWords("ColorFoliageNat", new String[]{"Image", "Growth", "Elevate", "Nature"});
        SymbolPoemData.setSymbolWords("ColorGrassNat", new String[]{"Image", "Growth", "Resilience", "Nature"});
        SymbolPoemData.setSymbolWords("ColorWaterNat", new String[]{"Image", "Flow", "Constraint", "Nature"});
        SymbolPoemData.setSymbolWords("EnvAccel", new String[]{"Survival", "Dynamic", "Change", "Spur"});
        SymbolPoemData.setSymbolWords("EnvExplosions", new String[]{"Survival", "Sacrifice", "Power", "Force"});
        SymbolPoemData.setSymbolWords("EnvLightning", new String[]{"Survival", "Sacrifice", "Power", "Energy"});
        SymbolPoemData.setSymbolWords("EnvMeteor", new String[]{"Survival", "Sacrifice", "Power", "Momentum"});
        SymbolPoemData.setSymbolWords("EnvScorch", new String[]{"Survival", "Sacrifice", "Power", "Chaos"});
        SymbolPoemData.setSymbolWords("ModClear", new String[]{"Contradict", "Transform", "Change", "Void"});
        SymbolPoemData.setSymbolWords("PvPOff", new String[]{"Chain", "Chaos", "Encourage", "Harmony"});
        SymbolPoemData.setSymbolWords("ModZero", new String[]{"Transform", "Time", "System", "Inhibit"});
        SymbolPoemData.setSymbolWords("ModHalf", new String[]{"Transform", "Time", "System", "Stimulate"});
        SymbolPoemData.setSymbolWords("ModDouble", new String[]{"Transform", "Time", "System", "Sacrifice"});
        SymbolPoemData.setSymbolWords("ModFull", new String[]{"Transform", "Time", "System", "Balance"});
        SymbolPoemData.setSymbolWords("ModNorth", new String[]{"Transform", "Flow", "Motion", "Control"});
        SymbolPoemData.setSymbolWords("ModSouth", new String[]{"Transform", "Flow", "Motion", "Chaos"});
        SymbolPoemData.setSymbolWords("ModEast", new String[]{"Transform", "Flow", "Motion", "Tradition"});
        SymbolPoemData.setSymbolWords("ModWest", new String[]{"Transform", "Flow", "Motion", "Change"});
        SymbolPoemData.setSymbolWords("ModEnd", new String[]{"Transform", "Cycle", "System", "Rebirth"});
        SymbolPoemData.setSymbolWords("ModRising", new String[]{"Transform", "Cycle", "System", "Growth"});
        SymbolPoemData.setSymbolWords("ModNoon", new String[]{"Transform", "Cycle", "System", "Harmony"});
        SymbolPoemData.setSymbolWords("ModSetting", new String[]{"Transform", "Cycle", "System", "Future"});
        SymbolPoemData.setSymbolWords("ModGradient", new String[]{"Transform", "Image", "Merge", "Weave"});
        SymbolPoemData.setSymbolWords("ColorHorizon", new String[]{"Transform", "Image", "Celestial", "Change"});
        SymbolPoemData.setSymbolWords("NoSea", new String[]{"Transform", "Constraint", "Flow", "Inhibit"});
        SymbolPoemData.setSymbolWords("LightingNormal", new String[]{"Ethereal", "Dynamic", "Cycle", "Balance"});
        SymbolPoemData.setSymbolWords("LightingBright", new String[]{"Ethereal", "Power", "Infinite", "Spur"});
        SymbolPoemData.setSymbolWords("LightingDark", new String[]{"Ethereal", "Void", "Constraint", "Inhibit"});
        SymbolPoemData.setSymbolWords("GenSpikes", new String[]{"Nature", "Encourage", "Entropy", "Static"});
        SymbolPoemData.setSymbolWords("CryForm", new String[]{"Nature", "Encourage", "Growth", "Static"});
        SymbolPoemData.setSymbolWords("HugeTrees", new String[]{"Nature", "Stimulate", "Spur", "Elevate"});
        SymbolPoemData.setSymbolWords("LakesSurface", new String[]{"Nature", "Flow", "Static", "Elevate"});
        SymbolPoemData.setSymbolWords("LakesDeep", new String[]{"Nature", "Flow", "Static", "Explore"});
        SymbolPoemData.setSymbolWords("StarFissure", new String[]{"Nature", "Harmony", "Mutual", "Void"});
        SymbolPoemData.setSymbolWords("DenseOres", new String[]{"Survival", "Stimulate", "Machine", "Chaos"});
        SymbolPoemData.setSymbolWords("SunNormal", new String[]{"Celestial", "Image", "Stimulate", "Energy"});
        SymbolPoemData.setSymbolWords("SunDark", new String[]{"Celestial", "Void", "Inhibit", "Energy"});
        SymbolPoemData.setSymbolWords("MoonNormal", new String[]{"Celestial", "Image", "Cycle", "Wisdom"});
        SymbolPoemData.setSymbolWords("MoonDark", new String[]{"Celestial", "Void", "Inhibit", "Wisdom"});
        SymbolPoemData.setSymbolWords("StarsNormal", new String[]{"Celestial", "Harmony", "Ethereal", "Order"});
        SymbolPoemData.setSymbolWords("StarsTwinkle", new String[]{"Celestial", "Harmony", "Ethereal", "Entropy"});
        SymbolPoemData.setSymbolWords("StarsDark", new String[]{"Celestial", "Void", "Inhibit", "Order"});
        SymbolPoemData.setSymbolWords("StarsEndSky", new String[]{"Celestial", "Image", "Chaos", "Weave"});
        SymbolPoemData.setSymbolWords("Rainbow", new String[]{"Celestial", "Image", "Harmony", "Balance"});
        SymbolPoemData.setSymbolWords("NoHorizon", new String[]{"Celestial", "Inhibit", "Image", "Void"});
        SymbolPoemData.setSymbolWords("Obelisks", new String[]{"Civilization", "Resilience", "Static", "Form"});
        SymbolPoemData.setSymbolWords("Dungeons", new String[]{"Civilization", "Constraint", "Chain", "Resurrect"});
        SymbolPoemData.setSymbolWords("Strongholds", new String[]{"Civilization", "Wisdom", "Future", "Honor"});
        SymbolPoemData.setSymbolWords("Villages", new String[]{"Civilization", "Society", "Harmony", "Nurture"});
        SymbolPoemData.setSymbolWords("NetherFort", new String[]{"Civilization", "Machine", "Power", "Entropy"});
        SymbolPoemData.setSymbolWords("Mineshafts", new String[]{"Civilization", "Machine", "Motion", "Tradition"});
        SymbolPoemData.setSymbolWords("Tendrils", new String[]{"Terrain", "Transform", "Growth", "Flow"});
        SymbolPoemData.setSymbolWords("TerModSpheres", new String[]{"Terrain", "Transform", "Form", "Cycle"});
        SymbolPoemData.setSymbolWords("Ravines", new String[]{"Terrain", "Transform", "Void", "Weave"});
        SymbolPoemData.setSymbolWords("Skylands", new String[]{"Terrain", "Transform", "Void", "Elevate"});
        SymbolPoemData.setSymbolWords("Caves", new String[]{"Terrain", "Transform", "Void", "Flow"});
        SymbolPoemData.setSymbolWords("FloatIslands", new String[]{"Terrain", "Transform", "Form", "Celestial"});
    }

    private static boolean setSymbolWords(String symbolId, String[] words) {
        IAgeSymbol isymbol = SymbolManager.getAgeSymbol(symbolId);
        if (isymbol == null) {
            LoggerUtils.info("Failed to set poem for symbol " + symbolId, new Object[0]);
            return false;
        }
        if (isymbol instanceof SymbolBase) {
            SymbolBase symbol2 = (SymbolBase)isymbol;
            symbol2.setWords(words);
            return true;
        }
        return false;
    }

    private static Integer[] constructNumber(int num) {
        int first = 0;
        if (num == 0) {
            return new Integer[]{1};
        }
        if (num >= 25) {
            return new Integer[]{2};
        }
        if (num >= 20) {
            first = 63;
        } else if (num >= 15) {
            first = 62;
        } else if (num >= 10) {
            first = 61;
        } else if (num >= 5) {
            first = 60;
        }
        int second = 0;
        if (num % 5 > 0) {
            second = num % 5 + 55;
        }
        if (first > 0) {
            if (second > 0) {
                return new Integer[]{first, second};
            }
            return new Integer[]{first};
        }
        return new Integer[]{second};
    }
}

