/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.grammar;

import com.xcompwiz.mystcraft.api.internal.IGrammarAPI;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.grammar.GrammarTree;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class GrammarAPIDelegate
implements IGrammarAPI {
    @Override
    public void registerGrammarRule(String parent, float rarity, String ... args) {
        ArrayList<String> list = CollectionUtils.buildList(args);
        GrammarGenerator.registerRule(new GrammarGenerator.Rule(parent, list, rarity));
    }

    public Collection<IAgeSymbol> getSymbolsExpandingToken(String token) {
        ArrayList<GrammarGenerator.Rule> rules = new ArrayList<GrammarGenerator.Rule>();
        List<GrammarGenerator.Rule> tokenrules = GrammarGenerator.getAllRules(token);
        if (tokenrules != null) {
            rules.addAll(tokenrules);
        }
        HashSet<IAgeSymbol> symbols = new HashSet<IAgeSymbol>();
        for (GrammarGenerator.Rule rule : rules) {
            for (String rule_token : rule.getValues()) {
                IAgeSymbol symbol2;
                if (!SymbolManager.hasBinding(rule_token) || (symbol2 = SymbolManager.getAgeSymbol(rule_token)) == null) continue;
                symbols.add(symbol2);
            }
        }
        return symbols;
    }

    @Override
    public Collection<String> getTokensProducingToken(String token) {
        HashSet<String> set = new HashSet<String>();
        List<GrammarGenerator.Rule> rules = GrammarGenerator.getParentRules(token);
        for (GrammarGenerator.Rule rule : rules) {
            set.add(rule.getParent());
        }
        return set;
    }

    @Override
    public List<String> generateFromToken(String root, Random rand) {
        GrammarTree tree = new GrammarTree(root);
        return tree.getExpanded(rand);
    }

    @Override
    public List<String> generateFromToken(String root, Random rand, List<String> parsed) {
        GrammarTree tree = new GrammarTree(root);
        tree.parseTerminals(parsed, rand);
        return tree.getExpanded(rand);
    }
}

