/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.xcompwiz.mystcraft.api.MystAPI;
import com.xcompwiz.mystcraft.core.InternalAPI;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.lang.reflect.Method;

public class IMCAPIRegister
implements IMCHandler.IMCProcessor {
    @Override
    public void process(FMLInterModComms.IMCMessage message) {
        if (!message.isStringMessage()) {
            return;
        }
        LoggerUtils.info(String.format("Receiving registration request from [%s] for method %s", message.getSender(), message.getStringValue()), new Object[0]);
        IMCAPIRegister.callbackRegistration(message.getStringValue(), message.getSender());
    }

    public static void callbackRegistration(String method, String modname) {
        String[] splitName = method.split("\\.");
        String methodName = splitName[splitName.length - 1];
        String className = method.substring(0, method.length() - methodName.length() - 1);
        LoggerUtils.info(String.format("Trying to call (reflection) %s %s", className, methodName), new Object[0]);
        try {
            Class<?> reflectClass = Class.forName(className);
            Method reflectMethod = reflectClass.getDeclaredMethod(methodName, MystAPI.class);
            reflectMethod.invoke(null, InternalAPI.getAPIInstance(modname));
            LoggerUtils.info(String.format("Success in registering %s", modname), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LoggerUtils.warn(String.format("Could not find class %s", className), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LoggerUtils.warn(String.format("Could not find method %s", methodName), new Object[0]);
        }
        catch (Exception e) {
            LoggerUtils.warn(String.format("Exception while trying to access the method : %s", e.toString()), new Object[0]);
        }
    }
}

