/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.google.common.collect.ImmutableList;
import com.xcompwiz.mystcraft.imc.IMCAPIRegister;
import com.xcompwiz.mystcraft.imc.IMCBlacklistFluid;
import com.xcompwiz.mystcraft.imc.IMCBlacklistSymbol;
import com.xcompwiz.mystcraft.imc.IMCFluidData;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.HashMap;
import java.util.Map;

public class IMCHandler {
    private static Map<String, IMCProcessor> processors = new HashMap<String, IMCProcessor>();

    public static void process(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            String key = message.key.toLowerCase();
            IMCProcessor process = processors.get(key);
            try {
                process.process(message);
            }
            catch (Exception e) {
                LoggerUtils.error(e.toString(), new Object[0]);
            }
        }
    }

    static {
        processors.put("blacklistfluid", new IMCBlacklistFluid());
        processors.put("blacklist", new IMCBlacklistSymbol());
        processors.put("fluidsymboldata", new IMCFluidData());
        processors.put("register", new IMCAPIRegister());
    }

    public static interface IMCProcessor {
        public void process(FMLInterModComms.IMCMessage var1);
    }
}

