/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.bonus;

import com.xcompwiz.mystcraft.instability.bonus.EventManager;
import com.xcompwiz.mystcraft.instability.bonus.InstabilityBonusManager;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class PlayerTrollPenalty
implements InstabilityBonusManager.IInstabilityBonus,
EventManager.IOnEntityDeath,
EventManager.IOnPlayerChangedDimension,
EventManager.IOnPlayerLoggedIn,
EventManager.IOnPlayerLoggedOut {
    private InstabilityBonusManager bonusmanager;
    private int max;
    private int min;
    private float decayrate;
    private float current;
    private String playername;
    private int dimensionid;
    private boolean playerisinworld;

    public PlayerTrollPenalty(InstabilityBonusManager bonusmanager, World worldObj, String playername, Integer max, Float decayrate) {
        this.bonusmanager = bonusmanager;
        this.current = 0.0f;
        this.playername = playername;
        this.max = max;
        this.min = 0;
        this.decayrate = decayrate.floatValue();
        this.dimensionid = worldObj.field_73011_w.field_76574_g;
        EventManager eventmgr = EventManager.get();
        eventmgr.register(this);
        eventmgr.register(this);
        eventmgr.register(this);
        eventmgr.register(this);
    }

    @Override
    public int getValue() {
        return (int)this.current;
    }

    @Override
    public void tick(World world) {
        this.current = this.playerisinworld ? Math.min((float)this.max, this.current + this.decayrate) : Math.max((float)this.min, this.current - this.decayrate);
    }

    @Override
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.entity.field_71093_bK == this.dimensionid && event.entity.func_70005_c_().equals(this.playername)) {
            this.current = this.min;
            this.announce("instability.bonus.troll.death", this.playername);
        }
    }

    @Override
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_71093_bK == this.dimensionid && event.player.func_70005_c_().equals(this.playername)) {
            this.playerisinworld = true;
            this.announce("instability.bonus.troll.alert", this.playername);
        }
    }

    @Override
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_71093_bK == this.dimensionid && event.player.func_70005_c_().equals(this.playername)) {
            this.playerisinworld = false;
            this.announce("instability.bonus.troll.left", this.playername);
        }
    }

    @Override
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.fromDim == this.dimensionid && event.player.func_70005_c_().equals(this.playername)) {
            this.playerisinworld = false;
            this.announce("instability.bonus.troll.left", this.playername);
        }
        if (event.toDim == this.dimensionid && event.player.func_70005_c_().equals(this.playername)) {
            this.playerisinworld = true;
            this.announce("instability.bonus.troll.alert", this.playername);
        }
    }

    private void announce(String string, Object ... args) {
        if (!this.bonusmanager.isInstabilityEnabled()) {
            return;
        }
        ChatComponentTranslation chatcomponent = new ChatComponentTranslation(string, args);
        NetworkUtils.sendMessageToPlayersInWorld((IChatComponent)chatcomponent, this.dimensionid);
    }
}

