/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.decay;

import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.instability.decay.DecayHandler;
import com.xcompwiz.mystcraft.world.WorldInfoHelper;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DecayHandlerBlack
extends DecayHandler {
    @Override
    public String getIdentifier() {
        return "black";
    }

    @Override
    public void pulse(World world, int x, int y, int z, Random random) {
        if (world.field_73012_v.nextInt(10) == 0) {
            this.decay(world, x, y, z);
        } else if (world.field_73012_v.nextInt(5) == 0) {
            this.corrupt(world, x - 1, y, z);
            this.corrupt(world, x + 1, y, z);
            this.corrupt(world, x, y, z - 1);
            this.corrupt(world, x, y, z + 1);
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.field_72995_K && world.func_147439_a(i, j, k) == ModBlocks.decay) {
            if (!WorldInfoHelper.isMystcraftAge(world)) {
                world.func_147449_b(i, j, k, Blocks.field_150350_a);
                return;
            }
            if (!WorldInfoHelper.isInstabilityEnabled(world)) {
                return;
            }
            if (world.func_147439_a(i, j - 1, k) == ModBlocks.decay && world.func_72805_g(i, j - 1, k) == this.getMetadata()) {
                world.func_147449_b(i, j - 1, k, Blocks.field_150350_a);
                EntityFallingBlock.drop(world, i, j, k);
                return;
            }
            if (world.func_147439_a(i, j + 1, k) == ModBlocks.decay && world.func_72805_g(i, j - 1, k) == this.getMetadata()) {
                world.func_147449_b(i, j, k, Blocks.field_150350_a);
                EntityFallingBlock.drop(world, i, j + 1, k);
                return;
            }
        }
    }

    private void decay(World world, int i, int j, int k) {
        this.corrupt(world, i - 1, j, k);
        this.corrupt(world, i + 1, j, k);
        this.corrupt(world, i, j, k - 1);
        this.corrupt(world, i, j, k + 1);
        world.func_147449_b(i, j - 1, k, Blocks.field_150350_a);
        EntityFallingBlock.drop(world, i, j, k);
    }

    private void corrupt(World world, int i, int j, int k) {
        if (world.func_147439_a(i, j, k).func_149688_o().func_76224_d()) {
            world.func_147449_b(i, j, k, Blocks.field_150350_a);
        }
        if (!world.func_147437_c(i, j, k)) {
            world.func_147465_d(i, j, k, ModBlocks.decay, this.getMetadata(), 3);
            this.addInstability(world, 1);
        }
    }
}

