/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.core.InternalAPI;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.oldapi.PositionableItem;
import com.xcompwiz.mystcraft.page.IItemPageProvider;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryNotebook
implements IInventory {
    private IInventory sourceinventory;
    private int slot;
    public static float pagewidth = 30.0f;
    public static float pageheight = pagewidth * 4.0f / 3.0f;

    public InventoryNotebook(IInventory source, int slot) {
        this.sourceinventory = source;
        this.slot = slot;
    }

    public ItemStack getNotebookItem() {
        return this.sourceinventory.func_70301_a(this.slot);
    }

    public String getNotebookName() {
        return InventoryNotebook.getName(this.getNotebookItem());
    }

    public int func_70302_i_() {
        return InventoryNotebook.getLargestSlotId(this.getNotebookItem()) + 1;
    }

    public ItemStack func_70301_a(int var1) {
        return InventoryNotebook.getItem(this.getNotebookItem(), var1);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stored = InventoryNotebook.getItem(this.getNotebookItem(), slot);
        ItemStack returned = stored.func_77946_l();
        if (returned.field_77994_a < amount) {
            amount = returned.field_77994_a;
        }
        returned.field_77994_a = amount;
        stored.field_77994_a -= amount;
        InventoryNotebook.setItem(this.getNotebookItem(), slot, stored);
        return returned;
    }

    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        InventoryNotebook.setItem(this.getNotebookItem(), i, itemstack);
    }

    public String func_145825_b() {
        String name = this.getNotebookName();
        if (name == null || name.equals("")) {
            return "Notebook";
        }
        return name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.getNotebookItem() != null && this.getNotebookItem().field_77994_a > 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public static boolean isItemValid(ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        if (itemstack.func_77973_b() == ModItems.page) {
            return true;
        }
        return itemstack.func_77973_b() == Items.field_151121_aF;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return InventoryNotebook.isItemValid(itemstack);
    }

    private static void initNotebook(ItemStack notebook) {
        if (notebook.field_77990_d == null) {
            notebook.field_77990_d = new NBTTagCompound();
        }
        if (!notebook.field_77990_d.func_74764_b("Pages")) {
            notebook.field_77990_d.func_74782_a("Pages", (NBTBase)new NBTTagCompound());
        }
        if (!notebook.field_77990_d.func_74764_b("BoundData")) {
            notebook.field_77990_d.func_74782_a("BoundData", (NBTBase)new NBTTagCompound());
        }
    }

    public static void setName(ItemStack notebook, String bookname) {
        if (notebook == null) {
            return;
        }
        if (notebook.func_77973_b() != ModItems.notebook) {
            return;
        }
        if (notebook.field_77990_d == null) {
            InventoryNotebook.initNotebook(notebook);
        }
        if (bookname == null || bookname.equals("")) {
            notebook.field_77990_d.func_82580_o("Name");
        } else {
            notebook.field_77990_d.func_74778_a("Name", bookname);
        }
    }

    public static String getName(ItemStack notebook) {
        if (notebook == null) {
            return null;
        }
        if (notebook.func_77973_b() != ModItems.notebook) {
            return null;
        }
        if (notebook.field_77990_d == null) {
            InventoryNotebook.initNotebook(notebook);
        }
        if (!notebook.field_77990_d.func_74764_b("Name")) {
            return null;
        }
        return notebook.field_77990_d.func_74779_i("Name");
    }

    private static NBTTagCompound getInventoryCompound(ItemStack notebook) {
        if (notebook == null) {
            return null;
        }
        if (notebook.func_77973_b() != ModItems.notebook) {
            return null;
        }
        if (notebook.field_77990_d == null) {
            InventoryNotebook.initNotebook(notebook);
        }
        if (!notebook.field_77990_d.func_74764_b("Pages")) {
            notebook.field_77990_d.func_74782_a("Pages", (NBTBase)new NBTTagCompound());
        }
        return notebook.field_77990_d.func_74775_l("Pages");
    }

    private static NBTTagCompound getExtraDataCompound(ItemStack notebook) {
        if (notebook == null) {
            return null;
        }
        if (notebook.func_77973_b() != ModItems.notebook) {
            return null;
        }
        if (notebook.field_77990_d == null) {
            InventoryNotebook.initNotebook(notebook);
        }
        if (!notebook.field_77990_d.func_74764_b("BoundData")) {
            notebook.field_77990_d.func_74782_a("BoundData", (NBTBase)new NBTTagCompound());
        }
        return notebook.field_77990_d.func_74775_l("BoundData");
    }

    public static int getItemCount(ItemStack notebook) {
        if (InventoryNotebook.getInventoryCompound(notebook) == null) {
            return 0;
        }
        return InventoryNotebook.getInventoryCompound(notebook).func_150296_c().size();
    }

    public static int getLargestSlotId(ItemStack notebook) {
        int largest = 0;
        NBTTagCompound compound = InventoryNotebook.getInventoryCompound(notebook);
        if (compound == null) {
            return 0;
        }
        Set tagnames = compound.func_150296_c();
        for (String tagname : tagnames) {
            int slot = Integer.parseInt(tagname);
            if (largest >= slot) continue;
            largest = slot;
        }
        return largest;
    }

    public static ItemStack getItem(ItemStack notebook, int slot) {
        NBTTagCompound data = InventoryNotebook.getInventoryCompound(notebook);
        if (data != null && data.func_74764_b("" + slot)) {
            return ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("" + slot));
        }
        return null;
    }

    public static ItemStack setItem(ItemStack notebook, int slot, ItemStack page) {
        if (!InventoryNotebook.isItemValid(page)) {
            return page;
        }
        NBTTagCompound data = InventoryNotebook.getInventoryCompound(notebook);
        if (data == null) {
            return page;
        }
        ItemStack previous = null;
        previous = InventoryNotebook.removeItem(notebook, slot);
        if (page != null && page.field_77994_a > 0) {
            data.func_74782_a("" + slot, (NBTBase)page.func_77955_b(new NBTTagCompound()));
        }
        return previous;
    }

    public static ItemStack removeItem(ItemStack notebook, int slot) {
        NBTTagCompound data = InventoryNotebook.getInventoryCompound(notebook);
        ItemStack itemstack = null;
        if (data != null) {
            if (data.func_74764_b("" + slot)) {
                itemstack = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("" + slot));
            }
            data.func_82580_o("" + slot);
        }
        return itemstack;
    }

    public static ItemStack addItem(ItemStack notebook, ItemStack page) {
        if (!InventoryNotebook.isItemValid(page)) {
            return page;
        }
        NBTTagCompound data = InventoryNotebook.getInventoryCompound(notebook);
        NBTTagCompound extra2 = InventoryNotebook.getExtraDataCompound(notebook);
        if (data == null) {
            return page;
        }
        int slot = 0;
        while (page != null) {
            if (!data.func_74764_b("" + slot)) {
                ItemStack clone = page.func_77946_l();
                clone.field_77994_a = 1;
                data.func_74782_a("" + slot, (NBTBase)clone.func_77955_b(new NBTTagCompound()));
                extra2.func_82580_o("" + slot);
                --page.field_77994_a;
                if (page.field_77994_a == 0) {
                    page = null;
                }
            }
            ++slot;
        }
        return null;
    }

    public static ItemStack addItemAt(ItemStack notebook, ItemStack page, float x, float y) {
        if (!InventoryNotebook.isItemValid(page)) {
            return page;
        }
        NBTTagCompound data = InventoryNotebook.getInventoryCompound(notebook);
        NBTTagCompound extra2 = InventoryNotebook.getExtraDataCompound(notebook);
        if (data == null) {
            return page;
        }
        int slot = 0;
        while (page != null) {
            if (!data.func_74764_b("" + slot)) {
                ItemStack clone = page.func_77946_l();
                clone.field_77994_a = 1;
                data.func_74782_a("" + slot, (NBTBase)clone.func_77955_b(new NBTTagCompound()));
                NBTTagCompound position = new NBTTagCompound();
                float f = x;
                x = f + 1.0f;
                position.func_74776_a("X", f);
                float f2 = y;
                y = f2 + 1.0f;
                position.func_74776_a("Y", f2);
                extra2.func_74782_a("" + slot, (NBTBase)position);
                --page.field_77994_a;
                if (page.field_77994_a == 0) {
                    page = null;
                }
            }
            ++slot;
        }
        return null;
    }

    public static List<ItemStack> getItems(ItemStack notebook) {
        ArrayList<ItemStack> pages = new ArrayList<ItemStack>();
        NBTTagCompound compound = InventoryNotebook.getInventoryCompound(notebook);
        if (compound == null) {
            return pages;
        }
        Set tagnames = compound.func_150296_c();
        for (String tagname : tagnames) {
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            int slot = Integer.parseInt(tagname);
            while (pages.size() <= slot) {
                pages.add(null);
            }
            pages.set(slot, ItemStack.func_77949_a((NBTTagCompound)pagedata));
        }
        return pages;
    }

    public static List<PositionableItem> getPositionableItems(ItemStack notebook) {
        ArrayList<PositionableItem> pages = new ArrayList<PositionableItem>();
        NBTTagCompound compound = InventoryNotebook.getInventoryCompound(notebook);
        if (compound == null) {
            return pages;
        }
        NBTTagCompound extra2 = InventoryNotebook.getExtraDataCompound(notebook);
        Set tagnames = compound.func_150296_c();
        for (String tagname : tagnames) {
            NBTTagCompound position;
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            int slot = Integer.parseInt(tagname);
            PositionableItem positionable = new PositionableItem(ItemStack.func_77949_a((NBTTagCompound)pagedata), slot);
            if (!extra2.func_74764_b("" + slot)) {
                position = extra2.func_74775_l("" + slot);
                position.func_74776_a("X", (float)(slot % 5) * (pagewidth + 1.0f));
                position.func_74776_a("Y", (float)(slot / 5) * (pageheight + 1.0f));
                extra2.func_74782_a("" + slot, (NBTBase)position);
            }
            position = extra2.func_74775_l("" + slot);
            positionable.x = position.func_74760_g("X");
            positionable.y = position.func_74760_g("Y");
            pages.add(positionable);
        }
        return pages;
    }

    public static void updatePages(ItemStack notebook) {
        NBTTagCompound compound = InventoryNotebook.getInventoryCompound(notebook);
        if (compound == null) {
            return;
        }
        ArrayList tagnames = new ArrayList();
        tagnames.addAll(compound.func_150296_c());
        for (String tagname : tagnames) {
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            ItemStack page = ItemStack.func_77949_a((NBTTagCompound)pagedata);
            List<ItemStack> results = SymbolRemappings.remap(page);
            int slot = Integer.parseInt(tagname);
            if (results.size() == 0) {
                InventoryNotebook.removeItem(notebook, slot);
                continue;
            }
            if (results.size() == 1) {
                InventoryNotebook.setItem(notebook, slot, results.get(0));
            }
            if (results.size() == 1) continue;
            InventoryNotebook.removeItem(notebook, slot);
            for (ItemStack item : results) {
                InventoryNotebook.addItem(notebook, item);
            }
        }
    }

    public static void sort(ItemStack notebook, IItemPageProvider.SortType type, short width) {
        NBTTagCompound compound = InventoryNotebook.getInventoryCompound(notebook);
        if (compound == null) {
            return;
        }
        NBTTagCompound extra2 = InventoryNotebook.getExtraDataCompound(notebook);
        int count = compound.func_150296_c().size();
        if (count == 0) {
            return;
        }
        float xStep = pagewidth + 1.0f;
        float yStep = pageheight + 1.0f;
        float x = 0.0f;
        float y = 0.0f;
        ArrayList<NBTTagCompound> pagenbts = new ArrayList<NBTTagCompound>();
        Set tagnames = compound.func_150296_c();
        HashMap<NBTTagCompound, String> tagnamemap = new HashMap<NBTTagCompound, String>();
        for (String tagname : tagnames) {
            NBTTagCompound tag = compound.func_74775_l(tagname);
            tagnamemap.put(tag, tagname);
            pagenbts.add(tag);
        }
        Collections.sort(pagenbts, InventoryNotebook.getComparator(type));
        for (NBTTagCompound pagedata : pagenbts) {
            int slot = Integer.parseInt((String)tagnamemap.get(pagedata));
            NBTTagCompound position = extra2.func_74775_l("" + slot);
            position.func_74776_a("X", x);
            position.func_74776_a("Y", y);
            extra2.func_74782_a("" + slot, (NBTBase)position);
            if (!((x += xStep) + xStep > (float)width)) continue;
            x = 0.0f;
            y += yStep;
        }
    }

    private static Comparator<NBTTagCompound> getComparator(IItemPageProvider.SortType type) {
        return SortingUtils.ComparatorTagItemSymbolAlphabetical.instance;
    }

    public static boolean writeSymbol(ItemStack notebook, String symbol2, ItemStack paperstack) {
        List<ItemStack> pages = InventoryNotebook.getItems(notebook);
        for (ItemStack page : pages) {
            if (page == null || page.func_77973_b() != ModItems.page || !InternalAPI.page.isPageWritable(page)) continue;
            InternalAPI.page.setPageSymbol(page, symbol2);
            return true;
        }
        if (paperstack != null) {
            ItemStack page = paperstack.func_77946_l();
            page.field_77994_a = 1;
            if ((page = ItemPage.createItemstack(page)) != null) {
                --paperstack.field_77994_a;
                InternalAPI.page.setPageSymbol(page, symbol2);
                InventoryNotebook.addItem(notebook, page);
                return true;
            }
        }
        return false;
    }
}

