/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.InventoryNotebook;
import com.xcompwiz.mystcraft.item.IItemWritable;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.oldapi.PositionableItem;
import com.xcompwiz.mystcraft.page.IItemPageProvider;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class ItemAgebook
extends ItemLinking
implements IItemPageProvider,
IItemWritable {
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("mystcraft:agebook");
    }

    @Override
    protected void initialize(World world, ItemStack itemstack, Entity entity) {
        AgeData data;
        if (world.field_72995_K) {
            return;
        }
        if (itemstack.field_77990_d != null && (data = AgeData.getAge(LinkOptions.getDimensionUID(itemstack.field_77990_d), world.field_72995_K)) == null) {
            itemstack.field_77990_d = null;
        }
        if (itemstack.field_77990_d == null) {
            AgeData bookdata = ItemAgebook.bindToNewDim(itemstack);
            bookdata.setPages(Arrays.asList(Page.createLinkPage()));
        }
    }

    public static AgeData bindToNewDim(ItemStack itemstack) {
        int dimUID = DimensionUtils.getNewDimensionUID();
        AgeData bookdata = DimensionUtils.createAge(DimensionUtils.convertDimensionUIDToID(dimUID));
        ItemAgebook.initializeCompound(itemstack, dimUID, bookdata);
        return bookdata;
    }

    public static AgeData getAgeData(World world, ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        ModItems.agebook.initialize(world, itemstack, null);
        int uid = LinkOptions.getDimensionUID(itemstack.field_77990_d);
        return AgeData.getAge(uid, world.field_72995_K);
    }

    public static void initializeCompound(ItemStack itemstack, int dimId, AgeData bookdata) {
        itemstack.func_77982_d(new NBTTagCompound());
        LinkOptions.setDimensionUID(itemstack.field_77990_d, dimId);
        LinkOptions.setDisplayName(itemstack.field_77990_d, bookdata.getAgeName());
        LinkOptions.setFlag(itemstack.field_77990_d, "Generate Platform", true);
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return itemstack.func_77948_v() ? EnumRarity.rare : EnumRarity.epic;
    }

    @Override
    public Collection<String> getAuthors(ItemStack itemstack) {
        Set<String> authors;
        int uid;
        AgeData data;
        if (itemstack.field_77990_d != null && (data = AgeData.getAge(uid = LinkOptions.getDimensionUID(itemstack.field_77990_d), true)) != null && (authors = data.getAuthors()) != null) {
            return authors;
        }
        return Collections.emptySet();
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        player.func_71064_a((StatBase)ModAchievements.agebook, 1);
    }

    @Override
    public String getDisplayName(EntityPlayer player, ItemStack itemstack) {
        return LinkOptions.getDisplayName(itemstack.field_77990_d);
    }

    @Override
    public void setDisplayName(EntityPlayer player, ItemStack itemstack, String name) {
        LinkOptions.setDisplayName(itemstack.field_77990_d, name);
        AgeData data = AgeData.getAge(LinkOptions.getDimensionUID(itemstack.field_77990_d), player.field_70170_p.field_72995_K);
        if (data != null) {
            data.setAgeName(name);
        }
    }

    @Override
    public boolean writeSymbol(EntityPlayer player, ItemStack target, String symbol2, ItemStack paper_feeder) {
        AgeData agedata = ItemAgebook.getAgeData(player.field_70170_p, target);
        if (agedata != null && !agedata.isVisited() && agedata.writeSymbol(symbol2)) {
            agedata.addAuthor(player.getDisplayName());
            return true;
        }
        return false;
    }

    public void addPages(EntityPlayer player, ItemStack itemstack, List<ItemStack> pages) {
        AgeData agedata = ItemAgebook.getAgeData(player.field_70170_p, itemstack);
        if (agedata != null && !agedata.isVisited()) {
            agedata.addPages(pages);
        }
    }

    public void addAuthor(EntityPlayer player, ItemStack itemstack) {
        AgeData agedata = ItemAgebook.getAgeData(player.field_70170_p, itemstack);
        if (agedata != null && !agedata.isVisited()) {
            agedata.addAuthor(player.getDisplayName());
        }
    }

    @Override
    public ItemStack removePage(EntityPlayer player, ItemStack itemstack, int index) {
        return null;
    }

    @Override
    public List<ItemStack> getPageList(EntityPlayer player, ItemStack itemstack) {
        AgeData data = AgeData.getAge(LinkOptions.getDimensionUID(itemstack.field_77990_d), player.field_70170_p.field_72995_K);
        if (data != null) {
            return data.getPages();
        }
        return null;
    }

    @Override
    public List<PositionableItem> getPagesForSurface(EntityPlayer player, ItemStack itemstack) {
        AgeData agedata = ItemAgebook.getAgeData(player.field_70170_p, itemstack);
        if (agedata != null) {
            return this.getPositionedPages(agedata.getPages());
        }
        return null;
    }

    public List<PositionableItem> getPositionedPages(List<ItemStack> pages) {
        ArrayList<PositionableItem> result = new ArrayList<PositionableItem>();
        int slot = 0;
        for (ItemStack page : pages) {
            PositionableItem positionable = new PositionableItem(page, slot);
            positionable.x = (float)(slot % 5) * (InventoryNotebook.pagewidth + 1.0f);
            positionable.y = (float)(slot / 5) * (InventoryNotebook.pageheight + 1.0f);
            result.add(positionable);
            ++slot;
        }
        return result;
    }

    @Override
    public ItemStack addPage(EntityPlayer player, ItemStack itemstack, ItemStack page) {
        return page;
    }

    @Override
    public ItemStack addPage(ItemStack itemstack, ItemStack page, float x, float y) {
        return page;
    }

    @Override
    public void sort(ItemStack itemstack, IItemPageProvider.SortType type, short width) {
    }
}

