/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

public class LinkController {
    public static boolean travelEntity(World world, Entity entity, ILinkInfo info) {
        if (world.field_72995_K) {
            return false;
        }
        if (info == null) {
            return false;
        }
        info = info.clone();
        int dimension = DimensionUtils.convertDimensionUIDToID(info.getDimensionUID());
        ChunkCoordinates spawn = info.getSpawn();
        float yaw = info.getSpawnYaw();
        if (!LinkListenerManager.isLinkPermitted(world, entity, info)) {
            return false;
        }
        MinecraftServer mcServer = Mystcraft.sidedProxy.getMCServer();
        if (mcServer == null || dimension != 0 && !mcServer.func_71255_r()) {
            return false;
        }
        WorldServer newworld = mcServer.func_71218_a(dimension);
        if (newworld == null) {
            System.err.println("Cannot Link Entity to Dimension: Could not get World for Dimension " + dimension);
            return false;
        }
        if (spawn == null) {
            spawn = newworld.func_72861_E();
            info.setSpawn(spawn);
        }
        LinkEvent.LinkEventAlter event = new LinkEvent.LinkEventAlter(world, (World)newworld, entity, info.clone());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.spawn != null) {
            spawn = event.spawn;
        }
        if (event.rotationYaw != null) {
            yaw = event.rotationYaw.floatValue();
        }
        LinkController.teleportEntity((World)newworld, entity, dimension, spawn, yaw, info);
        return true;
    }

    private static Entity teleportEntity(World newworld, Entity entity, int dimension, ChunkCoordinates spawn, float yaw, ILinkInfo info) {
        EntityPlayerMP player;
        World origin = entity.field_70170_p;
        if (!LinkListenerManager.isLinkPermitted(origin, entity, info)) {
            return null;
        }
        Entity mount = entity.field_70154_o;
        if (entity.field_70154_o != null) {
            entity.func_70078_a(null);
            mount = LinkController.teleportEntity(newworld, mount, dimension, spawn, yaw, info);
        }
        boolean changingworlds = origin != newworld;
        LinkListenerManager.onLinkStart(origin, entity, info);
        origin.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            if (changingworlds) {
                player.field_71093_bK = dimension;
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newworld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                if (newworld.field_73011_w instanceof WorldProviderMyst) {
                    NetworkUtils.sendAgeData(newworld, (EntityPlayer)player, newworld.field_73011_w.field_76574_g);
                }
                ((WorldServer)origin).func_73040_p().func_72695_c(player);
            }
        }
        if (changingworlds) {
            LinkController.removeEntityFromWorld(origin, entity);
        }
        LinkListenerManager.onExitWorld(entity, info);
        entity.func_70012_b((double)spawn.field_71574_a + 0.5, (double)spawn.field_71572_b, (double)spawn.field_71573_c + 0.5, yaw, entity.field_70125_A);
        ((WorldServer)newworld).field_73059_b.func_73158_c(spawn.field_71574_a >> 4, spawn.field_71573_c >> 4);
        while (LinkController.getCollidingWorldGeometry(newworld, entity.field_70121_D, entity).size() != 0) {
            ++spawn.field_71572_b;
            entity.func_70107_b((double)spawn.field_71574_a + 0.5, (double)spawn.field_71572_b, (double)spawn.field_71573_c + 0.5);
        }
        if (changingworlds) {
            if (!(entity instanceof EntityPlayer)) {
                NBTTagCompound entityNBT = new NBTTagCompound();
                entity.field_70128_L = false;
                entityNBT.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
                entity.func_70109_d(entityNBT);
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)newworld);
                if (entity == null) {
                    LoggerUtils.warn("Failed to reconstruct entity when linking", new Object[0]);
                    return null;
                }
                entity.field_71093_bK = newworld.field_73011_w.field_76574_g;
            }
            newworld.func_72838_d(entity);
            entity.func_70029_a(newworld);
        }
        entity.func_70012_b((double)spawn.field_71574_a + 0.5, (double)spawn.field_71572_b, (double)spawn.field_71573_c + 0.5, yaw, entity.field_70125_A);
        LinkListenerManager.onEnterWorld(origin, newworld, entity, info);
        newworld.func_72866_a(entity, false);
        entity.func_70012_b((double)spawn.field_71574_a + 0.5, (double)spawn.field_71572_b, (double)spawn.field_71573_c + 0.5, yaw, entity.field_70125_A);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            if (changingworlds) {
                player.field_71133_b.func_71203_ab().func_72375_a(player, (WorldServer)newworld);
            }
            player.field_71135_a.func_147364_a((double)spawn.field_71574_a + 0.5, (double)spawn.field_71572_b, (double)spawn.field_71573_c + 0.5, player.field_70177_z, player.field_70125_A);
        }
        newworld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP && changingworlds) {
            player = (EntityPlayerMP)entity;
            player.field_71134_c.func_73080_a((WorldServer)newworld);
            player.field_71133_b.func_71203_ab().func_72354_b(player, (WorldServer)newworld);
            player.field_71133_b.func_71203_ab().func_72385_f(player);
            for (PotionEffect effect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), effect));
            }
            player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
        entity.func_70012_b((double)spawn.field_71574_a + 0.5, (double)spawn.field_71572_b, (double)spawn.field_71573_c + 0.5, yaw, entity.field_70125_A);
        LinkListenerManager.onLinkEnd(origin, newworld, entity, info);
        if (mount != null) {
            if (entity instanceof EntityPlayerMP) {
                newworld.func_72866_a(entity, true);
            }
            entity.func_70078_a(mount);
        }
        return entity;
    }

    private static void removeEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71053_j();
            world.field_73010_i.remove(player);
            world.func_72854_c();
            int i = entity.field_70176_ah;
            int j = entity.field_70164_aj;
            if (entity.field_70175_ag && world.func_72863_F().func_73149_a(i, j)) {
                world.func_72964_e(i, j).func_76622_b(entity);
                world.func_72964_e((int)i, (int)j).field_76643_l = true;
            }
            world.field_72996_f.remove(entity);
            world.func_72847_b(entity);
        }
    }

    private static List<AxisAlignedBB> getCollidingWorldGeometry(World world, AxisAlignedBB axisalignedbb, Entity entity) {
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!world.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = world.func_147439_a(k1, i2, l1);
                    if (block == null) continue;
                    block.func_149743_a(world, k1, i2, l1, axisalignedbb, collidingBoundingBoxes, entity);
                }
            }
        }
        return collidingBoundingBoxes;
    }
}

