/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.item.ItemLinkbook;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LinkListenerBasic {
    @SubscribeEvent
    public void isLinkPermitted(LinkEvent.LinkEventAllow event) {
        Entity entity = event.entity;
        World world = event.origin;
        ILinkInfo info = event.info;
        if (world.field_72995_K) {
            return;
        }
        if (entity.field_70128_L || entity.field_70170_p != world || entity.field_70153_n != null) {
            event.setCanceled(true);
        } else if (entity.field_70170_p.field_73011_w.field_76574_g == DimensionUtils.convertDimensionUIDToID(info.getDimensionUID()) && !info.getFlag("Intra Linking")) {
            event.setCanceled(true);
        } else if (info.getFlag("Disarm")) {
            if (entity instanceof EntityItem) {
                event.setCanceled(true);
            } else if (entity instanceof EntityLinkbook) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleAlterEvent(LinkEvent.LinkEventAlter event) {
        Entity entity = event.entity;
        World world = event.origin;
        World newworld = event.destination;
        ILinkInfo info = event.info;
        if (info.getFlag("Relative")) {
            ChunkCoordinates origin = world.func_72861_E();
            float dx = (int)(entity.field_70165_t - (double)origin.field_71574_a);
            float dy = (int)(entity.field_70163_u - (double)origin.field_71572_b);
            float dz = (int)(entity.field_70161_v - (double)origin.field_71573_c);
            event.spawn = newworld.func_72861_E();
            event.spawn.field_71574_a = (int)((float)event.spawn.field_71574_a + dx);
            event.spawn.field_71572_b = (int)((float)event.spawn.field_71572_b + dy);
            event.spawn.field_71573_c = (int)((float)event.spawn.field_71573_c + dz);
        }
    }

    @SubscribeEvent
    public void onLinkStart(LinkEvent.LinkEventStart event) {
        Entity entity = event.entity;
        ILinkInfo info = event.info;
        if (info.getFlag("Disarm")) {
            if (entity instanceof EntityPlayer) {
                LinkListenerBasic.ejectInventory(entity.field_70170_p, (IInventory)((EntityPlayer)entity).field_71071_by, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
            if (entity instanceof IInventory) {
                LinkListenerBasic.ejectInventory(entity.field_70170_p, (IInventory)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
            if (entity instanceof EntityHorse) {
                ((EntityHorse)entity).func_110244_cA();
            }
            if (entity instanceof EntityLiving) {
                LinkListenerBasic.dropEquipment((EntityLiving)entity, new Random());
            }
        }
    }

    @SubscribeEvent
    public void onExitWorld(LinkEvent.LinkEventExitWorld event) {
        Entity entity = event.entity;
        ILinkInfo info = event.info;
        LinkListenerBasic.handleMomentum(entity, info);
    }

    @SubscribeEvent
    public void onEnterWorld(LinkEvent.LinkEventEnterWorld event) {
        Entity entity = event.entity;
        World world = event.destination;
        if (world.field_73011_w instanceof WorldProviderMyst && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof ItemLinkbook)) continue;
                return;
            }
            player.func_71064_a((StatBase)ModAchievements.quinn, 1);
        }
    }

    @SubscribeEvent
    public void onLinkEnd(LinkEvent.LinkEventEnd event) {
        Entity entity = event.entity;
        World world = event.destination;
        ILinkInfo info = event.info;
        ChunkCoordinates spawn = info.getSpawn();
        if (info.getFlag("Generate Platform") && world.func_147437_c(spawn.field_71574_a, spawn.field_71572_b - 1, spawn.field_71573_c) && world.func_147437_c(spawn.field_71574_a, spawn.field_71572_b - 2, spawn.field_71573_c)) {
            world.func_147465_d(spawn.field_71574_a, spawn.field_71572_b - 1, spawn.field_71573_c, Blocks.field_150348_b, 0, 3);
        }
        if (entity instanceof EntityMinecart) {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
    }

    private static void handleMomentum(Entity entity, ILinkInfo info) {
        if (!info.getFlag("Maintain Momentum")) {
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            entity.field_70143_R = 0.0f;
        } else {
            float yaw = info.getSpawnYaw();
            float rotationYaw = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            double cos = Math.cos(Math.toRadians(-rotationYaw));
            double sin = Math.sin(Math.toRadians(-rotationYaw));
            double tempXmotion = cos * entity.field_70159_w - sin * entity.field_70179_y;
            double tempZmotion = sin * entity.field_70159_w + cos * entity.field_70179_y;
            entity.field_70159_w = tempXmotion;
            entity.field_70179_y = tempZmotion;
            cos = Math.cos(Math.toRadians(yaw));
            sin = Math.sin(Math.toRadians(yaw));
            tempXmotion = cos * entity.field_70159_w - sin * entity.field_70179_y;
            tempZmotion = sin * entity.field_70159_w + cos * entity.field_70179_y;
            entity.field_70159_w = tempXmotion;
            entity.field_70179_y = tempZmotion;
        }
        entity.field_70181_x += 0.2;
    }

    private static void ejectInventory(World worldObj, IInventory inventory, double par2, double par3, double par4) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            inventory.func_70299_a(i, null);
            if (itemstack == null) continue;
            float f = worldObj.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = worldObj.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = worldObj.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int j = worldObj.field_73012_v.nextInt(21) + 10;
                if (j > itemstack.field_77994_a) {
                    j = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= j;
                EntityItem entityitem = new EntityItem(worldObj, par2 + (double)f, par3 + (double)f1, par4 + (double)f2, new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)worldObj.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)worldObj.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)worldObj.field_73012_v.nextGaussian() * f3;
                worldObj.func_72838_d((Entity)entityitem);
            }
        }
    }

    private static void dropEquipment(EntityLiving entity, Random rand) {
        float[] equipmentDropChances = (float[])ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, (Object)entity, (String[])new String[]{"equipmentDropChances", "field_82174_bp"});
        for (int j = 0; j < entity.func_70035_c().length; ++j) {
            boolean flag1;
            ItemStack itemstack = entity.func_71124_b(j);
            entity.func_70062_b(j, null);
            float chance = equipmentDropChances[j];
            boolean bl = flag1 = chance > 1.0f;
            if (itemstack == null || !flag1 || !(rand.nextFloat() < chance)) continue;
            if (!flag1 && itemstack.func_77984_f()) {
                int k = Math.max(itemstack.func_77958_k() - 25, 1);
                int l = itemstack.func_77958_k() - rand.nextInt(rand.nextInt(k) + 1);
                if (l > k) {
                    l = k;
                }
                if (l < 1) {
                    l = 1;
                }
                itemstack.func_77964_b(l);
            }
            entity.func_70099_a(itemstack, 0.0f);
        }
    }
}

