/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.nbt;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class NBTUtils {
    public static Number readNumber(NBTBase tag) {
        if (tag == null) {
            return 0;
        }
        if (tag instanceof NBTTagByte) {
            return ((NBTTagByte)tag).func_150290_f();
        }
        if (tag instanceof NBTTagShort) {
            return ((NBTTagShort)tag).func_150289_e();
        }
        if (tag instanceof NBTTagInt) {
            return ((NBTTagInt)tag).func_150287_d();
        }
        if (tag instanceof NBTTagLong) {
            return ((NBTTagLong)tag).func_150291_c();
        }
        if (tag instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return ((NBTTagDouble)tag).func_150286_g();
        }
        return 0;
    }

    public static void readInventoryArrayFromNBT(NBTTagList tagList, ItemStack[] inventory) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = tagList.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= inventory.length) continue;
            inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public static NBTTagList writeInventoryArrayToNBT(NBTTagList nbttaglist, ItemStack[] inventory) {
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(slot);
            nbttaglist.func_74742_a((NBTBase)slot);
        }
        return nbttaglist;
    }

    public static <T extends Map<String, Byte>> T readByteMapFromNBT(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, NBTUtils.readNumber(tagcompound.func_74781_a(tagname)).byteValue());
        }
        return map;
    }

    public static NBTTagCompound writeByteMapToNBT(NBTTagCompound tagcompound, Map<String, Byte> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74774_a(key, map.get(key).byteValue());
        }
        return tagcompound;
    }

    public static <T extends Map<String, Integer>> T readIntMapFromNBT(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, NBTUtils.readNumber(tagcompound.func_74781_a(tagname)).intValue());
        }
        return map;
    }

    public static NBTTagCompound writeIntMapToNBT(NBTTagCompound tagcompound, Map<String, Integer> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74768_a(key, map.get(key).intValue());
        }
        return tagcompound;
    }

    public static <T extends Map<String, Float>> T readFloatMapFromNBT(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, (Float)Float.valueOf(NBTUtils.readNumber(tagcompound.func_74781_a(tagname)).floatValue()));
        }
        return map;
    }

    public static NBTTagCompound writeFloatMapToNBT(NBTTagCompound tagcompound, Map<String, Float> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74776_a(key, map.get(key).floatValue());
        }
        return tagcompound;
    }

    public static NBTTagList writeStringListToNBT(NBTTagList nbttaglist, Collection<String> list) {
        nbttaglist = new NBTTagList();
        for (String str : list) {
            if (str == null) continue;
            nbttaglist.func_74742_a((NBTBase)new NBTTagString(str));
        }
        return nbttaglist;
    }

    public static <T extends Collection<String>> T readStringListFromNBT(NBTTagList nbttaglist, T list) {
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            list.add((String)nbttaglist.func_150307_f(i));
        }
        return list;
    }
}

