/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.client.gui.GuiHandlerManager;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.MPacketAgeData;
import com.xcompwiz.mystcraft.network.MPacketOpenWindow;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public final class NetworkUtils {
    public static void displayGui(EntityPlayer entityplayer, World worldObj, int guiID, int i, int j, int k) {
        if (!(entityplayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityplayer;
        GuiHandlerManager.GuiHandler handler = GuiHandlerManager.getGuiNetHandler(guiID);
        if (handler == null) {
            LoggerUtils.warn(String.format("Unrecognized gui type id %s", guiID), new Object[0]);
            return;
        }
        TileEntity tileentity = handler.getTileEntity(player, worldObj, i, j, k);
        if (tileentity == null) {
            LoggerUtils.warn(String.format("GUI Handler %s did not return a tile entity.", guiID), new Object[0]);
            return;
        }
        player.field_71070_bA = handler.getContainer(player, worldObj, tileentity, i, j, k);
        if (player.field_71070_bA == null) {
            LoggerUtils.warn(String.format("GUI Handler %s did not produce a container.", guiID), new Object[0]);
            return;
        }
        int currentWindowId = NetworkUtils.getNextWindowId(player);
        MystcraftPacketHandler.bus.sendTo(MPacketOpenWindow.createPacket(currentWindowId, guiID, tileentity), player);
        player.field_71070_bA.field_75152_c = currentWindowId;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static void displayGui(EntityPlayer entityplayer, World worldObj, int guiID, ItemStack itemstack) {
        if (!(entityplayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityplayer;
        GuiHandlerManager.GuiHandler handler = GuiHandlerManager.getGuiNetHandler(guiID);
        if (handler == null) {
            LoggerUtils.warn(String.format("Unrecognized gui type id %s", guiID), new Object[0]);
            return;
        }
        int slot = MystcraftCommonProxy.findInInventory((IInventory)player.field_71071_by, itemstack);
        if (slot < 0) {
            LoggerUtils.warn(String.format("Attempted to open GUI for item not in inventory (%s)", guiID), new Object[0]);
            return;
        }
        player.field_71070_bA = handler.getContainer(player, worldObj, itemstack, slot);
        if (player.field_71070_bA == null) {
            LoggerUtils.warn(String.format("GUI Handler %s did not produce a container.", guiID), new Object[0]);
            return;
        }
        int currentWindowId = NetworkUtils.getNextWindowId(player);
        MystcraftPacketHandler.bus.sendTo(MPacketOpenWindow.createPacket(currentWindowId, guiID, (byte)slot), player);
        player.field_71070_bA.field_75152_c = currentWindowId;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static void displayGui(EntityPlayer entityplayer, World worldObj, int guiID, Entity entity) {
        if (!(entityplayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityplayer;
        GuiHandlerManager.GuiHandler handler = GuiHandlerManager.getGuiNetHandler(guiID);
        if (handler == null) {
            LoggerUtils.warn(String.format("Unrecognized gui type id %s", guiID), new Object[0]);
            return;
        }
        player.field_71070_bA = handler.getContainer(player, worldObj, entity);
        if (player.field_71070_bA == null) {
            LoggerUtils.warn(String.format("GUI Handler %s did not produce a container.", guiID), new Object[0]);
            return;
        }
        int currentWindowId = NetworkUtils.getNextWindowId(player);
        MystcraftPacketHandler.bus.sendTo(MPacketOpenWindow.createPacket(currentWindowId, guiID, entity), player);
        player.field_71070_bA.field_75152_c = currentWindowId;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static void sendAgeData(World worldObj, EntityPlayer player, int ageUID) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (!Mystcraft.registeredDims.contains(ageUID)) {
            return;
        }
        if (AgeData.getAge(ageUID, false) == null) {
            return;
        }
        ((EntityPlayerMP)player).field_71135_a.func_147359_a(MPacketAgeData.getDataPacket(ageUID));
    }

    public static void sendAgeData(World worldObj, ItemStack itemstack, EntityPlayer player) {
        if (itemstack != null && itemstack.func_77973_b() == ModItems.agebook) {
            NetworkUtils.sendAgeData(worldObj, player, LinkOptions.getDimensionUID(itemstack.field_77990_d));
        }
    }

    public static void sendAgeData(World worldObj, ItemStack itemstack, int i, int j, int k) {
        if (itemstack != null && itemstack.func_77973_b() == ModItems.agebook) {
            MinecraftServer mcServer = Mystcraft.sidedProxy.getMCServer();
            if (mcServer == null) {
                LoggerUtils.warn("Failed to get mcServer instance while sending AgeData Packet", new Object[0]);
            } else {
                int dimId = LinkOptions.getDimensionUID(itemstack.field_77990_d);
                if (!Mystcraft.registeredDims.contains(dimId)) {
                    return;
                }
                if (AgeData.getAge(dimId, false) == null) {
                    return;
                }
                Packet packet = MPacketAgeData.getDataPacket(dimId);
                mcServer.func_71203_ab().func_148541_a((double)i, (double)j, (double)k, 16.0, worldObj.field_73011_w.field_76574_g, packet);
            }
        }
    }

    private static int getNextWindowId(EntityPlayerMP player) {
        player.func_71117_bO();
        return player.field_71139_cq;
    }

    public static void sendMessageToAdmins(IChatComponent chatcomponent) {
        for (EntityPlayer entityplayer : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(entityplayer.func_146103_bH())) continue;
            entityplayer.func_145747_a(chatcomponent);
        }
        MinecraftServer.func_71276_C().func_145747_a(chatcomponent);
    }

    public static void sendMessageToPlayersInWorld(IChatComponent chatcomponent, int dimensionid) {
        for (EntityPlayer entityplayer : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (entityplayer.field_71093_bK != dimensionid) continue;
            entityplayer.func_145747_a(chatcomponent);
        }
        MinecraftServer.func_71276_C().func_145747_a(chatcomponent);
    }

    public static void sendMessageToPlayers(IChatComponent chatcomponent) {
        Iterator iterator = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.iterator();
        while (iterator.hasNext()) {
            ((EntityPlayer)iterator.next()).func_145747_a(chatcomponent);
        }
        MinecraftServer.func_71276_C().func_145747_a(chatcomponent);
    }
}

