/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.api.world.logic.IChunkProviderFinalization;
import com.xcompwiz.mystcraft.api.world.logic.ICloudColorProvider;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.api.world.logic.IFogColorProvider;
import com.xcompwiz.mystcraft.api.world.logic.ILightingController;
import com.xcompwiz.mystcraft.api.world.logic.IMoon;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.api.world.logic.ISkyColorProvider;
import com.xcompwiz.mystcraft.api.world.logic.ISkyDoodad;
import com.xcompwiz.mystcraft.api.world.logic.ISpawnModifier;
import com.xcompwiz.mystcraft.api.world.logic.IStarfield;
import com.xcompwiz.mystcraft.api.world.logic.IStaticColorProvider;
import com.xcompwiz.mystcraft.api.world.logic.ISun;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainFeatureLocator;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import com.xcompwiz.mystcraft.api.world.logic.IWeatherController;
import com.xcompwiz.mystcraft.symbol.ColorGradient;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.Modifier;
import com.xcompwiz.mystcraft.world.IAgeController;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.world.biome.WorldChunkManager;

public class SymbolProfiler
implements IAgeController {
    private HashMap<Class<?>, HashSet<IAgeSymbol>> registrations = new HashMap();
    private HashSet<IAgeSymbol> cloudHeight = new HashSet();
    private HashSet<IAgeSymbol> horizon = new HashSet();
    private HashSet<IAgeSymbol> grndlevel = new HashSet();
    private HashSet<IAgeSymbol> sealevel = new HashSet();
    private HashSet<IAgeSymbol> renderHorizon = new HashSet();
    private HashSet<IAgeSymbol> renderVoid = new HashSet();
    private HashSet<IAgeSymbol> pvpEnabled = new HashSet();
    private HashMap<String, HashSet<IAgeSymbol>> setsModifier = new HashMap();
    private HashMap<String, HashSet<IAgeSymbol>> popsModifier = new HashMap();
    private HashSet<IAgeSymbol> clearsModifiers = new HashSet();
    private HashSet<IAgeSymbol> addsInstability = new HashSet();
    private IAgeSymbol agent = null;

    public void startProfiling(IAgeSymbol symbol2) {
        if (this.agent != null) {
            throw new RuntimeException("Attempting to profile multiple symbols at once!");
        }
        this.agent = symbol2;
    }

    public void endProfiling(IAgeSymbol symbol2) {
        if (this.agent != symbol2) {
            throw new RuntimeException("Mismatch in symbol profiler termination!");
        }
        this.agent = null;
    }

    public void remove(IAgeSymbol symbol2) {
        for (HashSet<IAgeSymbol> list : this.registrations.values()) {
            list.remove(symbol2);
        }
        for (HashSet<IAgeSymbol> list : this.setsModifier.values()) {
            list.remove(symbol2);
        }
        for (HashSet<IAgeSymbol> list : this.popsModifier.values()) {
            list.remove(symbol2);
        }
        this.cloudHeight.remove(symbol2);
        this.horizon.remove(symbol2);
        this.grndlevel.remove(symbol2);
        this.sealevel.remove(symbol2);
        this.renderHorizon.remove(symbol2);
        this.renderVoid.remove(symbol2);
        this.pvpEnabled.remove(symbol2);
        this.clearsModifiers.remove(symbol2);
        this.addsInstability.remove(symbol2);
    }

    public HashSet<IAgeSymbol> getSymbolsProviding(Class<?> interface1) {
        return this.getInterfaceList(interface1);
    }

    private HashSet<IAgeSymbol> getInterfaceList(Class<?> class1) {
        if (!this.registrations.containsKey(class1)) {
            this.registrations.put(class1, new HashSet());
        }
        return this.registrations.get(class1);
    }

    @Override
    public long getTime() {
        return 0L;
    }

    @Override
    public int getInstabilityScore() {
        return 0;
    }

    @Override
    public float getCloudHeight() {
        return 0.0f;
    }

    @Override
    public double getHorizon() {
        return 0.0;
    }

    @Override
    public int getAverageGroundLevel() {
        return 0;
    }

    @Override
    public int getSeaLevel() {
        return 0;
    }

    @Override
    public long getSeed() {
        return 0L;
    }

    @Override
    public ColorGradient getSunriseSunsetColor() {
        return null;
    }

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return null;
    }

    @Override
    public void addInstability(int instability) {
        if (this.agent == null) {
            return;
        }
        this.addsInstability.add(this.agent);
    }

    @Override
    public void setCloudHeight(float height) {
        if (this.agent == null) {
            return;
        }
        this.cloudHeight.add(this.agent);
    }

    @Override
    public void setHorizon(double height) {
        if (this.agent == null) {
            return;
        }
        this.horizon.add(this.agent);
    }

    @Override
    public void setAverageGroundLevel(int height) {
        if (this.agent == null) {
            return;
        }
        this.grndlevel.add(this.agent);
    }

    @Override
    public void setSeaLevel(int height) {
        if (this.agent == null) {
            return;
        }
        this.sealevel.add(this.agent);
    }

    @Override
    public void setDrawHorizon(boolean flag) {
        if (this.agent == null) {
            return;
        }
        this.renderHorizon.add(this.agent);
    }

    @Override
    public void setDrawVoid(boolean flag) {
        if (this.agent == null) {
            return;
        }
        this.renderVoid.add(this.agent);
    }

    @Override
    public void setPvPEnabled(boolean flag) {
        if (this.agent == null) {
            return;
        }
        this.pvpEnabled.add(this.agent);
    }

    @Override
    public void registerInterface(IBiomeController controller) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IBiomeController.class).add(this.agent);
    }

    @Override
    public void registerInterface(ITerrainGenerator terrainGen) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ITerrainGenerator.class).add(this.agent);
    }

    @Override
    public void registerInterface(ILightingController reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ILightingController.class).add(this.agent);
    }

    @Override
    public void registerInterface(IWeatherController reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IWeatherController.class).add(this.agent);
    }

    @Override
    public void registerInterface(ITerrainAlteration reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ITerrainAlteration.class).add(this.agent);
    }

    @Override
    public void registerInterface(IChunkProviderFinalization reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IChunkProviderFinalization.class).add(this.agent);
    }

    @Override
    public void registerInterface(IPopulate reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IPopulate.class).add(this.agent);
    }

    @Override
    public void registerInterface(ITerrainFeatureLocator reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ITerrainFeatureLocator.class).add(this.agent);
    }

    @Override
    public void registerInterface(IFogColorProvider reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IFogColorProvider.class).add(this.agent);
    }

    @Override
    public void registerInterface(ISpawnModifier reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ISpawnModifier.class).add(this.agent);
    }

    @Override
    public void registerInterface(ISkyColorProvider skyColorizer) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ISkyColorProvider.class).add(this.agent);
    }

    @Override
    public void registerInterface(ICloudColorProvider reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ICloudColorProvider.class).add(this.agent);
    }

    @Override
    public void registerInterface(IStaticColorProvider reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IStaticColorProvider.class).add(this.agent);
    }

    @Override
    public void registerInterface(IEnvironmentalEffect reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IEnvironmentalEffect.class).add(this.agent);
    }

    @Override
    public void registerInterface(ISun reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ISun.class).add(this.agent);
    }

    @Override
    public void registerInterface(IMoon reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IMoon.class).add(this.agent);
    }

    @Override
    public void registerInterface(IStarfield reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(IStarfield.class).add(this.agent);
    }

    @Override
    public void registerInterface(ISkyDoodad reg) {
        if (this.agent == null) {
            return;
        }
        this.getInterfaceList(ISkyDoodad.class).add(this.agent);
    }

    private HashSet<IAgeSymbol> getModifierList(HashMap<String, HashSet<IAgeSymbol>> map, String id) {
        if (!map.containsKey(id)) {
            map.put(id, new HashSet());
        }
        return map.get(id);
    }

    @Override
    public void setModifier(String id, Object obj) {
        if (this.agent == null) {
            return;
        }
        this.getModifierList(this.setsModifier, id).add(this.agent);
    }

    @Override
    public void setModifier(String id, Modifier obj) {
        if (this.agent == null) {
            return;
        }
        this.getModifierList(this.setsModifier, id).add(this.agent);
    }

    @Override
    public Modifier popModifier(String id) {
        if (this.agent == null) {
            return null;
        }
        this.getModifierList(this.popsModifier, id).add(this.agent);
        return new Modifier();
    }

    @Override
    public void clearModifiers() {
        if (this.agent == null) {
            return;
        }
        this.clearsModifiers.add(this.agent);
    }
}

