/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;

public class ModifierBiome
extends SymbolBase {
    public static ArrayList<BiomeGenBase> selectables = new ArrayList();
    private BiomeGenBase biome;
    private String displayName;

    public ModifierBiome(BiomeGenBase biome) {
        this.biome = biome;
        this.displayName = this.formatted();
        if (!this.displayName.endsWith("Biome")) {
            this.displayName = this.displayName + " Biome";
        }
        this.setWords(new String[]{"Nature", "Nurture", "Encourage", biome.field_76791_y + biome.field_76756_M});
    }

    private String formatted() {
        String regex = "([A-Z][a-z]+)";
        String replacement = "$1 ";
        return this.biome.field_76791_y.replaceAll(regex, replacement).replaceAll("([A-Z][a-z]+)  ", replacement).trim();
    }

    @Override
    public void registerLogic(IAgeController controller, long seed) {
        controller.setAverageGroundLevel((int)(this.biome.field_76748_D * 64.0f + 64.0f));
        ModifierUtils.pushBiome(controller, this.biome);
    }

    @Override
    public String identifier() {
        return "Biome" + this.biome.field_76756_M;
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    public static BiomeGenBase getRandomBiome(Random rand) {
        BiomeGenBase biome = null;
        while (biome == null) {
            if (selectables.size() > 0) {
                biome = selectables.get(rand.nextInt(selectables.size()));
                continue;
            }
            biome = BiomeGenBase.func_150568_d((int)rand.nextInt(BiomeGenBase.func_150565_n().length));
        }
        return biome;
    }
}

