/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;

public class ModifierPhase
extends SymbolBase {
    private final float value;
    private final String identifier;
    private final String display;

    public ModifierPhase(float value, String identifier, String display) {
        this.value = value;
        this.identifier = identifier;
        this.display = display;
    }

    @Override
    public void registerLogic(IAgeController controller, long seed) {
        Float value = Float.valueOf(this.value);
        Number prev = controller.popModifier("phase").asNumber();
        if (prev != null) {
            value = Float.valueOf(ModifierUtils.averageAngles(prev.floatValue(), value.floatValue()));
        }
        if (value.floatValue() >= 360.0f) {
            value = Float.valueOf(value.floatValue() - 360.0f);
        }
        controller.setModifier("phase", value);
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public String displayName() {
        return this.display + " Phase";
    }
}

