/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.logic.ICloudColorProvider;
import com.xcompwiz.mystcraft.symbol.Color;
import com.xcompwiz.mystcraft.symbol.ColorGradient;
import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;

public class SymbolColorCloud
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        ColorGradient gradient = ModifierUtils.popGradient(controller, 1.0f, 1.0f, 1.0f);
        controller.registerInterface(new CloudColorizer(controller, gradient));
    }

    @Override
    public String identifier() {
        return "ColorCloud";
    }

    private class CloudColorizer
    implements ICloudColorProvider {
        ColorGradient gradient;
        private IAgeController controller;

        public CloudColorizer(IAgeController controller, ColorGradient gradient) {
            this.controller = controller;
            this.gradient = gradient;
        }

        @Override
        public Color getCloudColor(float time, float celestial_angle) {
            return this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
        }
    }
}

