/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.world.logic.ISkyDoodad;
import com.xcompwiz.mystcraft.client.render.RenderRainbow;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SymbolDoodadRainbow
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        Number angle = controller.popModifier("angle").asNumber();
        controller.registerInterface(new CelestialObject(controller, seed, angle));
    }

    @Override
    public String identifier() {
        return "Rainbow";
    }

    private class CelestialObject
    implements ISkyDoodad {
        private Random rand;
        private float angle;
        private boolean initialized;
        private Integer rainbowGLCallList = null;

        CelestialObject(IAgeController controller, long seed, Number angle) {
            this.rand = new Random(seed);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(TextureManager eng, World worldObj, float partial) {
            if (!this.initialized) {
                this.initialize();
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            if (this.rainbowGLCallList == null) {
                RenderRainbow.renderRainbow(0.0f, 50.0f);
            } else {
                GL11.glCallList((int)this.rainbowGLCallList);
            }
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glPopMatrix();
        }

        @SideOnly(value=Side.CLIENT)
        private void initialize() {
            this.initialized = true;
            if (Mystcraft.fastRainbows) {
                this.rainbowGLCallList = GLAllocation.func_74526_a((int)1);
                GL11.glNewList((int)this.rainbowGLCallList, (int)4864);
                GL11.glPushMatrix();
                RenderRainbow.renderRainbow(0.0f, 50.0f);
                GL11.glPopMatrix();
                GL11.glEndList();
            }
        }
    }
}

