/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainFeatureLocator;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStronghold;

public class SymbolStrongholds
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        MapGenStronghold generator = new MapGenStronghold();
        controller.registerInterface(new TerrainAlteration(generator));
        controller.registerInterface(new Populator(generator));
        controller.registerInterface(new FeatureLocator(generator));
    }

    @Override
    public String identifier() {
        return "Strongholds";
    }

    @Override
    public int instabilityModifier(int count) {
        if (count > 3) {
            return 100;
        }
        return 0;
    }

    private class FeatureLocator
    implements ITerrainFeatureLocator {
        MapGenStronghold generator;

        public FeatureLocator(MapGenStronghold gen) {
            this.generator = gen;
        }

        @Override
        public ChunkPosition locate(World world, String s, int i, int j, int k) {
            if ("Stronghold".equals(s) && this.generator != null) {
                return this.generator.func_151545_a(world, i, j, k);
            }
            return null;
        }
    }

    private class TerrainAlteration
    implements ITerrainAlteration {
        MapGenStronghold generator;

        public TerrainAlteration(MapGenStronghold gen) {
            this.generator = gen;
        }

        @Override
        public void alterTerrain(World worldObj, int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
            this.generator.func_151539_a(worldObj.func_72863_F(), worldObj, chunkX, chunkZ, null);
        }
    }

    private class Populator
    implements IPopulate {
        MapGenStronghold generator;

        public Populator(MapGenStronghold gen) {
            this.generator = gen;
        }

        @Override
        public boolean populate(World worldObj, Random rand, int i, int j, boolean flag) {
            this.generator.func_75051_a(worldObj, rand, i >> 4, j >> 4);
            return false;
        }
    }
}

