/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.block.BlockWritingDesk;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.fluids.FluidUtils;
import com.xcompwiz.mystcraft.item.IItemRenameable;
import com.xcompwiz.mystcraft.item.IItemWritable;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.linking.LinkController;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.network.IMessageReceiver;
import com.xcompwiz.mystcraft.network.MPacketMessage;
import com.xcompwiz.mystcraft.oldapi.PositionableItem;
import com.xcompwiz.mystcraft.page.IItemPageProvider;
import com.xcompwiz.mystcraft.tileentity.FluidTankFiltered;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityDesk
extends TileEntity
implements IFluidHandler,
ISidedInventory,
IMessageReceiver {
    private ItemStack[] itemstacks = new ItemStack[4];
    private ItemStack[] notebooks = new ItemStack[25];
    private FluidTankFiltered inkwell = new FluidTankFiltered(1000);
    private static final int slot_wrt = 0;
    private static final int slot_pap = 1;
    private static final int slot_ctn = 2;
    private static final int slot_out = 3;
    private static final int[] isidedslots = new int[]{1};

    public TileEntityDesk() {
        this.inkwell.setPermittedFluids(Mystcraft.validInks);
    }

    public int getMainInventorySize() {
        return this.itemstacks.length;
    }

    public int getMaxNotebookCount() {
        return this.notebooks.length;
    }

    public int getPaperCount() {
        ItemStack itemstack = this.func_70301_a(1);
        if (itemstack != null) {
            return itemstack.field_77994_a;
        }
        return 0;
    }

    public ItemStack getDisplayItem() {
        return this.func_70301_a(0);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        ItemStack itemstack = null;
        itemstack = this.func_70301_a(0);
        if (itemstack != null) {
            nbttagcompound.func_74782_a("DisItem", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        if ((itemstack = this.func_70301_a(1)) != null) {
            nbttagcompound.func_74782_a("PaperItem", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        return MPacketMessage.createPacket(this, nbttagcompound);
    }

    @Override
    public void processMessageData(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("DisItem")) {
            this.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("DisItem")));
        } else {
            this.func_70299_a(0, null);
        }
        if (nbttagcompound.func_74764_b("PaperItem")) {
            this.func_70299_a(1, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("PaperItem")));
        } else {
            this.func_70299_a(1, null);
        }
        this.func_70296_d();
    }

    public ItemStack getNotebook(byte activeslot) {
        if (activeslot < 0 || activeslot >= this.notebooks.length) {
            return null;
        }
        return this.notebooks[activeslot];
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return false;
        }
        if (slotIndex == 0 && itemstack.func_77973_b() instanceof IItemWritable) {
            return true;
        }
        if (slotIndex == 0 && itemstack.func_77973_b() instanceof IItemRenameable) {
            return true;
        }
        if (slotIndex == 1 && itemstack.func_77973_b() == Items.field_151121_aF) {
            return true;
        }
        if (slotIndex == 2 && FluidContainerRegistry.isContainer((ItemStack)itemstack)) {
            return true;
        }
        if ((slotIndex -= this.itemstacks.length) < 0) {
            return false;
        }
        if (slotIndex >= this.notebooks.length) {
            return false;
        }
        return itemstack.func_77973_b() instanceof IItemPageProvider;
    }

    public int func_70302_i_() {
        return this.itemstacks.length + this.notebooks.length;
    }

    public ItemStack func_70301_a(int index) {
        ItemStack[] inv = this.itemstacks;
        if (index >= inv.length) {
            index -= inv.length;
            inv = this.notebooks;
        }
        if (index > inv.length) {
            return null;
        }
        return inv[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack[] inv = this.itemstacks;
        if (index >= inv.length) {
            index -= inv.length;
            inv = this.notebooks;
        }
        if (inv[index] != null) {
            if (inv[index].field_77994_a <= amount) {
                ItemStack itemstack = inv[index];
                inv[index] = null;
                this.handleItemChange(inv[index]);
                return itemstack;
            }
            ItemStack itemstack1 = inv[index].func_77979_a(amount);
            if (inv[index].field_77994_a == 0) {
                inv[index] = null;
            }
            this.handleItemChange(inv[index]);
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack itemstack) {
        ItemStack[] inv = this.itemstacks;
        if (index >= inv.length) {
            index -= inv.length;
            inv = this.notebooks;
        }
        inv[index] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.handleItemChange(inv[index]);
    }

    public String func_145825_b() {
        return "Writing Desk";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean hasTop() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) != ModBlocks.writingdesk) {
            return false;
        }
        return BlockWritingDesk.isBlockTop(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
    }

    public boolean isLeftCovered() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && block != ModBlocks.writingdesk) {
            return true;
        }
        return !BlockWritingDesk.isBlockTop(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("Fluid")) {
            this.inkwell.fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("Fluid")), true);
        }
        NBTUtils.readInventoryArrayFromNBT(nbttagcompound.func_150295_c("Items", 10), this.itemstacks);
        NBTUtils.readInventoryArrayFromNBT(nbttagcompound.func_150295_c("Notebooks", 10), this.notebooks);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        FluidStack fluid = this.inkwell.getFluid();
        if (fluid != null) {
            nbttagcompound.func_74782_a("Fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)NBTUtils.writeInventoryArrayToNBT(new NBTTagList(), this.itemstacks));
        nbttagcompound.func_74782_a("Notebooks", (NBTBase)NBTUtils.writeInventoryArrayToNBT(new NBTTagList(), this.notebooks));
    }

    public void handleItemChange(ItemStack itemstack) {
    }

    public String getTargetString(EntityPlayer player) {
        ItemStack itemstack = this.itemstacks[0];
        if (itemstack == null) {
            return "";
        }
        if (!(itemstack.func_77973_b() instanceof IItemRenameable)) {
            return "";
        }
        String name = ((IItemRenameable)itemstack.func_77973_b()).getDisplayName(player, itemstack);
        if (name == null) {
            return "";
        }
        return name;
    }

    public void setBookTitle(EntityPlayer player, String bookname) {
        ItemStack itemstack = this.itemstacks[0];
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof IItemRenameable)) {
            return;
        }
        ((IItemRenameable)itemstack.func_77973_b()).setDisplayName(player, itemstack, bookname);
    }

    public List<ItemStack> getBookPageList(EntityPlayer player) {
        ItemStack itemstack = this.itemstacks[0];
        if (itemstack == null) {
            return null;
        }
        if (!(itemstack.func_77973_b() instanceof IItemWritable)) {
            return null;
        }
        return ((IItemWritable)itemstack.func_77973_b()).getPageList(player, itemstack);
    }

    public void writeSymbol(EntityPlayer player, String symbol2) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.hasEnoughInk()) {
            return;
        }
        if (this.itemstacks[0] == null && this.itemstacks[1] != null) {
            this.itemstacks[0] = ItemPage.createItemstack(this.itemstacks[1]);
        }
        if (this.itemstacks[0] == null) {
            return;
        }
        ItemStack target = this.itemstacks[0];
        if (target == null) {
            return;
        }
        if (!(target.func_77973_b() instanceof IItemWritable)) {
            return;
        }
        if (((IItemWritable)target.func_77973_b()).writeSymbol(player, target, symbol2, this.itemstacks[1])) {
            this.useink();
            player.func_71064_a((StatBase)ModAchievements.write, 1);
        }
        if (this.itemstacks[1] != null && this.itemstacks[1].field_77994_a <= 0) {
            this.itemstacks[1] = null;
        }
    }

    public List<PositionableItem> getSurfacePages(EntityPlayer player, byte slot) {
        if (slot >= this.notebooks.length) {
            return null;
        }
        ItemStack itemstack = this.notebooks[slot];
        if (itemstack == null) {
            return null;
        }
        if (!(itemstack.func_77973_b() instanceof IItemPageProvider)) {
            return null;
        }
        return ((IItemPageProvider)itemstack.func_77973_b()).getPagesForSurface(player, itemstack);
    }

    public ItemStack removePageFromSurface(EntityPlayer player, ItemStack itemstack, int index) {
        if (itemstack == null) {
            return null;
        }
        if (!(itemstack.func_77973_b() instanceof IItemPageProvider)) {
            return null;
        }
        ItemStack page = ((IItemPageProvider)itemstack.func_77973_b()).removePage(player, itemstack, index);
        this.func_70296_d();
        return page;
    }

    public ItemStack placePageInSurface(EntityPlayer player, ItemStack itemstack, ItemStack page, float x, float y) {
        if (itemstack == null) {
            return page;
        }
        if (!(itemstack.func_77973_b() instanceof IItemPageProvider)) {
            return page;
        }
        ItemStack result = ((IItemPageProvider)itemstack.func_77973_b()).addPage(itemstack, page, x, y);
        this.func_70296_d();
        return result;
    }

    public ItemStack addPage(EntityPlayer player, ItemStack itemstack, ItemStack page) {
        if (itemstack == null) {
            return page;
        }
        if (!(itemstack.func_77973_b() instanceof IItemPageProvider)) {
            return page;
        }
        ItemStack result = ((IItemPageProvider)itemstack.func_77973_b()).addPage(player, itemstack, page);
        this.func_70296_d();
        return result;
    }

    public ItemStack getTarget() {
        return this.itemstacks[0];
    }

    public ItemStack func_70304_b(int index) {
        ItemStack[] inv = this.itemstacks;
        if (index >= this.itemstacks.length) {
            inv = this.notebooks;
            index -= this.itemstacks.length;
        }
        if (inv[index] != null) {
            ItemStack itemstack = inv[index];
            inv[index] = null;
            return itemstack;
        }
        return null;
    }

    public void sortNotebook(ItemStack itemstack, short width, IItemPageProvider.SortType type) {
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof IItemPageProvider)) {
            return;
        }
        ((IItemPageProvider)itemstack.func_77973_b()).sort(itemstack, type, width);
    }

    public FluidStack getInk() {
        return this.inkwell.getFluid();
    }

    public void setInk(FluidStack fluid) {
        this.inkwell.setFluid(fluid);
    }

    private boolean hasEnoughInk() {
        FluidStack fluid = this.inkwell.getFluid();
        if (fluid == null) {
            return false;
        }
        return fluid.amount >= Mystcraft.inkcost;
    }

    private void useink() {
        this.inkwell.drain(Mystcraft.inkcost, true);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        return this.inkwell.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.inkwell.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.isFluidEqual(this.inkwell.getFluid())) {
            return this.inkwell.drain(resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.inkwell.isFluidPermitted(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.inkwell.isFluidPermitted(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.inkwell.getInfo()};
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        ItemStack result;
        ItemStack container;
        ItemStack emptycontainer;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (BlockWritingDesk.isBlockFoot(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
            this.field_145846_f = true;
        }
        if (this.itemstacks[2] != null && ((emptycontainer = (container = this.itemstacks[2]).func_77973_b().getContainerItem(container)) == null || TileEntityDesk.mergeItemStacksLeft(this.itemstacks[3], emptycontainer) != this.itemstacks[3]) && (result = FluidUtils.fillTankWithContainer((IFluidTank)this.inkwell, container)) != null) {
            this.itemstacks[3] = TileEntityDesk.mergeItemStacksLeft(this.itemstacks[3], result);
            if (container.field_77994_a == 0) {
                this.itemstacks[2] = null;
            }
        }
        if (this.itemstacks[2] != null) {
            container = this.itemstacks[2];
            FluidStack tankFluid = this.inkwell.getFluid();
            result = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)container);
            if (TileEntityDesk.mergeItemStacksLeft(this.itemstacks[3], result) != this.itemstacks[3]) {
                this.itemstacks[3] = TileEntityDesk.mergeItemStacksLeft(this.itemstacks[3], FluidUtils.drainTankIntoContainer((IFluidTank)this.inkwell, container));
                if (container.field_77994_a == 0) {
                    this.itemstacks[2] = null;
                }
            }
        }
    }

    private static ItemStack mergeItemStacksLeft(ItemStack left, ItemStack right) {
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return left;
        }
        if (left.func_77942_o() != right.func_77942_o()) {
            return left;
        }
        if (left.func_77942_o() && !left.func_77978_p().equals((Object)right.func_77978_p())) {
            return left;
        }
        if (left.func_77973_b().func_77614_k() && left.func_77960_j() != right.func_77960_j()) {
            return left;
        }
        if (left.field_77994_a + right.field_77994_a > left.func_77976_d()) {
            return left;
        }
        left = left.func_77946_l();
        left.field_77994_a += right.field_77994_a;
        right.field_77994_a = 0;
        return left;
    }

    public void link(Entity player) {
        ItemStack book = this.getTarget();
        if (book == null) {
            return;
        }
        if (!(book.func_77973_b() instanceof ItemLinking)) {
            return;
        }
        LinkController.travelEntity(this.field_145850_b, player, ((ItemLinking)book.func_77973_b()).getLinkInfo(book));
    }

    public int[] func_94128_d(int par1) {
        return isidedslots;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int par3) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }
}

