/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModLinkEffects;
import com.xcompwiz.mystcraft.fluids.FluidUtils;
import com.xcompwiz.mystcraft.inventory.IItemBuilder;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityInkMixer
extends TileEntity
implements IItemBuilder,
ISidedInventory {
    private ItemStack[] itemstacks;
    private boolean hasInk = false;
    private HashMap<String, Float> ink_probabilities = new HashMap();
    private long next_seed = new Random().nextLong();
    private static final int ink_in = 0;
    private static final int ink_out = 2;
    private static final int paper = 1;
    private static int[] isidedslots = new int[]{1, 0};

    public TileEntityInkMixer() {
        this.itemstacks = new ItemStack[3];
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (slotIndex == 0 && FluidContainerRegistry.isContainer((ItemStack)itemstack)) {
            return true;
        }
        return slotIndex == 1 && itemstack.func_77973_b() == Items.field_151121_aF;
    }

    public int func_70302_i_() {
        return this.itemstacks.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.itemstacks.length) {
            return null;
        }
        return this.itemstacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.itemstacks[i] != null) {
            if (this.itemstacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.itemstacks[i];
                this.itemstacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.itemstacks[i].func_77979_a(j);
            if (this.itemstacks[i].field_77994_a == 0) {
                this.itemstacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.itemstacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Ink Mixer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTUtils.readInventoryArrayFromNBT(nbttagcompound.func_150295_c("Items", 10), this.itemstacks);
        this.hasInk = nbttagcompound.func_74767_n("Ink");
        this.ink_probabilities = NBTUtils.readFloatMapFromNBT(nbttagcompound.func_74775_l("Probabilities"), new HashMap());
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74782_a("Items", (NBTBase)NBTUtils.writeInventoryArrayToNBT(new NBTTagList(), this.itemstacks));
        nbttagcompound.func_74757_a("Ink", this.hasInk);
        nbttagcompound.func_74782_a("Probabilities", (NBTBase)NBTUtils.writeFloatMapToNBT(new NBTTagCompound(), this.ink_probabilities));
    }

    @Override
    public void buildItem(ItemStack itemstack, EntityPlayer player) {
        if (!this.canBuildItem()) {
            return;
        }
        if (itemstack.func_77973_b() instanceof ItemPage) {
            Random rand = new Random(this.next_seed);
            for (Map.Entry<String, Float> entry : this.ink_probabilities.entrySet()) {
                float f = entry.getValue().floatValue() * 100.0f;
                int i = rand.nextInt(100);
                if (!((float)i < f)) continue;
                Page.addLinkProperty(itemstack, entry.getKey());
            }
            this.next_seed = rand.nextLong();
            this.hasInk = false;
            this.ink_probabilities.clear();
            --this.itemstacks[1].field_77994_a;
            if (this.itemstacks[1].field_77994_a <= 0) {
                this.itemstacks[1] = null;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        } else {
            itemstack.field_77994_a = 0;
        }
    }

    private boolean canBuildItem() {
        return this.itemstacks[1] != null && this.itemstacks[1].func_77973_b() == Items.field_151121_aF && this.hasInk;
    }

    public ItemStack getCraftedItem() {
        if (!this.canBuildItem()) {
            return null;
        }
        return Page.createLinkPage();
    }

    public boolean getHasInk() {
        return this.hasInk;
    }

    public void setHasInk(boolean b) {
        this.hasInk = b;
    }

    public long getNextSeed() {
        return this.next_seed;
    }

    public void setNextSeed(long seed) {
        this.next_seed = seed;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public int[] func_94128_d(int par1) {
        return isidedslots;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int par3) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return false;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        ItemStack result;
        ItemStack container;
        ItemStack emptycontainer;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.itemstacks[0] == null || this.hasInk || (emptycontainer = (container = this.itemstacks[0]).func_77973_b().getContainerItem(container)) != null && this.mergeItemStacksLeft(this.itemstacks[2], emptycontainer) == this.itemstacks[2] || (result = this.fillBasinWithContainer(container)) == null)) {
            this.itemstacks[2] = this.mergeItemStacksLeft(this.itemstacks[2], result);
            if (container.field_77994_a == 0) {
                this.itemstacks[0] = null;
            }
        }
    }

    private ItemStack fillBasinWithContainer(ItemStack containerStack) {
        ItemStack container = containerStack.func_77946_l();
        container.field_77994_a = 1;
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (fluid != null) {
            if (!Mystcraft.validInks.contains(fluid.getFluid().getName())) {
                return null;
            }
            int used = 1000;
            if (used == fluid.amount) {
                --containerStack.field_77994_a;
                this.hasInk = true;
                container = FluidUtils.emptyContainer(container);
                return container;
            }
        }
        return null;
    }

    private ItemStack mergeItemStacksLeft(ItemStack left, ItemStack right) {
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return left;
        }
        if (left.func_77942_o() != right.func_77942_o()) {
            return left;
        }
        if (left.func_77942_o() && !left.func_77978_p().equals((Object)right.func_77978_p())) {
            return left;
        }
        if (left.func_77973_b().func_77614_k() && left.func_77960_j() != right.func_77960_j()) {
            return left;
        }
        if (left.field_77994_a + right.field_77994_a > left.func_77976_d()) {
            return left;
        }
        left = left.func_77946_l();
        left.field_77994_a += right.field_77994_a;
        right.field_77994_a = 0;
        return left;
    }

    public Map<String, Float> getInkProperties() {
        return Collections.unmodifiableMap(this.ink_probabilities);
    }

    public ItemStack addItems(ItemStack itemstack, int amount) {
        Map<String, Float> itemprobs = null;
        itemprobs = InkEffects.getItemEffects(itemstack);
        if (itemprobs == null) {
            return itemstack;
        }
        float total = 0.0f;
        for (Map.Entry<String, Float> entry : itemprobs.entrySet()) {
            if (entry.getKey().equals("") || !this.isPropertyAllowed(entry.getKey())) continue;
            total += entry.getValue().floatValue();
        }
        float inverse = 1.0f - total;
        if (amount > itemstack.field_77994_a) {
            amount = itemstack.field_77994_a;
        }
        for (int i = 0; i < amount; ++i) {
            --itemstack.field_77994_a;
            for (Map.Entry<String, Float> entry : this.ink_probabilities.entrySet()) {
                entry.setValue(Float.valueOf(entry.getValue().floatValue() * inverse));
            }
            for (Map.Entry<String, Float> entry : itemprobs.entrySet()) {
                if (entry.getKey().equals("") || !this.isPropertyAllowed(entry.getKey())) continue;
                float prob = entry.getValue().floatValue();
                Float f = this.ink_probabilities.get(entry.getKey());
                if (f != null) {
                    prob += f.floatValue();
                }
                this.ink_probabilities.put(entry.getKey(), Float.valueOf(prob));
            }
        }
        if (itemstack.field_77994_a <= 0) {
            itemstack = null;
        }
        return itemstack;
    }

    private boolean isPropertyAllowed(String property) {
        return ModLinkEffects.isPropertyAllowed(property);
    }

    private void addTraitWithProbability(String trait, float prob) {
        float inverse = 1.0f - prob;
        for (Map.Entry<String, Float> entry : this.ink_probabilities.entrySet()) {
            entry.setValue(Float.valueOf(entry.getValue().floatValue() * inverse));
        }
        if (trait.equals("")) {
            return;
        }
        Float f = this.ink_probabilities.get(trait);
        if (f != null) {
            prob += f.floatValue();
        }
        this.ink_probabilities.put(trait, Float.valueOf(prob));
    }
}

