/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WorldInfoHelper {
    public static long getWorldTimeAtNextCelestialAngle(WorldServer world, float target) {
        target = Math.abs(target);
        long time = world.func_72820_D();
        float lastangle = world.field_73011_w.func_76563_a(time, 0.0f);
        if (lastangle < 0.0f) {
            return time;
        }
        float angle = lastangle;
        int steprate = 10;
        for (int attempt = 0; attempt < 1000; ++attempt) {
            if ((double)Math.abs(angle - target) < 0.05) {
                return time;
            }
            angle = world.field_73011_w.func_76563_a(time += (long)steprate, 0.0f);
            if ((double)Math.abs(angle - lastangle) < 0.01) {
                steprate *= 10;
            }
            if ((double)Math.abs(angle - lastangle) > 0.1) {
                steprate /= 2;
            }
            lastangle = angle;
        }
        return world.func_72820_D();
    }

    public static long getWorldNextDawnTime(WorldServer world) {
        return WorldInfoHelper.getWorldTimeAtNextCelestialAngle(world, 0.78f);
    }

    public static long getWorldNextDuskTime(WorldServer world) {
        return WorldInfoHelper.getWorldTimeAtNextCelestialAngle(world, 0.3f);
    }

    private static AgeData getWorldAgeData(World world) {
        if (!(world.field_73011_w instanceof WorldProviderMyst)) {
            return null;
        }
        return ((WorldProviderMyst)world.field_73011_w).agedata;
    }

    public static boolean isMystcraftAge(World world) {
        return world.field_73011_w instanceof WorldProviderMyst;
    }

    public static boolean isInstabilityEnabled(World world) {
        AgeData data = WorldInfoHelper.getWorldAgeData(world);
        if (data == null) {
            return false;
        }
        return data.isInstabilityEnabled();
    }
}

