/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.agedata;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.grammar.GrammarTree;
import com.xcompwiz.mystcraft.nbt.NBTTagCompoundWrapper;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderManager;
import com.xcompwiz.mystcraft.world.storage.IStorageObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;

public class AgeData
extends WorldSavedData {
    private String agename;
    private Set<String> authors;
    private long seed;
    private short instability;
    private boolean instabilityEnabled;
    private long worldtime;
    private ChunkCoordinates spawn;
    private List<ItemStack> pages = new ArrayList<ItemStack>();
    private List<String> symbols = new ArrayList<String>();
    private boolean visited;
    private NBTTagCompound datacompound;
    public Map<String, NBTBase> cruft = new HashMap<String, NBTBase>();
    private boolean updated;
    private Boolean sharedDirty = new Boolean(false);
    private boolean needsResend;
    private Boolean sharedResend = new Boolean(false);

    public AgeData(String s) {
        super(s);
        this.datacompound = new NBTTagCompound();
    }

    public boolean func_76188_b() {
        if (this.sharedDirty.booleanValue()) {
            return true;
        }
        return super.func_76188_b();
    }

    public void func_76186_a(boolean par1) {
        super.func_76186_a(par1);
        if (!par1) {
            this.sharedDirty = false;
        }
    }

    public boolean needsResend() {
        if (this.sharedResend.booleanValue()) {
            return true;
        }
        return this.needsResend;
    }

    public void resent() {
        this.needsResend = false;
        this.sharedResend = false;
    }

    public void markNeedsResend() {
        this.needsResend = true;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void markVisited() {
        if (!this.visited) {
            this.func_76185_a();
        }
        this.visited = true;
        this.updated = false;
    }

    public void onConstruct() {
        this.updated = false;
    }

    public void setAgeName(String name) {
        this.agename = name;
        this.func_76185_a();
    }

    public String getAgeName() {
        return this.agename;
    }

    public Set<String> getAuthors() {
        if (this.authors == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.authors);
    }

    public void addAuthor(String name) {
        if (this.authors == null) {
            this.authors = new HashSet<String>();
        }
        this.authors.add(name);
    }

    public long getSeed() {
        return this.seed;
    }

    public ChunkCoordinates getSpawn() {
        return this.spawn;
    }

    public void setSpawn(ChunkCoordinates spawn) {
        this.spawn = spawn;
    }

    public boolean isInstabilityEnabled() {
        return this.instabilityEnabled;
    }

    public void setInstabilityEnabled(boolean instabilityEnabled) {
        this.instabilityEnabled = instabilityEnabled;
        this.func_76185_a();
    }

    public int getBaseInstability() {
        return this.instability;
    }

    public List<ItemStack> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public void addPages(List<ItemStack> pages) {
        this.pages.addAll(pages);
        this.func_76185_a();
    }

    public boolean writeSymbol(String symbol2) {
        if (this.visited) {
            return false;
        }
        for (ItemStack page : this.pages) {
            if (!Page.isBlank(page)) continue;
            Page.setSymbol(page, symbol2);
            if (this.visited) {
                // empty if block
            }
            this.func_76185_a();
            return true;
        }
        return false;
    }

    public void addSymbol(String symbol2, int instability) {
        this.symbols.add(symbol2);
        this.instability = (short)(this.instability + instability);
        this.func_76185_a();
    }

    public void setPages(List<ItemStack> pages) {
        this.pages.clear();
        this.pages.addAll(pages);
        this.func_76185_a();
    }

    public List<String> getSymbols(boolean isRemote) {
        if (!this.visited && !isRemote) {
            this.symbols.clear();
            for (int i = 0; i < this.pages.size(); ++i) {
                String symbol2 = Page.getSymbol(this.pages.get(i));
                if (symbol2 == null) continue;
                this.symbols.add(symbol2);
            }
            GrammarTree tree = new GrammarTree("Age");
            tree.parseTerminals(this.symbols, new Random(this.seed));
            if (Mystcraft.debugGrammar) {
                System.out.println(" == Parsed Tree ==");
                tree.print();
            }
            this.symbols = tree.getExpanded(new Random(this.seed));
            if (Mystcraft.debugGrammar) {
                System.out.println(" == Produced Tree ==");
                tree.print();
            }
        }
        return Collections.unmodifiableList(this.symbols);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        List<Object> mapping;
        AgeDataData loadeddata = AgeDataLoaderManager.load(nbttagcompound);
        this.agename = loadeddata.agename;
        this.authors = loadeddata.authors;
        this.seed = loadeddata.seed;
        this.visited = loadeddata.visited;
        this.worldtime = loadeddata.worldtime;
        this.instability = loadeddata.instability;
        this.instabilityEnabled = loadeddata.instabilityEnabled;
        this.setSpawn(loadeddata.spawn);
        this.pages = loadeddata.pages;
        this.symbols = loadeddata.symbols;
        this.datacompound = loadeddata.datacompound;
        this.cruft = loadeddata.cruft;
        if (this.datacompound == null) {
            this.datacompound = new NBTTagCompound();
        }
        int i = 0;
        while (i < this.pages.size()) {
            ItemStack page = this.pages.remove(i);
            mapping = SymbolRemappings.remap(page);
            this.pages.addAll(i, mapping);
            if (mapping.size() <= 0 || !page.equals(mapping.get(0))) continue;
            ++i;
        }
        i = 0;
        while (i < this.symbols.size()) {
            String symbol2 = this.symbols.remove(i);
            mapping = SymbolRemappings.remap(symbol2);
            this.symbols.addAll(i, mapping);
            if (mapping.size() <= 0 || !symbol2.equals(mapping.get(0))) continue;
            ++i;
        }
        this.updated = true;
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Version", "4.2");
        if (this.agename == null || this.agename.isEmpty()) {
            this.agename = "Unnamed Age";
        }
        nbttagcompound.func_74778_a("AgeName", this.agename);
        nbttagcompound.func_74772_a("Seed", this.seed);
        nbttagcompound.func_74777_a("BaseIns", this.instability);
        nbttagcompound.func_74757_a("InstabilityEnabled", this.instabilityEnabled);
        nbttagcompound.func_74757_a("Visited", this.visited);
        nbttagcompound.func_74782_a("DataCompound", (NBTBase)this.datacompound);
        nbttagcompound.func_74772_a("WorldTime", this.worldtime);
        if (this.getSpawn() != null) {
            nbttagcompound.func_74768_a("SpawnX", this.spawn.field_71574_a);
            nbttagcompound.func_74768_a("SpawnY", this.spawn.field_71572_b);
            nbttagcompound.func_74768_a("SpawnZ", this.spawn.field_71573_c);
        }
        NBTTagList list = new NBTTagList();
        for (ItemStack page : this.pages) {
            list.func_74742_a((NBTBase)page.field_77990_d);
        }
        nbttagcompound.func_74782_a("Pages", (NBTBase)list);
        nbttagcompound.func_74782_a("Symbols", (NBTBase)NBTUtils.writeStringListToNBT(new NBTTagList(), this.symbols));
        if (this.authors != null) {
            nbttagcompound.func_74782_a("Authors", (NBTBase)NBTUtils.writeStringListToNBT(new NBTTagList(), this.authors));
        }
        if (this.cruft != null && this.cruft.size() > 0) {
            NBTTagCompound cruftnbt = new NBTTagCompound();
            for (Map.Entry<String, NBTBase> elem : this.cruft.entrySet()) {
                cruftnbt.func_74782_a(elem.getKey(), elem.getValue());
            }
            nbttagcompound.func_74782_a("Cruft", (NBTBase)cruftnbt);
        }
    }

    public static AgeData getMPAgeData(int uid) {
        MapStorage storage = Mystcraft.getStorage(false);
        String s = AgeData.getStringID(uid);
        if (storage == null) {
            throw new RuntimeException("Mystcraft could not retrieve the agedata file.  The storage object is null.");
        }
        AgeData age = (AgeData)storage.func_75742_a(AgeData.class, s);
        if (age == null) {
            age = new AgeData(s);
            storage.func_75745_a(s, (WorldSavedData)age);
            age.func_76185_a();
        }
        return age;
    }

    public static AgeData getAge(int uid, boolean isRemote) {
        if (DimensionManager.getProviderType((int)uid) != Mystcraft.providerId) {
            return null;
        }
        String s = AgeData.getStringID(uid);
        MapStorage storage = Mystcraft.getStorage(!isRemote);
        if (storage == null) {
            throw new RuntimeException("Mystcraft could not load the agedata file.  The storage object is null. (Attempted as " + (isRemote ? "remote" : "server") + ")");
        }
        AgeData age = (AgeData)storage.func_75742_a(AgeData.class, s);
        if (age == null) {
            age = new AgeData(s);
            storage.func_75745_a(s, (WorldSavedData)age);
            age.agename = "Age " + uid;
            age.seed = Mystcraft.getLevelSeed(!isRemote) + new Random(uid).nextLong();
            age.setSpawn(null);
            age.instability = 0;
            age.instabilityEnabled = true;
            age.visited = false;
            age.updated = false;
            age.func_76185_a();
        }
        return age;
    }

    public static String getStringID(int uid) {
        return "agedata_" + uid;
    }

    public IStorageObject getStorageObject(String string) {
        if (!this.datacompound.func_74764_b(string)) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.datacompound.func_74782_a(string, (NBTBase)nbttagcompound);
        }
        return new NBTTagCompoundWrapper(this.datacompound.func_74775_l(string), this.sharedDirty, this.sharedResend);
    }

    public void setWorldTime(long time) {
        this.worldtime = time;
        this.func_76185_a();
    }

    public long getWorldTime() {
        return this.worldtime;
    }

    public NBTBase popCruft(String string) {
        if (this.cruft == null) {
            return null;
        }
        return this.cruft.remove(string);
    }

    public static class AgeDataData {
        public String agename;
        public Set<String> authors = new HashSet<String>();
        public long seed;
        public short instability;
        public boolean instabilityEnabled;
        public ChunkCoordinates spawn;
        public List<ItemStack> pages = new ArrayList<ItemStack>();
        public List<String> symbols = new ArrayList<String>();
        public boolean visited;
        public NBTTagCompound datacompound;
        public long worldtime;
        public String version;
        public Map<String, NBTBase> cruft = new HashMap<String, NBTBase>();
    }
}

