/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;

public class GalacticraftRegistry {
    private static Map<Class<? extends WorldProvider>, ITeleportType> teleportTypeMap = new HashMap<Class<? extends WorldProvider>, ITeleportType>();
    private static List<SpaceStationType> spaceStations = new ArrayList<SpaceStationType>();
    private static List<INasaWorkbenchRecipe> rocketBenchT1Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> buggyBenchRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> rocketBenchT2Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> cargoRocketRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static List<INasaWorkbenchRecipe> rocketBenchT3Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static Map<Class<? extends WorldProvider>, ResourceLocation> rocketGuiMap = new HashMap<Class<? extends WorldProvider>, ResourceLocation>();
    private static Map<Integer, List<ItemStack>> dungeonLootMap = new HashMap<Integer, List<ItemStack>>();

    public static void registerTeleportType(Class<? extends WorldProvider> clazz, ITeleportType type) {
        if (!teleportTypeMap.containsKey(clazz)) {
            teleportTypeMap.put(clazz, type);
        }
    }

    public static void registerRocketGui(Class<? extends WorldProvider> clazz, ResourceLocation rocketGui) {
        if (!rocketGuiMap.containsKey(clazz)) {
            rocketGuiMap.put(clazz, rocketGui);
        }
    }

    public static void addDungeonLoot(int tier, ItemStack loot) {
        List<Object> dungeonStacks = null;
        if (dungeonLootMap.containsKey(tier)) {
            dungeonStacks = dungeonLootMap.get(tier);
            dungeonStacks.add(loot);
        } else {
            dungeonStacks = new ArrayList<ItemStack>();
            dungeonStacks.add(loot);
        }
        dungeonLootMap.put(tier, dungeonStacks);
    }

    public static void addT1RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT1Recipes.add(recipe);
    }

    public static void addT2RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT2Recipes.add(recipe);
    }

    public static void addT3RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT3Recipes.add(recipe);
    }

    public static void addCargoRocketRecipe(INasaWorkbenchRecipe recipe) {
        cargoRocketRecipes.add(recipe);
    }

    public static void addMoonBuggyRecipe(INasaWorkbenchRecipe recipe) {
        buggyBenchRecipes.add(recipe);
    }

    public static ITeleportType getTeleportTypeForDimension(Class<? extends WorldProvider> clazz) {
        if (!IGalacticraftWorldProvider.class.isAssignableFrom(clazz)) {
            clazz = WorldProviderSurface.class;
        }
        return teleportTypeMap.get(clazz);
    }

    public static void registerSpaceStation(SpaceStationType type) {
        spaceStations.add(type);
    }

    public SpaceStationType getTypeFromPlanetID(int planetID) {
        return spaceStations.get(planetID);
    }

    public static List<SpaceStationType> getSpaceStationData() {
        return spaceStations;
    }

    public static List<INasaWorkbenchRecipe> getRocketT1Recipes() {
        return rocketBenchT1Recipes;
    }

    public static List<INasaWorkbenchRecipe> getRocketT2Recipes() {
        return rocketBenchT2Recipes;
    }

    public static List<INasaWorkbenchRecipe> getRocketT3Recipes() {
        return rocketBenchT3Recipes;
    }

    public static List<INasaWorkbenchRecipe> getCargoRocketRecipes() {
        return cargoRocketRecipes;
    }

    public static List<INasaWorkbenchRecipe> getBuggyBenchRecipes() {
        return buggyBenchRecipes;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getResouceLocationForDimension(Class<? extends WorldProvider> clazz) {
        if (!IGalacticraftWorldProvider.class.isAssignableFrom(clazz)) {
            clazz = WorldProviderSurface.class;
        }
        return rocketGuiMap.get(clazz);
    }

    public static List<ItemStack> getDungeonLoot(int tier) {
        return dungeonLootMap.get(tier);
    }
}

