/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntitySpaceshipBase
extends Entity
implements IPacketReceiver,
IIgnoreShift {
    public int launchPhase = EnumLaunchPhase.UNIGNITED.ordinal();
    protected long ticks = 0L;
    protected double dragAir;
    public int timeUntilLaunch;
    public float timeSinceLaunch;
    public float rollAmplitude;
    public float shipDamage;

    public EntitySpaceshipBase(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70155_l = 5.0;
    }

    public abstract int getMaxFuel();

    public abstract int getScaledFuelLevel(int var1);

    public abstract int getPreLaunchWait();

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_85032_ar() || this.field_70163_u > 300.0) {
                return false;
            }
            this.rollAmplitude = 10.0f;
            this.func_70018_K();
            this.shipDamage += par2 * 10.0f;
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.shipDamage = 100.0f;
            }
            if (this.shipDamage > 90.0f && !this.field_70170_p.field_72995_K) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70106_y();
                this.dropShipAsItem();
                return true;
            }
            return true;
        }
        return true;
    }

    public void dropShipAsItem() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (ItemStack item : this.getItemsDropped(new ArrayList<ItemStack>())) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public abstract List<ItemStack> getItemsDropped(List<ItemStack> var1);

    public void func_70057_ab() {
        this.rollAmplitude = 5.0f;
        this.shipDamage += this.shipDamage * 10.0f;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70071_h_() {
        block24: {
            block23: {
                if (this.ticks >= Long.MAX_VALUE) {
                    this.ticks = 1L;
                }
                ++this.ticks;
                super.func_70071_h_();
                if (this.field_70153_n != null) {
                    this.field_70153_n.field_70143_R = 0.0f;
                }
                double d = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                if (this.field_70163_u > d) {
                    this.onReachAtmosphere();
                }
                if (this.rollAmplitude > 0.0f) {
                    this.rollAmplitude -= 1.0f;
                }
                if (this.shipDamage > 0.0f) {
                    this.shipDamage -= 1.0f;
                }
                if (this.field_70163_u < 0.0) break block23;
                double d2 = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                if (!(this.field_70163_u > d2 + 10.0)) break block24;
            }
            this.func_70076_C();
        }
        if (this.launchPhase == EnumLaunchPhase.UNIGNITED.ordinal()) {
            this.timeUntilLaunch = this.getPreLaunchWait();
        }
        this.timeSinceLaunch = this.launchPhase == EnumLaunchPhase.LAUNCHED.ordinal() ? (this.timeSinceLaunch += 1.0f) : 0.0f;
        if (this.timeUntilLaunch > 0 && this.launchPhase == EnumLaunchPhase.IGNITED.ordinal()) {
            --this.timeUntilLaunch;
        }
        AxisAlignedBB box = null;
        box = this.field_70121_D.func_72314_b(0.2, 0.2, 0.2);
        List var15 = this.field_70170_p.func_72839_b((Entity)this, box);
        if (var15 != null && !var15.isEmpty()) {
            for (int var52 = 0; var52 < var15.size(); ++var52) {
                Entity var17 = (Entity)var15.get(var52);
                if (var17 == this.field_70153_n) continue;
                var17.func_70108_f((Entity)this);
            }
        }
        if (this.timeUntilLaunch == 0 && this.launchPhase == EnumLaunchPhase.IGNITED.ordinal()) {
            this.setLaunchPhase(EnumLaunchPhase.LAUNCHED);
            this.onLaunch();
        }
        if (this.field_70125_A > 90.0f) {
            this.field_70125_A = 90.0f;
        }
        if (this.field_70125_A < -90.0f) {
            this.field_70125_A = -90.0f;
        }
        this.field_70159_w = -(50.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0));
        this.field_70179_y = -(50.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * 0.01 * Math.PI / 180.0));
        if (this.timeSinceLaunch > 50.0f && this.field_70122_E) {
            this.failRocket();
        }
        if (this.launchPhase != EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.shouldMoveClientSide()) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K && this.ticks % 3L == 0L) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketDynamic(this), this.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    protected boolean shouldMoveClientSide() {
        return true;
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.setLaunchPhase(EnumLaunchPhase.values()[buffer.readInt()]);
        this.timeSinceLaunch = buffer.readFloat();
        this.timeUntilLaunch = buffer.readInt();
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            new Exception().printStackTrace();
        }
        list.add(this.launchPhase);
        list.add(Float.valueOf(this.timeSinceLaunch));
        list.add(this.timeUntilLaunch);
    }

    public void turnYaw(float f) {
        this.field_70177_z += f;
    }

    public void turnPitch(float f) {
        this.field_70125_A += f;
    }

    protected void failRocket() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70097_a((DamageSource)DamageSourceGC.spaceshipCrash, 81.0f);
        }
        if (!ConfigManagerCore.disableSpaceshipGrief) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70101_b(par7, par8);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("launchPhase", this.launchPhase + 1);
        nbt.func_74768_a("timeUntilLaunch", this.timeUntilLaunch);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.timeUntilLaunch = nbt.func_74762_e("timeUntilLaunch");
        boolean hasOldTags = false;
        if (nbt.func_150296_c().contains("launched")) {
            hasOldTags = true;
            boolean launched = nbt.func_74767_n("launched");
            if (launched) {
                this.setLaunchPhase(EnumLaunchPhase.LAUNCHED);
            }
        }
        if (nbt.func_150296_c().contains("ignite")) {
            hasOldTags = true;
            int ignite = nbt.func_74762_e("ignite");
            if (ignite == 1) {
                this.setLaunchPhase(EnumLaunchPhase.IGNITED);
            }
        }
        if (hasOldTags) {
            if (this.launchPhase != EnumLaunchPhase.LAUNCHED.ordinal() && this.launchPhase != EnumLaunchPhase.IGNITED.ordinal()) {
                this.setLaunchPhase(EnumLaunchPhase.UNIGNITED);
            }
        } else {
            this.setLaunchPhase(EnumLaunchPhase.values()[nbt.func_74762_e("launchPhase") - 1]);
        }
    }

    public boolean getLaunched() {
        return this.launchPhase == EnumLaunchPhase.LAUNCHED.ordinal();
    }

    public boolean canBeRidden() {
        return false;
    }

    public void ignite() {
        this.setLaunchPhase(EnumLaunchPhase.IGNITED);
    }

    public double func_70042_X() {
        return -0.9;
    }

    public void onLaunch() {
    }

    public void onReachAtmosphere() {
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public boolean canRiderInteract() {
        return true;
    }

    public ResourceLocation getSpaceshipGui() {
        return GalacticraftRegistry.getResouceLocationForDimension(this.field_70170_p.field_73011_w.getClass());
    }

    public void setLaunchPhase(EnumLaunchPhase phase) {
        this.launchPhase = phase.ordinal();
    }

    @Override
    public boolean shouldIgnoreShiftExit() {
        return this.launchPhase == EnumLaunchPhase.LAUNCHED.ordinal();
    }

    public static enum EnumLaunchPhase {
        UNIGNITED,
        IGNITED,
        LAUNCHED;

    }
}

