/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.compatibility;

import cpw.mods.fml.common.Loader;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class NetworkConfigHandler {
    private static Configuration config;
    public static float BC3_RATIO;
    public static float TE_RATIO;
    public static float IC2_RATIO;
    public static float MEKANISM_RATIO;
    public static float TO_BC_RATIO;
    public static float TO_TE_RATIO;
    public static float TO_IC2_RATIO;
    public static float TO_MEKANISM_RATIO;
    public static Object gasOxygen;
    public static boolean displayEnergyUnitsBC;
    public static boolean displayEnergyUnitsIC2;
    private static boolean cachedIC2Loaded;
    private static boolean cachedIC2LoadedValue;
    private static boolean cachedBCLoaded;
    private static boolean cachedBCLoadedValue;
    private static int cachedBCVersion;
    private static Boolean mekanismOldClassFound;

    public static void setDefaultValues(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        config.load();
        IC2_RATIO = (float)config.get("Compatibility", "IndustrialCraft Conversion Ratio", (double)IC2_RATIO).getDouble((double)IC2_RATIO);
        BC3_RATIO = (float)config.get("Compatibility", "BuildCraft Conversion Ratio", (double)BC3_RATIO).getDouble((double)BC3_RATIO);
        TO_IC2_RATIO = 1.0f / IC2_RATIO;
        TO_BC_RATIO = 1.0f / BC3_RATIO;
        TO_TE_RATIO = 1.0f / TE_RATIO;
        TO_MEKANISM_RATIO = 1.0f / MEKANISM_RATIO;
        displayEnergyUnitsBC = config.get("Display", "If BuildCraft is loaded, show Galacticraft machines energy as MJ instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsIC2 = config.get("Display", "If IndustrialCraft2 is loaded, show Galacticraft machines energy as EU instead of gJ?", false).getBoolean(false);
        if (!NetworkConfigHandler.isBuildcraftLoaded()) {
            displayEnergyUnitsBC = false;
        }
        if (!NetworkConfigHandler.isIndustrialCraft2Loaded()) {
            displayEnergyUnitsIC2 = false;
        }
        if (NetworkConfigHandler.isIndustrialCraft2Loaded()) {
            displayEnergyUnitsBC = false;
        }
        config.save();
    }

    public static void initGas() {
    }

    public static boolean isIndustrialCraft2Loaded() {
        if (!cachedIC2Loaded) {
            cachedIC2Loaded = true;
            cachedIC2LoadedValue = Loader.isModLoaded((String)"IC2");
        }
        return cachedIC2LoadedValue;
    }

    public static boolean isBuildcraftLoaded() {
        if (!cachedBCLoaded) {
            cachedBCLoaded = true;
            cachedBCLoadedValue = Loader.isModLoaded((String)"BuildCraft|Energy");
        }
        return cachedBCLoadedValue;
    }

    public static int getBuildcraftVersion() {
        if (cachedBCVersion != -1) {
            return cachedBCVersion;
        }
        if (cachedBCLoaded) {
            boolean bc6Found = true;
            try {
                Class.forName("buildcraft.api.mj.MjAPI");
            }
            catch (Throwable t) {
                bc6Found = false;
            }
            cachedBCVersion = bc6Found ? 6 : 5;
        }
        return cachedBCVersion;
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }

    public static boolean isMekanismLoaded() {
        return Loader.isModLoaded((String)"Mekanism");
    }

    public static boolean isMekanismV6Loaded() {
        if (!NetworkConfigHandler.isMekanismLoaded()) {
            return false;
        }
        if (mekanismOldClassFound != null) {
            return mekanismOldClassFound == false;
        }
        try {
            Class.forName("mekanism.api.gas.IGasAcceptor");
        }
        catch (ClassNotFoundException e) {
            mekanismOldClassFound = false;
            return true;
        }
        mekanismOldClassFound = true;
        return false;
    }

    static {
        BC3_RATIO = 16.0f;
        TE_RATIO = BC3_RATIO / 10.0f;
        IC2_RATIO = BC3_RATIO / 2.44f;
        MEKANISM_RATIO = IC2_RATIO / 100.0f;
        TO_BC_RATIO = 1.0f / BC3_RATIO;
        TO_TE_RATIO = 1.0f / TE_RATIO;
        TO_IC2_RATIO = 1.0f / IC2_RATIO;
        TO_MEKANISM_RATIO = 1.0f / MEKANISM_RATIO;
        gasOxygen = null;
        displayEnergyUnitsBC = false;
        displayEnergyUnitsIC2 = false;
        cachedIC2Loaded = false;
        cachedIC2LoadedValue = false;
        cachedBCLoaded = false;
        cachedBCLoadedValue = false;
        cachedBCVersion = -1;
    }
}

