/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.item;

import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.EnergyHelper;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.ElectricItemManagerIC2;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.transmission.item.IItemElectric;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.world.World;

public abstract class ItemElectric
extends Item
implements IItemElectric {
    private static Object itemManagerIC2;
    public float transferMax;

    public ItemElectric() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        if (NetworkConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = new ElectricItemManagerIC2();
        }
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        String color = "";
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        list.add(color + EnergyHelper.getEnergyDisplayS(joules) + "/" + EnergyHelper.getEnergyDisplayS(this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    @Override
    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    @Override
    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    @Override
    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @Override
    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    @Override
    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    @Override
    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(ElectricItemHelper.getUncharged(new ItemStack((Item)this)));
        par3List.add(ElectricItemHelper.getWithCharge(new ItemStack((Item)this), this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    public static boolean isElectricItem(Item item) {
        if (item instanceof ItemElectric) {
            return true;
        }
        return NetworkConfigHandler.isIndustrialCraft2Loaded() && item instanceof ISpecialElectricItem;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getMaxCharge(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) * NetworkConfigHandler.TO_IC2_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTier(ItemStack itemStack) {
        return this.getTierGC(itemStack) == 2 ? 4 : 2;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTransferLimit(ItemStack itemStack) {
        return (int)(this.transferMax * NetworkConfigHandler.TO_IC2_RATIO);
    }
}

